
/* Arduino Nano Sketch for a Frequency Generator using an AD9851 DDS Module
The Following Pins are used on the Nano
Nano pin    Description    Use
4            Gnd           Ground
5            D2            Rotary Encoder A input
6            D3            Rotary Encoder B input
7            D4            AD9851 Data input
8            D5            AD9851 W_Clk
9            D6            AD9851 FQup DDS Update pin
10           D7            AD9851 Reset input
11           D8            Display D4 (LSB)
12           D9            Display D5
13           D10           Display D6
14           D11           Display D7 (MSB)
15           D12           Display Enable
16           D13           Display Register Select
17           3.3 V         Not Used
18           A Ref         Not Used
19           A0            Push Button Input (Tuning Step)
20-26        A1-A7         Analog Inputs (not used)
27           +5V           5 Volt Output (not Used)
28           CPU Reset     Not Used
29           Gnd           Ground
30           Vin           Unregulated Power Input (+11.1 V)
*/
// Declare the Variables
const byte DATA = (7);       //DDS Data pin
const byte W_CLK = (8);      //DDs Word Clocking
const byte FQ_UD = (9);      //DDS Frequency Update pin
const byte RESET = (10);     //DDS reset pin
const byte EncB = (6);       //Encoder B input
const byte en = (15);        //Enable pin on LCD
const byte rs = (16);        //Register Select on LCD
const byte interruptPin = (5);
#include <LiquidCrystal.h>     //Library module for display
LiquidCrystal lcd(en,rs,11,12,13,14); //Setup display pins
const long unsigned Fclk = 180000000 ; // Crystal Oscillator Freq- Fine Tune for output freq
int Units = (0) ;            //Units counter
int Tens = (0) ;             //Tens count
int Hund = (0) ;             //Hundreds count
int Thou = (0) ;             //Thousands count
int TenThou = (0);           //Ten thousands count
int HunThou = (0);           //Hundred Thousand count
int Mill = ( 0 ) ;           //Millions count
int TenMil = (1);            //Ten million count
int pb = (0);                // 0 = Button not pushed 1=Button pushed
int stepsz = (0) ;           //Count used for display item to change
volatile byte dirRot = (0) ; //If = 1, then CCW else 0 = CW rotation of switch
long unsigned F1 = (10000000) ; // Beginning frequency (10 mhz) when power switch is turned on
long unsigned Temp1 = (1) ;       //temporary registers used in sketch
long unsigned F2= (0) ;           //temporary registers used in sketch
long unsigned Temp3 = (0);        //temporary registers used in sketch
long unsigned Val1 = (1);
long unsigned x = (1);
volatile int y = 1;                //Change in display to indicate a change
volatile int z = 1;
volatile byte Control = 1;

void setup() 
{lcd.begin(16,2);            //Define LCD as 2 lines of 16 digits each line
  pinMode( (5), INPUT);      //pin used for rotary encoder setup as Interrupt
  attachInterrupt( (interruptPin), FXC ,RISING); // Setup interrupt calling FXC if frequecy knob is changed
  pinMode (6, INPUT);        // pin used for B input from encoder
  digitalWrite (8, HIGH);    // pull pin high
  pinMode (7, OUTPUT);       // DDS DATA output
  pinMode (8, OUTPUT);       // DDS W_Clk
  digitalWrite (8, LOW);     // Force pin LOW
  pinMode (9, OUTPUT);       // DDS FQup
  pinMode (10, OUTPUT);      // DDS RESET
  digitalWrite (10 , LOW);   // Make sure DDS doesn't store bad information
  pinMode (11, OUTPUT);      // Display DB4
  pinMode (12, OUTPUT);      // Display DB5
  pinMode (13, OUTPUT);      // Display DB6
  pinMode (14, OUTPUT);      // Display DB7
  pinMode (15, OUTPUT);      // Display Eable
  pinMode (16, OUTPUT);      // Display RegSel
  delay(500);                //delay to allow DDS and LCD to stabilize
  // Reset the DDS Module First
  digitalWrite (RESET , HIGH);
  digitalWrite (RESET , LOW) ;
  // Set up DDS before use, put DDS into crystal times 6 with a beginning frequency and add control word
   F1 = ((Units) + (10 * Tens) +(100 * Hund) + (1000 * Thou) + (10000 * TenThou) + (100000 * HunThou) + (1000000 * Mill) + (10000000 * TenMil));
  Temp1 = (F1);
  Temp1 = (F1 * 4294967295/Fclk);
  shiftOut(DATA, W_CLK, LSBFIRST, Temp1);
  Temp1 = (Temp1>>8);
  shiftOut(DATA, W_CLK, LSBFIRST, Temp1);
  Temp1 = (Temp1>>8);
  shiftOut(DATA, W_CLK, LSBFIRST, Temp1);
  Temp1 = (Temp1>>8);
  shiftOut(DATA, W_CLK, LSBFIRST, Temp1 );
  shiftOut(DATA, W_CLK, LSBFIRST, Control);
  Control = 1;
  digitalWrite (FQ_UD, HIGH);
  digitalWrite (FQ_UD, LOW);
}

void loop() 
{ F1 = ((Units) + (10 * Tens) +(100 * Hund) + (1000 * Thou) + (10000 * TenThou) + (100000 * HunThou) + (1000000 * Mill) + (10000000 * TenMil));
  if (F2 != F1)
  {
  Temp1 = (F1 * 4294967295/Fclk);
  shiftOut(DATA, W_CLK, LSBFIRST, Temp1);
  Temp1 = (Temp1>>8);
  shiftOut(DATA, W_CLK, LSBFIRST, Temp1);
  Temp1 = (Temp1>>8);
  shiftOut(DATA, W_CLK, LSBFIRST, Temp1);
  Temp1 = (Temp1>>8);
  shiftOut(DATA, W_CLK, LSBFIRST, Temp1 );
  Temp1 = (Temp1>>8);
  shiftOut(DATA, W_CLK, LSBFIRST, Control);
  Control = 1;
  digitalWrite (FQ_UD, HIGH);
  digitalWrite (FQ_UD, LOW);
Control = 1;
F2 = F1;                    // Update the new Frequency
  // Update Display
  lcd.setCursor(0,0);       //Put Cursor on first line, first position
  lcd.print("FREQ= ");      //First line of display gives a space before numbers
  lcd.print(TenMil);        //Beginning of Numbers MSB first
  lcd.print(Mill);
  lcd.print(",");
  lcd.print(HunThou);
  lcd.print(TenThou);
  lcd.print(Thou);
  lcd.print(",");
  lcd.print(Hund);
  lcd.print(Tens);
  lcd.print(Units);
  lcd.setCursor(0,1);      //Goto second line for showing step size
  lcd.print("Step= ");
  if (stepsz == (1)) 
  {lcd.print("      1,000,000");
  }
  if (stepsz == (2))
  {lcd.print("       100,000");
  }
  if (stepsz == (3)) 
  {lcd.print("        10,000");
  }
  if (stepsz == (4)) 
  {lcd.print("         1,000");
  }
  if (stepsz == (5)) 
  {lcd.print("          100");
  }
  if (stepsz == (6)) 
  {lcd.print("           10");
  }
  if (stepsz == (7)) 
  {lcd.print("            1");
  }
}
pb = analogRead(26);
 if (pb < 512)
 { stepsz = (stepsz + 1);
 F2 = (1);                // Change the F2 value so that dis[play updates
   if (stepsz >= 8)
   { stepsz = 1;
   }
delay(250);               //Delay for step size
}
// following corrects for encoder changing the frequency
if(y == 1)
{ if (dirRot == 0)
  { if (stepsz == 7)
    { Mill = (Mill + 1);
    if (Mill > 9)
    { (Mill + 9);
      TenMil = (TenMil + 1);
      if (TenMil > 3)
      { TenMil = 0;
      }
    }
  }
}
if (stepsz == 6)
{ HunThou = (HunThou + 1);
  if (HunThou > 9)
  { HunThou = 0;
    Mill = (Mill + 1);
    if (Mill > 9)
    { Mill = 0;
      TenMil = (TenMil + 1);
      if (TenMil > 9)
      { TenMil = 0;
      }
    }
  }
}
  if (stepsz == 5)
  { TenThou = (TenThou + 1);
  if (TenThou > 9)
  { TenThou = 0;
    HunThou = (HunThou + 1);
    if (HunThou > 9)
    { HunThou = (0);
      Mill = (Mill +1);
    if (Mill > 9)
    { Mill = (0);
      TenMil = (TenMil +1);
      if (TenMil > 3)
      { TenMil = 0;
      }
    }
  }
}
}
if (stepsz == 4)
{
  Thou = (Thou +1 );
  if (Thou > 9)
  { Thou = (0);
    TenThou = (TenThou +1);
    if (TenThou > 9)
    { TenThou = 0;
      HunThou = (HunThou + 1);
      if (HunThou > 9)
      { HunThou = (0);
        Mill = (Mill + 1);
        if (Mill > 9)
        { Mill = 0;
          TenMil = (TenMil + 1);
          if (TenMil > 3)
          { TenMil = 0;
          }
        }
      }
    }
  }
}
if (stepsz == 3)   
{ Hund = (Hund +1);
  if (Hund > 9)
  { Hund = (0);
    Thou = (Thou + 1);
    if (Thou > 9)
    { Thou = 0;
      TenThou = (TenThou + 1);
      if (TenThou > 9)
      { TenThou = 0;
        HunThou = (HunThou + 1);
        if (HunThou > 9)
        { HunThou = 0;
          Mill = (Mill + 1);
          if (Mill > 9)
          { Mill = 0;
            TenMil = (TenMil + 1);
            if (TenMil > 3)
            { TenMil = 0;
            }
          }
        }
      }
    }
  }
}
if (stepsz == 2)
{ Tens = (Tens +1);
  if (Tens > 0)
  { Tens = 0;
    Hund = (Hund + 1);
    if (Hund > 9)
    { Hund = 0;
      Thou = (Thou + 1);
      if (Thou > 9)
      { Thou = 0;
        TenThou = (TenThou + 1);
        if (TenThou > 9)
        { TenThou = 0;
          HunThou = (HunThou + 1);
          if (HunThou > 9)
          { HunThou = 0;
            Mill = (Mill + 1);
            if (Mill > 9)
            { Mill = 0;
              TenMil = (TenMil + 1);
              if (TenMil > 3)
              { TenMil = 0;
              }
            }
          }
        }
      }
    }
  }
}
if (stepsz == 1)
{ Units = (Units + 1);
  if (Units > 9)
  { Units = 0;
    Tens = (Tens + 1);
    if (Tens > 9)
    { Tens = (0);
      Hund = (Hund + 1);
      if (Hund > 9)
      { Hund = 0;
        Thou = (Thou + 1);
        if (Thou > 9)
        { Thou = 0;
          TenThou = (TenThou + 1);
          if (TenThou > 9)
          { TenThou = 0;
            HunThou = (HunThou + 1);
            if (HunThou > 9)
            { HunThou = 0;
              Mill = (Mill + 1);
              if (Mill > 9)
              { Mill = 0;
                TenMil = (TenMil + 1);
                if (TenMil > 3)
                { TenMil = 0;
                }
              }
            }
          }
        }
      }
    }
  }
}

if(y == 1)
{ if (dirRot == 1)
  { if (stepsz == 7)
    { Mill = (Mill - 1);
    if (Mill < 0)
    { (Mill = 9);
      TenMil = (TenMil - 1);
      if (TenMil < 0)
      { TenMil = 3;
      }
    }
  }
}
}
if (stepsz == 6)
{ HunThou = (HunThou - 1);
  if (HunThou < 0)
  { HunThou = 9;
    Mill = (Mill - 1);
    if (Mill > 9)
    { Mill = 9;
      TenMil = (TenMil - 1);
      if (TenMil < 0)
      { TenMil = 3;
      }
    }
  }
}
  if (stepsz == 5)
  { TenThou = (TenThou - 1);
  if ( TenThou > 9 )
  { TenThou = 0;
    HunThou = (HunThou - 1);
    if (HunThou < 0)
    {HunThou = (9);
    Mill = (Mill - 1);
    if (Mill < 0)
    { Mill = (9);
      TenMil = (TenMil - 1);
      if (TenMil < 0)
      { TenMil = 3;
      }
    }
  }
}
}
if (stepsz == 4)
{ Thou = (Thou - 1);
  if (Thou < 0)
  { Thou = (9);
    TenThou = (TenThou - 1);
    if (TenThou < 0)
    { TenThou = 9;
      HunThou = (HunThou - 1);
      if (HunThou < 0)
      { HunThou = (9);
        Mill = (Mill - 1);
        if (Mill < 0)
        { Mill = 9;
          TenMil = (TenMil - 1);
          if (TenMil < 0)
          { TenMil = 3;
          }
        }
      }
    }
  }
}
if (stepsz == 3)   
{ Hund = (Hund - 1);
  if (Hund < 0)
  { Hund = (9);
    Thou = (Thou - 1);
    if (Thou < 0)
    { Thou = 9;
      TenThou = (TenThou - 1);
      if (TenThou < 0)
      { TenThou = 9;
        HunThou = (HunThou - 1);
        if (HunThou < 0)
        { HunThou = 9;
          Mill = (Mill - 1);
          if (Mill < 0)
          { Mill = 9;
            TenMil = (TenMil - 1);
            if (TenMil < 0)
            { TenMil = 3;
            }
          }
        }
      }
    }
  }
}
if (stepsz == 2)
{ Tens = (Tens - 1);
  if (Tens < 0)
  { Tens = 9;
    Hund = (Hund - 1);
    if (Hund < 0)
    { Hund = 9;
      Thou = (Thou - 1);
      if (Thou < 0)
      { Thou = 9;
        TenThou = (TenThou - 1);
        if (TenThou < 0)
        { TenThou = 9;
          HunThou = (HunThou - 1);
          if (HunThou < 0)
          { HunThou = 9;
            Mill = (Mill - 1);
            if (Mill < 0)
            { Mill = 9;
              TenMil = (TenMil - 1);
              if (TenMil < 0)
              { TenMil = 3;
              }
            }
          }
        }
      }
    }
  }
}
if (stepsz == 1)
{ Units = (Units - 1);
  if (Units < 0)
  { Units = 9;
    Tens = (Tens - 1);
    if (Tens < 0)
    { Tens = 9;
      Hund = (Hund - 1);
      if (Hund < 0)
      { Hund = 9;
        Thou = (Thou - 1);
        if (Thou < 0)
        { Thou = 9;
          TenThou = (TenThou - 1);
          if (TenThou < 0)
          { TenThou = 9;
            HunThou = (HunThou - 1);
            if (HunThou < 0)
            { HunThou = 9;
              Mill = (Mill - 1);
              if (Mill < 0)
              { Mill = 9;
                TenMil = (TenMil - 1);
                if (TenMil < 0)
                { TenMil = 3;
                }
              }
            }
          }
        }
      }
    }
  }
}
}
y = 0;
}
  
void FXC() 
{ 
  z = digitalRead (6);
  if (z = 0)
  { dirRot = 1;
}
else 
{
  (dirRot = 0);
  y = 1;
}
}

