/* Title: solutions.c
 * Author: Jed Marti KI7NNP
 * Description: Compute the capacitance of all the different circuits and return.
 * Revision History: (Created Sun Sep 11 15:19:52 2022)
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <math.h>
#include "caps.h"


////////////////////////////////////////////////////////////////////////////////////////////////////
//                                          Single Capacitor

double circuit1(double c)
/*     A single capacitor.
 */
{
  return c;
}



////////////////////////////////////////////////////////////////////////////////////////////////////
//                                           Two Capacitors

double circuit2a(double c1, double c2)
/*     Two capacitors in parallel.
 */
{
  return (c1 + c2);
}



double circuit2b(double c1, double c2)
/*     Two capacitors in series.
 */
{
  return 1.0 / (1.0 / c1 + 1.0 / c2);
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//                                         Three Capacitors

double circuit3a(double c1, double c2, double c3)
/*     3 capacitors in parallel.
 */
{
  return (c1 + c2 + c3);
}



double circuit3b(double c1, double c2, double c3)
/*     Two in series, one parallel to last one.
 */
{
  return 1.0 / (1.0 / c1 + 1.0 / (c2 + c3));
}




double circuit3c(double c1, double c2, double c3)
/*     Two in series, one parallel to both.
 */
{
  return (c3 + 1.0 / (1.0 / c1 + 1.0 / c2));
}



double circuit3d(double c1, double c2, double c3)
/*     Three in series.
 */
{
  return 1.0 / (1.0 / c1 + 1.0 / c2 + 1.0 / c3);
}



////////////////////////////////////////////////////////////////////////////////////////////////////
//                                          Four Capacitors

double circuit4a(double c1, double c2, double c3, double c4)
/*     Four in series.
 */
{
  return 1.0 / (1.0 / c1 + 1.0 / c2 + 1.0 / c3 + 1.0 / c4);
}



double circuit4b(double c1, double c2, double c3, double c4)
/*     3 in series, one in parallel on one.
 */
{
  return 1.0 / (1.0 / c1 + 1.0 / c2 + 1.0 / (c3 + c4));
}



double circuit4c(double c1, double c2, double c3, double c4)
/*     3 in series + one in parallel with 2 in series.
 */
{
  return 1.0 / (1.0 / c1 + (1.0 / (c4 + 1.0 / (1.0 / c2 + 1.0 / c3))));
}



double circuit4d(double c1, double c2, double c3, double c4)
/*     3 in series + one in parallel with the 3.
 */
{
  return c4 + 1.0 / (1.0 / c1 + 1.0 / c2 + 1.0 / c3);
}



double circuit4e(double c1, double c2, double c3, double c4)
/*     Two sets of two in parallel, then in series.
 */
{
  return 1.0 / (1.0 / (c1 + c2) + 1.0 / (c3 + c4));
}



double circuit4f(double c1, double c2, double c3, double c4)
/*     Two sets of two in series, then both in parallel.
 */
{
  return (1.0 / (1.0 / c1 + 1.0 / c2)) + (1.0 / (1.0 / c3 + 1.0 / c4));
}



double circuit4g(double c1, double c2, double c3, double c4)
/*     One in series with 3 in parallel.
 */
{
  return 1.0 / (1.0 / c1 + 1.0 / (c2 + c3 + c4));
}



double circuit4h(double c1, double c2, double c3, double c4)
/*     Two in parallel in parallel with two in series.
 */
{
  return (1.0 / (1.0 / c1 + 1.0 / c2)) + c2 + c3;
}


double circuit4i(double c1, double c2, double c3, double c4)
// Special thanks to David Luker.
{
  return 1.0 / (1.0 / (c1 + c3) + 1.0 / c2) + c4;
}



double circuit4j(double c1, double c2, double c3, double c4)
/*     Four in parallel.
 */
{
  return c1 + c2 + c3 + c4;
}


// EOF
