/* Title: caps.h
 * Author: Jed Marti KI7NNP
 * Description: enumerations, porototypes for the capacitance calculator.
 * Revision History: (Created Sun Sep 11 14:51:00 2022)
 */

#ifndef caps_h
#define caps_h

#define VERSION 1
#define RELEASE 1
#define PATCH   4


// The maximum number of capacitors we're going to include in the solution.
#define MAXCAPS 4

// For saving best results.
typedef struct {
  uint8_t  cnt;              // Number of caps
  double   bestcs[MAXCAPS];  // Their best values.
  uint64_t bestperm;         // The permuation that got us here.
  double   bestres;          // Best result (nearest target).
  double   bestgoodness;     // Difference between target and result.
  char     *bestcircuit;     // Circuit name.
} Optimal;

// Indices in the result array.
enum {
  Circuit1 = 0,
  Circuit2 = 1,
  Circuit3 = 2,
  Circuit4 = 3
};

// See readcaps.c - read the junk box file of capacitors in picofarads.
uint8_t readCapacitorFile(char *fname);

// See solutions.c - these are the functions to solve for each circuit.
double circuit1(double c);
double circuit2a(double c1, double c2);
double circuit2b(double c1, double c2);
double circuit3a(double c1, double c2, double c3);
double circuit3b(double c1, double c2, double c3);
double circuit3c(double c1, double c2, double c3);
double circuit3d(double c1, double c2, double c3);
double circuit4a(double c1, double c2, double c3, double c4);
double circuit4b(double c1, double c2, double c3, double c4);
double circuit4c(double c1, double c2, double c3, double c4);
double circuit4d(double c1, double c2, double c3, double c4);
double circuit4e(double c1, double c2, double c3, double c4);
double circuit4f(double c1, double c2, double c3, double c4);
double circuit4g(double c1, double c2, double c3, double c4);
double circuit4h(double c1, double c2, double c3, double c4);
double circuit4i(double c1, double c2, double c3, double c4);
double circuit4j(double c1, double c2, double c3, double c4);


// See utils.c - bit fiddling.
uint8_t bitson(uint64_t v);
uint8_t bitIndex(uint64_t, uint8_t whichb);
uint8_t isInt(char *msg);

#endif
