// =====================================================================================================================================================================================================
// (c) 2021 Lynn Hansen, KU7Q															                                                                                                               |
// This Source Code Form is subject to the terms of the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007. A copy of this license can be found here: https://choosealicense.com/licenses/gpl-3.0/|
// =====================================================================================================================================================================================================


// Terminal routines for ChkPCCmd() 


void SendTermMenu()
{
	//We're in terminal mode on serial port - send starting menu	
	TermOut(" ", true);
	TermOut("CTR2 Terminal Menu", true);
	TermOut(" ", true);
	TermOut("Select one of the following options:", true);
	TermOut(" ", true);
	TermOut("[F1]   Help                   [F2]    Disable Tx Mode    [F3]   Enable Tx Mode", true);
	TermOut("[F4]   Virtual Keyboard       [F5]    Log Call Sign      [F6]   Log Sent RST", true);
	TermOut("[F7]   Log Rcvd RST           [F8]    Log Output Power   [F9]   Log Contest Ctr", true);
	TermOut("[F10]  Log Contest Exchange   [F11]   Save Log           [F12]  View Rx Buffer", true);
	TermOut(" ", true);
	TermOut("[Tab]  List ADIF Log File (Delete Log from Config Page)", true);
	TermOut("[PgUp] [PgDn] Cycle Encoder   [Up Arrow]    Inc Value   [Left]  Freq Step Left", true);
	TermOut("[Home] Reset Encoder          [Down Arrow]  Dec Value   [Right] Freq Step Right", true);
	TermOut("[ESC]  Return to Home page    [Enter] Accept and return ", true);
	if (hmiPage == HMI_HOME)
	{
		TermOut(" ", true);
		TermOut("In CW or RTTY MODES:", true);
		TermOut("--------------------------------------------------------------------------------", true);
		TermOut("Enter [Alt+1] to [Alt+0] to Transmit buffer 1 to 10", true);
		TermOut("  NOTE: Use [Ctrl+#] instead of [Alt+#] on local keyboard", true);
		TermOut("Enter up to 74 chrs then press [Enter] to Transmit buffer", true);
		TermOut("[Insert]  Pause Tx Buffer      [End]  Delete Tx Buffer", true);
		TermOut("--------------------------------------------------------------------------------", true);
		TermOut(" ", true);
	}
	TermOut("Press [Enter] twice to display this menu.", true);

	TermOut(" ", true);

}

void SendTxBuffer(uint8_t & chrCtr)
{
	//send terminal string to bTx.txt to tx it
	if (gOMode != MODE_DIG && chrCtr > 0)
	{
		String txt = "";
		for (int i = 0; i < chrCtr; i++)
		{
			txt += String(char(pcCmdRx[i]));
		}
		if (hmi_bTx == "Tx:")
		{
			hmi_bTx = txt; //new buffer
		}
		else
		{
			hmi_bTx += txt; //append it to current buffer
		}
		Tx2HMI("Home.bTx.txt=`" + hmi_bTx + "`"); //load buffer
		Tx2HMI("Home.bTx.txt=`" + hmi_bTx + "`");
		Tx2HMI("Home.btPlay.val=1"); //start keyer
		Tx2HMI("Home.btPlay.val=1");
	}
	else if (hmiPage != HMI_HOME)
	{
		//just send cr to display
		keyboardChr = 13;
		ChkChr2HMI(); //process it
	}
	chrCtr = 0;
}

void TermOut(String txt, bool lfcr)
{
	//this routine is used by terminal mode
	if (gComMode == COM_MODE_TERM)
	{
		if (!lfcr)
		{
			Serial.print(txt);
		}
		else
		{
			Serial.print(txt + "\r\n");
		}
	}
}


void ProcessTerminalCmd(uint8_t & chrCtr)
{
	//process the terminal command received from ChkPCCmd()
	//we come here if chrs rx from pc start with 27 91, check remaining chrs
	//convert key sequence to keycode then call ChkChr2HMI()
	int kyCode = 0;

	//chk for esc key 	
	if (pcCmdRx[0] == 27 && chrCtr == 1)
	{
		kyCode = pcCmdRx[0]; //return to home page
		goto ExitHr;
	}

	if (chrCtr == 2)
	{
		//translate alt+1 to alt+0 to keyCodes 17-25 as sent from the local keyboard
		switch (pcCmdRx[1])
		{
			//value 48 (0) to 57 (9)
		case 49: //alt+1
			kyCode = 17; //ctr+1 from keyboard
			break;
		case 50: //2
			kyCode = 18;
			break;
		case 51: //3
			kyCode = 19;
			break;
		case 52: //4
			kyCode = 20;
			break;
		case 53: //5
			kyCode = 21;
			break;
		case 54: //6
			kyCode = 22;
			break;
		case 55: //7
			kyCode = 23;
			break;
		case 56: //8
			kyCode = 24;
			break;
		case 57: //9
			kyCode = 25;
			break;
		case 48: //0 - tx buffer 10
			kyCode = 16;
			break;
		}
	}
	else if (chrCtr == 3)
	{
		switch (pcCmdRx[2])
		{
		case 65: //up arrow
			kyCode = 218;
			break;
		case 66: //down arrow
			kyCode = 217;
			break;
		case 68: //left arrow
			kyCode = 216;
			break;
		case 67: //right arrow
			kyCode = 215;
			break;
		}
	}
	else if (chrCtr == 4 && pcCmdRx[3] == 126)
	{
		//chk for home key
		if (pcCmdRx[2] == 49)
		{
			kyCode = 210;
		}
	}
	else if (chrCtr == 5 && pcCmdRx[4] == 126)
	{
		//longer esc strings
		switch (pcCmdRx[2])
		{
		case 49: //first chr of f1-f8 keys
			switch (pcCmdRx[3])
			{
			case 49: //f1 - open help
				kyCode = 194;
				break;
			case 50: //f2 - disable tx
				kyCode = 195;
				break;
			case 51: //f3 - enable tx
				kyCode = 196;
				break;
			case 52: //f4 - opens keyboard - not used with terminal
				kyCode = 197;
				break;
			case 53: //f5 - edit call
				kyCode = 198;
				break;
			case 55: //f6 - edit sRST
				kyCode = 199;
				break;
			case 56: //f7 - edit rRST
				kyCode = 200;
				break;
			case 57: //f8 - edit pwr
				kyCode = 201;
				break;
			}
			break;
		case 50: //first chr of f9-f12, some others
			switch (pcCmdRx[3])
			{
			case 48: //f9 - edit contest ctr
				kyCode = 202;
				break;
			case 49: //f10 - edit exch
				kyCode = 203;
				break;
			case 51: //f11 - save log
				kyCode = 204;
				break;
			case 52: //f12 - view rx buffer
				kyCode = 205;
				break;
			}
			break;
		case 52: // end key - del current tx buff
			kyCode = 213;
			break;
		case 53: // pg up
			kyCode = 211;
			break;
		case 54: //pg down - dec gEncoder
			kyCode = 214;
			break;
		}
	}
	else if (chrCtr > 5)
	{
		chrCtr = 0; //too long, reset
	}
ExitHr:
	if (kyCode)
	{
		chrCtr = 0;
		keyboardChr = kyCode;
		ChkChr2HMI(); //process key input from terminal
	}

}
