// =====================================================================================================================================================================================================
// (c) 2021 Lynn Hansen, KU7Q															                                                                                                               |
// This Source Code Form is subject to the terms of the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007. A copy of this license can be found here: https://choosealicense.com/licenses/gpl-3.0/|
// =====================================================================================================================================================================================================



bool SetAntSwitch(bool rst)
{
	//THIS CODE SETS THE RELAYS ON THE ANTENNA SWITCH CONTROLLER BASED ON THE BITS IN gAnt

	//reset all (rst=true) during initialization

	//only allow ant switching in Rx mode
	if (gTxMode < RADIO_TX_PADDLE && gTxModeSet2 < RADIO_TX_PADDLE)
	{
		pinMode(RJ_SW_DATA_1, OUTPUT); //set new address
		pinMode(RJ_SW_DATA_2, OUTPUT);
		pinMode(RJ_SW_DATA_3, OUTPUT);
		pinMode(RJ_SW_DATA_4, OUTPUT);
		digitalWrite(RJ_SW_STROBE, LOW); //make sure this is low so we ignore it
		digitalWrite(ANT_SW_STROBE, HIGH); //this goes high to low to strobe
		delay(10);

		for (int cnt = 0; cnt < 2; cnt++)
		{
			uint8_t set = 0; //set relay are adrs 0-7
			uint8_t reset = 8; //reset relays are adrs 8=15
			uint8_t adrs = 0; //holds the set/reset adrs depending on bit state in cmd
			uint8_t val = gAnt;
			//cycle through gAnt and set corresponding relay
			//send commands twice to make sure they take
			for (int i = 0; i < 8; i++)
			{
				//get bit value		

				// The commented out if() below will reset all relays on first pass then set them on second pass
				//if (val & 0x01 && cnt > 0 && rst == false)

				if (val & 0x01 && rst == false)
				{
					adrs = set;
				}
				else
				{
					adrs = reset;
				}
				digitalWrite(RJ_SW_DATA_1, (adrs & 0x01));
				digitalWrite(RJ_SW_DATA_2, (adrs & 0x02) >> 1);
				digitalWrite(RJ_SW_DATA_3, (adrs & 0x04) >> 2);
				digitalWrite(RJ_SW_DATA_4, (adrs & 0x08) >> 3);
				delay(10);
				//strobe new adrs out and disable Inhibit so relay is activated
				digitalWrite(ANT_SW_STROBE, LOW);
				delay(10);
				//brings Inhibit high so relay is inactive
				digitalWrite(ANT_SW_STROBE, HIGH); //pull low to latch adrs bits and send to relay - INHIBIT is strapped low
				delay(10);
				//SerialOut("i= " + String(i) + ", adrs= " + String(adrs) + ", val= " + String(val), true);
				val >>= 1; //rotate to next bit
				set++; //inc to next set relay
				reset++; //inc to next reset adrs
			}
		}
		return true; //switched OK
	}
	else
	{
		return false; //failed to switch
	}
}

void SetRJ45Switch()
{
	//THIS CODE ALSO CONTROLS THE RADIO ANTENNA SWITCH RELAYS

	//chk for active boards and select based on gRadioSel
	uint8_t boards = ChkRJ45SwitchBoards();
	uint8_t adrs = 0xff;
	if (!boards)
	{
		//not installed
		SerialOut("No RJ45 boards found", true);
		return;
	}

	//determine which port to select	
	if (gRadioSel < 4)
	{
		//we'll always have the first four ports if the switch is installed so just select the port we need
		adrs = gRadioSel;
	}
	else if (gRadioSel < 8)
	{
		//gRadioSel is on the second row
		if (boards & 0x02)
		{
			//board installed, used selected radio port
			adrs = gRadioSel;
		}
		else
		{
			//board not installed, use the port above
			adrs = gRadioSel - 4;
		}
	}
	else if (gRadioSel < 12)
	{
		//radios on the third row
		if (boards & 0x04)
		{
			//board installed
			adrs = gRadioSel;
		}
		else if (boards & 0x02)
		{
			//board above is installed, use it
			adrs = gRadioSel - 4;
		}
		else
		{
			//only the first board is installed use the active port above the selected radio
			adrs = gRadioSel - 8;
		}
	}
	else
	{
		//radios on the bottom row
		if (boards & 0x08)
		{
			//board installed
			adrs = gRadioSel;
		}
		else if (boards & 0x04)
		{
			//board in slot 3 is installed, use it
			adrs = gRadioSel - 4;
		}
		else if (boards & 0x02)
		{
			//board in slot 2 installed, use it
			adrs = gRadioSel - 8;
		}
		else
		{
			//only first port is active use it
			adrs = gRadioSel - 12;
		}
	}

	//SerialOut("RJ45 Switch - adrs =" + String(adrs), true);
	if (adrs == 0xff)
	{
		SerialOut("RJ45 Address failed", true);
		return; //something went wrong
	}

	if (gRadioSel != gRadioSelPrev)
	{
		//mute audio and drop out current relays if changing
		sgtl5000_1.volume(0.0); //mute while changing radios
		digitalWrite(RJ_SW_INHIBIT, HIGH); //disable output from the encoder to drop out all relays
		delay(20);
	}

	//uncomment ctrlAllRJ45Ports at start of code to ignore the logic above and directly control all RJ45 and antenna switch ports (whether RJ45 switch cards are detected or not)
#ifdef ctrlAllRJ45Ports
	{
		adrs = gRadioSel; //ignore installed boards
	}
#endif

	//set relay group
	digitalWrite(RJ_SW_STROBE, LOW); //pulse the strobe to latch the relay adrs

	pinMode(RJ_SW_DATA_1, OUTPUT); //set new address
	pinMode(RJ_SW_DATA_2, OUTPUT);
	pinMode(RJ_SW_DATA_3, OUTPUT);
	pinMode(RJ_SW_DATA_4, OUTPUT);
	delay(1);
	digitalWrite(RJ_SW_DATA_1, (adrs & 0x01));
	digitalWrite(RJ_SW_DATA_2, (adrs & 0x02) >> 1);
	digitalWrite(RJ_SW_DATA_3, (adrs & 0x04) >> 2);
	digitalWrite(RJ_SW_DATA_4, (adrs & 0x08) >> 3);
	delay(20);
	digitalWrite(RJ_SW_STROBE, HIGH); //pulse the strobe to latch the relay adrs
	delay(20);
	digitalWrite(RJ_SW_STROBE, LOW);
	delay(20);
	digitalWrite(RJ_SW_INHIBIT, LOW); //enable output from the encoder to pull in the relays

	boards = ChkRJ45SwitchBoards(); //call again to reset data pins to input. We don't care their status now

	if (gRadioSel != gRadioSelPrev)
	{
		sgtl5000_1.volume(0.8); //bring it back up
	}
}