// =====================================================================================================================================================================================================
// (c) 2021 Lynn Hansen, KU7Q															                                                                                                               |
// This Source Code Form is subject to the terms of the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007. A copy of this license can be found here: https://choosealicense.com/licenses/gpl-3.0/|
// =====================================================================================================================================================================================================



// THIS FILE CONTAINS CODE THAT MANAGES THE RADIO COMM


void ChkRadioRx()
{
	//wait for rx from radio	
	if (RADIO.available() > 0 && radioRxBytes > 0)
	{
		int radioMsgCtr = 0;

		byte rx = 0;

		long radioMsgTimeout = millis();//set start of rx window

	Wait4Chr:
		while (radioMsgTimeoutDefault > millis() - radioMsgTimeout)
		{
			//wait for reply			
			if (RADIO.available() > 0)
			{
				rx = RADIO.read();
				
				//wait for start bytes
				switch (gRadio)
				{
				case RADIO_TYPE_ICOM:
					//must start with 0xfe 0xfe and end with 0xfd, and be the correct length
					if ((radioMsgCtr == 0) && (rx != 0xfe))
					{
						goto Wait4Chr;
					}
					else if ((radioMsgCtr == 1) && (rx != 0xfe))
					{
						radioMsgCtr = 0;
						goto Wait4Chr;
					}
					else if ((radioMsgCtr == 2) && (rx != 0xe0))
					{
						//msg with master "from" address - this is proably an echo of the tx cmd, wait for correct formt for reply
						radioMsgCtr = 0;
						goto Wait4Chr;
					}
					else if ((radioMsgCtr == radioRxBytes) && (rx != 0xfd))
					{
						//bad end chr, recync
						radioMsgCtr = 0;
						goto Wait4Chr;
					}
					else if ((radioMsgCtr > 1 && radioMsgCtr < radioRxBytes - 1))
					{
						//check for sync chrs in the middle in case we join mid stream
						if (rx == 0xfe)
						{
							radioMsgCtr = 0; //accept this as the start of the next packet and continue							
						}
						else if (rx == 0xfd)
						{
							radioMsgCtr = 0; //start over
							goto Wait4Chr;
						}
					}
					break;
				case RADIO_TYPE_KENWOOD1:
Kenwood:
					//must start with "IF" and end with ";" and be the correct length
					if ((radioMsgCtr == 0) && (rx != 'I'))
					{
						//wait for a 'I'
						goto Wait4Chr;
					}
					else if ((radioMsgCtr == 1) && (rx != 'F'))
					{
						//reset if we don't get 'F' in the second position
						radioMsgCtr = 0;
						goto Wait4Chr;
					}
					else if ((radioMsgCtr != radioRxBytes) && (rx == ';'))
					{
						//reset if we get a ';' midstream
						radioMsgCtr = 0;
						goto Wait4Chr;
					}
					break;
				case RADIO_TYPE_KENWOOD2:
					goto Kenwood;
					break;
				case RADIO_TYPE_YAESUFTDX:
					//must start with IF and end with ";' and be correct length
					if ((radioMsgCtr == 0) && (rx != 'I'))
					{
						//wait for start of msg
						goto Wait4Chr;
					}
					else if ((radioMsgCtr == 1) && (rx != 'F'))
					{
						radioMsgCtr = 0;
						goto Wait4Chr;
					}
					else if ((radioMsgCtr + 1 != radioRxBytes) && (rx == ';'))
					{
						//IGNORE LOCATION OF TERMINATOR (;) - RADIO HAS A BUG THAT CAN ADD ADDITIONAL CHRS TO REPLY SO JUST LOOK FOR ; AT THE END OF THE MESSAGE
						//terminator in wrong bin
						//radioMsgCtr = 0;
						//goto Wait4Chr;
					}
					break;
				case RADIO_TYPE_YAESU100:
					//no validation required for Yaesu
					break;
				}
				//SerialOut(String(radioMsgCtr) + ":" + String(rx, HEX) + " ", false);
				radioRx[radioMsgCtr] = rx;				
				if (radioMsgCtr == radioRxBytes || (radioRx[radioMsgCtr] == ';' && gRadio==RADIO_TYPE_YAESUFTDX))
				{
					//SerialOut(" Got one!", true);
					DecRadioRx(radioMsgCtr);
					return; //we're done
				}
				radioMsgCtr++;
				goto Wait4Chr;
			}
			goto Wait4Chr;
		}
		//clear buffer if rx fails
		for (int i = 0; i < radioRxBufMax; i++)
		{
			radioRx[i] = 0;
		}
		//SerialOut("--> err - Radio Fail!", true);
		if (radioMsgCtr > 1)
		{
			//ignore single random chrs
			hmiWait4Reply = 0;
			Tx2HMI("Home.tInfo1.txt=`Radio Fail!`");
		}
		else
		{
			SerialOut(" ignore junk from radio ", true);
		}
	}
}

void DecRadioRx(int msgCtr)
{
	//decodes msg rx from ChkRadioRx()

	switch (gRadio)
	{
	case RADIO_TYPE_ICOM:
		if (radioRx[0] == 0xfe && radioRx[1] == 0xfe && radioRx[radioRxBytes] == 0xfd)
		{
			if (radioRxBytes == 10)
			{
				//decode freq				
				gFreqRadio = ((radioRx[9] & 0xf) * 100000000) + ((radioRx[8] >> 4) * 10000000) + ((radioRx[8] & 0xf) * 1000000) + ((radioRx[7] >> 4) * 100000) + ((radioRx[7] & 0xf) * 10000) + ((radioRx[6] >> 4) * 1000) + ((radioRx[6] & 0xf) * 100) + ((radioRx[5] >> 4) * 10) + (radioRx[5] & 0xf);
				//SerialOut("gFreqRadio from Icom= " + String(gFreqRadio), true);
				if (gFreqRadio < 100000)
				{
					//invalid reply, ignore and exit
					SerialOut("Invalid gFreqRadio = " + String(gFreqRadio), true);
					gFreqRadio = gFreqRadioPrev;
					return;
				}
				ChkFreqChange();
				gIcmAdr = radioRx[3]; //get "from" address				
			}
			else if (radioRxBytes == 7)
			{
				gRMode = radioRx[5];
				//match hmi mode values
				switch (gRMode)
				{
				case 0: //LSB
					gRMode = RADIO_LSB;
					break;
				case 1: //USB
					gRMode = RADIO_USB;
					break;
				case 2: //AM
					gRMode = RADIO_AM;
					break;
				case 3: //CW
					gRMode = RADIO_CW;
					break;
				case 4: //RTTY
					gRMode = RADIO_DIG_H; //DigU
				case 5: //FMn
					gRMode = RADIO_FM_N;
					break;
				case 6: //FMw
					gRMode = RADIO_FM_W;
					break;
				case 7: //CWr
					gRMode = RADIO_CW_R;
					break;
				case 8: //RTTY-r
					gRMode = RADIO_DIG_L; //DigL
					break;
				case 0x12: //Dig
					gRMode = RADIO_DIG_H; //DigU
					break;
				case 0x13:
					gRMode = RADIO_DIG_L; //DigL - not sure about this mode - DL40r.de shows it as 0x12, same as Dig normal
					break;
				}
			}
		}
		break;
	case RADIO_TYPE_KENWOOD1:
	Kenwood:
		if (radioRx[0] == 'I' && radioRx[1] == 'F' && radioRxBytes == 37 && radioRx[radioRxBytes] == ';')
		{

			//must start with "IF", be 38 bytes long, and end with ";" to be valid
			//not using the 10ghz or 1ghz digits in [2] and [3]


			/*
			//debug
			for (int i = 0; i < radioRxBytes; i++)
			{
				SerialOut(String(radioRx[i], HEX) + " ", false);
			}
			SerialOut("", true);
			SerialOut("# of Rx bytes= " + String(radioRxBytes), true);
			*/

			//info sent as ascii chars - strip off 4msb
			gFreqRadio = ((radioRx[4] & 0x0f) * 100000000) + ((radioRx[5] & 0x0f) * 10000000) + ((radioRx[6] & 0x0f) * 1000000) + ((radioRx[7] & 0x0f) * 100000) + ((radioRx[8] & 0x0f) * 10000)
				+ ((radioRx[9] & 0x0f) * 1000) + ((radioRx[10] & 0x0f) * 100) + ((radioRx[11] & 0x0f) * 10) + (radioRx[12] & 0x0f);
			if (gFreqRadio < 100000)
			{
				//invalid reply, ignore and exit
				SerialOut("Invalid gFreqRadio = " + String(gFreqRadio), true);
				gFreqRadio = gFreqRadioPrev;
				return;
			}
			ChkFreqChange();
			gRMode = radioRx[29] & 0x0f;
			//match hmi mode values
			switch (gRMode)
			{
			case 1: //LSB
				gRMode = RADIO_LSB;
				break;
			case 2: //USB
				gRMode = RADIO_USB;
				break;
			case 3: //CW
				gRMode = RADIO_CW;
				break;
			case 4: //FM
				gRMode = RADIO_FM_W;
				break;
			case 5: //AM
				gRMode = RADIO_AM;
				break;
			case 6: //fsk
				gRMode = RADIO_DIG_L;
				break;
			case 7: //CWr
				gRMode = RADIO_CW_R;
				break;
			case 9: //FSKr
				gRMode = RADIO_DIG_H; //DigU
				break;
			}
		}
		break;
	case RADIO_TYPE_KENWOOD2:
		goto Kenwood;
		break;
	case RADIO_TYPE_YAESUFTDX:
		//allow for random length replies to IF; request - bug in radio causes random data appended to end of IF; reply but aLWAYS TERMINATED WITH A ;
		//SerialOut("\nmsgCtr=" + String(msgCtr), true);
		if (radioRx[0] == 'I' && radioRx[1] == 'F' && radioRx[msgCtr] == ';')
		{

			/*
			//debug
			for (int i = 0; i < radioRxBytes; i++)
			{
				SerialOut(String(radioRx[i], HEX) + " ", false);
			}
			SerialOut("", true);
			SerialOut("# of Rx bytes= " + String(radioRxBytes), true);
			*/
			//info sent as ascii chars - strip off 4msb
			gFreqRadio = ((radioRx[5] & 0x0f) * 100000000) + ((radioRx[6] & 0x0f) * 10000000) + ((radioRx[7] & 0x0f) * 1000000) + ((radioRx[8] & 0x0f) * 100000) + ((radioRx[9] & 0x0f) * 10000)
				+ ((radioRx[10] & 0x0f) * 1000) + ((radioRx[11] & 0x0f) * 100) + ((radioRx[12] & 0x0f) * 10) + (radioRx[13] & 0x0f);
			if (gFreqRadio < 100000)
			{
				//invalid reply, ignore and exit
				SerialOut("Invalid gFreqRadio = " + String(gFreqRadio), true);
				gFreqRadio = gFreqRadioPrev;
				return;
			}
			ChkFreqChange();
			gRMode = radioRx[21] & 0x0f;
			//match hmi mode values
			switch (gRMode)
			{
			case 1: //LSB
				gRMode = RADIO_LSB;
				break;
			case 2: //USB
				gRMode = RADIO_USB;
				break;
			case 3: //CW
				gRMode = RADIO_CW;
				break;
			case 4: //FM
				gRMode = RADIO_FM_W;
				break;
			case 5: //AM
				gRMode = RADIO_AM;
				break;
			case 6: //FSK
				gRMode = RADIO_DIG_L; //DigL
				break;
			case 7: //CWr
				gRMode = RADIO_CW_R;
				break;
			case 8: //Dig low
				gRMode = RADIO_DIG_L;
				break;
			case 0x0C:
				gRMode = RADIO_DIG_H;
			default:
				gRMode = RADIO_USB; //unknown mode
			}
		}
		break;
	case RADIO_TYPE_YAESU100:
		//responce from status update cmd
	RxYaesu100:
		gFreqRadio = (radioRx[1] << 24) + (radioRx[2] << 16) + (radioRx[3] << 8) + radioRx[4]; //encoded as a 32 bit #
		if (gFreqRadio < 100000)
		{
			//invalid reply, ignore and exit
			SerialOut("Invalid gFreqRadio = " + String(gFreqRadio), true);
			gFreqRadio = gFreqRadioPrev;
			return;
		}
		ChkFreqChange();
		gRMode = radioRx[5] & 0x0F;
		//match mode to hmi rMode
		switch (gRMode)
		{
		case 0: //LSB
			gRMode = RADIO_LSB;
			break;
		case 1: //USB
			gRMode = RADIO_USB;
			break;
		case 2: //CW
			gRMode = RADIO_CW;
			break;
		case 3: //CWr
			gRMode = RADIO_CW_R;
			break;
		case 4: //AM			
			gRMode = RADIO_AM;
			break;
		case 5: //Dig on FT100, not used on 8x7
			gRMode = RADIO_DIG_H;
			break;
		case 6: //FMn on FT100
			gRMode = RADIO_FM_N;
			break;
		case 7: //FMw on FT100
			gRMode = RADIO_FM_W;
			break;
		case 8: //FM
			gRMode = RADIO_FM_N;
			break;
		case 0xA: //Dig
			gRMode = RADIO_DIG_H; //DigU
			break;
		case 0xC: //Pkt
			gRMode = RADIO_DIG_L; //DigL
		}
		break;
	case RADIO_TYPE_YAESU1000: //return 16 bytes with band [0], freq [1] through [4], clarifier [5] & [6], mode [7], IF filter offset [8], VFO/Mem flags [9], [10] through [15] not used
	RxYaesu1000:
		gFreqRadio = (radioRx[1] << 24) + (radioRx[2] << 16) + (radioRx[3] << 8) + radioRx[4]; //encoded as a 32 bit #
		if (gFreqRadio < 100000)
		{
			//invalid reply, ignore and exit
			SerialOut("Invalid gFreqRadio = " + String(gFreqRadio), true);
			gFreqRadio = gFreqRadioPrev;
			return;
		}
		ChkFreqChange();
		gRMode = radioRx[7];
		//convert radio mode to hmi modes
		switch (gRMode)
		{
		case 0: //LSB
			gRMode = RADIO_LSB;
			break;
		case 1: //USB
			gRMode = RADIO_USB;
			break;
		case 2: //CW
			gRMode = RADIO_CW;
			break;
		case 3: //AM
			gRMode = RADIO_AM;
			break;
		case 4: //FM
			gRMode = RADIO_FM_N;
			break;
		case 5: //RTTY
			gRMode = RADIO_DIG_H; //DigU
			break;
		case 6: //Pkt
			gRMode = RADIO_DIG_L; //DigL
			break;
		}
		break;
	case RADIO_TYPE_YAESU757:
		goto RxYaesu100;
		break;
	case RADIO_TYPE_YAESU890:
		goto RxYaesu1000;
	case RADIO_TYPE_YAESU8x7:
		//chk mode first - if it's invalid, throw this packet away
		int val = radioRx[4];
		//match mode to hmi rMode
		switch (val)
		{
		case 0: //LSB
			gRMode = RADIO_LSB;
			break;
		case 1: //USB
			gRMode = RADIO_USB;
			break;
		case 2: //CW
			gRMode = RADIO_CW;
			break;
		case 3: //CWr
			gRMode = RADIO_CW_R;
			break;
		case 4: //AM			
			gRMode = RADIO_AM;
			break;
		case 6: //FMn on FT100
			gRMode = RADIO_FM_N;
			break;
		case 7: //FMw on FT100
			gRMode = RADIO_FM_W;
			break;
		case 8: //FM
			gRMode = RADIO_FM_N;
			break;
		case 0xA: //Dig
			gRMode = RADIO_DIG_H; //DigH
			break;
		case 0xC: //Pkt
			gRMode = RADIO_DIG_L; //DigL
			break;
		default:
			return; //bad mode = bad packet
			break;
		}

		//freq reply
		//SerialOut("\nRx: " + String(radioRx[0], HEX) + " " + String(radioRx[1], HEX) + " " + String(radioRx[2], HEX) + " " + String(radioRx[3], HEX)  + " " + String(radioRx[4], HEX), true);
		gFreqRadio = ((radioRx[0] >> 4) * 100000000) + ((radioRx[0] & 0x0f) * 10000000) + ((radioRx[1] >> 4) * 1000000) + ((radioRx[1] & 0x0f) * 100000) + ((radioRx[2] >> 4) * 10000) + ((radioRx[2] & 0x0f) * 1000) + ((radioRx[3] >> 4) * 100) + ((radioRx[3] & 0x0f) * 10);
		if (gFreqRadio < 100000)
		{
			//invalid reply, ignore and exit
			SerialOut("Invalid gFreqRadio = " + String(gFreqRadio), true);
			gFreqRadio = gFreqRadioPrev;
			return;
		}
		ChkFreqChange();
	}
}


void CalcKenwoodFreq(char *sFrq)
{
	//calculates freq string for kenwood reply
	uint32_t frq = gFreqRadio; //use gFreqHMI - gFreqRadio depends on a radio being selected
	uint32_t val = 0;
	//separate out individual freq values
	if (frq > 99999999)
	{
		val = frq / 100000000;
		sFrq[2] = val | 0x30;
		frq -= val * 100000000;
	}
	if (frq > 9999999)
	{
		val = frq / 10000000;
		sFrq[3] = val | 0x30;
		frq -= val * 10000000;
	}
	if (frq > 999999)
	{
		val = frq / 1000000;
		sFrq[4] = val | 0x30;
		frq -= val * 1000000;
	}
	if (frq > 99999)
	{
		val = frq / 100000;
		sFrq[5] = val | 0x30;
		frq -= val * 100000;
	}
	if (frq > 9999)
	{
		val = frq / 10000;
		sFrq[6] = val | 0x30;
		frq -= val * 10000;
	}
	if (frq > 999)
	{
		val = frq / 1000;
		sFrq[7] = val | 0x30;
		frq -= val * 1000;
	}
	if (frq > 99)
	{
		val = frq / 100;
		sFrq[8] = val | 0x30;
		frq -= val * 100;
	}
	if (frq > 9)
	{
		val = frq / 10;
		sFrq[9] = val | 0x30;
		frq -= val * 10;
	}
	sFrq[10] = frq | 0x30;
	sFrq[11] = 0;
}



void ChkRxSquelch(bool forceChng)
{	
	//control rx audio level
	static float lastGain = 0.0; //only update if gain changes
	//Rx volume is set here
	if (forceChng)
	{
		lastGain = 0.0; //force gain change
	}
	//use gTxModeSet2 because it has the actual tx/rx state, before it's sent to HMI. Anything over RADIO_TX_ENAB = tx
	if (gTxModeSet2 <= RADIO_TX_ENAB && millis() - lastRxAudioUpdate > 1000)
	{
		//chk every second if we're not txing
		float eqBoost = 0.0;
		if (gSqGain <= 10 )
		{
			//just set volume			
			if (gRxEQ == true && (gOMode == MODE_VOICE || (gOMode == MODE_DIG && gDigProc == true)))
			{
				//eqBoost = -10.0; //subtract 10 dB for equalizer gain
			}
			//if - gain, set to 0
			float g = gVolGain + (gLnOutLv - 50.0) + eqBoost;
			if (g < 0)
			{
				g = LEV_OFF;
			}
			if (g != lastGain)
			{
				AudioNoInterrupts();
				Amp_Out.gain(g);
				Amp_Out.update();
				AudioInterrupts();
				gVolGainPrev = gVolGain;
				lastGain = g;
			}
		}
		else if (Sq_Det.available())
		{		
			int lev = Sq_Det.read() * 10000; //we can't compare tiny floating #s - scale to fit gSqGain range		
			if (lev >= gSqGain)
			{				
				if (gRxEQ == true && (gOMode == MODE_VOICE || (gOMode == MODE_DIG && gDigProc == true)))
				{
					//eqBoost = -10.0; //subtract 10 dB for equalizer gain
				}
				float g = gVolGain + (gLnOutLv - 50.0) + eqBoost;
				if (g < 0)
				{
					g = LEV_OFF;
				}
				if (g != lastGain)
				{
					AudioNoInterrupts();
					Amp_Out.gain(g);
					Amp_Out.update();
					AudioInterrupts();
					lastGain = g;
				}
				gVolGainPrev = gVolGain;
			}
			else
			{
				Amp_Out.gain(LEV_OFF); //mute rx	
				lastGain = LEV_OFF;
				Amp_Out.update();
			}
					
		}
		lastRxAudioUpdate = millis();
	}
}

void ChkTxVox()
{
	uint8_t prev = gOModePrev; //forces SetOutputSource() to change
	gOModePrev = 0xff;
	if (gOMode == MODE_DIG && gRadio != RADIO_TYPE_PCR1000)
	{
		uint16_t lev = 0;
		if (gTxModeSet2 != RADIO_TX_OFF && gDigTxActiv != DIG_ACT_NOTHING)
		{
			if (Vox_Det.available())
			{
				lev = uint16_t(Vox_Det.read() * 10000); //multiply by 10000 for compare - you can't compare tiny floating #s
				//SerialOut("=====> vox lev=" + String(lev) + ", vox thresh=" + String(gDigVoxThresh), true);
				//Tx2HMI("Home.bRx.txt=`Vox Lev=" + String(lev) + "`");
				//if we have audio and Tx is enabled, key tx, switch audio paths
				//check both the current tx state and the set2 modes in case we're in the process of changing modes
				if (lev >= gDigVoxThresh && gDigTxActiv != DIG_ACT_NOTHING)
				{
					if (gTxMode == RADIO_TX_ENAB || gTxModeSet2 == RADIO_TX_ENAB)
					{
						//only call once otherwise we get clicks in the audio
						if (gTxModeSet2 != RADIO_TX_VOX)
						{
							gTxModeSet2 = RADIO_TX_VOX; //txing using vox	
							gDigVoxKeyed = true; //block chkptt from keying if just audio passed through												
							if (gDigTxActiv == DIG_ACT_KEY)
							{
								digitalWrite(PTT_OUT, LOW); //key ptt							
								//SerialOut("======> VOX keying radio", true);
								pttWatchDog = millis(); //start watchdog						
							}
							delay(25); //let radio stabilze before turning on audio

							SetOutputSource(1, true); //set audio path to output	
													
							//Tx2HMI("Home.bRx.txt=`Switching to Tx  `");
						}
					}
					voxHoldTime = millis(); //reset hold time
				}
				else if (lev < gDigVoxThresh && gDigVoxKeyed == true && (millis() - voxHoldTimeDefault > voxHoldTime))
				{
					gDigVoxKeyed = false;
					gTxModeSet2 = RADIO_TX_ENAB;
					digitalWrite(PTT_OUT, HIGH); //unkey ptt					
					SetOutputSource(0, true); //force audio path back to rx
					Tx2HMI("Home.bRx.txt=`Switching to Rx `");
				}
			}
		}
		else if (gTxModeSet2 < RADIO_TX_PADDLE && gDigVoxKeyed == true)
		{
			//force ptt off	
			gDigVoxKeyed = false;
			if (gTxModeSet2 == RADIO_TX_ENAB)
			{
				gTxMode = gTxModeSet2;
			}
			else
			{
				gTxMode = RADIO_TX_OFF;
			}
			digitalWrite(PTT_OUT, HIGH); //unkey ptt			
			SetOutputSource(0, true); //force audio path back to rx			
		}
	}
	else
	{
		gDigVoxKeyed = false;
	}
	gOModePrev = prev; //return of previous value
}


void ChkFreqModeChng()
{	

	//chk for freq or mode change 
	//SerialOut("Checking FreqMode Change", true);

	if (gFreqRadio != lastStableFreq || gRMode != lastStableRMode || gOMode != lastStableOMode)
	{		
		if (lastStableFreq == 0 && gFreqRadio >= 100000)
		{
			//we haven't been initialized yet. Do it now and return
			//SerialOut("Initializing FreqMode Change arrays", true);
			lastStableFreq = gFreqRadio;
			lastStableRMode = gRMode;
			lastStableOMode = gOMode;
			for (int i = 0; i < 10; i++)
			{
				//preload all arrays to initial values
				prevFreq[i] = gFreqRadio;
				prevRMode[i] = gRMode;
				prevOMode[i] = gOMode;
			}
			return;
		}
		//something has changed, push new freq/modes to stack
		for (int i = 10; i > 0; i--)
		{
			//move current values down one
			prevFreq[i] = prevFreq[i - 1];
			prevRMode[i] = prevRMode[i - 1];
			prevOMode[i] = prevOMode[i - 1];
		}
		prevFreq[0] = lastStableFreq; //put last stable infor on top
		prevRMode[0] = lastStableRMode;
		prevOMode[0] = lastStableOMode;
		lastStableFreq = gFreqRadio;
		lastStableRMode = gRMode;
		lastStableOMode = gOMode;
		/* debugg
		for (int i = 0; i < 10; i++)
		{
			SerialOut(String(i) + "= " + String(prevFreq[i]), true);
		}
		*/
	}

}

void ChkFreqChange()
{
	//Don't change gFreqRadioPrev here, let UpdateHMIEveryPoll() do it so band changes and display updates are processed

	static uint32_t oldFreq = 0;

	if (gFreqRadio != oldFreq && gFreqRadio >= 100000)
	{
		if (TxFreq2Radio(gFreqRadio))
		{			
			oldFreq = gFreqRadio;
			//SerialOut("Freq Changed to " + String(gFreqRadio), true);
			//only change hmi if not in split mode
			if (gSplit != RADIO_VFO_SPLIT)
			{
				Tx2HMI("gFreq=" + String(gFreqRadio)); //if we're not busy, tx now, otherwisw que it
				delay(5);
				Tx2HMI("gFreq=" + String(gFreqRadio));
			}
		}
	}
}

bool GetFreqMode()
{
	/*
	<< DON'T POLL FOR RADIO FREQ/MODE CHANGES IN TX MODE >>
	<<< CAT DATA IS CAUSING PULSING NOISE IN TX AUDIO >>
	*/		
	if (gTxMode > 1 || gTxModeSet2 > 1)
	{		
		return false;
	}
	
	
	//read the freq and mode from the selected radio
	//alternate between the two every other scan if icom

	//returns true if radio on line - false if not
	if (radioCommBusy == true)
	{
		return false;
	}
	else if (gRadio == RADIO_TYPE_FLEX || gRadio == RADIO_TYPE_PCR1000)
	{
		//Flex will tell us if anything changed in the slice subscription packet - we don't ask here
		//On PCR1000 the "K0?" request is replied with "G000". We do get the set freq when we TxFreq() but that happens during an _ISR so we can't call it		
		return true;
	}

	radioCommBusy = true; // block ISR
	static bool toggle = false;
	int numChr = 5; //defaults to Yaesu len, change for icom and kenwood
	char cmdYaesuFTdx[4] = { 'I', 'F', ';' , 0x00 }; //
	char cmdYaesu[5] = { 0x03, 0x03, 0x03, 0x03, 0x03 };
	char cmdKenIF[3] = { 'I', 'F', ';' }; // 'IF;' command
	char cmdIcomFreq[6] = { 0xfe, 0xfe, 0x00, 0xe0, 0x03, 0xfd };
	char cmdIcomMode[6] = { 0xfe, 0xfe, 0x00, 0xe0, 0x04, 0xfd };

	//make sure rx buffer is clear before we tx new msg
	while (RADIO.available() > 0)
	{
		RADIO.read();
	}

	switch (gRadio)
	{
	case RADIO_TYPE_ICOM:
		numChr = 6;
		if (toggle == false)
		{
			radioRxBytes = 10;
			RADIO.write(cmdIcomFreq, numChr); //send it to the radio
			RADIO.flush();
		}
		else
		{
			radioRxBytes = 7;
			RADIO.write(cmdIcomMode, numChr); //send it to the radio
			RADIO.flush();
		}
		toggle = !toggle;
		break;
	case RADIO_TYPE_KENWOOD1:
Kenwood:
		numChr = 3;
		radioRxBytes = 37; //require 38 bytes from radio
		RADIO.write(cmdKenIF, numChr); //send it to the radio
		RADIO.flush();
		break;
	case RADIO_TYPE_KENWOOD2:
		goto Kenwood;
		break;
	case RADIO_TYPE_YAESUFTDX:
		numChr = 3;
		radioRxBytes = 50; //this should be =28 but radio randomly sends additional chrs before the terminator (;) so look long 
		RADIO.write(cmdYaesuFTdx, numChr);
		RADIO.flush();
		//SerialOut("\nftdx= " + String(cmdYaesuFTdx), true);
		break;
	case RADIO_TYPE_YAESU100:
		//inExpectedRx = 64 '32 bytes of data in hex format - from WB8LGH
TxYaesu100:
		radioRxBytes = 15;
		cmdYaesu[0] = 0; //this value doesn't matter
		cmdYaesu[1] = 0;
		cmdYaesu[2] = 0;
		cmdYaesu[3] = 0;
		cmdYaesu[4] = 0x10; //read status command
		RADIO.write(cmdYaesu, numChr); //send it to the radio
		RADIO.flush();
		break;
	case RADIO_TYPE_YAESU1000:
TxYaesu1000:
		radioRxBytes = 15;
		cmdYaesu[0] = 0;
		cmdYaesu[1] = 0;
		cmdYaesu[2] = 0;
		cmdYaesu[3] = 3; //return 16 bytes with band [0], freq [1] through [4], clarifier [5] & [6], mode [7], IF filter offset [8], VFO/Mem flags [9], [10] through [15] not used
		cmdYaesu[4] = 0x10; //read status command
		RADIO.write(cmdYaesu, numChr); //send it to the radio
		RADIO.flush();
		break;
	case RADIO_TYPE_YAESU757:
		goto TxYaesu100;
		break;
	case RADIO_TYPE_YAESU890:
		goto TxYaesu1000;
	case RADIO_TYPE_YAESU8x7:
		//use default msg		
		radioRxBytes = 4;
		RADIO.write(cmdYaesu, numChr); //send it to the radio
		RADIO.flush();
		break;
	}

	//wait 100 mS for reply
	for (int i = 0; i < 100; i++)
	{
		delay(1);
		if (RADIO.available() > 0)
		{
			ChkRadioRx();
			radioCommBusy = false;
			return true;
		}
	}
	radioCommBusy = false;
	return false;
}



bool TxFreq2Radio(uint32_t freq)
{		
	//call this routine to tx new freq to radio using TxFreq() below
	//it will try twice then give up
	bool success = TxFreq(freq);
	if (!success)
	{
		success = TxFreq(freq);
	}
	return success;
}

bool TxFreq(uint32_t freq)
{
	//returns true if we successfully sent the data to the radio and didn't block it

	//WARNING: Don't use delay() in this routine or routines it calls as it can be called from the _ISR routines

	//move notch filter with freq if it's enabled
	if (gNFltr > 1 && gNFltr < 31)
	{
		//notch filter is on - see if this freq change is within the audio bw of the display - move notch to match new freq if it is
		int freqChng = (int(gFreqRadio) - int(gFreqRadioPrev)) / 100; //so it's in the same units as gNFltr (actual freq /100)		
		if (gRMode == RADIO_CW_R || gRMode == RADIO_LSB)
		{
			//LSB so change would add to current filter
			freqChng = gNFltr + freqChng;
		}
		else
		{
			//USB so change would subtract from current filter
			freqChng = gNFltr - freqChng;
		}
		//SerialOut("freqChng= " + String(freqChng),true);
		if (freqChng > 1 && freqChng <= 32)
		{
			gNFltr = freqChng;
		}
		else if (freqChng < 2 || freqChng >32)
		{
			gNFltr = 32; //reset it			
		}
	}

	if (gRadio == RADIO_TYPE_FLEX)
	{
		//uses ESP01
		if (gFlexCon == true)
		{
			Flex_TxFreq(freq);
			return true;
		}
		else
		{
			return false;
		}
	}

	if (gRadio == RADIO_TYPE_NONE)
	{
		//nothing to do
		radioCommBusy = false;
		return true;
	}

	while (RADIO.availableForWrite() == 0)
	{
		//wait for tx buffer to clear
	}

	if (radioCommBusy == true)
	{
		//SerialOut("Radio comm busy...", true);
		return false; //don't clear flags that sent this data
	}

	radioCommBusy = true; //block ISR from overwriting
	//gRadioLastFreqUpdateTime = millis(); // must have 2 seconds after one control changes freq before another one can

	//freq has changed, send it to the radio
	char cmdYaesuFTdx[13] = { 'F', 'A', '0', '0', '0', '0', '0', '0', '0', '0', '0', ';' , 0x00};
	char cmdYaesu[5] = { 0, 0, 0, 0, 0x01 };
	char cmdKen[15] = { 0x46, 0x41, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3b, 00 };
	char cmdIcom[11] = { 0xFE, 0xFE, gIcmAdr, 0xE0, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFD }; //0xE0 is the master "from" address
	char cmdPCR1000[20] = { 0x4b, 0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,13,10 }; //K0GMMMKKKHHHmmff where G=Ghz, M=MHz, K=kHz, H=Hz, mm=mode, ff=bandwidth, padding, cr, lf
	char frq[9] = { 0,0,0,0,0,0,0,0,0 };

	uint32_t temp = freq;
	uint8_t val = 0;
	uint8_t numBytes = 0; //# of bytes to tx

	//make sure rx buffer is clear before we tx new msg
	while (RADIO.available() > 0)
	{
		RADIO.read();
	}

	//separate out individual freq values
	if (temp > 99999999)
	{
		//100 mhz digit
		val = temp / 100000000;
		frq[8] = val;
		temp -= val * 100000000;
	}
	if (temp > 9999999)
	{
		//10 mhz digit
		val = temp / 10000000;
		frq[7] = val;
		temp -= val * 10000000;
	}
	if (temp > 999999)
	{
		//1 mhz digit
		val = temp / 1000000;
		frq[6] = val;
		temp -= val * 1000000;
	}
	if (temp > 99999)
	{
		//100k digit
		val = temp / 100000;
		frq[5] = val;
		temp -= val * 100000;
	}
	if (temp > 9999)
	{
		//10k digit
		val = temp / 10000;
		frq[4] = val;
		temp -= val * 10000;
	}
	if (temp > 999)
	{
		//1k digit
		val = temp / 1000;
		frq[3] = val;
		temp -= val * 1000;
	}
	if (temp > 99)
	{
		//100s digit
		val = temp / 100;
		frq[2] = val;
		temp -= val * 100;
	}
	if (temp > 9)
	{
		//10s digit
		val = temp / 10;
		frq[1] = val;
		temp -= val * 10;
	}
	//1s digit
	frq[0] = temp;

	switch (gRadio)
	{
	case RADIO_TYPE_ICOM:
		//use long Icon command if not 731/735 - byte 9 is 100 mhz byte 

		cmdIcom[9] = frq[8]; //100mhz 
		cmdIcom[8] = frq[7] << 4; //10mhz in msb
		cmdIcom[8] += frq[6]; //1mhz in lsb
		cmdIcom[7] = frq[5] << 4; //100khz in msb
		cmdIcom[7] += frq[4]; //10khz in lsb
		cmdIcom[6] = frq[3] << 4; //1khz in msb
		cmdIcom[6] += frq[2]; //100hz in lsb
		cmdIcom[5] = frq[1] << 4; //10 hz in msb
		cmdIcom[5] += frq[0]; //1 hz in lsb
		numBytes = 11;//default to long command

		//if model 735, use short command (doesn't suport >99 mhz
		if (gIcmAdr == 4)
		{
			cmdIcom[9] = 0xfd; //move terminator over one
			cmdIcom[10] = 0x00;
			numBytes = 10;
		}
		RADIO.write(cmdIcom, numBytes); //send it to the radio
		RADIO.flush();
		break;
	case RADIO_TYPE_KENWOOD1:
Kenwood:
		cmdKen[4] = frq[8] | 0x30; //100mhz - convert to ascii
		cmdKen[5] = frq[7] | 0x30; //10mhz
		cmdKen[6] = frq[6] | 0x30; //1mhz
		cmdKen[7] = frq[5] | 0x30; //100khz
		cmdKen[8] = frq[4] | 0x30; //10khz
		cmdKen[9] = frq[3] | 0x30; //1khz
		cmdKen[10] = frq[2] | 0x30; //100hz
		cmdKen[11] = frq[1] | 0x30; //10hz
		cmdKen[12] = frq[0] | 0x30; //1hz	
		RADIO.write(cmdKen, 14);
		RADIO.flush();
		//SerialOut(String(cmdKen), true);
		break;
	case RADIO_TYPE_KENWOOD2:
		goto Kenwood;
		break;
	case RADIO_TYPE_YAESUFTDX:
		cmdYaesuFTdx[2] = frq[8] | 0x30; //100mhz - convert to ascii
		cmdYaesuFTdx[3] = frq[7] | 0x30; //10mhz
		cmdYaesuFTdx[4] = frq[6] | 0x30; //1mhz
		cmdYaesuFTdx[5] = frq[5] | 0x30; //100khz
		cmdYaesuFTdx[6] = frq[4] | 0x30; //10khz
		cmdYaesuFTdx[7] = frq[3] | 0x30; //1khz
		cmdYaesuFTdx[8] = frq[2] | 0x30; //100hz
		cmdYaesuFTdx[9] = frq[1] | 0x30; //10hz
		cmdYaesuFTdx[10] = frq[0] | 0x30; //1hz	
		RADIO.write(cmdYaesuFTdx, 12);
		RADIO.flush();
		//SerialOut("\nftdx= " + String(cmdYaesuFTdx), true);
		break;
	case RADIO_TYPE_YAESU100:
		radioRxBytes = 5; //we're expecting 5 byts
TxYaesu:
		cmdYaesu[0] = frq[8] << 4; //100mhz
		cmdYaesu[0] += frq[7]; //10mhz
		cmdYaesu[1] = frq[6] << 4; //1mhz
		cmdYaesu[1] += frq[5]; //100khz
		cmdYaesu[2] = frq[4] << 4; //10khz
		cmdYaesu[2] += frq[3]; //1khz
		cmdYaesu[3] = frq[2] << 4; //100hz
		cmdYaesu[3] += frq[1]; //10hz 
		//yaesu doesn't use 1hz digit
		//SerialOut("Tx: " + String(cmdYaesu[0], HEX) + " " + String(cmdYaesu[1], HEX) + " " + String(cmdYaesu[2], HEX) + " " + String(cmdYaesu[3], HEX), true);
		RADIO.write(cmdYaesu, 5);
		RADIO.flush();
		break;
	case RADIO_TYPE_YAESU757:
		goto TxYaesu;
		break;
	case RADIO_TYPE_YAESU8x7:
		goto TxYaesu;
		break;
	case RADIO_TYPE_YAESU890:
		goto TxYaesu;
		break;
	case RADIO_TYPE_YAESU1000:
		goto TxYaesu;
		break;
	case RADIO_TYPE_PCR1000:
		//send them as ascii strings
		cmdPCR1000[3] = frq[8] + 0x30;
		cmdPCR1000[4] = frq[7] + 0x30;
		cmdPCR1000[5] = frq[6] + 0x30;
		cmdPCR1000[6] = frq[5] + 0x30;
		cmdPCR1000[7] = frq[4] + 0x30;
		cmdPCR1000[8] = frq[3] + 0x30;
		cmdPCR1000[9] = frq[2] + 0x30;
		cmdPCR1000[10] = frq[1] + 0x30;
		cmdPCR1000[11] = frq[0] + 0x30;
		switch (gRMode)
		{
		case 0: //cw
			cmdPCR1000[13] = '3';
			break;
		case 1: //cwr
			cmdPCR1000[13] = '3';
			break;
		case 2: //lsb
			cmdPCR1000[13] = '0';
			break;
		case 3: //usb
			cmdPCR1000[13] = '1';
			break;
		case 4: //fmn
			cmdPCR1000[13] = '5';
			break;
		case 5: //fmw - only for 230 kHz bw			
			cmdPCR1000[13] = '6';
			break;
		case 6: //am
			cmdPCR1000[13] = '2';
			break;
		case 7: //digL - force to LSB
			cmdPCR1000[13] = '0';
			break;
		case 8: //digH - force to USB
			cmdPCR1000[13] = '1';
			break;
		}
		cmdPCR1000[15] = gPCRBW + 0x30; //0=3k, 1=6k, 2=15k, 3=50k, 4=230k
		if (gPCRInit == true)
		{
			RADIO.write(cmdPCR1000, 20);
			RADIO.flush();
			gPCRBWPrev = gPCRBW;
		}
		//don't look for freq, we may be in a _ISR and timers lock up up
		break;
	}
	//SerialOut("--> Set Tx Freq" + String(freq), true);
	radioCommBusy = false;
	return true; //we sent it!
}


bool TxMode2Radio()
{
	if (gRadio == RADIO_TYPE_FLEX)
	{
		Flex_TxMode();
		return true;
	}
	while (RADIO.availableForWrite() == 0)
	{
		//wait for tx buffer to clear
	}
	if (radioCommBusy == true)
	{
		return false; //return false if busy so we'll try again
	}
	if (gRadio == RADIO_TYPE_PCR1000)
	{
		//mode is set with freq		
		bool success = TxFreq2Radio(gFreqRadio);
		return success;
	}
	radioCommBusy = true; //blocks ISR from overwriting

	//gRMode has changed, send it to the radio
	
	//==============================================================================================================================
	//!!!! 4/25/21: NOTE: FTdx101 CAT has a bug it in. You have to send MC instead of MD to control the radio mode
	char cmdYaesuFTdx[6] = { 'M', 'C', '0', '0', ';', 0x00 }; // digit 2 is always 0 to send to main radio, digit 3 holds mode
	//==============================================================================================================================


	char cmdYaesu[5] = { 0, 0, 0, 0, 0x07 };
	char cmdKen[4] = { 'M', 'D', '0', ';' }; //"MDx;" where x=radio mode
	char cmdIcom[8] = { 0xFE, 0xFE, gIcmAdr, 0xE0, 0x1, 0x0, 0x1, 0xFD }; //0xE0 is the master "from" address

	//make sure rx buffer is clear before we tx new msg
	while (RADIO.available() > 0)
	{
		RADIO.read();
	}

	switch (gRadio)
	{
	case RADIO_TYPE_ICOM:
		//convert CTR2 mode to Icom mode
		switch (gRMode)
		{
		case 0: //cw
			cmdIcom[5] = 3;
			break;
		case 1: //cwr
			cmdIcom[5] = 7;
			break;
		case 2: //lsb
			cmdIcom[5] = 0;
			break;
		case 3: //usb
			cmdIcom[5] = 1;
			break;
		case 4: //fmn
			cmdIcom[5] = 5;
			break;
		case 5: //fmw - force to fmn
			cmdIcom[5] = 6;
			break;
		case 6: //am
			cmdIcom[5] = 2;
			break;
		case 7: //digL - force to rtty reverse
			cmdIcom[5] = 8;
			break;
		case 8: //digH - force to rtty
			cmdIcom[5] = 4;
			break;
		}
		RADIO.write(cmdIcom, 8); //send it to the radio
		RADIO.flush();
		break;
	case RADIO_TYPE_KENWOOD1:
		//convert CTR2 mode to Kenwood mode
Kenwood:
		switch (gRMode)
		{
		case 0: //cw
			cmdKen[2] = '3'; //modes in ascii
			break;
		case 1: //cwr
			cmdKen[2] = '7';
			break;
		case 2: //lsb
			cmdKen[2] = '1';
			break;
		case 3: //usb
			cmdKen[2] = '2';
			break;
		case 4: //fmn
			cmdKen[2] = '4';
			break;
		case 5: //fmw - force to fmn
			cmdKen[2] = '4';
			break;
		case 6: //am
			cmdKen[2] = '5';
			break;
		case 7: //digL - force to fsk reverse
			cmdKen[2] = '6';
			break;
		case 8: //digH - force to fsk
			cmdKen[2] = '9';
			break;
		}
		RADIO.write(cmdKen, 4);
		RADIO.flush();
		break;
	case RADIO_TYPE_KENWOOD2:
		goto Kenwood;
		break;
	case RADIO_TYPE_YAESUFTDX:	
		switch (gRMode)
		{
		case 0: //cw
			cmdYaesuFTdx[3] = '3'; //modes in ascii
			break;
		case 1: //cwr
			cmdYaesuFTdx[3] = '7';
			break;
		case 2: //lsb
			cmdYaesuFTdx[3] = '1';
			break;
		case 3: //usb
			cmdYaesuFTdx[3] = '2';
			break;
		case 4: //fmn
			cmdYaesuFTdx[3] = 'B';
			break;
		case 5: //fmw - force to fmn
			cmdYaesuFTdx[3] = '4';
			break;
		case 6: //am
			cmdYaesuFTdx[3] = '5';
			break;
		case 7: //digL - data lower
			cmdYaesuFTdx[3] = '8'; 
			break;
		case 8: //digH - data upper
			cmdYaesuFTdx[3] = 'C';
			break;
		}	
		RADIO.write(cmdYaesuFTdx, 5);		
		RADIO.flush();
		//SerialOut("\nftdx mode= " + String(cmdYaesuFTdx) ,true);	
		break;		
	case RADIO_TYPE_YAESU100:
TxYaesu:
		radioRxBytes = 5; //we're expecting 5 byts
		//convert CTR2 mode to Yaesu mode
		switch (gRMode)
		{
		case 0: //cw
			cmdYaesu[0] = 2;
			break;
		case 1: //cwr
			cmdYaesu[0] = 3;
			break;
		case 2: //lsb
			cmdYaesu[0] = 0;
			break;
		case 3: //usb
			cmdYaesu[0] = 1;
			break;
		case 4: //fmn
			cmdYaesu[0] = 6;
			break;
		case 5: //fmw 
			cmdYaesu[0] = 7;
			break;
		case 6: //am
			cmdYaesu[0] = 4;
			break;
		case 7: //digL - force to packet low
			cmdYaesu[0] = 0x0A;
			break;
		case 8: //digH - force to packet
			cmdYaesu[0] = 0x0B;
			break;
		}
		RADIO.write(cmdYaesu, 5);
		RADIO.flush();
		break;
	case RADIO_TYPE_YAESU757:
		goto TxYaesu;
		break;
	case RADIO_TYPE_YAESU8x7:
		radioRxBytes = 5; //we're expecting 5 byts
		//only send valid modes to radio otherwise it will CRASH!
		switch (gRMode)
		{
		case 0: //cw
			cmdYaesu[0] = 2;
			break;
		case 1: //cwr
			cmdYaesu[0] = 3;
			break;
		case 2: //lsb
			cmdYaesu[0] = 0;
			break;
		case 3: //usb
			cmdYaesu[0] = 1;
			break;
		case 4: //fmn
			cmdYaesu[0] = 8;
			break;
		case 5: //fmw 
			cmdYaesu[0] = 8; //same as fmn - radio will go to fmw if tuned to 88-108 mhz
			break;
		case 6: //am
			cmdYaesu[0] = 4;
			break;
		case 7: //digH - is dig on 817
			cmdYaesu[0] = 0x0C;
			break;
		case 8: //digL - is pkt on 8x7
			cmdYaesu[0] = 0x0A;
			break;
		default:
			cmdYaesu[0] = 3; //default to usb
			break;
		}
		RADIO.write(cmdYaesu, 5);
		RADIO.flush();
		break;
	case RADIO_TYPE_YAESU890:
		goto TxYaesu;
		break;
	case RADIO_TYPE_YAESU1000:
		goto TxYaesu;
		break;
	}
	radioCommBusy = false;
	return true;

}


void SetRadioBaud()
{
	int settings = 0;
	//set baud rate on radio port based on radio
	//flex radio uses Wifi API for control	
	switch (gRadio)
	{
	case RADIO_TYPE_FLEX:
		radioMsgTimeoutDefault = 500; //long timeout for wifi
		settings = SERIAL_8N1; //temp for flex test - may need to use API
		break;
	case RADIO_TYPE_PCR1000:
		radioBaud[RADIO_TYPE_PCR1000] = 9600; //force default baud
		settings = SERIAL_8N1;
		gDigTxActiv = DIG_ACT_NOTHING; //no tx here
		gPCRInit = false; //force update
		break;
	case RADIO_TYPE_ICOM:
		radioMsgTimeoutDefault = 80;
		settings = SERIAL_8N1;
		break;
	case RADIO_TYPE_KENWOOD1:
		radioMsgTimeoutDefault = 200;;
		settings = SERIAL_8N1; //kenwood default 9600 1 stop bit (newer radios)
		break;
	case RADIO_TYPE_KENWOOD2:
		radioMsgTimeoutDefault = 250;
		settings = SERIAL_8N2; //kenwood default 4800 2 stop bit (older radios)
		break;
	case RADIO_TYPE_YAESUFTDX:
		radioMsgTimeoutDefault = 200;
		settings = SERIAL_8N2; //cat manual doesn't specify this - assume
		break;
	case RADIO_TYPE_YAESU100:
		radioMsgTimeoutDefault = 100;
		settings = SERIAL_8N2;
		break;
	case RADIO_TYPE_YAESU1000:
		radioMsgTimeoutDefault = 100;
		settings = SERIAL_8N2;
		break;
	case RADIO_TYPE_YAESU757:
		radioMsgTimeoutDefault = 100;
		settings = SERIAL_8N2;
		break;
	case RADIO_TYPE_YAESU890:
		radioMsgTimeoutDefault = 100;
		settings = SERIAL_8N2;
		break;
	case RADIO_TYPE_YAESU8x7:
		radioMsgTimeoutDefault = 50; //short msgs - radio throws random 0 chrs - short timeout to ignore them
		settings = SERIAL_8N2;
		break;
	}
	SerialOut("baud= " + String(radioBaud[gRadio]), true);
	if (radioBaud[gRadio] != 0)
	{
		RADIO.end();
		delay(100);
		RADIO.begin(radioBaud[gRadio], settings); //change radio ctrl baud and settings
		//SerialOut("Radio Baud set to " + String(radioBaud[gRadio]), true);
		if (gRadio == RADIO_TYPE_PCR1000)
		{
			//force auto update off
			String reply = Tx2PCR1000("G300");
		}
	}
	else
	{
		RADIO.end(); //if no radio, just kill the radio process
	}
	gRadioPrev = gRadio;
}



String CalcBand()
{
	//calcualte the band we're in by gFreqRadio - update gAntBand if we're using band ant switching
	String temp = "";

	//update band and clock
	if (gFreqRadio >= 1800000 && gFreqRadio < 2000000)
	{
		gBand = 0;
		temp = "160m";
	}
	else if (gFreqRadio >= 3500000 && gFreqRadio < 4000000)
	{
		gBand = 1;
		temp = "80m";
	}
	else if (gFreqRadio >= 5330000 && gFreqRadio < 5405000)
	{
		//we're in the 60m band - find USB channel
		gBand = 2;
		if (gFreqRadio == 5330500)
		{
			temp = "60m1";
		}
		else if (gFreqRadio == 5346500)
		{
			temp = "60m2";
		}
		else if (gFreqRadio == 5357000)
		{
			temp = "60m3";
		}
		else if (gFreqRadio == 5371500)
		{
			temp = "60m4";
		}
		else if (gFreqRadio == 5403500)
		{
			temp = "60m5";
		}
		else
		{
			temp = "60m";
		}
	}
	else if (gFreqRadio >= 7000000 && gFreqRadio < 7300000)
	{
		gBand = 3;
		temp = "40m";
	}
	else if (gFreqRadio >= 10100000 && gFreqRadio < 10150000)
	{
		gBand = 4;
		temp = "30m";
	}
	else if (gFreqRadio >= 14000000 && gFreqRadio < 14350000)
	{
		gBand = 5;
		temp = "20m";
	}
	else if (gFreqRadio >= 18068000 && gFreqRadio < 18168000)
	{
		gBand = 6;
		temp = "17m";
	}
	else if (gFreqRadio >= 21000000 && gFreqRadio < 21450000)
	{
		gBand = 7;
		temp = "15m";
	}
	else if (gFreqRadio >= 24089000 && gFreqRadio < 24990000)
	{
		gBand = 8;
		temp = "12m";
	}
	else if (gFreqRadio >= 28000000 && gFreqRadio < 29700000)
	{
		gBand = 9;
		temp = "10m";
	}
	else if (gFreqRadio >= 50000000 && gFreqRadio < 54000000)
	{
		gBand = 10;
		temp = "6m";
	}
	else if (gFreqRadio >= 144000000 && gFreqRadio < 148000000)
	{
		gBand = 11;
		temp = "2m";
	}
	else if (gFreqRadio >= 222000000 && gFreqRadio < 225000000)
	{
		gBand = 12;
		temp = "1.25m";
	}
	else if (gFreqRadio >= 420000000 && gFreqRadio < 450000000)
	{
		gBand = 13;
		temp = "70cm";
	}
	else if (gFreqRadio >= 902000000 && gFreqRadio < 928000000)
	{
		gBand = 14;
		temp = "33cm";
	}
	else
	{
		gBand = 15;
		temp = "Gen";
	}

	//if we are using ant band switching
	if (gAntBand != 0xff)
	{
		gAntBand = gBand;
		Tx2HMI("gAntBand=" + String(gBand));
		Tx2HMI("gAntBand=" + String(gBand));
		gAnt = bandMemAnt[gBand];
		Tx2HMI("gAnt=" + String(bandMemAnt[gBand]));
		Tx2HMI("gAnt=" + String(bandMemAnt[gBand]));
	}

	return temp;

}


