// =====================================================================================================================================================================================================
// (c) 2021 Lynn Hansen, KU7Q															                                                                                                               |
// This Source Code Form is subject to the terms of the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007. A copy of this license can be found here: https://choosealicense.com/licenses/gpl-3.0/|
// =====================================================================================================================================================================================================



// THESE TASKS ARE EXECUTED IN THE ARDUINO LOOP ROUTINE


void loop()
{
	//normal loop without WiFi connected
	DoLoopTasks();

	//see if we're connected to WiFi - if so, move loop to inside wifi service routines
	if (gWiFi == 1)
	{
		if (gIPMode == 0)
		{
			//we're online and in station mode, move the loop here
			WiFiStationLoop();
		}
		else
		{
			//run ap loop
		}
	}

}
 

void DoLoopTasks()
{
	//normal loop tasks - put them here so they can be run from wifi loops too
	
	Tx2HMI(""); //chks que

	ChkMouse();

	UpdateFFTMarkers();

	UpdateHMIDisplay();

	UpdateFFT();

	//chk for rx data on USB port - process incoming request from PC software
	ChkPCCmd();

	//chk to see if we're in digital mode - if so, check for tone to key ptt (vox)
	ChkTxVox();

	ChkFreqChange();
	if (gEncoderChng)
	{
		ChkEncoderChng();
	}

	//send chr to hmi if we have a decoded chr waiting to send
	ChkChr2HMI();

	//chk HMI for activity
	if ((HMI.available() || HMIR.available()) && hmiNewMsg == 0 && hmiCtrlChange == 0)
	{
		ChkHmiRx();
		if (hmiNewMsg != 0)
		{
			DecHMICmd();
		}
	}

	if (gAction != 0)
	{
		DoAction();
	}
}



void WiFiStationLoop()
{
	String temp = "";
	String txt = "";

	static int msgNum = 0; //which message to send back to server

	if (gFlexCon == true)
	{
		//run this loop while flex is connected
		if (!flexAPI)
		{
			SerialOut("===> Starting flexAPI", true);
			flexAPI = server.available();
			Flex_Initialize();
		}

		DoLoopTasks();
		while (flexAPI.connected())
		{
			if (gWiFi == 0)
			{
				//wifi turned off, shut down and exit
				flexAPI.stop();
				WiFi.disconnect();
				WiFi.endAP();
				gFlexCon = 0;
				return;
			}
			DoLoopTasks();
			txt = "";
			if (flexAPI.available())
			{
				Flex_ChkRx();
			}
			if (gFlexPingTmr < millis() - 2000)
			{
				String reply = Tx2ESP(ESP_FLEX, "|ping");
				gFlexPingTmr = millis();
			}
		}
	}


	//This loop will run while the WiFi station is active so we can keep the link open
	if (!client)
	{
		client = server.available();
	}
	else
	{
		//IPAddress ip = client.remoteIP();
		//SerialOut("New request from ", false);
		//SerialOut(String(ip), true);
		DoLoopTasks();

		while (client.connected())
		{
			DoLoopTasks(); //service normal loop tasks
			if (gWiFi == 0)
			{
				//wifi turned off, shut down and exit
				client.stop();
				WiFi.disconnect();
				WiFi.endAP();
				return;
			}

			if (client.available())
			{
				String line = client.readStringUntil('\n');
				line.trim();
				SerialOut(line, true);
				if (line.indexOf("GET /LOG/CTR2_LOG.ADI") > -1)
				{
					msgNum = 1; //send file back
				}

				// if you've gotten to the end of the HTTP header (the line is blank),
				// the http request has ended, so you can send a reply
				if (line.length() == 0)
				{
					// send a standard http response header		
					String txt = "";
					BuildSvrReply(msgNum, txt); //create basic server reply
					client.println(txt);
					client.flush();
					//SerialOut(txt, true);								
					client.stop();
					msgNum = 0; //reset msg
				}
			}
		}
	}

}