// =====================================================================================================================================================================================================
// (c) 2021 Lynn Hansen, KU7Q															                                                                                                               |
// This Source Code Form is subject to the terms of the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007. A copy of this license can be found here: https://choosealicense.com/licenses/gpl-3.0/|
// =====================================================================================================================================================================================================


// THIS FILE CONTAINS DEMODULATORS AND SUPPORTING CODE

// NOTE! THESE RUN UNDER ISR

void DemodMorse()
{
	//This routine is called during the ChkDecode_ISR
	//WARNING! DO NOT CALL ANY EXTERNAL CALLS FROM THIS ROUTINE !!
	//Post chr2HMI from main loop

	static bool buildingCodeAry = false;
	static bool prevState = false;
	static bool prevFilteredState = false;
	static uint32_t lastDitDur = 80; //hold the last dit duration for comparison with interdigit space
	static uint32_t lastDahDur = 240;
	bool filteredState = false;

	static uint32_t lo2Hi;
	static uint32_t hiDur;
	static uint32_t ditDurAvg = 80; //start out at 15 wpm
	static uint32_t hi2Lo;
	static uint32_t loDur;
	static uint32_t prevStartTime = millis();
	static uint8_t charCtr = 0;

	static bool alreadyHr = false; //blocks recussion

	uint8_t minMSec = 10; //ignore short pulses

	uint32_t mSec = millis(); //mSec at call time - it won't change during this routine since we're cli()

	bool curState = false;

	if (!Tone1.available() || alreadyHr == true)
	{
		return;
	}
	alreadyHr = true;

	//Tone Decoder option
	float val = Tone1.read();
	//adjust this value to make decoder more of less sensitive - minimum is .03
	if (val > gMorseDetLev)
	{
		curState = true;
	}

	//rising or falling edge detection
	if (curState != prevState)
	{
		prevStartTime = mSec;
		prevState = curState;
	}

	//ignore short pulses
	if ((mSec - prevStartTime) >= minMSec)
	{
		if (curState != filteredState)
		{
			//current state is stable, set filtered state
			filteredState = curState;
		}
	}
	else
	{
		alreadyHr = false;
		return; //noise burst
	}

	//edge time
	if (filteredState != prevFilteredState)
	{
		prevFilteredState = filteredState;
		if (filteredState == true)
		{
			//rising edge
			lo2Hi = mSec;
			loDur = (mSec - hi2Lo); //how long we were low before we went high
		}
		else
		{
			//falling edge
			hi2Lo = mSec;
			hiDur = hi2Lo - lo2Hi; //how long we were high before we went low again

			//SerialOut("hiDur= " + String(hiDur) + ", loDur= " + String(loDur), true);

			//detect dit time and add to average if its > 1/4 lastDitDur, < lastDitDur * 2, < 1/2 lastDahDur, and < 40 WPM (30 mSec)
			//uint32_t oldDur = ditDurAvg;
			//SerialOut("\nhiDur=" + String(hiDur) + ",  ditDurAvg=" + String(ditDurAvg) + ", lastDitDur=" + String(lastDitDur) + ", lastDahDur=" + String(lastDahDur), true);
			if ((hiDur > lastDitDur >> 2) && (hiDur < lastDitDur << 1) && (hiDur < lastDahDur >> 1) && (hiDur > 30)) //limit to 40 wpm max 
			{
				ditDurAvg = (hiDur + (ditDurAvg << 2)) / 5; // now we know avg dit time ( rolling 5 avg)	
				//SerialOut("\n--> hiDur=" + String(hiDur) + " >" + String(lastDitDur>>1) + " and <" + String(lastDitDur<<1) + " and <" + String(lastDahDur>>1) + " ---> digDurAvg=" + String(ditDurAvg), true);
			}
			/*
			if (hiDur > (5 * ditDurAvg))
			{
				//ditDurAvg = (hiDur + (ditDurAvg<<1)) / 3;   // if speed decreases fast
			}
			if (oldDur != ditDurAvg)
			{
				//SerialOut("\nOld WPM=" + String(1200/oldDur) + ", New WPM=" + String(1200 / ditDurAvg), true);
			}
			*/
		}

		buildingCodeAry = true;
		if (filteredState == false)
		{
			//we just ended a high pulse - chk length of hiDur to determine element
			//if hiDur is > ditDurAvg * 2 and < ditDurAvg * 16
			if (hiDur > (ditDurAvg << 1) && hiDur < (ditDurAvg << 4))
			{
				//dah
				lastDahDur = hiDur;
				charCtr++;
				if (charCtr < NUM_DECODE_ELEMENTS)
				{
					strcat(codeBuff, "-");
					//SerialOut("-", false);
				}
				else
				{
					//SerialOut("\nDah Overflow = " + String(charCtr), true);
					codeBuff[0] = 0; //start over
					charCtr = 0;
				}
			}
			else if (hiDur <= ditDurAvg << 1 && ditDurAvg > 30)
			{
				//if < ditDurAvg * 2 its a dit
				lastDitDur = hiDur; //save to compare to interdigit space
				charCtr++;
				if (charCtr < NUM_DECODE_ELEMENTS)
				{
					strcat(codeBuff, ".");
					//SerialOut(".", false);
				}
				else
				{
					//SerialOut("\nDit Overflow = " + String(charCtr), true);
					codeBuff[0] = 0; //start over
					charCtr = 0;
				}

				decodeWPM = (decodeWPM + (1275 / ditDurAvg)) / 2; //wpm sent to HMI is based on average dit length - fudge it slightly - we're reading about 3 WPM slow - partly fft tone decoder delay
				//SerialOut("\rWPM=" + String(wpm), true);
			}
		}
		else
		{
			// we just ended a LOW - check to see if we see a letter space or word space
			//if loDur > 1/2 ditDurAvg and < ditDurAvg * 2
			if ((loDur > (ditDurAvg >> 1)) && (loDur < (ditDurAvg << 1)))
			{
				//interelement space, wait for next element				
			}
			else
			{
				// chr complete, decode accumulated chars								
				if (charCtr > 0 && charCtr < NUM_DECODE_ELEMENTS)
				{
					chr2HMI[chr2HMICtr] = Morse2Char();
					chr2HMICtr++;
				}
				codeBuff[0] = 0; //start new string
				charCtr = 0;
			}
			if (loDur >= (ditDurAvg * 5))
			{
				// word space	
				if (charCtr > 0 && charCtr < NUM_DECODE_ELEMENTS)
				{
					chr2HMI[chr2HMICtr] = Morse2Char();
					chr2HMICtr++;
				}
				else
				{
					chr2HMI[chr2HMICtr] = ' ';
					chr2HMICtr++;
				}
				codeBuff[0] = 0; //terminate string
				charCtr = 0;
				buildingCodeAry = false; //we're done with this word
			}
		}
	}

	//if we're low and the low time is > ditDurAvg * 8 and we're building a code array, send what we have and reset code array
	if ((filteredState == false) && ((mSec - hi2Lo) > (ditDurAvg << 3)) && buildingCodeAry == true)
	{
		//if we see a long SPACE, decode chr
		if (charCtr > 0 && charCtr < NUM_DECODE_ELEMENTS)
		{
			chr2HMI[chr2HMICtr] = Morse2Char();
			chr2HMICtr++;
		}
		codeBuff[0] = 0; //clear string
		charCtr = 0;
		buildingCodeAry = false;
	}
	if (chr2HMICtr > 31)
	{
		//failsafe
		chr2HMICtr = 31;
	}
	alreadyHr = false;

}

char Morse2Char()
{
	//decode the char represented by the code char array	
	if (strcmp(codeBuff, ".-") == 0)		return char('a');
	if (strcmp(codeBuff, "-...") == 0)		return char('b');
	if (strcmp(codeBuff, "-.-.") == 0)		return char('c');
	if (strcmp(codeBuff, "-..") == 0)		return char('d');
	if (strcmp(codeBuff, ".") == 0)			return char('e');
	if (strcmp(codeBuff, "..-.") == 0)		return char('f');
	if (strcmp(codeBuff, "--.") == 0)		return char('g');
	if (strcmp(codeBuff, "....") == 0)		return char('h');
	if (strcmp(codeBuff, "..") == 0)		return char('i');
	if (strcmp(codeBuff, ".---") == 0)		return char('j');
	if (strcmp(codeBuff, "-.-") == 0)		return char('k');
	if (strcmp(codeBuff, ".-..") == 0)		return char('l');
	if (strcmp(codeBuff, "--") == 0)		return char('m');
	if (strcmp(codeBuff, "-.") == 0)		return char('n');
	if (strcmp(codeBuff, "---") == 0)		return char('o');
	if (strcmp(codeBuff, ".--.") == 0)		return char('p');
	if (strcmp(codeBuff, "--.-") == 0)		return char('q');
	if (strcmp(codeBuff, ".-.") == 0)		return char('r');
	if (strcmp(codeBuff, "...") == 0)		return char('s');
	if (strcmp(codeBuff, "-") == 0)			return char('t');
	if (strcmp(codeBuff, "..-") == 0)		return char('u');
	if (strcmp(codeBuff, "...-") == 0)		return char('v');
	if (strcmp(codeBuff, ".--") == 0)		return char('w');
	if (strcmp(codeBuff, "-..-") == 0)		return char('x');
	if (strcmp(codeBuff, "-.--") == 0)		return char('y');
	if (strcmp(codeBuff, "--..") == 0)		return char('z');

	if (strcmp(codeBuff, ".----") == 0)		return char('1');
	if (strcmp(codeBuff, "..---") == 0)		return char('2');
	if (strcmp(codeBuff, "...--") == 0)		return char('3');
	if (strcmp(codeBuff, "....-") == 0)		return char('4');
	if (strcmp(codeBuff, ".....") == 0)		return char('5');
	if (strcmp(codeBuff, "-....") == 0)		return char('6');
	if (strcmp(codeBuff, "--...") == 0)		return char('7');
	if (strcmp(codeBuff, "---..") == 0)		return char('8');
	if (strcmp(codeBuff, "----.") == 0)		return char('9');
	if (strcmp(codeBuff, "-----") == 0)		return char('0');

	if (strcmp(codeBuff, ".-.-.-") == 0)	return char('.');
	if (strcmp(codeBuff, "--..--") == 0)	return char(',');
	if (strcmp(codeBuff, "..--..") == 0)	return char('?');
	if (strcmp(codeBuff, "-..-.") == 0)		return char('/');
	if (strcmp(codeBuff, "-...-") == 0)		return char('='); //also BT
	if (strcmp(codeBuff, "-.-.--") == 0)	return char('!');
	if (strcmp(codeBuff, "-.-.-.") == 0)	return char(';');
	if (strcmp(codeBuff, ".-.-.") == 0)		return char('+'); //also AR
	if (strcmp(codeBuff, ".--.-.") == 0)	return char('@');
	if (strcmp(codeBuff, ".-...") == 0)		return char('&'); //also AS
	if (strcmp(codeBuff, "-.--.") == 0)		return char('('); //also KN
	if (strcmp(codeBuff, "...-.-") == 0)	return char('$'); //use for SK ($ is actually ...-..-
	if (strcmp(codeBuff, "-....-") == 0)	return char('-');
	if (strcmp(codeBuff, "......") == 0)	return char('<'); //use multiple err codes for back space chr
	if (strcmp(codeBuff, ".......") == 0)	return char('<');
	if (strcmp(codeBuff, "........") == 0)	return char('<');
	if (strcmp(codeBuff, ".........") == 0)		return char('<');
	if (strcmp(codeBuff, "..........") == 0)	return char('<');

	return char(0);
}

String TxChar2Morse(String txChar)
{
	//lower case char to morse symbols
	if (txChar == "a") return ".-";
	if (txChar == "b") return "-...";
	if (txChar == "c") return "-.-.";
	if (txChar == "d") return "-..";
	if (txChar == "e") return ".";
	if (txChar == "f") return "..-.";
	if (txChar == "g") return "--.";
	if (txChar == "h") return "....";
	if (txChar == "i") return "..";
	if (txChar == "j") return ".---";
	if (txChar == "k") return "-.-";
	if (txChar == "l") return ".-..";
	if (txChar == "m") return "--";
	if (txChar == "n") return "-.";
	if (txChar == "o") return "---";
	if (txChar == "p") return ".--.";
	if (txChar == "q") return "--.-";
	if (txChar == "r") return ".-.";
	if (txChar == "s") return "...";
	if (txChar == "t") return "-";
	if (txChar == "u") return "..-";
	if (txChar == "v") return "...-";
	if (txChar == "w") return ".--";
	if (txChar == "x") return "-..-";
	if (txChar == "y") return "-.--";
	if (txChar == "z") return "--..";

	if (txChar == "1") return ".----";
	if (txChar == "2") return "..---";
	if (txChar == "3") return "...--";
	if (txChar == "4") return "....-";
	if (txChar == "5") return ".....";
	if (txChar == "6") return "-....";
	if (txChar == "7") return "--...";
	if (txChar == "8") return "---..";
	if (txChar == "9") return "----.";
	if (txChar == "0") return "-----";

	if (txChar == ".") return ".-.-.-";
	if (txChar == ",") return "--..--";
	if (txChar == "?") return "..--..";
	if (txChar == "/") return "-..-.";
	if (txChar == "=") return "-...-";
	if (txChar == "!") return "-.-.--";
	if (txChar == ";") return "-.-.-.";
	if (txChar == "+") return ".-.-."; //also AR
	if (txChar == "@") return ".--.-.";
	if (txChar == "&") return ".-..."; //also AS
	if (txChar == "(") return "-.--."; //also KN
	if (txChar == "$") return "...-.-"; //use for SK ($ is actually ...-..-
	if (txChar == "-") return "-....-";
	if (txChar == "<") return "........";
	return " ";
}

void DemodRTTY()
{
	//This routine is called during the ChkDecode_ISR
	//WARNING! DO NOT CALL ANY EXTERNAL CALLS FROM THIS ROUTINE !!
	//Post chr2HMI from main loop

	static uint8_t bitPtr = 0; //clocks in 5 bits, 6th bit must be a Stop bit
	static uint32_t bitTmr = 0; //holds length of bit in mSec

	static uint8_t chr = 0; //holds chr code as it's clocked in	

	static bool syncd = false; //goes true when we're synced to bit stream

	//figMode goes true when Figure shift code (0x1b) is received - reset it on space (0x04) or Leters shift code (0x1f) is received
	//AND 0x20 into chr if we're in Figures mode
	static bool figMode = false;

	static uint32_t mSec = millis(); //mSec at call time - it won't change during this routine since we're cli()

	bool mark = false; //current state of tone detectors
	bool space = false;

	/*
	if (!Tone1.available() && !Tone2.available())
	{
		return; //waiting for tone detector
	}
	*/

	//Tone Decoder - valid tone is over .09

	//if (Tone1.available())
	{
		float tone = Tone1.read();
		//SerialOut("tone1=" + String(tone), true);
		if (tone > .08)
		{
			mark = true;
		}
	}
	//if (Tone2.available())
	{
		float tone = Tone2.read();
		//SerialOut("tone2=" + String(tone), true);
		if (tone > .08)
		{
			space = true;
		}
	}
	if (mark == true && space == true)
	{
		//SerialOut("Both tones active", true);
		return; //invalid state - noise
	}

	//wait for start bit
	if (!syncd)
	{
		if (space)
		{
			if (bitTmr == 0)
			{
				//start of start bit - set bitTmr to 1/2 bit time and return
				//SerialOut("Mark->Space - start timing", true);
				chr = 0;
				bitPtr = 0; //start fresh
				bitTmr = rttyBaud[gRtyBaud] / 2; //rttyBaud holds mSec for bit timing
				mSec = millis(); //start of start bit 				
				return;
			}
			if (millis() - mSec > bitTmr)
			{
				//time to sample center of bit - if it's a space, start sync
				//SerialOut("Center of start bit", true);
				syncd = true;
				bitTmr = rttyBaud[gRtyBaud]; //wait full bit time to sample next
				mSec = millis();
				return;
			}
			return; //wait for sample time
		}
		else
		{
			//if we're marking, cancel search for sync bit and wait for mark to space transition
			bitPtr = 0;
			bitTmr = 0;
			chr = 0;
			return;
		}
	}
	else
	{
		//we're synced, clock in data bits and stop bit - if stop bit is not a mark, abort
		if (millis() - mSec > bitTmr)
		{
			if (bitPtr < 5)
			{
				//just read bit and add it to chr
				if (mark)
				{
					chr += 0x01 << bitPtr;
				}
				bitPtr++;
				mSec = millis();
			}
			else
			{
				if (mark)
				{
					SerialOut(String(rttyChr[chr]), false);
					//valid stop bit - chk for Figure shift and send chr to Chr2HMI to display
					//turn off figMode if Letter shift or space rxd
					switch (chr)
					{
					case 0x1f:
						//letter shift
						chr = 0; //don't print ctrl chrs
						figMode = false;
						break;
					case 0x04:
						//space
						figMode = false; //revert back to letter mode on space
						break;
					case 0x1B:
						//figure shift
						figMode = true;
						chr = 0; //don't print figure shift '^'
						break;
					case 0x02:
						//line feed
						chr = 0;
						break;
					case 0x08:
						//cr
						//chr = 0x04; //convert CR to space
						chr = 0; //null
						break;
					}
					if (figMode == true)
					{
						chr |= 0x20; //shift to upper 32 chrs
						//SerialOut("\nchr=" + String(chr, HEX), true);
					}
					chr2HMI[chr2HMICtr] = rttyChr[chr]; //convert to ascii chr
					//SerialOut(String(chr2HMI[chr2HMICtr]), false);
					chr2HMICtr++;
					chr2HMI[chr2HMICtr] = 0; //terminator
				}
				//reset for next chr regardless if we had a valid stop
				syncd = false;
				bitPtr = 0;
				bitTmr = 0;
				chr = 0;
			}
			if (chr2HMICtr > 31)
			{
				//failsafe
				chr2HMICtr = 31;
			}
		}
		else
		{
			return; //waiting for center of bit
		}

	}
}
