#!/usr/bin/python3
"""

 Jim Koehler, Comox, April, 2019
 
 
"""

from breezypythongui import EasyFrame
import os

class ProgSelect(EasyFrame):
	
    def __init__(self):
        """Sets up the window and widgets."""
        EasyFrame.__init__(self, title = "Select Impedance Program (W10)")
        self.setSize(350, 150)
        self.setResizable(False)
        self.setBackground("#c00fffc00")

       # radio button group for choices
        self.addLabel(text="Program", row = 0, column=2, background = "#d80fffd80")
        self.typeGroup=self.addRadiobuttonGroup( row = 1, column = 2)
        defaultProg = self.typeGroup.addRadiobutton(text="Impedance")
        self.typeGroup.setSelectedButton(defaultProg)
        self.typeGroup.addRadiobutton(text="VSWR")
        self.typeGroup.setSelectedButton(defaultProg)
        self.typeGroup.addRadiobutton(text="Xtal")
        self.typeGroup.setSelectedButton(defaultProg)
        self.typeGroup.addRadiobutton(text="Trans")
        self.typeGroup.setSelectedButton(defaultProg)
        self.typeGroup.addRadiobutton(text="L_meas")
                                                       
                                                       


        # The command button
        self.addButton(text = "Go", row = 1, column = 0,
                       columnspan = 2, command = self.startGo)

    # The event handling method for the button
    def startGo(self):
        if self.typeGroup.getSelectedButton()["text"] == "Impedance":
            os.system("del scan.png")
            os.system("W10_scan.py %Z_METER_COM%")
        if self.typeGroup.getSelectedButton()["text"] == "VSWR":
            os.system("del gamma.png")
            os.system("W10_VSWR_scan.py %Z_METER_COM%")
        if self.typeGroup.getSelectedButton()["text"] == "Xtal":
            os.system("del adm.png")
            os.system("W10_xtal.py&")
        if self.typeGroup.getSelectedButton()["text"] == "Trans":
            os.system("del scan.png")
            os.system("W10_transfer.py&")
        if self.typeGroup.getSelectedButton()["text"] == "L_meas":
            os.system("del scan.png")
            os.system("W10_measure_L.py&")
		
		

#Instantiate and pop up the window."""
if __name__ == "__main__":
    ProgSelect().mainloop()
