#!/usr/bin/python3
#
#
"""
     This program does a scan of admittance versus frequency
     over a range specified by the call
     
     The call is:
     
     ./y_scan.py b u n filename
     
     where  b is the start frequency in Hz,
			u is the stop frequency, in Hz,
			n is th number of frequencies
			filename is the name to give to the png and textfile of the results
			NOTE: '.png' and '.txt' will be added to the filename to create the files
			
	Jim Koehler, Comox, April, 2019
"""
import numpy as np
import math
import sys
import serial
import time
import os
from pathlib import Path
commPort = 'COMx'

def rect_to_polar(x, y):
	mag = math.sqrt(x**2 + y**2)
	ph = math.tan(y/x)
	return mag, ph
	
def polar_to_rect(mag, ph):
	x = mag * math.cos(ph)
	y = mag * math.sin(ph)
	return x, y

def get_cal():
	r = np.loadtxt("calibration.txt")
	return r
	
def calibrate( inp, f, c):
	rh = inp[0]  # inp is the uncorrected list with rho magnitude and phase
	ph = inp[1]
	i = round(f / 1e6) - 1 # points to the correct calibration number
	rh = rh * c[i, 0] # correct magnitude
	ph = ph - c[i, 1] # correct phase
	a, b = polar_to_rect(rh, ph) #convert to rectangular
	return a + b * 1j
	

def do_scan(b, u, n, plottype):
    R = complex(50.0, 0)
    TWO = complex(2.0, 0)
    r = [0, 0]
    comm = serial.Serial(commPort, baudrate = 115200, timeout = 0.3)
    comm.readlines()    # flush the read buffer
    comm.write(s2b("b " + b + "\r")) 
    time.sleep(0.2)
    comm.write(s2b("u " + u + "\r")) 
    time.sleep(0.2)
    comm.write(s2b("n " + n + "\r")) 
    time.sleep(0.2)    
    if (float(plottype) < 0.5):
        comm.write(s2b("o\r"))
    else:
        comm.write(s2b("l\r"))        
    time.sleep(0.2)    
    comm.readlines()
    
   
    c = get_cal()
    
    comm.write(s2b("g\r"))
    
    fh=open("tmp.txt", 'wb')   
    for i in range(int(n)):
        v = comm.readline()
        fh.write(v)
    fh.close()
    
    fh=open("tmp.txt", 'rb')
    fh_out = open("admittance.txt", 'wb')
    fh_out.write(s2b("#    Admittance vs frequency\n"))
    fh_out.write(s2b("# \n"))
    fh_out.write(s2b("# freq         G              B\n"))
    fh_out.write(s2b("# \n"))
   
   
    for i in range(int(n)):
        v = str.split(b2s(fh.readline()))
        r[0] = float(v[1]) / float(v[3])
        r[1] = float(v[2]) - float(v[4])
        rho = calibrate(r, float(v[0]), c)
        z = R * rho/(TWO - rho)
        y = 1/z
        fh_out.write(s2b(v[0] + ' ' + str(y.real) + ' ' + str(y.imag) + '\n'))
 
    fh.close()
    fh_out.close()


def b2s(message):
    '''Byte to string'''
    return bytes.decode(message)

def s2b(message):
    '''string to bytes'''
    return bytearray(message, "ascii")

def main():
    global commPort
    b = sys.argv[1] # the first argument of the command line
    u = sys.argv[2] # the second argument of the command line
    n = sys.argv[3] # the third argument of the command line
    filename = sys.argv[4]
    plottype = sys.argv[5]
    commPort = sys.argv[6] # %Z_METER_COM%
    do_scan(b, u, n, plottype)
    string = "-c admitplot.gp " + str(b) + " " + str(u) + " " + str(plottype)
    os.system("start wgnuplot " + string)
    time.sleep(.5)#give wgnuplot time to complete writing scan.png
    print("W10_y_scan" + string)
    userFileName = (filename +".png")
    loop = 1
    while 1:
        c = os.path.isfile("scan.png") and os.path.getsize("scan.png") > 0
        if c > 0:
            break
        time.sleep(1)#give wgnuplot time to complete writing scan.png
        loop +=1
        if loop > 15:
            print ("scan.png delay timeout")
            break
    time.sleep(1)#give wgnuplot time file write completion
    print("GNUplot delay = ", end = '')
    print(loop, end = '')
    print(" sec.")
    os.system("copy scan.png " + userFileName)
    os.system("copy zed.txt " + filename + ".txt")
    os.system(userFileName)#opens with default picture viewer for png files

if __name__=="__main__":
    main()
    
