#ifndef _DDS_H
#define _DDS_H

#include "GPSReference.h"

class DDSControl
{

    private:

	typedef enum { CLK0, CLK1 } Clock;

	int32_t setSiFreq (Clock c, uint32_t freq_cHz);
	void writeSi (uint8_t reg, uint8_t val);
	void loadSiRegs (uint8_t addr, uint32_t p1, uint32_t p2, uint32_t p3);

	uint32_t ctrl_freq;		// measured REF_FREQ on CLK1, cHz
	uint32_t user_freq;		// desired user freq on CLK0, cHz
	uint32_t m_t0;			// millis() when measurement began
	uint32_t pad;			// values get corrupted without this
	bool init_err;			// flag for initializing mean
	uint8_t reg16;			// shadow of reg 16 containing output level and more

    public:

	// both an enum and the actual bits in reg 16 to set output power level
        typedef enum {
            DDS_2MA = 0x0,
            DDS_4MA = 0x1,
            DDS_6MA = 0x2,
            DDS_8MA = 0x3,
        } PowerLevel;

	DDSControl(uint32_t initial_hz);
	void update(void);
	int32_t setUserFreq(uint32_t new_freq);
	uint32_t getUserFreq(void);
	void startMeasurement(bool full);
	uint8_t getPower(void);
	void setPower(uint8_t);
	void setOutput (bool want_on);

	// these are public so they can be used by the interrupt service routines
	volatile uint16_t n_overflows;  // running n overflows
	volatile uint16_t icr_0, icr_1; // initial and final Timer1 input captures
	volatile uint16_t n_ovf_capture;// captured n overflows
	volatile uint8_t n_pps;         // running n seconds since starting this calibration
	volatile bool start_freq;       // set by background to start measurement
	volatile bool freq_ready;       // set by interrupt to inform background measurement is ready
	volatile int8_t m_secs;		// measurement period


};

#endif // _DDS_H
