/******************************************************************************
    main.c

    PID Example application

    Created on: 7 March 2016
      Author: Ray Mack

*******************************************************************************/
#include <stdbool.h>
#include <xdc/runtime/System.h>
#include <xdc/std.h>
#include <xdc/runtime/Error.h>

#include <ti/sysbios/gates/GateTask.h>
#include <ti/sysbios/gates/GateHwi.h>

#include <ti/sysbios/hal/Timer.h>

#include <ti/sysbios/BIOS.h>

#include "driverlib/watchdog.h"
#include "driverlib/sysctl.h"
#include <driverlib/eeprom.h>
#include "inc/hw_memmap.h"

//*****************************************************************************
// [global] current system clock rate in Hz
//*****************************************************************************
#define SYSTEM_CLOCK_RATE 100000000
uint32_t SysClock = 0;

void app_HW_Init(void);
void PID_control_loop(int target_ADC_reading);
/*****************************************************************************
  FUNCTION:    main

  DESCRIPTION: Main entry point for the Test Program.

  INPUTS:      None
               
  OUTPUTS:     None

  RETURNS:     Nothing.

  NOTES:       We have a very long timing loop at the beginning. Its purpose
              is to ensure that JTAG has enough time to grab the processor if
              some sort of hardware issue occurs. It is not necessary for 
              operation once we have the system set up and debugged.

  CONTEXT:     This function only runs in user task context and cannot be 
               called from any other function.

*****************************************************************************/
void main(void)
{
volatile long long tmp = 1234567890;
int i=0;

    // Run from the PLL at 120 MHz and save off setting
    SysClock = SysCtlClockFreqSet((SYSCTL_XTAL_25MHZ |
                                   SYSCTL_OSC_MAIN |
                                   SYSCTL_USE_PLL |
              										 SYSCTL_CFG_VCO_480), 
                                   SYSTEM_CLOCK_RATE );

//    System_printf("System Clock: %d\n", g_ui32SysClock );
//    System_flush();



//    System_printf("entering Main\n");
//    System_flush();
    
    
//    System_printf("entering initial wait loop\n");
//    System_flush();

// This loop is here just in case we get the hardware so hosed
// that we cannot get the attention of the JTAG. Putting this loop in
// gives us a second or two to get the JTAG connected if there is a 
// software/hardware configuration error.  We found this in a situation
// where the Ethernet controller would lock up the system because the hardware
// was defective. Once you have a system working, you can probably 
// remove this loop.

    for (i=0;i < 200000; i++)
    {
       tmp =tmp/7;
       tmp = tmp * 7;
    }


    app_HW_Init();


//    System_printf("starting TI-RTOS\n");
//    System_flush();
//    PID_control_loop(1638);
    PID_control_loop(700);

    // This main() is a generic Tiva main. For the PID Example running 
    // bare metal, this does not execute.
    // enable interrupts and start SYS/BIOS. This will NEVER return
    BIOS_start();
}

