/******************************************************************************

    gpio.c

    Created on: 30 July 2015
      Author: Ray Mack

*******************************************************************************/
#include <stdbool.h>
#include <stdint.h>
#include "inc/hw_gpio.h"
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "driverlib/gpio.h"
#include "driverlib/pin_map.h"
#include "driverlib/sysctl.h"
#include <ti/sysbios/knl/Task.h>
#include "driverlib/timer.h"
#include "driverlib/pwm.h"


/*****************************************************************************
  FUNCTION:    init_GPIO

  DESCRIPTION: This function sets .

  INPUTS:      None
               
  OUTPUTS:     Updated hardware configuration

  RETURNS:     Nothing.

  NOTES:       None.

  CONTEXT:     This function only runs in user task context.

*****************************************************************************/

void init_GPIO(void)
{

  // Enable GPIO Port A
  SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
  
  // Port B has no connections!!!

  // enable Port C 
  // BE EXTREMELY CAREFUL.  This port is shared with JTAG for the debugger.
  // Messing up the pins will turn off the JTAG debugger and make it *really* hard to
  // connect
  SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOC); 

  // Port D has the SPI signals clk, mosi, and miso as well as 4 analog input channels
  SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOD); 
  
  // Port E has only analog input connections.  This port is enabled in another
  // function
  
  // Port F only has PWM output connections.
  SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF); 
  
  // Port G only has PWM output connections.  It is initialized for PWM operation
  // in another function.
  SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOG); 

  // Port M implements 6 analog inputs. It also implements the Data Ready input for the analog system (U4)
  SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOM);

  //
  SysCtlPeripheralEnable(SYSCTL_PERIPH_PWM0);
  
  //
  // Configure TimerA as a half-width one-shot timer, and TimerB as a
  // half-width edge capture counter.
  //
  TimerConfigure(TIMER0_BASE, (TIMER_CFG_SPLIT_PAIR | TIMER_CFG_A_ONE_SHOT));
  //
  // Set the count time for the the one-shot timer (TimerA).
  //
  TimerLoadSet(TIMER0_BASE, TIMER_A, 10000);
  TimerEnable(TIMER0_BASE, TIMER_A);
  
  init_analog_in();
  // PWM setup
  GPIOPinTypeGPIOOutput(GPIO_PORTF_BASE, GPIO_PIN_0);
  GPIOPinConfigure(GPIO_PF0_M0PWM0);
  GPIOPinTypePWM(GPIO_PORTF_BASE, GPIO_PIN_0);
  PWMClockSet(PWM0_BASE,PWM_SYSCLK_DIV_64);
  // down count mode, no sync of updating count value
  PWMGenConfigure(PWM0_BASE, PWM_GEN_0, PWM_GEN_MODE_DOWN | PWM_GEN_MODE_NO_SYNC);
  // Set the output pin on
  PWMOutputState(PWM0_BASE, PWM_OUT_0_BIT, 1);
  PWMGenPeriodSet(PWM0_BASE, PWM_GEN_0, 4000);
  PWMPulseWidthSet(PWM0_BASE, PWM_OUT_0, 2000);
  // turn on the PWM circuitry
  PWMGenEnable(PWM0_BASE, PWM_GEN_0);
  // Set the output pin on
  PWMOutputState(PWM0_BASE, PWM_OUT_0_BIT, 1);
}

