/****************************************************************************

 Filename:       app_init.c

 Description:    this file contains the hardware specific functions for the
                 PID Loop Example.
 
 Author:        Ray Mack
****************************************************************************/

/*****************************************************************************

How it Works:

The system comes up in bare metal condition. The functions in this file are
used to activate the various GPIO systems (a Tiva concept) and then configure
those GPIO systems so they are ready for the devices to use.

**************************************************************************/


#include <stdint.h>
#include <stdbool.h>
#include <inc/hw_memmap.h>
#include <inc/hw_types.h>
#include <inc/hw_ints.h>
#include <inc/hw_gpio.h>

#include <driverlib/rom.h>
#include <driverlib/rom_map.h>
#include <driverlib/gpio.h>
#include <driverlib/flash.h>
#include <driverlib/sysctl.h>
#include <driverlib/i2c.h>
#include <driverlib/ssi.h>
#include <driverlib/udma.h>
#include <driverlib/pin_map.h>

#include <xdc/std.h>
#include <xdc/cfg/global.h>
#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>
#include <ti/sysbios/family/arm/m3/Hwi.h>

//#include "uart.h"
//#include "uartstdio.h"
void init_GPIO(void);

/*****************************************************************************
  FUNCTION:    app_HW_Init

  DESCRIPTION: This function is used to init hardware after a software or 
               hardware reset.

  INPUTS:      All hardware is still in bare metal state after a reset.
               
  OUTPUTS:     None

  RETURNS:     Nothing.

  NOTES:       None.

  CONTEXT:     This function only runs bare metal context from reset. 
  
*****************************************************************************/
void app_HW_Init(void)
{

  System_printf("entering HW_Init()\n");
  System_flush();

// initialize all of the peripherals and any pins used.
//
  init_GPIO();
   
}
