#pragma once
//#include "resource.h"
#include "windows.h"

#define C_ASCII_1									'1'
#define C_EOT										'\x04'
#define C_NULL										'\x00'
#define SZ_ASCII_0									"0"
#define SZ_ASCII_1									"1"
#define SZ_DECOMPRESSION_ERROR						"***Decompression Error!***"
#define SZ_SYMBOL_SET								"\x04\x0a\x0d /0123456789?ABCDEFGHIJKLMNOPQRSTUVWXYZ"	//total of 42 symbols
#define UI_MASK_BIT_00								0x00000001
#define UI_MASK_BIT_00_TO_29						0x3fffffff
#define UI_MASK_BIT_30								0x40000000
#define UI_MASK_BIT_31								0x80000000

class clsAAC {

public:
	clsAAC();
	~clsAAC();
	bool fnIsValidSymbol(char cSymbol);
	void fnCompress(char* szMessage, char* szCompressedMessage, int iSize);
	void fnDecompress(char* szCompressedMessage, char* szMessage, int iSize);

private:
	char* szSymbolSet = NULL;
	unsigned int* uiCumulativeCountArray = NULL;
	unsigned int uiSymbolSetLength; 
	unsigned int fnGetBitFromCompressedMessage(char* szCompressedMessage, unsigned int uiIndex);
	unsigned int fnGetIndexFromSymbol(char cSymbol);
	unsigned int fnGetSymbolLowerRangeCountFromSymbol(char cSymbol); 
	unsigned int fnGetSymbolUpperRangeCountFromSymbol(char cSymbol);
	long long llCumulativeCountArrayMaximumValue;
	void fnInitializeCumulativeCountArray();
	void fnUpdateCumulativeCountArray(char cSymbol);

};

