#pragma once
#include "clsAAC.h"

clsAAC::clsAAC() {
	uiSymbolSetLength = strlen(SZ_SYMBOL_SET);
	szSymbolSet = new char[uiSymbolSetLength + 1];					//add 1 to leave room for the terminating null character
	strcpy_s(szSymbolSet, (uiSymbolSetLength + 1), SZ_SYMBOL_SET);	//ditto
	uiCumulativeCountArray = new unsigned int[uiSymbolSetLength];
}

clsAAC::~clsAAC() {
	delete[] szSymbolSet;
	szSymbolSet = NULL;
	delete[] uiCumulativeCountArray;
	uiCumulativeCountArray = NULL;
}

void clsAAC::fnCompress(char* szMessage, char* szCompressedMessage, int iSize) {
	char c1;
	char szOneOrZero[] = SZ_ASCII_0;
	long long llRange;
	unsigned int ui1;
	unsigned int uiRangeLower;
	unsigned int uiRangeUpper;
	unsigned int uiUnderflowBitCount;
	szCompressedMessage[0] = C_NULL;
	if (strlen(szMessage) == 0) {
		return;
	}
	uiRangeLower = 0;
	uiRangeUpper = UINT_MAX;
	uiUnderflowBitCount = 0;
	fnInitializeCumulativeCountArray();
	for (ui1 = 0; (ui1 < (strlen(szMessage) + 1)); ui1++) {
		if (ui1 < strlen(szMessage)) {
			c1 = szMessage[ui1];
			if (fnIsValidSymbol(c1) == false) {
				continue;
			}
		}
		else {
			c1 = C_EOT;
		}
		llRange = (long long)uiRangeUpper - (long long)uiRangeLower + 1; 
		uiRangeUpper = (unsigned int)((long long)uiRangeLower
			+ (((long long)fnGetSymbolUpperRangeCountFromSymbol(c1) * llRange) / llCumulativeCountArrayMaximumValue)
			- 1);
		uiRangeLower = (unsigned int)((long long)uiRangeLower
			+ (((long long)fnGetSymbolLowerRangeCountFromSymbol(c1) * llRange) / llCumulativeCountArrayMaximumValue)
			- (long long)0);
		while (true) {
			//if lower >= 1/2 (0.1 in binary notation) then upper must also be > 1/2; thus they are converging above 1/2; thus both MSBs = 1
			if (uiRangeLower >= UI_MASK_BIT_31) {
				strcat_s(szCompressedMessage, iSize, SZ_ASCII_1);
				while (uiUnderflowBitCount > 0) {
					strcat_s(szCompressedMessage, iSize, SZ_ASCII_0);
					uiUnderflowBitCount--;
				}
			}
			//if upper <= 1/2 (0.1 in binary notation) then lower must also be < 1/2; thus they are converging below 1/2; thus both MSBs = 0
			else if (uiRangeUpper <= UI_MASK_BIT_31) {
				strcat_s(szCompressedMessage, iSize, SZ_ASCII_0);
				while (uiUnderflowBitCount > 0) {
					strcat_s(szCompressedMessage, iSize, SZ_ASCII_1);
					uiUnderflowBitCount--;
				}
			}
			//only other scenario is lower < 1/2 and upper > 1/2; if next lower MSB is 1 and next upper MSB is 0, underflow is threatened
			else if ((uiRangeLower & UI_MASK_BIT_30) && !(uiRangeUpper & UI_MASK_BIT_30)) {
				uiUnderflowBitCount++;
				uiRangeLower &= UI_MASK_BIT_00_TO_29;
				uiRangeUpper |= UI_MASK_BIT_30;
			}
			//this is where the compressor gets "adapted" to the changing stream of symbols
			else {
				fnUpdateCumulativeCountArray(c1);
				break;
			}
			uiRangeLower <<= 1;
			uiRangeUpper <<= 1;
			uiRangeUpper |= UI_MASK_BIT_00;
		}
	}
	//the rest of this code "flushes" the compressor
	if (uiRangeLower & UI_MASK_BIT_30) {
		strcat_s(szCompressedMessage, iSize, SZ_ASCII_1);
	}
	else {
		strcat_s(szCompressedMessage, iSize, SZ_ASCII_0);
		szOneOrZero[0] = C_ASCII_1;
	}
	uiUnderflowBitCount++;
	while (uiUnderflowBitCount--) {
		strcat_s(szCompressedMessage, iSize, szOneOrZero);
	}
}

void clsAAC::fnDecompress(char* szCompressedMessage, char* szMessage, int iSize) {
	char szCharToString[2] = { C_NULL, C_NULL };
	long long llRange;
	unsigned int ui1;
	unsigned int ui2;
	unsigned int uiIndex;
	unsigned int uiRangeLower;
	unsigned int uiRangeUpper;
	unsigned int uiWorkingRegister;
	szMessage[0] = C_NULL;
	if (strlen(szCompressedMessage) == 0) {
		return;
	}
	//even if the compressed message contains nothing but "0" and "1", it might not be decompressible and might crash this function due to 
	//fade, interference, dropped bits, etc.; so, I've included a try/catch
	try {
		uiRangeLower = 0;
		uiRangeUpper = UINT_MAX;
		uiWorkingRegister = 0;
		fnInitializeCumulativeCountArray();
		for (uiIndex = 0; uiIndex < (sizeof(unsigned int) * CHAR_BIT); uiIndex++) {
			uiWorkingRegister <<= 1;
			uiWorkingRegister |= fnGetBitFromCompressedMessage(szCompressedMessage, uiIndex);
		}
		while (true) {
			llRange = (long long)uiRangeUpper - (long long)uiRangeLower + 1;
			ui1 = (unsigned int)(((((long long)uiWorkingRegister - (long long)uiRangeLower + 1) * llCumulativeCountArrayMaximumValue) - 1) / llRange);
			for (ui2 = 0; ui2 < uiSymbolSetLength; ui2++) {
				if (ui1 < uiCumulativeCountArray[ui2]) {
					break;
				}
			}
			if (szSymbolSet[ui2] == C_EOT) {
				return;
			}
			szCharToString[0] = szSymbolSet[ui2];
			strcat_s(szMessage, iSize, szCharToString);
			uiRangeUpper = (unsigned int)((long long)uiRangeLower
				+ (((long long)fnGetSymbolUpperRangeCountFromSymbol(szSymbolSet[ui2]) * llRange) / llCumulativeCountArrayMaximumValue)
				- 1);
			uiRangeLower = (unsigned int)((long long)uiRangeLower
				+ (((long long)fnGetSymbolLowerRangeCountFromSymbol(szSymbolSet[ui2]) * llRange) / llCumulativeCountArrayMaximumValue)
				- (long long)0);
			while (true) {
				//if lower >= 1/2 (0.1 in binary notation) then upper must be > 1/2; thus they are converging above 1/2; thus both MSBs = 1
				if (uiRangeLower >= UI_MASK_BIT_31) {
					//do nothing
				}
				//if upper <= 1/2 (0.1 in binary notation) then lower must be < 1/2; thus they are converging below 1/2; thus both MSBs = 0
				else if (uiRangeUpper <= UI_MASK_BIT_31) {
					//do nothing
				}
				//only other scenario is lower < 1/2 and upper > 1/2; if next lower MSB is 1 and next upper MSB is 0, underflow is threatened
				else if ((uiRangeLower & UI_MASK_BIT_30) && !(uiRangeUpper & UI_MASK_BIT_30)) {
					uiRangeLower &= UI_MASK_BIT_00_TO_29;
					uiRangeUpper |= UI_MASK_BIT_30;
					uiWorkingRegister ^= UI_MASK_BIT_30;
				}
				//this is where the compressor gets "adapted" to the changing stream of symbols
				else {
					fnUpdateCumulativeCountArray(szSymbolSet[ui2]);
					break;
				}
				uiRangeLower <<= 1;
				uiRangeUpper <<= 1;
				uiRangeUpper |= UI_MASK_BIT_00;
				uiWorkingRegister <<= 1;
				uiWorkingRegister |= fnGetBitFromCompressedMessage(szCompressedMessage, uiIndex);
				uiIndex++;
			}
		}
	}
	catch (...) {
		strcat_s(szMessage, iSize, SZ_DECOMPRESSION_ERROR);
		return;
	}
}

unsigned int clsAAC::fnGetBitFromCompressedMessage(char* szCompressedMessage, unsigned int uiIndex) {
	if ((uiIndex + 1) > strlen(szCompressedMessage)) {
		return 0;
	}
	return (unsigned int)(szCompressedMessage[uiIndex] & UI_MASK_BIT_00);
}

unsigned int clsAAC::fnGetIndexFromSymbol(char cSymbol) {
	char* pc;
	if (cSymbol == C_NULL) {
		return false;
	}
	pc = strchr(szSymbolSet, cSymbol);
	if (pc != NULL) {
		return pc - &szSymbolSet[0];
	}
	return 0;
}

unsigned int clsAAC::fnGetSymbolLowerRangeCountFromSymbol(char cSymbol) {
	unsigned int ui1;
	ui1 = fnGetIndexFromSymbol(cSymbol);
	if (ui1 > 0) {
		return uiCumulativeCountArray[ui1 - 1];
	}
	return 0;
}

unsigned int clsAAC::fnGetSymbolUpperRangeCountFromSymbol(char cSymbol) {
	return uiCumulativeCountArray[fnGetIndexFromSymbol(cSymbol)];
}

void clsAAC::fnInitializeCumulativeCountArray() {
	unsigned int ui1;
	for (ui1 = 0; ui1 < uiSymbolSetLength; ui1++) {
		uiCumulativeCountArray[ui1] = ui1 + 1;
	}
	llCumulativeCountArrayMaximumValue = (long long)uiCumulativeCountArray[ui1 - 1];
}

bool clsAAC::fnIsValidSymbol(char cSymbol) {
	if (cSymbol == C_NULL) {
		return false;
	}
	if (strchr(szSymbolSet, cSymbol) != NULL) {
		return true;
	}
	return false;
}

void clsAAC::fnUpdateCumulativeCountArray(char cSymbol) {
	unsigned int ui1;
	for (ui1 = fnGetIndexFromSymbol(cSymbol); ui1 < uiSymbolSetLength; ui1++) {
		uiCumulativeCountArray[ui1]++;
	}
	llCumulativeCountArrayMaximumValue = (long long)uiCumulativeCountArray[ui1 - 1];
}
