/*
 * Copyright (C) 2013 Thomas M. Alldread
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package va7ta.app.nimblesigsweepgen;

import va7ta.app.nimblesigsweepgen.R;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnFocusChangeListener;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import android.widget.TextView;


public class SweepSetup extends Activity{

		private static final String TAG = "SweepSetup";
	    private static final boolean D = true;
	    
	    
	    private static final int NO_SELECTION = 0;
		private static final int SPAN_WIDTH_SELECT = 1;
		private static final int START_FREQ_SELECT = 2;
		private static final int CENTER_FREQ_SELECT = 3;
		private static final int STOP_FREQ_SELECT = 4;
		private static final int SPAN_HZ_DIV_SELECT = 5;
		private static final int SWEEP_TIME_SELECT = 6;
		private static final int SWEEP_STEPS_SELECT = 7;
		private static final int REF_LEVEL_SELECT = 8;
		private static final int DB_DIV_SELECT = 9;
		

		
	    // onActivityResult Return Codes
	    private static final int REQUEST_CONNECT_DEVICE_SECURE = 1;
	    private static final int REQUEST_CONNECT_DEVICE_INSECURE = 2;    
	    private static final int REQUEST_ENABLE_BT = 3;
	    private static final int PHASE_OFFSET_UPDATE_GEN_A = 4;
	    private static final int PHASE_OFFSET_UPDATE_GEN_B = 5;
	    private static final int OUTPUT_LEVEL_UPDATE_GEN_A = 6;
	    private static final int OUTPUT_LEVEL_UPDATE_GEN_B = 7;
	    private static final int AM_MOD_INDEX_UPDATE_GEN_A = 8;
	    private static final int AM_MOD_INDEX_UPDATE_GEN_B = 9;
	    private static final int FM_DEV_UPDATE_GEN_A = 10;
	    private static final int FM_DEV_UPDATE_GEN_B = 11;
	    private static final int MOD_FREQ_HZ_UPDATE = 12;
	    private static final int SWEEP_GEN_RESULTS= 13;
	    private static final int SWEEP_GEN_NEW_SETUP= 14;
	    private static final int SWEEP_GEN_SET_CNTR_FREQ_HZ=15;


		private double g_NewFreqHz_Flt=0; 
		private double g_LastFinerAdj_Flt=0;
		private double g_FinerAdjust_Flt=0;
		private double g_StartPos10MHz_Flt=0; 
		
		private int g_CntrFqHz_Int=0;
		private int g_StartPos_Int=0; 
		private int g_ParameterSelected_Int=CENTER_FREQ_SELECT; 
		private int g_NewFreqHz_Int=0;	
		
	    private String g_NewFreqHz_Str="0";
	    private String presentCntrFqHz_Str="0";

	    private boolean g_fineBarAutoCntr_Bool=false;
		private boolean g_autoAdj10MHzBar_Bool=false;
		
		private   Button mSweepSetUpBtn;
		protected Button mCenterFreqHzBtn;
		protected Button mStartFreqHzBtn;
		protected Button mStopFreqHzBtn;
		protected Button mSpanWidthHzBtn;
		protected Button mSpanHzDivBtn;
		protected Button mSweepTimeBtn;
		protected Button m_dB_Div_Btn;
		protected Button mSelect_dB_DivBtn;
		
		protected EditText mSweepStepsEdit;
		protected EditText mSweepRefLevelEdit;
		
		protected TextView mCenterFreqHzLbl;
		protected TextView mStartFreqHzLbl;
		protected TextView mStopFreqHzLbl;
		protected TextView mSpanWidthHzLbl;
		protected TextView mSpanHzDivLbl;
		protected TextView mSweepStepsLbl;
		protected TextView mSweepTimeLbl;
		protected TextView m_stepHz_Text;
		protected TextView mSelect_dB_DivLbl;
		protected TextView mRefLevel_2dB_DivLbl;
		
		protected SeekBar mAdjFreq10MHz_Bar;
		protected SeekBar mAdjFreq1MHz_Bar;
		protected SeekBar mAdjFreq100KHz_Bar;
		protected SeekBar mAdjFreq10KHz_Bar;
		protected SeekBar mAdjFreq1KHz_Bar;
		protected SeekBar mAdjFreq100Hz_Bar;
		protected SeekBar mAdjFreq10Hz_Bar;
		protected SeekBar mAdjFreq1Hz_Bar;
				
		@Override
		public void onCreate(Bundle icicle) {
	    super.onCreate(icicle);
	    	if(D) Log.e(TAG, "+ ON CREATE +");

//	        Intent currentValIntent = getIntent();
//	        if(currentValIntent.hasExtra("centerFreqHz")){
//	        	sg_SweepCenterFreqHz = currentValIntent.getStringExtra("valFM_DevHzA");
//	            presentCntrFqHz_Str = stripSpaces(presentCntrFqHz_Str);
//	        }
	    	// Set up the window layout
	    	setContentView(R.layout.sweep_setup);
	    	// prevent default keyboard from popping up at beginning
	        this.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);

//	    	TextView FM_DevHzAValStr =(TextView) findViewById(R.id.fmDevHzValue);
//	        FM_DevHzAValStr.setText(presentCntrFqHz_Str);            
//	    	TextView FM_DevHzAdjTitle = (TextView) findViewById(R.id.titleFM_Dev_Adjust); 
//	    	FM_DevHzAdjTitle.setText("Generator 'A' FM Deviation - Hz.");
	    	
	        iniWidgetVars();
	        g_ParameterSelected_Int = CENTER_FREQ_SELECT;
	        buttenSel(g_ParameterSelected_Int);
	        setBarStartPositions(g_ParameterSelected_Int);
	        
	        //================

	        // The action listener for the EditText widget, to listen for the return key
	        final EditText.OnEditorActionListener mRefLevelListener = new EditText.OnEditorActionListener() {
	            public boolean onEditorAction(TextView refLevelView, int actionId, KeyEvent event) {
	                    String message = refLevelView.getText().toString();
	                    int newRefLeveldBm = Integer.valueOf(message);
	                    if(newRefLeveldBm > 20)newRefLeveldBm=20;
	                    if(newRefLeveldBm < -50)newRefLeveldBm=-50;
	                    mSweepRefLevelEdit = (EditText) findViewById(R.id.refLevel2dB_Edit);	
	                    mSweepRefLevelEdit.setText(String.valueOf(newRefLeveldBm));
	                    NS3_App.sg_2dB_DivRefLvl_Int = newRefLeveldBm;
	                    NS3_App.sg_Yaxis_RefLevel_dBm_Int = NS3_App.sg_2dB_DivRefLvl_Int;
//	                    buttenSel(REF_LEVEL_SELECT);
//	                    upDateHzPerStep();
		            	buttenSel(NO_SELECTION);					
                    return true;
	            }
	        };
	        
	        // Initialize the compose field with a listener for the return key
	        mSweepRefLevelEdit = (EditText) findViewById(R.id.refLevel2dB_Edit);
	        mSweepRefLevelEdit.setOnEditorActionListener(mRefLevelListener);
	        	       	        
	        // green highlight the edit widget
	        mSweepRefLevelEdit = (EditText) findViewById(R.id.refLevel2dB_Edit);
		    mSweepRefLevelEdit.setOnFocusChangeListener(new View.OnFocusChangeListener() {				
				@Override
				public void onFocusChange(View v, boolean hasFocus) {
					// TODO Auto-generated method stub
	            	buttenSel(REF_LEVEL_SELECT);					
				}
			});

	        //==================

		    // The action listener for the EditText widget, to listen for the return key
	        final EditText.OnEditorActionListener mStepsPerSweepListener = new EditText.OnEditorActionListener() {
	            public boolean onEditorAction(TextView sweepStepsView, int actionId, KeyEvent event) {
	                    String message = sweepStepsView.getText().toString();
	                    int newStepsPerSweep = Integer.valueOf(message);
	                    if(newStepsPerSweep < 10)newStepsPerSweep=10;
	                    if(newStepsPerSweep > 1024)newStepsPerSweep=1024;
	        	        mSweepStepsEdit = (EditText) findViewById(R.id.stepsPerSweep);	
	                    mSweepStepsEdit.setText(String.valueOf(newStepsPerSweep));
	                    NS3_App.sg_StepsPerSweep = newStepsPerSweep;
	                    upDateHzPerStep();
		            	buttenSel(NO_SELECTION);					
                    return true;
	            }
	        };
	        
	        // Initialize the compose field with a listener for the return key
	        mSweepStepsEdit = (EditText) findViewById(R.id.stepsPerSweep);
	        mSweepStepsEdit.setOnEditorActionListener(mStepsPerSweepListener);

	        // green highlight the edit widget
	        mSweepStepsEdit = (EditText) findViewById(R.id.stepsPerSweep);
	        mSweepStepsEdit.setOnFocusChangeListener(new View.OnFocusChangeListener() {				
				@Override
				public void onFocusChange(View v, boolean hasFocus) {
					// TODO Auto-generated method stub
	            	buttenSel(SWEEP_STEPS_SELECT);					
				}
			});
	        
	        //===================
	        
	        mSpanWidthHzBtn = (Button) findViewById(R.id.spanWidthHz);
	        mSpanWidthHzBtn.setOnClickListener(new OnClickListener() {
	            public void onClick(View v) {
	            	buttenSel(SPAN_WIDTH_SELECT);
	    	        setBarStartPositions(g_ParameterSelected_Int);
	            }
	        });       
	    	
	        mStartFreqHzBtn = (Button) findViewById(R.id.startFreqHz);
	        mStartFreqHzBtn.setOnClickListener(new OnClickListener() {
	            public void onClick(View v) {
	            	buttenSel(START_FREQ_SELECT);
	    	        setBarStartPositions(g_ParameterSelected_Int);
	            }
	        });
	        
	        mCenterFreqHzBtn = (Button) findViewById(R.id.centerFreqValHz);
	        mCenterFreqHzBtn.setOnClickListener(new OnClickListener() {
	            public void onClick(View v) {
	            	buttenSel(CENTER_FREQ_SELECT);
	    	        setBarStartPositions(g_ParameterSelected_Int);
	            }
	        });
	        
	        mStopFreqHzBtn = (Button) findViewById(R.id.stopFreqValHz);
	        mStopFreqHzBtn.setOnClickListener(new OnClickListener() {
	            public void onClick(View v) {
	            	buttenSel(STOP_FREQ_SELECT);
	    	        setBarStartPositions(g_ParameterSelected_Int);
	            }
	        });       
	    	
	        mSpanHzDivBtn = (Button) findViewById(R.id.freqHzDiv);
	        mSpanHzDivBtn.setOnClickListener(new OnClickListener() {
	            public void onClick(View v) {
	            	buttenSel(SPAN_HZ_DIV_SELECT);
	    	        setBarStartPositions(g_ParameterSelected_Int);
	            }
	        });
	        
//	        mSweepTimeBtn = (Button) findViewById(R.id.sweepTime_mS);
//	        mSweepTimeBtn.setOnClickListener(new OnClickListener() {
//	            public void onClick(View v) {
//	            	buttenSel(SWEEP_TIME_SELECT);
//	            }
//	        });       
	    	
	        
	        mSweepStepsEdit = (EditText) findViewById(R.id.stepsPerSweep);
	        mSweepStepsEdit.setOnClickListener(new OnClickListener() {
	            public void onClick(View v) {
	            	buttenSel(SWEEP_STEPS_SELECT);
	            }
	        }); 
	        
	        mSelect_dB_DivBtn = (Button) findViewById(R.id.dB_Div_Btn);
	        mSelect_dB_DivBtn.setOnClickListener(new OnClickListener() {
	            public void onClick(View v) {
	            	buttenSel(DB_DIV_SELECT);
	            	String dBDivStr="";
	            	dBDivStr=String.valueOf(mSelect_dB_DivBtn.getText());
	            	if(NS3_App.sg_Scale_dB_Div_Int != 10){
	            		NS3_App.sg_Scale_dB_Div_Int = 10;
	            		NS3_App.sg_10dB_Div_Yaxis_b = true;
	            		NS3_App.sg_Yaxis_RefLevel_dBm_Int=20;
	            		NS3_App.sg_Yaxis_DynamicRange_dB_Int= 100;
	            		mSelect_dB_DivBtn.setText("10");
	            	}else{
	            		NS3_App.sg_Scale_dB_Div_Int = 2;	            		
	            		NS3_App.sg_10dB_Div_Yaxis_b = false;
	            		NS3_App.sg_Yaxis_DynamicRange_dB_Int= 20;
	            		mSelect_dB_DivBtn.setText("2");
	            		NS3_App.sg_Yaxis_RefLevel_dBm_Int=NS3_App.sg_2dB_DivRefLvl_Int;
	            		NS3_App.sg_NormalizeMode_b=false;
	            	}
	            }
	        }); 
	        
	        //"ACCEPT" button with a listener that for click events
	        mSweepSetUpBtn = (Button) findViewById(R.id.newSweepGoBtn);
	        mSweepSetUpBtn.setOnClickListener(new OnClickListener() {
	        	public void onClick(View v) {
	                TextView FM_DevHzA_Value=(TextView) findViewById(R.id.centerFreqValHz);
	                g_NewFreqHz_Str = FM_DevHzA_Value.getText().toString();
	            	Intent newFM_DevHzA_Val=new Intent(getApplicationContext(), NimbleSigSweepGenMain.class);
	            	newFM_DevHzA_Val.putExtra("centerFreq",NS3_App.sg_SweepCenterFreqHz);
	        		finish();
	        	}
	        });
	        
	        //Start seekbar code==========================================================
	    	
	        

// 10 MHz Bar	        
	        mAdjFreq10MHz_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 
	            @Override 
	            public void onStopTrackingTouch(SeekBar seekBar) { 
	                
	            	g_LastFinerAdj_Flt = 0;
//	                SeekBar mAdjFreq100KHz_Bar=(SeekBar) findViewById(R.id.freq100KHzAdjBar);
//	                mAdjFreq100KHz_Bar.setProgress(2500);
	            } 

	            @Override 
	            public void onStartTrackingTouch(SeekBar seekBar) { 	                

	            } 

	            @Override 
	            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 	                
	            	if(!g_autoAdj10MHzBar_Bool){//skip if adjustment from finer seek bars
		            	// To convert it as g_NewFreqHz_Flt value 
		                g_NewFreqHz_Flt=(progress/10000000)*10000000; 
		                g_NewFreqHz_Int=(int)(g_NewFreqHz_Flt);
		                g_NewFreqHz_Str = String.valueOf(g_NewFreqHz_Int);
		                upDateTarget(g_ParameterSelected_Int, g_NewFreqHz_Int);//set progress

	            	}else g_autoAdj10MHzBar_Bool=false;
	            } 
	        }); 
	        
// 1 MHz Bar	 
	        mAdjFreq1MHz_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 	        	
	            @Override 
	            public void onStopTrackingTouch(SeekBar seekBar) { 	                
	                int newProgress = g_NewFreqHz_Int;
	                g_autoAdj10MHzBar_Bool=true;
	                mAdjFreq10MHz_Bar.setProgress(newProgress);
	                g_fineBarAutoCntr_Bool=true;
	                mAdjFreq1MHz_Bar.setProgress(10000000);
	                g_LastFinerAdj_Flt = 0;	                
	            } 

	            @Override 
	            public void onStartTrackingTouch(SeekBar seekBar) { 	               
	            } 

	            @Override 
	            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 	                
	            	if(!g_fineBarAutoCntr_Bool){
	            		g_FinerAdjust_Flt=progress-10000000;
	            		g_FinerAdjust_Flt=((int)g_FinerAdjust_Flt/1000000)*1000000;
	            		g_NewFreqHz_Flt=((int)((g_NewFreqHz_Flt+.5)/1000000))*1000000;
		                g_NewFreqHz_Flt += (g_FinerAdjust_Flt-g_LastFinerAdj_Flt);            
		                g_LastFinerAdj_Flt = g_FinerAdjust_Flt;
		                g_NewFreqHz_Int=(int)g_NewFreqHz_Flt;
		                upDateTarget(g_ParameterSelected_Int, g_NewFreqHz_Int);//set progress
	            	}
	                else g_fineBarAutoCntr_Bool = false;
	            } 
	        }); //mAdjFreq1MHz_Bar

// 100 KHz Bar	 
	        mAdjFreq100KHz_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 
	            @Override 
	            public void onStopTrackingTouch(SeekBar seekBar) { 	                
	                int newProgress = g_NewFreqHz_Int;
	                g_autoAdj10MHzBar_Bool=true;
	                mAdjFreq10MHz_Bar.setProgress(newProgress);
	                g_fineBarAutoCntr_Bool=true;
	                mAdjFreq100KHz_Bar.setProgress(1000000);
	                g_LastFinerAdj_Flt = 0;	                
	            } 

	            @Override 
	            public void onStartTrackingTouch(SeekBar seekBar) { 	               
	            } 

	            @Override 
	            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 	                
	            	if(!g_fineBarAutoCntr_Bool){
	            		g_FinerAdjust_Flt=progress-1000000;
	            		g_FinerAdjust_Flt=((int)g_FinerAdjust_Flt/100000)*100000;
	            		g_NewFreqHz_Flt=((int)((g_NewFreqHz_Flt+.5)/100000))*100000;
		                g_NewFreqHz_Flt += (g_FinerAdjust_Flt-g_LastFinerAdj_Flt);            
		                g_LastFinerAdj_Flt = g_FinerAdjust_Flt;
		                g_NewFreqHz_Int=(int)g_NewFreqHz_Flt;
		                upDateTarget(g_ParameterSelected_Int, g_NewFreqHz_Int);//set progress
	            	}
	                else g_fineBarAutoCntr_Bool = false;
	            } 
	        }); //mAdjFreq100KHz_Bar
	 
//10 KHz Bar
	        mAdjFreq10KHz_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

	            @Override 
	            public void onStopTrackingTouch(SeekBar seekBar) { 	                
	                int newProgress = g_NewFreqHz_Int;
	                g_autoAdj10MHzBar_Bool=true;
	                mAdjFreq10MHz_Bar.setProgress(newProgress);
	                g_fineBarAutoCntr_Bool=true;
	                mAdjFreq10KHz_Bar.setProgress(100000);
	                g_LastFinerAdj_Flt = 0;	                
	            } 

	            @Override 
	            public void onStartTrackingTouch(SeekBar seekBar) { 	               
	            } 

	            @Override 
	            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 	                
	            	if(!g_fineBarAutoCntr_Bool){
	            		g_FinerAdjust_Flt=progress-100000;
	            		g_FinerAdjust_Flt=((int)g_FinerAdjust_Flt/10000)*10000;
	            		g_NewFreqHz_Flt=((int)((g_NewFreqHz_Flt+.5)/10000))*10000;
		                g_NewFreqHz_Flt += (g_FinerAdjust_Flt-g_LastFinerAdj_Flt);            
		                g_LastFinerAdj_Flt = g_FinerAdjust_Flt;
		                g_NewFreqHz_Int=(int)g_NewFreqHz_Flt;
		                upDateTarget(g_ParameterSelected_Int, g_NewFreqHz_Int);//set progress
	            	}
	                else g_fineBarAutoCntr_Bool = false;
	            } 
	        }); //mAdjFreq10KHz_Bar
	        
// 1 KHz Bar
	        mAdjFreq1KHz_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

	            @Override 
	            public void onStopTrackingTouch(SeekBar seekBar) { 	                
	                int newProgress = g_NewFreqHz_Int;
	                g_autoAdj10MHzBar_Bool=true;
	                mAdjFreq10MHz_Bar.setProgress(newProgress);
	                g_fineBarAutoCntr_Bool=true;
	                mAdjFreq1KHz_Bar.setProgress(10000);
	                g_LastFinerAdj_Flt = 0;	                
	            } 

	            @Override 
	            public void onStartTrackingTouch(SeekBar seekBar) { 	               
	            } 

	            @Override 
	            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 	                
	            	if(!g_fineBarAutoCntr_Bool){
	            		g_FinerAdjust_Flt=progress-10000;
	            		g_FinerAdjust_Flt=((int)g_FinerAdjust_Flt/1000)*1000;
	            		g_NewFreqHz_Flt=((int)((g_NewFreqHz_Flt+.5)/1000))*1000;
		                g_NewFreqHz_Flt += (g_FinerAdjust_Flt-g_LastFinerAdj_Flt);            
		                g_LastFinerAdj_Flt = g_FinerAdjust_Flt;
		                g_NewFreqHz_Int=(int)g_NewFreqHz_Flt;
		                upDateTarget(g_ParameterSelected_Int, g_NewFreqHz_Int);//set progress
	            	}
	                else g_fineBarAutoCntr_Bool = false;
	            } 
	        }); //mAdjFreq1KHz_Bar
	        
// 100 Hz Bar
	        mAdjFreq100Hz_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 
	            @Override 
	            public void onStopTrackingTouch(SeekBar seekBar) { 	                
	                int newProgress = g_NewFreqHz_Int;
	                g_autoAdj10MHzBar_Bool=true;
	                mAdjFreq10MHz_Bar.setProgress(newProgress);
	                g_fineBarAutoCntr_Bool=true;
	                mAdjFreq100Hz_Bar.setProgress(1000);
	                g_LastFinerAdj_Flt = 0;	                
	            } 

	            @Override 
	            public void onStartTrackingTouch(SeekBar seekBar) { 	               
	            } 

	            @Override 
	            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 	                
	            	if(!g_fineBarAutoCntr_Bool){
	            		g_FinerAdjust_Flt=progress-1000;
	            		g_FinerAdjust_Flt=((int)g_FinerAdjust_Flt/100)*100;
	            		g_NewFreqHz_Flt=((int)((g_NewFreqHz_Flt+.5)/100))*100;
		                g_NewFreqHz_Flt += (g_FinerAdjust_Flt-g_LastFinerAdj_Flt);            
		                g_LastFinerAdj_Flt = g_FinerAdjust_Flt;
		                g_NewFreqHz_Int=(int)g_NewFreqHz_Flt;
		                upDateTarget(g_ParameterSelected_Int, g_NewFreqHz_Int);//set progress
	            	}
	                else g_fineBarAutoCntr_Bool = false;
	            } 
	        }); //mAdjFreq100Hz_Bar
	        
// 10 Hz Bar
	        mAdjFreq10Hz_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

	            @Override 
	            public void onStopTrackingTouch(SeekBar seekBar) { 	                
	                int newProgress = g_NewFreqHz_Int;
	                g_autoAdj10MHzBar_Bool=true;
	                mAdjFreq10MHz_Bar.setProgress(newProgress);
	                g_fineBarAutoCntr_Bool=true;
	                mAdjFreq10Hz_Bar.setProgress(100);
	                g_LastFinerAdj_Flt = 0;	                
	            } 

	            @Override 
	            public void onStartTrackingTouch(SeekBar seekBar) { 	               
	            } 

	            @Override 
	            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 	                
	            	if(!g_fineBarAutoCntr_Bool){
	            		g_FinerAdjust_Flt=progress-100;
	            		g_FinerAdjust_Flt=((int)g_FinerAdjust_Flt/10)*10;//provides 10 Hz steps
	            		g_NewFreqHz_Flt=((int)((g_NewFreqHz_Flt)/10))*10;
		                g_NewFreqHz_Flt += (g_FinerAdjust_Flt-g_LastFinerAdj_Flt);            
		                g_LastFinerAdj_Flt = g_FinerAdjust_Flt;
		                g_NewFreqHz_Int=(int)g_NewFreqHz_Flt;
		                upDateTarget(g_ParameterSelected_Int, g_NewFreqHz_Int);//set progress
	            	}
	                else g_fineBarAutoCntr_Bool = false;
	            } 
	        }); //mAdjFreq10Hz_Bar
	        
// 1 Hz Bar
	        mAdjFreq1Hz_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

	            @Override 
	            public void onStopTrackingTouch(SeekBar seekBar) { 	                
	                int newProgress = g_NewFreqHz_Int;
	                g_autoAdj10MHzBar_Bool=true;
	                mAdjFreq10MHz_Bar.setProgress(newProgress);
	                g_fineBarAutoCntr_Bool=true;
	                mAdjFreq1Hz_Bar.setProgress(10);
	                g_LastFinerAdj_Flt = 0;	                
	            } 

	            @Override 
	            public void onStartTrackingTouch(SeekBar seekBar) { 	               
	            } 

	            @Override 
	            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 	                
	            	if(!g_fineBarAutoCntr_Bool){
	            		g_FinerAdjust_Flt=progress-10;
	            		g_FinerAdjust_Flt=((int)g_FinerAdjust_Flt/1)*1;
	            		g_NewFreqHz_Flt=((int)((g_NewFreqHz_Flt+.5)/1))*1;
		                g_NewFreqHz_Flt += (g_FinerAdjust_Flt-g_LastFinerAdj_Flt);            
		                g_LastFinerAdj_Flt = g_FinerAdjust_Flt;
		                g_NewFreqHz_Int=(int)g_NewFreqHz_Flt;
		                upDateTarget(g_ParameterSelected_Int, g_NewFreqHz_Int);//set progress
	            	}
	                else g_fineBarAutoCntr_Bool = false;
	            } 
	        }); //mAdjFreq1Hz_Bar
	        
	 
	    }//onCreate 
		
	    @Override
	    protected synchronized void onResume() {
	        super.onResume();
	    	if(D) Log.e(TAG, "+++ ON RESUME +++");
	       
	        iniWidgetVars();
	        iniSweepValues();
	        upDateHzPerStep();
	        upDateHzPerDiv();
	        
	        
	    }//onResume
	    
	    @Override
	    protected synchronized void onPause() {
	        super.onPause();
//		        if(D) Log.e(TAG, "- ON PAUSE -");
	    }

	    @Override
	    protected void onStop() {
	        super.onStop();
//		        if(D) Log.e(TAG, "-- ON STOP --");
	    }

	    @Override
	    protected void onDestroy() {
	        super.onDestroy();
//		        if(D) Log.e(TAG, "--- ON DESTROY ---");
	    }

	    // activity methods definitions follow============================================

	    private String stripSpaces(String str){
	        int l=str.length();
	        int i=0;
	        char tempChr[]=str.toCharArray();
	        String tempStr="";
	        while(i<l){
	        	if(tempChr[i] !=' '){
	        		tempStr+=String.valueOf(tempChr[i]);
	        	}
	        	i++;
	        }
	    	return tempStr;
	    }

	    private void iniSweepValues(){
		    mCenterFreqHzBtn = (Button) findViewById(R.id.centerFreqValHz);
	    	mCenterFreqHzBtn.setText(spaceDelimiter(NS3_App.sg_SweepCenterFreqHz));
			mSpanWidthHzBtn = (Button) findViewById(R.id.spanWidthHz);
			mSpanWidthHzBtn.setText(spaceDelimiter(NS3_App.sg_SweepSpanFreqHz));
	        mStartFreqHzBtn = (Button) findViewById(R.id.startFreqHz);
	        mStartFreqHzBtn.setText(spaceDelimiter(NS3_App.sg_SweepStartFreqHz));
			mStopFreqHzBtn = (Button) findViewById(R.id.stopFreqValHz);
			mStopFreqHzBtn.setText(spaceDelimiter(NS3_App.sg_SweepStopFreqHz));
			mSweepStepsEdit = (EditText) findViewById(R.id.stepsPerSweep);
			mSweepStepsEdit.setText(spaceDelimiter(NS3_App.sg_StepsPerSweep));
	        mSpanHzDivBtn = (Button) findViewById(R.id.freqHzDiv);
	        mSpanHzDivBtn.setText(spaceDelimiter(NS3_App.sg_HzPerDiv_Int));	
	        m_stepHz_Text=(TextView) findViewById(R.id.stepHz); 
	        m_stepHz_Text.setText(spaceDelimiter(NS3_App.sg_HzPerStep_Int));
	        m_dB_Div_Btn = (Button) findViewById(R.id.dB_Div_Btn);
	        m_dB_Div_Btn.setText(spaceDelimiter(NS3_App.sg_Scale_dB_Div_Int));
	        mSweepRefLevelEdit = (EditText) findViewById(R.id.refLevel2dB_Edit);
	        mSweepRefLevelEdit.setText(String.valueOf(NS3_App.sg_2dB_DivRefLvl_Int));
	    }
	    
	    private void iniWidgetVars(){
	        mAdjFreq10MHz_Bar=(SeekBar) findViewById(R.id.freq10MHzAdjBar); 
	        mAdjFreq1MHz_Bar=(SeekBar) findViewById(R.id.freq1MHzAdjBar); 
	        mAdjFreq100KHz_Bar=(SeekBar) findViewById(R.id.freq100KHzAdjBar); 
	        mAdjFreq10KHz_Bar=(SeekBar) findViewById(R.id.freq10KHzAdjBar); 
	        mAdjFreq1KHz_Bar=(SeekBar) findViewById(R.id.freq1KHzAdjBar); 
	        mAdjFreq100Hz_Bar=(SeekBar) findViewById(R.id.freq100HzAdjBar); 
	        mAdjFreq10Hz_Bar=(SeekBar) findViewById(R.id.freq10HzAdjBar); 
	        mAdjFreq1Hz_Bar=(SeekBar) findViewById(R.id.freq1HzAdjBar); 

	    }

	    private void upDateTarget(int target, int freq){
	    	if(target == SPAN_WIDTH_SELECT){
    			mSpanWidthHzBtn.setText(spaceDelimiter(freq));	    		
		    	NS3_App.sg_SweepSpanFreqHz=freq;
		    	upDateStartFreq();
		    	upDateStopFreq();
		    	upDateHzPerStep();
		    	upDateHzPerDiv();
	    	}
	    	else if(target == START_FREQ_SELECT){
		        mStartFreqHzBtn.setText(spaceDelimiter(freq));   				    		
		    	NS3_App.sg_SweepStartFreqHz=freq;
		    	upDateCenterFreq();
		    	upDateStopFreq();
	    	}
	    	else if(target == CENTER_FREQ_SELECT){
		    	mCenterFreqHzBtn.setText(spaceDelimiter(freq));
		    	NS3_App.sg_SweepCenterFreqHz=freq;
		    	upDateStopFreq();
		    	upDateStartFreq();
	    	}
	    	else if(target == STOP_FREQ_SELECT){
	    		mStopFreqHzBtn.setText(spaceDelimiter(freq));
		    	NS3_App.sg_SweepStopFreqHz=freq;
		    	upDateCenterFreq();
		    	upDateStartFreq();
	    	}
//	    	else if(target == SPAN_HZ_DIV_SELECT){
//	    		mSpanHzDivBtn.setText(spaceDelimiter(freq));	    		
//		    	NS3_App.sg_HzPerDiv_Int=freq;
//	    	}
//	    	else if(target == SWEEP_TIME_SELECT){
//	    		mSweepTimeBtn.setText(spaceDelimiter(freq));	    		
//		    	NS3_App.sg_SweepTime_mS_Int=freq;
//	    	}
	    	else if(target == SPAN_WIDTH_SELECT){
	    		mSpanWidthHzBtn.setText(spaceDelimiter(freq));	    		
		    	NS3_App.sg_SweepSpanFreqHz=freq;
	    	}
//	    	else if(target == SWEEP_STEPS_SELECT){
	    	// handled by editor see: mStepsPerSweepListener
//	    	}
	    	iniSweepValues();
	    }

	    private void upDateHzPerDiv(){
	    	NS3_App.sg_HzPerDiv_Int = 
	    	NS3_App.sg_SweepSpanFreqHz/10;
    		mSpanHzDivBtn.setText(spaceDelimiter(NS3_App.sg_HzPerDiv_Int));	    		
	    }
	    
	    private void upDateHzPerStep(){
	    	NS3_App.sg_HzPerStep_Int = 
	    	NS3_App.sg_SweepSpanFreqHz/
	    	NS3_App.sg_StepsPerSweep;
	    	m_stepHz_Text.setText(spaceDelimiter(NS3_App.sg_HzPerStep_Int));	    			    	
	    }
	    
	    private void upDateStopFreq(){
	    	NS3_App.sg_SweepStopFreqHz = 
	    	NS3_App.sg_SweepCenterFreqHz +
	    	NS3_App.sg_SweepSpanFreqHz/2;
	    }
	    
	    private void upDateStartFreq(){
	    	NS3_App.sg_SweepStartFreqHz = 
	    	NS3_App.sg_SweepCenterFreqHz -
	    	NS3_App.sg_SweepSpanFreqHz/2;
	    }
	    
	    private void upDateCenterFreq(){
	    	NS3_App.sg_SweepCenterFreqHz = 
	    	NS3_App.sg_SweepStartFreqHz +
	    	NS3_App.sg_SweepSpanFreqHz/2;
	    }
	    
	    private void buttenSel(int sel){
    		if(sel == SPAN_WIDTH_SELECT){
    			mSpanWidthHzBtn = (Button) findViewById(R.id.spanWidthHz);
    			mSpanWidthHzBtn.setBackgroundColor(0xFF00FF00);//0xFFFFD36B
		        mCenterFreqHzLbl = (TextView) findViewById(R.id.freqSpanHzLbl);
		        mCenterFreqHzLbl.setBackgroundColor(0xFF00FF00);//0xFFFFD36B
		        g_ParameterSelected_Int = SPAN_WIDTH_SELECT;
    		}else{
    			mSpanWidthHzBtn = (Button) findViewById(R.id.spanWidthHz);
    			mSpanWidthHzBtn.setBackgroundColor(0xFFFFD36B);//0xFFFFD36B
		        mCenterFreqHzLbl = (TextView) findViewById(R.id.freqSpanHzLbl);
		        mCenterFreqHzLbl.setBackgroundColor(0xFFFFD36B);//0xFFFFD36B    			
    		}
    		if(sel == START_FREQ_SELECT){    		
		        mStartFreqHzBtn = (Button) findViewById(R.id.startFreqHz);
		        mStartFreqHzBtn.setBackgroundColor(0xFF00FF00);//0xFFCC9741    			
		        mStartFreqHzLbl = (TextView) findViewById(R.id.startFreqLbl);
		        mStartFreqHzLbl.setBackgroundColor(0xFF00FF00);//0xFFCC9741
		        g_ParameterSelected_Int = START_FREQ_SELECT;
    		}else{
		        mStartFreqHzBtn = (Button) findViewById(R.id.startFreqHz);
		        mStartFreqHzBtn.setBackgroundColor(0xFFCC9741);//0xFFCC9741    			
		        mStartFreqHzLbl = (TextView) findViewById(R.id.startFreqLbl);
		        mStartFreqHzLbl.setBackgroundColor(0xFFCC9741);//0xFFCC9741
    		}
    		if(sel == CENTER_FREQ_SELECT){
    	        mCenterFreqHzBtn = (Button) findViewById(R.id.centerFreqValHz);
		    	mCenterFreqHzBtn.setBackgroundColor(0xFF00FF00);//0xFFFFD36B
		        mCenterFreqHzLbl = (TextView) findViewById(R.id.centerFreqLbl);
		        mCenterFreqHzLbl.setBackgroundColor(0xFF00FF00);//0xFFFFD36B
		        g_ParameterSelected_Int = CENTER_FREQ_SELECT;
    		}else{
    	        mCenterFreqHzBtn = (Button) findViewById(R.id.centerFreqValHz);
		    	mCenterFreqHzBtn.setBackgroundColor(0xFFFFD36B);//0xFFFFD36B
		        mCenterFreqHzLbl = (TextView) findViewById(R.id.centerFreqLbl);
		        mCenterFreqHzLbl.setBackgroundColor(0xFFFFD36B);//0xFFFFD36B    			
    		}
    		if(sel == STOP_FREQ_SELECT){
    			mStopFreqHzBtn = (Button) findViewById(R.id.stopFreqValHz);
    			mStopFreqHzBtn.setBackgroundColor(0xFF00FF00);//0xFFCC9741
    			mStopFreqHzLbl = (TextView) findViewById(R.id.stopFreqHzLbl);
    			mStopFreqHzLbl.setBackgroundColor(0xFF00FF00);//0xFFCC9741
		        g_ParameterSelected_Int = STOP_FREQ_SELECT;
    		}else{
    			mStopFreqHzBtn = (Button) findViewById(R.id.stopFreqValHz);
    			mStopFreqHzBtn.setBackgroundColor(0xFFCC9741);//0xFFFFD36B
    			mStopFreqHzLbl = (TextView) findViewById(R.id.stopFreqHzLbl);
    			mStopFreqHzLbl.setBackgroundColor(0xFFCC9741);//0xFFFFD36B    			
    		}
    		if(sel == SPAN_HZ_DIV_SELECT){ 
    			g_ParameterSelected_Int=NO_SELECTION;
//		        mSpanHzDivBtn = (Button) findViewById(R.id.freqHzDiv);
//		        mSpanHzDivBtn.setBackgroundColor(0xFF00FF00);//0xFFFFD36B    			
//    			mSpanHzDivLbl = (TextView) findViewById(R.id.freqHzPerDivLbl);
//    			mSpanHzDivLbl.setBackgroundColor(0xFF00FF00);//0xFFFFD36B
//		        g_ParameterSelected_Int = SPAN_HZ_DIV_SELECT;
    		}else{
		        mSpanHzDivBtn = (Button) findViewById(R.id.freqHzDiv);
		        mSpanHzDivBtn.setBackgroundColor(0xFFFFD36B);//0xFFFFD36B    			
    			mSpanHzDivLbl = (TextView) findViewById(R.id.freqHzPerDivLbl);
    			mSpanHzDivLbl.setBackgroundColor(0xFFFFD36B);//0xFFFFD36B
    		}
    		if(sel == SWEEP_TIME_SELECT){
    			g_ParameterSelected_Int=NO_SELECTION;
//    			mSweepTimeBtn = (Button) findViewById(R.id.sweepTime_mS);
//    			mSweepTimeBtn.setBackgroundColor(0xFF00FF00);//0xFFCC9741
//    			mSweepTimeLbl = (TextView) findViewById(R.id.sweepTime_mS_Lbl);
//    			mSweepTimeLbl.setBackgroundColor(0xFF00FF00);//0xFFCC9741
//		        g_ParameterSelected_Int = SWEEP_TIME_SELECT;
    		}else{
    			mSweepTimeBtn = (Button) findViewById(R.id.sweepTime_mS);
    			mSweepTimeBtn.setBackgroundColor(0xFFCC9741);//0xFFFFD36B
    			mSweepTimeLbl = (TextView) findViewById(R.id.sweepTime_mS_Lbl);
    			mSweepTimeLbl.setBackgroundColor(0xFFCC9741);//0xFFFFD36B    			
    		}
    		if(sel == SWEEP_STEPS_SELECT){
    			mSweepStepsEdit = (EditText) findViewById(R.id.stepsPerSweep);
    			mSweepStepsEdit.setBackgroundColor(0xFF00FF00);//0xFFCC9741
    			mSweepStepsLbl = (TextView) findViewById(R.id.stepsPerSweepLbl);
    			mSweepStepsLbl.setBackgroundColor(0xFF00FF00);//0xFFCC9741
		        g_ParameterSelected_Int = SWEEP_STEPS_SELECT;
    		}else{
    			mSweepStepsEdit = (EditText) findViewById(R.id.stepsPerSweep);
    			mSweepStepsEdit.setBackgroundColor(0xFFCC9741);//0xFFCC9741
    			mSweepStepsLbl = (TextView) findViewById(R.id.stepsPerSweepLbl);
    			mSweepStepsLbl.setBackgroundColor(0xFFCC9741);//0xFFCC9741  			
    		}
    		if(sel == REF_LEVEL_SELECT){
    			mSweepRefLevelEdit = (EditText) findViewById(R.id.refLevel2dB_Edit);
    			mSweepRefLevelEdit.setBackgroundColor(0xFF00FF00);//0xFFFFD36B
    			mRefLevel_2dB_DivLbl = (TextView) findViewById(R.id.refLevel_2dB_div_Lbl);
    			mRefLevel_2dB_DivLbl.setBackgroundColor(0xFF00FF00);//0xFFFFD36B
    		}else{
    			mSweepRefLevelEdit = (EditText) findViewById(R.id.refLevel2dB_Edit);
    			mSweepRefLevelEdit.setBackgroundColor(0xFFFFD36B);//0xFFFFD36B
    			mRefLevel_2dB_DivLbl = (TextView) findViewById(R.id.refLevel_2dB_div_Lbl);
    			mRefLevel_2dB_DivLbl.setBackgroundColor(0xFFFFD36B);//0xFFFFD36B  			
    		}
    		if(sel == DB_DIV_SELECT){
    			mSelect_dB_DivBtn = (Button) findViewById(R.id.dB_Div_Btn);
    			mSelect_dB_DivBtn.setBackgroundColor(0xFF00FF00);//0xFFFFD36B
    			mSelect_dB_DivLbl = (TextView) findViewById(R.id.select_dB_Div_Lbl);
    			mSelect_dB_DivLbl.setBackgroundColor(0xFF00FF00);//0xFFFFD36B
    		}else{
    			mSelect_dB_DivBtn = (Button) findViewById(R.id.dB_Div_Btn);
    			mSelect_dB_DivBtn.setBackgroundColor(0xFFCC9741);//0xFFCC9741
    			mSelect_dB_DivLbl = (TextView) findViewById(R.id.select_dB_Div_Lbl);
    			mSelect_dB_DivLbl.setBackgroundColor(0xFFCC9741);//0xFFCC9741  			
    		}
    		    		
    		if((sel != SWEEP_STEPS_SELECT)&&(sel != REF_LEVEL_SELECT)){//hide keyboard only for slider control
		        InputMethodManager imm = (InputMethodManager)getSystemService(Context.INPUT_METHOD_SERVICE);
		        imm.hideSoftInputFromWindow(mCenterFreqHzBtn.getWindowToken(), 0);
    		}
    	}

	    // convert int to string and add space delimiters for GUI display
	    private String spaceDelimiter(int freq_Int){
	    	String freqDelimited_Str = String.valueOf(freq_Int);
	        char tempChr[]=freqDelimited_Str.toCharArray();
	        int l=freqDelimited_Str.length();
	        int space1=l-4;
	        int space2=l-7;
	        String tempStr="";
	        for(int i=0;i<l;i++){
	        	tempStr+=String.valueOf(tempChr[i]);
	        	if((i==space1)|(i==space2))tempStr+=' ';
	        }     	
	    	return tempStr;
	    }
    	
        public void setBarStartPositions(int target){
        	switch (target)
        	{
    		case SPAN_WIDTH_SELECT:
    	        g_StartPos_Int=NS3_App.sg_SweepSpanFreqHz; 
    	        g_StartPos10MHz_Flt=g_StartPos_Int;    //you need to give starting position value of SeekBar 
    	        g_NewFreqHz_Flt=g_StartPos10MHz_Flt; 
    	        mAdjFreq10MHz_Bar.setProgress(g_StartPos_Int);
    	        break;
    		case START_FREQ_SELECT:
    	        g_StartPos_Int=NS3_App.sg_SweepStartFreqHz; 
    	        g_StartPos10MHz_Flt=g_StartPos_Int;    //you need to give starting position value of SeekBar 
    	        g_NewFreqHz_Flt=g_StartPos10MHz_Flt; 
    	        mAdjFreq10MHz_Bar.setProgress(g_StartPos_Int);
    	        break;
    		case CENTER_FREQ_SELECT:
    	        g_StartPos_Int=NS3_App.sg_SweepCenterFreqHz; 
    	        g_StartPos10MHz_Flt=g_StartPos_Int;    //you need to give starting position value of SeekBar 
    	        g_NewFreqHz_Flt=g_StartPos10MHz_Flt; 
    	        mAdjFreq10MHz_Bar.setProgress(g_StartPos_Int);
    	        break;
    		case STOP_FREQ_SELECT:
    	        g_StartPos_Int=NS3_App.sg_SweepStopFreqHz; 
    	        g_StartPos10MHz_Flt=g_StartPos_Int;    //you need to give starting position value of SeekBar 
    	        g_NewFreqHz_Flt=g_StartPos10MHz_Flt; 
    	        mAdjFreq10MHz_Bar.setProgress(g_StartPos_Int);
    	        break;
    		case SPAN_HZ_DIV_SELECT:
//    	        g_StartPos_Int=NS3_App.sg_HzPerDiv_Int; 
//    	        g_StartPos10MHz_Flt=g_StartPos_Int;    //you need to give starting position value of SeekBar 
//    	        g_NewFreqHz_Flt=g_StartPos10MHz_Flt; 
//    	        mAdjFreq10MHz_Bar.setProgress(g_StartPos_Int);
    	        break;
    		case SWEEP_TIME_SELECT:
//    	        g_StartPos_Int=NS3_App.sg_SweepTime_mS_Int; 
//    	        g_StartPos10MHz_Flt=g_StartPos_Int;    //you need to give starting position value of SeekBar 
//    	        g_NewFreqHz_Flt=g_StartPos10MHz_Flt; 
//    	        mAdjFreq10MHz_Bar.setProgress(g_StartPos_Int);
    	        break;
    		case SWEEP_STEPS_SELECT:
    	        break;        			
        	}
        	//for all cases center the finer adjust progress bars
        	mAdjFreq1MHz_Bar.setProgress(10000000); 
	        mAdjFreq100KHz_Bar.setProgress(1000000); 
	        mAdjFreq10KHz_Bar.setProgress(100000); 
	        mAdjFreq1KHz_Bar.setProgress(10000); 
	        mAdjFreq100Hz_Bar.setProgress(1000); 
	        mAdjFreq10Hz_Bar.setProgress(100); 
	        mAdjFreq1Hz_Bar.setProgress(10);        	
        }
       
	    @Override
	    public void finish() {
	      // Prepare data intent 
	      Intent newCntrFreqIntent = new Intent();
	      newCntrFreqIntent.putExtra("centerFreq", NS3_App.sg_SweepCenterFreqHz_Str);
	      // Activity finished ok, return the data
	      setResult(RESULT_OK, newCntrFreqIntent);
	      super.finish();
        }
	    // activity methods stop ==============================================================
        								   

	}

