/*
 * Copyright (C) 2013 Thomas M. Alldread
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
	package va7ta.app.nimblesigsweepgen;


	import va7ta.app.nimblesigsweepgen.R;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import android.widget.TextView;


public class SetPhaseB extends Activity{ 

		

	    private static final int NEW_PHASE_B_VALUE = 5;
		private static final String TAG = "NimbleSig.SetPhaseB";
	    private static final boolean D = true;
	    
	    
		private Button mPhaseB_SetButton;
		private float degrees=0; 
		private int degreesInt=0; 
	    private int milliDegrees;
	    private String currentPhaseB="0";
	    private String newPhaseB="0";
	    private String newPhaseB_Value="0";
	    private String newPhaseB_mDeg="0";
	    private float temp=0;
		private float startCrs=-180; 
		private float endCrs=180; 
		private float start_posCrs=0; 
		private int start_positionCrs=0; 
		private float startFine=-180; 
		private float endFine=180; 
		private float start_posFine=0; 
		private int start_positionFine=0; 
		private float lastFineCorrection=0;
		private float fineCorrection=0;
		private boolean fineBarAutoCentre=false;
		private boolean courseBarAutoAdj=false;
		@Override
		public void onCreate(Bundle icicle) {
	    super.onCreate(icicle);
	    	if(D) Log.e(TAG, "+++ SET GEN B PHASE +++");

	        Intent currentValIntent = getIntent();
	        if(currentValIntent.hasExtra("valPhaseB")){
            currentPhaseB = currentValIntent.getStringExtra("valPhaseB");
	        }
	    	// Set up the window layout
	    	setContentView(R.layout.activity_nimble_sig_rfgen_set_phase);
	        TextView phaseBValStr =(TextView) findViewById(R.id.phaseValue);
	        phaseBValStr.setText(currentPhaseB);            
	    	TextView phaseBdjTitle = (TextView) findViewById(R.id.phase_AdjustTitle); 
	    	phaseBdjTitle.setText("VFO 'A' Relative Phase Value - Degrees");   		    	
	        startCrs=-180;      //you need to give starting value of CourseSeekBar 
	        endCrs=180;         //you need to give end value of Course SeekBar 
	        start_posCrs=Float.parseFloat(currentPhaseB);    //you need to give starting position value of SeekBar 
	        start_positionCrs=(int) (start_posCrs); 
	        degrees=start_posCrs; 
	        SeekBar crsPhaseB_Bar=(SeekBar) findViewById(R.id.courseAdjPhase_Bar); 
	        crsPhaseB_Bar.setProgress(start_positionCrs+180); 
	        SeekBar finePhaseB_Bar=(SeekBar) findViewById(R.id.fineAdjPhase_Bar); 
	        finePhaseB_Bar.setProgress(500); 
	        SeekBar extraFinePhaseB_Bar=(SeekBar) findViewById(R.id.extraFineAdjPhase_Bar); 
	        extraFinePhaseB_Bar.setProgress(500);         
	        crsPhaseB_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

	            @Override 
	            public void onStopTrackingTouch(SeekBar seekBar) { 
	                // TODO Auto-generated method stub 
/*
	            	if (degrees >= 0){
	            		milliDegrees *= (int)1000;
	            	}
	            	if (degrees < 0){
	            		milliDegrees = (int)(360-degrees)*1000;
	            	}
	            	
	            	newPhaseB_mDeg = String.valueOf(milliDegrees);
//	            	sendMessage("pa"+newPhaseB_mDeg);
*/
	                lastFineCorrection = 0;
	                SeekBar finePhaseB_Bar=(SeekBar) findViewById(R.id.fineAdjPhase_Bar);
	                finePhaseB_Bar.setProgress(500);
	            } 

	            @Override 
	            public void onStartTrackingTouch(SeekBar seekBar) { 
	                // TODO Auto-generated method stub 

	            } 

	            @Override 
	            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
	                // TODO Auto-generated method stub 
	            	if(!courseBarAutoAdj){
		            	// To convert it as degrees value 
		                float temp=progress; 
		                float dis=endCrs-startCrs; 
		                degrees=temp-180;//(startCrs+((temp/100)*dis)); 
		                newPhaseB = String.valueOf(degrees);
		//                Toast.makeText(getBaseContext(), "degrees = "+newPhaseB, Toast.LENGTH_SHORT).show(); 
		                upDatePhaseBVal(degrees);
	            	}else courseBarAutoAdj=false;
	            } 
	        }); 
	 
	        finePhaseB_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

	            @Override 
	            public void onStopTrackingTouch(SeekBar seekBar) { 
	                // TODO Auto-generated method stub 
	                // To convert it as degrees value 
	                SeekBar crsPhaseB_Bar=(SeekBar) findViewById(R.id.courseAdjPhase_Bar);
	                float deg = degrees;
	                courseBarAutoAdj=true;
	                crsPhaseB_Bar.setProgress((int) (deg+180));
	                fineBarAutoCentre=true;
	                SeekBar finePhaseB_Bar=(SeekBar) findViewById(R.id.fineAdjPhase_Bar);
	                finePhaseB_Bar.setProgress(500);
	                lastFineCorrection = 0;
	                
	            } 

	            @Override 
	            public void onStartTrackingTouch(SeekBar seekBar) { 
	                // TODO Auto-generated method stub 

	            } 

	            @Override 
	            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
	                // TODO Auto-generated method stub 
	            	if(!fineBarAutoCentre){
		                temp=progress;
		                if(temp != 500)fineCorrection=(temp-500)/100;
		                else fineCorrection = 0;
		                degrees += (fineCorrection-lastFineCorrection);            
		                lastFineCorrection = fineCorrection;
		                float test1 = degrees;
		                newPhaseB = String.valueOf(degrees);
		                upDatePhaseBVal(degrees);
	            	}
	                else fineBarAutoCentre = false;
	            } 
	        }); 
	 
	        extraFinePhaseB_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

	            @Override 
	            public void onStopTrackingTouch(SeekBar seekBar) { 
	                // TODO Auto-generated method stub 
	                // To convert it as degrees value 
	                SeekBar crsPhaseB_Bar=(SeekBar) findViewById(R.id.courseAdjPhase_Bar);
	                float deg = degrees;
	                courseBarAutoAdj=true;
	                crsPhaseB_Bar.setProgress((int) (deg+180));
	                fineBarAutoCentre=true;
	                SeekBar finePhaseB_Bar=(SeekBar) findViewById(R.id.extraFineAdjPhase_Bar);
	                finePhaseB_Bar.setProgress(500);
	                lastFineCorrection = 0;
	                
	            } 

	            @Override 
	            public void onStartTrackingTouch(SeekBar seekBar) { 
	                // TODO Auto-generated method stub 

	            } 

	            @Override 
	            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
	                // TODO Auto-generated method stub 
	            	if(!fineBarAutoCentre){
		                temp=progress;
		                if(temp != 500)fineCorrection=(temp-500)/1000;
		                else fineCorrection = 0;
		                degrees += (fineCorrection-lastFineCorrection);            
		                lastFineCorrection = fineCorrection;
		                float test1 = degrees;
		                newPhaseB = String.valueOf(degrees);
		                upDatePhaseBVal(degrees);
	            	}
	                else fineBarAutoCentre = false;
	            } 
	        }); 
	 
	        }//onCreate 
		
		
	    public void upDatePhaseBVal(float val) {
	        TextView phaseB_ValLabel = (TextView) findViewById(R.id.phaseValue);
	        val*=10;
	        val+=.5;
	        degreesInt = (int)(val);
	        float roundedVal = (float)degreesInt/10;
	        phaseB_ValLabel.setText(String.valueOf(roundedVal));
	    }

	    @Override
	    public synchronized void onResume() {
	        super.onResume();
	    	if(D) Log.e(TAG, "+++ ON RESUME +++");
	       

	        //VFO A Phase SET button with a listener that for click events
	        mPhaseB_SetButton = (Button) findViewById(R.id.updatePhaseBtn);
	        mPhaseB_SetButton.setOnClickListener(new OnClickListener() {
	        	public void onClick(View v) {
	                TextView phaseB_Value=(TextView) findViewById(R.id.phaseValue);
	                newPhaseB_Value = phaseB_Value.getText().toString();
	            	Intent newPhaseB_Val=new Intent(getApplicationContext(), NimbleSigSweepGenMain.class);
	            	newPhaseB_Val.putExtra("valPhaseB",newPhaseB_Value);
	        		finish ();
	        	}
	        });
	        
	    }//onResume
	    
	    @Override
	    public void finish() {
	      // Prepare data intent 
	      Intent newPhaseB_ValIntent = new Intent();
	      newPhaseB_ValIntent.putExtra("valPhaseB", newPhaseB_Value);
	      // Activity finished ok, return the data
	      setResult(RESULT_OK, newPhaseB_ValIntent);
	      super.finish();
	    } 
	   
	    @Override
	    public synchronized void onPause() {
	        super.onPause();
//		        if(D) Log.e(TAG, "- ON PAUSE -");
	    }

	    @Override
	    public void onStop() {
	        super.onStop();
//		        if(D) Log.e(TAG, "-- ON STOP --");
	    }

	    @Override
	    public void onDestroy() {
	        super.onDestroy();
//		        if(D) Log.e(TAG, "--- ON DESTROY ---");
	    }


	}
