/*
 * Copyright (C) 2013 Thomas M. Alldread
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package va7ta.app.nimblesigsweepgen;


import va7ta.app.nimblesigsweepgen.R;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import android.widget.TextView;

public class SetPhaseA extends Activity { 
	

    private static final int NEW_PHASE_A_VALUE = 4;
	private static final String TAG = "NimbleSig.SetPhaseA";
    private static final boolean D = true;
    
    
	private Button mPhaseA_SetButton;
	private float degrees=0; 
	private int degreesInt=0; 
    private int milliDegrees;
    private String currentPhaseA="0";
    private String newPhaseA="0";
    private String newPhaseA_Value="0";
    private String newPhaseA_mDeg="0";
    private float temp=0;
	private float startCrs=-180; 
	private float endCrs=180; 
	private float start_posCrs=0; 
	private int start_positionCrs=0; 
	private float startFine=-180; 
	private float endFine=180; 
	private float start_posFine=0; 
	private int start_positionFine=0; 
	private float lastFineCorrection=0;
	private float fineCorrection=0;
	private boolean fineBarAutoCentre=false;
	private boolean courseBarAutoAdj=false;
	@Override
	public void onCreate(Bundle icicle) {
    super.onCreate(icicle);
    	if(D) Log.e(TAG, "+++ SET GEN A PHASE +++");

        Intent currentValIntent = getIntent();
        if(currentValIntent.hasExtra("valPhaseA")){
//            currentPhaseA = currentValIntent.getExtras().toString();//"-45.5";//
            currentPhaseA = currentValIntent.getStringExtra("valPhaseA");
        }
    	// Set up the window layout
    	setContentView(R.layout.activity_nimble_sig_rfgen_set_phase);
        TextView phaseAValStr =(TextView) findViewById(R.id.phaseValue);
        phaseAValStr.setText(currentPhaseA);            
    	TextView phaseAdjTitle = (TextView) findViewById(R.id.phase_AdjustTitle); 
    	phaseAdjTitle.setText("VFO 'A' Relative Phase Value - Degrees");
    	
    	
        startCrs=-180;      //you need to give starting value of CourseSeekBar 
        endCrs=180;         //you need to give end value of Course SeekBar 
//        start_posCrs=0;    //you need to give starting position value of SeekBar 
        start_posCrs=Float.parseFloat(currentPhaseA);    //you need to give starting position value of SeekBar 
        start_positionCrs=(int) (start_posCrs); 
        degrees=start_posCrs; 
        SeekBar crsPhaseA_Bar=(SeekBar) findViewById(R.id.courseAdjPhase_Bar); 
        crsPhaseA_Bar.setProgress(start_positionCrs+180); 
        SeekBar finePhaseA_Bar=(SeekBar) findViewById(R.id.fineAdjPhase_Bar); 
        finePhaseA_Bar.setProgress(500); 
        SeekBar extraFinePhaseA_Bar=(SeekBar) findViewById(R.id.extraFineAdjPhase_Bar); 
        extraFinePhaseA_Bar.setProgress(500); 

        
        crsPhaseA_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

            @Override 
            public void onStopTrackingTouch(SeekBar seekBar) { 
                // TODO Auto-generated method stub 
/*
            	if (degrees >= 0){
            		milliDegrees *= (int)1000;
            	}
            	if (degrees < 0){
            		milliDegrees = (int)(360-degrees)*1000;
            	}
            	
                newPhaseA_mDeg = String.valueOf(milliDegrees);
//            	sendMessage("pa"+newPhaseA_mDeg);
*/
            	lastFineCorrection = 0;
                SeekBar finePhaseA_Bar=(SeekBar) findViewById(R.id.fineAdjPhase_Bar);
                finePhaseA_Bar.setProgress(500);
            } 

            @Override 
            public void onStartTrackingTouch(SeekBar seekBar) { 
                // TODO Auto-generated method stub 

            } 

            @Override 
            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
                // TODO Auto-generated method stub 
            	if(!courseBarAutoAdj){
	            	// To convert it as degrees value 
	                float temp=progress; 
	                float dis=endCrs-startCrs; 
	                degrees=temp-180;//(startCrs+((temp/100)*dis)); 
	                newPhaseA = String.valueOf(degrees);
	//                Toast.makeText(getBaseContext(), "degrees = "+newPhaseA, Toast.LENGTH_SHORT).show(); 
	                upDatePhaseAVal(degrees);
            	}else courseBarAutoAdj=false;
            } 
        }); 
 
        finePhaseA_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

            @Override 
            public void onStopTrackingTouch(SeekBar seekBar) { 
                // TODO Auto-generated method stub 
                // To convert it as degrees value 
                SeekBar crsPhaseA_Bar=(SeekBar) findViewById(R.id.courseAdjPhase_Bar);
                float deg = degrees;
                courseBarAutoAdj=true;
                crsPhaseA_Bar.setProgress((int) (deg+180));
                fineBarAutoCentre=true;
                SeekBar finePhaseA_Bar=(SeekBar) findViewById(R.id.fineAdjPhase_Bar);
                finePhaseA_Bar.setProgress(500);
                lastFineCorrection = 0;
                
            } 

            @Override 
            public void onStartTrackingTouch(SeekBar seekBar) { 
                // TODO Auto-generated method stub 

            } 

            @Override 
            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
                // TODO Auto-generated method stub 
            	if(!fineBarAutoCentre){
	                temp=progress;
	                if(temp != 500)fineCorrection=(temp-500)/100;
	                else fineCorrection = 0;
	                degrees += (fineCorrection-lastFineCorrection);            
	                lastFineCorrection = fineCorrection;
	                float test1 = degrees;
	                newPhaseA = String.valueOf(degrees);
	                upDatePhaseAVal(degrees);
            	}
                else fineBarAutoCentre = false;
            } 
        }); 
 
        extraFinePhaseA_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

            @Override 
            public void onStopTrackingTouch(SeekBar seekBar) { 
                // TODO Auto-generated method stub 
                // To convert it as degrees value 
                SeekBar crsPhaseA_Bar=(SeekBar) findViewById(R.id.courseAdjPhase_Bar);
                float deg = degrees;
                courseBarAutoAdj=true;
                crsPhaseA_Bar.setProgress((int) (deg+180));
                fineBarAutoCentre=true;
                SeekBar extraFinePhaseA_Bar=(SeekBar) findViewById(R.id.extraFineAdjPhase_Bar);
                extraFinePhaseA_Bar.setProgress(500);
                lastFineCorrection = 0;
                
            } 

            @Override 
            public void onStartTrackingTouch(SeekBar seekBar) { 
                // TODO Auto-generated method stub 

            } 

            @Override 
            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
                // TODO Auto-generated method stub 
            	if(!fineBarAutoCentre){
	                temp=progress;
	                if(temp != 500)fineCorrection=(temp-500)/1000;
	                else fineCorrection = 0;
	                degrees += (fineCorrection-lastFineCorrection);            
	                lastFineCorrection = fineCorrection;
	                float test1 = degrees;
	                newPhaseA = String.valueOf(degrees);
	                upDatePhaseAVal(degrees);
            	}
                else fineBarAutoCentre = false;
            } 
        }); 
 
    }//onCreate 
	
	
    public void upDatePhaseAVal(float val) {
        TextView phaseA_ValLabel = (TextView) findViewById(R.id.phaseValue);
        val*=10;
        val+=.5;
        degreesInt = (int)(val);
        float roundedVal = (float)degreesInt/10;
        phaseA_ValLabel.setText(String.valueOf(roundedVal));
    }

    @Override
    public synchronized void onResume() {
        super.onResume();
    	if(D) Log.e(TAG, "+++ ON RESUME +++");
       

        //VFO A Phase SET button with a listener that for click events
        mPhaseA_SetButton = (Button) findViewById(R.id.updatePhaseBtn);
        mPhaseA_SetButton.setOnClickListener(new OnClickListener() {
        	public void onClick(View v) {
                TextView phaseA_Value=(TextView) findViewById(R.id.phaseValue);
                newPhaseA_Value = phaseA_Value.getText().toString();
            	Intent newPhaseA_Val=new Intent(getApplicationContext(), NimbleSigSweepGenMain.class);
            	newPhaseA_Val.putExtra("valPhaseA",newPhaseA_Value);
        		finish ();
        	}
        });
        
    }//onResume
    
    @Override
    public void finish() {
      // Prepare data intent 
      Intent newPhaseA_ValIntent = new Intent();
      newPhaseA_ValIntent.putExtra("valPhaseA", newPhaseA_Value);
      // Activity finished ok, return the data
      setResult(RESULT_OK, newPhaseA_ValIntent);
      super.finish();
    } 
   
    @Override
    public synchronized void onPause() {
        super.onPause();
//	        if(D) Log.e(TAG, "- ON PAUSE -");
    }

    @Override
    public void onStop() {
        super.onStop();
//	        if(D) Log.e(TAG, "-- ON STOP --");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
//	        if(D) Log.e(TAG, "--- ON DESTROY ---");
    }


}
