/*
 * Copyright (C) 2013 Thomas M. Alldread
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package va7ta.app.nimblesigsweepgen;

import va7ta.app.nimblesigsweepgen.R;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import android.widget.TextView;

public class SetLevelB extends Activity {

	private static final String TAG = "NimbleSig.SetLevelB";//ID for debug progress error message
    private static final boolean D = true;
    
    
    private String currentLevelB="0";
    private String newLevelB="0";
    private String newLevelB_Value="0";
    private String newLevelB_mDeg="0";
    
	private Button mLevelB_SetButton;
	private SeekBar mCourseAdjSeekBar;
	private SeekBar mFineAdjSeekBar;
	
	private int start_positionCrs=0; 
	private int dBmInt=0; 
    private int millidBm;
	private int start_positionFine=0; 

	private float dBm=0; 
    private float temp=0;
	private float startCrs=0; 
	private float endCrs=0; 
	private float start_posCrs=0; 
	private float startFine=0; 
	private float endFine=0; 
	private float start_posFine=0; 
	private float lastFineCorrection=0;
	private float fineCorrection=0;

	private boolean fineBarAutoCentre=false;
	private boolean courseBarAutoAdj=false;
	
	private byte amModStatusByte;

	
	
	@Override
	public void onCreate(Bundle icicle) {
    super.onCreate(icicle);
    	if(D) Log.e(TAG, "+++ SET GEN B OUTPUT LEVEL +++");

        Intent currentValIntent = getIntent();
        if(currentValIntent.hasExtra("valLevelB")){
            currentLevelB = currentValIntent.getStringExtra("valLevelB");
        }
        if(currentValIntent.hasExtra("statusAM_ModGenB")){
        	amModStatusByte = currentValIntent.getByteExtra("statusAM_ModGenB",(byte)0);
        }
    	setContentView(R.layout.activity_nimble_sig_rfgen_set_level);// Paint the adjust screen

        TextView levelBValStr =(TextView) findViewById(R.id.newValue);
        levelBValStr.setText(currentLevelB);            
    	TextView levelBdjTitle = (TextView) findViewById(R.id.parameterAdjustTitle); 
    	levelBdjTitle.setText("VFO 'B' Output Level - dBm");
    	
    	
    	//Course SeekBar range is 0-100 units
    	//Initialize Bar settings
        dBm=(Float.valueOf(currentLevelB)); 
        float centiBm=10*dBm; //convert to centiBm units
        if(amModStatusByte ==0) start_posCrs =-(-200-centiBm);
        else start_posCrs =-(-260-centiBm);	    	        
        start_positionCrs=(int) (start_posCrs); 
        mCourseAdjSeekBar=(SeekBar) findViewById(R.id.courseAdj_Bar); 
        mCourseAdjSeekBar.setProgress(start_positionCrs); 
        mFineAdjSeekBar=(SeekBar) findViewById(R.id.fineAdj_Bar); 
        mFineAdjSeekBar.setProgress(5); 

        
        mCourseAdjSeekBar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

            @Override 
            public void onStopTrackingTouch(SeekBar seekBar) { 
                // TODO Auto-generated method stub 
/*
            	if (dBm >= 0){
            		millidBm *= (int)1000;
            	}
            	if (dBm < 0){
            		millidBm = (int)(360-dBm)*1000;
            	}
            	
                newLevelB_mDeg = String.valueOf(millidBm);
//            	sendMessage("pa"+newLevelB_mDeg);
*/
            	lastFineCorrection = 0;
                mFineAdjSeekBar.setProgress(5);
            } 

            @Override 
            public void onStartTrackingTouch(SeekBar seekBar) { 
                // TODO Auto-generated method stub 

            } 

            @Override 
            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
                // TODO Auto-generated method stub 
            	if(!courseBarAutoAdj){
	            	// To convert it as dBm value 
	                float temp=progress; //0.0 to 100 scale for -20.0 to -10.0 dBm range
	                if(amModStatusByte ==0) dBm=(float)(temp-200)/10;
	                else dBm=(float)(temp-260)/10;
	                newLevelB = String.valueOf(dBm);
	                upDateLevelBVal(dBm);
            	}else courseBarAutoAdj=false;
            } 
        });         
 
        mFineAdjSeekBar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

            @Override 
            public void onStopTrackingTouch(SeekBar seekBar) { 
                // TODO Auto-generated method stub 
                // To convert it as dBm value 
                float deg = dBm;
                courseBarAutoAdj=true;
                float centiBm = 10*dBm;
                if(amModStatusByte ==0) start_posCrs =-(-200-centiBm);
                else start_posCrs =-(-260-centiBm);	    	        
    	        start_positionCrs=(int) (start_posCrs);	                
                mCourseAdjSeekBar.setProgress(start_positionCrs);
                fineBarAutoCentre=true;
                mFineAdjSeekBar.setProgress(5);
                lastFineCorrection = 0;	                
            } 

            @Override 
            public void onStartTrackingTouch(SeekBar seekBar) { 
                // TODO Auto-generated method stub 

            } 

            @Override 
            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
                // TODO Auto-generated method stub 
            	if(!fineBarAutoCentre){
	                temp=progress;
	                fineCorrection=(temp-5);		                
	                fineCorrection/=10;		                
	                dBm += (fineCorrection-lastFineCorrection);            
	                lastFineCorrection = fineCorrection;
	                float test1 = dBm;
	                newLevelB = String.valueOf(dBm);
	                upDateLevelBVal(dBm);
            	}
                else fineBarAutoCentre = false;
            } 
        }); 
 
    }//onCreate 
	
	
    public void upDateLevelBVal(float val) {
        TextView LevelB_ValLabel = (TextView) findViewById(R.id.newValue);
        val*=10;
        val+=.5;
        dBmInt = (int)(val);
        float roundedVal = (float)dBmInt/10;
        LevelB_ValLabel.setText(String.valueOf(roundedVal));
    }

    @Override
    public synchronized void onResume() {
        super.onResume();
    	if(D) Log.e(TAG, "+++ ON RESUME +++");
       

        //VFO A Level SET button with a listener that for click events
        mLevelB_SetButton = (Button) findViewById(R.id.updateLevelBtn);
        mLevelB_SetButton.setOnClickListener(new OnClickListener() {
        	public void onClick(View v) {
                TextView LevelB_Value=(TextView) findViewById(R.id.newValue);
                newLevelB_Value = LevelB_Value.getText().toString();
            	Intent newLevelB_Val=new Intent(getApplicationContext(), NimbleSigSweepGenMain.class);
            	newLevelB_Val.putExtra("valLevelB",newLevelB_Value);
        		finish ();
        	}
        });
        
    }//onResume
    
    @Override
    public void finish() {
      // Prepare data intent 
      Intent newLevelB_ValIntent = new Intent();
      newLevelB_ValIntent.putExtra("valLevelB", newLevelB_Value);
      // Activity finished ok, return the data
      setResult(RESULT_OK, newLevelB_ValIntent);
      super.finish();
    } 
   
    @Override
    public synchronized void onPause() {
        super.onPause();
//	        if(D) Log.e(TAG, "- ON PAUSE -");
    }

    @Override
    public void onStop() {
        super.onStop();
//	        if(D) Log.e(TAG, "-- ON STOP --");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
//	        if(D) Log.e(TAG, "--- ON DESTROY ---");
    }


}

