/*
 * Copyright (C) 2013 Thomas M. Alldread
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package va7ta.app.nimblesigsweepgen;

import va7ta.app.nimblesigsweepgen.R;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import android.widget.TextView;


public class SetGen_A_AM_ModIndex extends Activity{


			private static final String TAG = "NimbleSig.SetAM_modIndexA";//ID for debug progress error message
		    private static final boolean D = true;
		    
		    
		    private String currentModAMIdxA_Str="0";
		    private String newModAMIdxA="0";
		    private String newModAMIdxA_Value="0";
		    private String newModAMIdxA_mDeg="0";
		    
			private Button mModAMIdxA_SetButton;
			private SeekBar mCourseAdjSeekBar;
			private SeekBar mFineAdjSeekBar;
			private SeekBar mExtraFineAdjSeekBar;
			
			private int start_positionCrs=0; 
			private int amModIdxInt=0; 
		    private int milliamModIdx;
			private int start_positionFine=0; 
			private int amModIdx=0; 
			
		    private float temp=0;
			private float startCrs=0; 
			private float endCrs=0; 
			private float start_posCrs=0; 
			private float startFine=0; 
			private float endFine=0; 
			private float start_posFine=0; 
			private float lastFineCorrection=0;
			private float fineCorrection=0;

			private boolean fineBarAutoCentre=false;
			private boolean courseBarAutoAdj=false;
			
			
			@Override
			public void onCreate(Bundle icicle) {
		    super.onCreate(icicle);
		    	if(D) Log.e(TAG, "+++ SET GEN A AM MOD INDEX +++");

		        Intent currentValIntent = getIntent();
		        if(currentValIntent.hasExtra("valAM_ModIdxA")){
		            currentModAMIdxA_Str = currentValIntent.getStringExtra("valAM_ModIdxA");
		        }
		    	setContentView(R.layout.activity_nimble_sig_rfgen_set_am_mod_index);// Paint the adjust screen

		        TextView modAMIdxAValStr =(TextView) findViewById(R.id.newValue);
		        modAMIdxAValStr.setText(currentModAMIdxA_Str);            
		    	TextView modAMIdxAdjTitle = (TextView) findViewById(R.id.parameterAdjustTitle); 
		    	modAMIdxAdjTitle.setText("VFO 'A' AM Mod Index - %");
		    	
		    	//Course SeekBar range is 0-100 units
		    	//Initialize Bar settings
		        amModIdx=(Integer.valueOf(currentModAMIdxA_Str)); 
		        start_posCrs =amModIdx;
		        start_positionCrs=(int) (start_posCrs); 
		        mCourseAdjSeekBar=(SeekBar) findViewById(R.id.courseAdj_Bar); 
		        mCourseAdjSeekBar.setProgress(start_positionCrs); 
		        mFineAdjSeekBar=(SeekBar) findViewById(R.id.fineAdj_Bar); 
		        mFineAdjSeekBar.setProgress(5); 

		        
		        mCourseAdjSeekBar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

		            @Override 
		            public void onStopTrackingTouch(SeekBar seekBar) { 
		                // TODO Auto-generated method stub 
		/*
		            	if (amModIdx >= 0){
		            		milliamModIdx *= (int)1000;
		            	}
		            	if (amModIdx < 0){
		            		milliamModIdx = (int)(360-amModIdx)*1000;
		            	}
		            	
		                newModAMIdxA_mDeg = String.valueOf(milliamModIdx);
//		            	sendMessage("pa"+newModAMIdxA_mDeg);
		*/
		            	lastFineCorrection = 0;
		                mFineAdjSeekBar.setProgress(5);
		            } 

		            @Override 
		            public void onStartTrackingTouch(SeekBar seekBar) { 
		                // TODO Auto-generated method stub 

		            } 

		            @Override 
		            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
		                // TODO Auto-generated method stub 
		            	if(!courseBarAutoAdj){
			            	// To convert it as amModIdx value 
		            		amModIdx=progress;
			                newModAMIdxA = String.valueOf(progress);			           
			                upDateModAMIdxAVal(progress);
		            	}else courseBarAutoAdj=false;
		            } 
		        }); 
		 
		        mFineAdjSeekBar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

		            @Override 
		            public void onStopTrackingTouch(SeekBar seekBar) { 
		                // TODO Auto-generated method stub 
		                // To convert it as amModIdx value 
		                courseBarAutoAdj=true;
		    	        start_posCrs =amModIdx;
		    	        start_positionCrs=(int) (start_posCrs);	                
		                mCourseAdjSeekBar.setProgress(start_positionCrs);
		                fineBarAutoCentre=true;
		                mFineAdjSeekBar.setProgress(5);
		                lastFineCorrection = 0;	                
		            } 

		            @Override 
		            public void onStartTrackingTouch(SeekBar seekBar) { 
		                // TODO Auto-generated method stub 

		            } 

		            @Override 
		            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
		                // TODO Auto-generated method stub 
		            	if(!fineBarAutoCentre){
			                fineCorrection=(progress-5);		                
			                amModIdx += (fineCorrection-lastFineCorrection);            
			                lastFineCorrection = fineCorrection;
			                newModAMIdxA = String.valueOf(amModIdx);
			                upDateModAMIdxAVal(amModIdx);
		            	}
		                else fineBarAutoCentre = false;
		            } 
		        }); 
		 
		    }//onCreate 
			
			
		    public void upDateModAMIdxAVal(int val) {
		        TextView ModAMIdxA_ValLabel = (TextView) findViewById(R.id.newValue);
		        ModAMIdxA_ValLabel.setText(String.valueOf(val));
		    }

		    @Override
		    public synchronized void onResume() {
		        super.onResume();
		    	if(D) Log.e(TAG, "+++ ON RESUME +++");
		       

		        //VFO A Level SET button with a listener that for click events
//		        mModAMIdxA_SetButton = (Button) findViewById(R.id.updateLevelBtn);
		        mModAMIdxA_SetButton = (Button) findViewById(R.id.updateModIndexBtn);
		        mModAMIdxA_SetButton.setOnClickListener(new OnClickListener() {
		        	public void onClick(View v) {
		                TextView ModAMIdxA_Value=(TextView) findViewById(R.id.newValue);
		                newModAMIdxA_Value = ModAMIdxA_Value.getText().toString();
		            	Intent newModAMIdxA_Val=new Intent(getApplicationContext(), NimbleSigSweepGenMain.class);
		            	newModAMIdxA_Val.putExtra("valModAMIdxA",newModAMIdxA_Value);
		        		finish ();
		        	}
		        });
		        
		    }//onResume
		    
		    @Override
		    public void finish() {
		      // Prepare data intent 
		      Intent newModAMIdxA_ValIntent = new Intent();
		      newModAMIdxA_ValIntent.putExtra("valModAMIdxA", newModAMIdxA_Value);
		      // Activity finished ok, return the data
		      setResult(RESULT_OK, newModAMIdxA_ValIntent);
		      super.finish();
		    } 
		   
		    @Override
		    public synchronized void onPause() {
		        super.onPause();
//			        if(D) Log.e(TAG, "- ON PAUSE -");
		    }

		    @Override
		    public void onStop() {
		        super.onStop();
//			        if(D) Log.e(TAG, "-- ON STOP --");
		    }

		    @Override
		    public void onDestroy() {
		        super.onDestroy();
//			        if(D) Log.e(TAG, "--- ON DESTROY ---");
		    }


		}
