/* 
	af.h
	Common definitions for afrecv.c and afxmit.c
	version: 0.3 3/9/2013
	Copyright (c) 2012 Martin S Ewing

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Contact author: ewing@alum.mit.edu, 
		28 Wood Rd, Branford, CT, USA 06405
	
	Changelog:
	3/2013 Changes for gcc -std=c99
 */

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif

#ifdef WIN32
// Windows-specific defs.
#include <windows.h>
#include <xaudio2.h>
#include <string>
#include <WinSock2.h>
#include <ws2tcpip.h>
#include "speex/speex.h"

#define snprintf _snprintf_s
#define close closesocket
#define sleep(x) Sleep((x)*1000)
#define XA2_MAX_BUFF_CT 3	// must be at least 3?
#define WAIT_MAX 2000L		// 2 sec. (why? what to do if timeout occurs?)
//--------------------------------------------------------------------------------------
// Helper macros
//--------------------------------------------------------------------------------------
#ifndef SAFE_DELETE_ARRAY
#define SAFE_DELETE_ARRAY(p) { if(p) { delete[] (p);   (p)=NULL; } }
#endif
#ifndef SAFE_RELEASE
#define SAFE_RELEASE(p)      { if(p) { (p)->Release(); (p)=NULL; } }
#endif

#else
// Linux-specific defs.
#include "portaudio.h"
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <speex/speex.h>
#include <sys/timeb.h>
#include <fcntl.h>
#include <errno.h>
#include <getopt.h>
#define TRUE	(1)
#define FALSE	(0)
#endif
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <assert.h>

// enumerate codecs
#define	CODEC_NULL		(0)
#define	CODEC_SPEEX		(1)

#define PORT_DEFAULT	(14694)
#define SAMPLE_RATE		(8000)
#define NUM_CHANNELS	(1)
#define CODEC_NULL_CHUNK 256
#define SAMPLE_WIDTH	2	// == paInt16?

/* Select sample format. */
#define PA_SAMPLE_TYPE  paInt16
typedef short SAMPLE;
#define SAMPLE_SILENCE  (0)
#define PRINTF_S_FORMAT "%d"

/* server commands */
#define L_CMD		(64)	// commands have fixed len (w params)
#define L_CMD_OP	(5)		// all ops = 5 chars
#define	CMD_CODEC	"CODEC"	// Choose codec, set parameters
#define CMD_START	"START"
#define CMD_STOP	"STOP "
#define CMD_QUIT	"QUIT "
#define NET_BUF_SIZE	(8000)	// oversize, handy for UDP
#define NET_TEST_SIZE	(1000)
#define RETRY_UDP   (3)         // how many udp reads to try if first one is ng.
#define RETRY_LIMIT	(5)	//max missing packets in input stream before abort ??

/* Utilities for afdump diagnostic */
void	hexdump(char *s, int n) 
{
	unsigned char *su;
	su = (unsigned char *)s;
	int n8 = n/8;
	printf("n=%d\n", 8*n8); // always multiple of 8 b.
	for(int j=0; j<n8; j++)
	{
		for(int i=0; i<8; i++) printf("%02x ", *(su++));
		printf("\n");
	}
	return;
}

void	stars(int v, int vmax, int width, char * starstring)
{
	char s1 = '*';
	int nstar = (v *width) / vmax;
	memset(starstring, s1, nstar);
	starstring[nstar] = '\0';
	return;
}

// Pause in console window.  Useful to keep window open at program end.
// Not "pause", but "apause" to avoid conflict (Linux)
void apause() {
	printf("Program ending, sleeping...\n");
	sleep (5);	// 5 sec
}

/* Common error print / quit */
void perr(const char *msg)
{
	perror(msg);
	exit(EXIT_FAILURE);
}

// Debugging only:
// Load a buffer with a freq. ramp, continuous in phase with next buffer.
short int *fill_buffer(short int *pBuffer, int lBuffer)
{
    static double test_phase = 0.0, freq_offset = 0.0;
	const double phase_inc = 0.1, test_rate = 8.0e-7;
	static int sample_count = 0;
	short int *pB , *pAns;
	pB = pAns = pBuffer;
	for(int i=0; i<lBuffer; i++)
	{
		*(pB++) = 10000 * cos(test_phase + sample_count*freq_offset);
		test_phase += phase_inc;	// test_phase should be continuous across sound buffers.
		sample_count++;
		freq_offset += test_rate;
	}
	return pAns;
}
