CLS
PRINT "       Program PREDFREQ.BAS takes the 4 bytes sent to the AD9650 board"
PRINT "       and reconverts them to the delta phase (Tuning Word) value and to"
PRINT "       the output frequency the DDS would produce from those 4 bytes."
PRINT "       Note - As Phase control is not impremented in DDS.BAS, the 4th"
PRINT "       i.e. most significant byte is always 0 and is not a input to"
PRINT "       this program. Only the decimal values of bytes 3, 2, 1, and 0"
PRINT "       are entered into this program."
PRINT
PRINT "       Use of this program is to compare the predicted frequency displayed"
PRINT "       by the DDS control program to the predicted frequency obtained"
PRINT "       by entering the bytes sent to \ received from the DDS into this program."
PRINT "       The two predicted frequencies should be exactly the same if"
PRINT "       the DDS control program is operating correctly. The program"
PRINT "       also computes and displays the 1/0 status of each bit in the"
PRINT "       32 bit tuning word."
PRINT
PRINT "       Type F1 and Enter to exit program gracefully"
PRINT

PRINT "       Type enter to start program ";
       
        INPUT y$

'       program assumes a 100 MHz clock to the DDS.
'
'       Define Variables and Arrays.
'
'       Integers
'
'       N% used as inex in various loops
'       A% used to increment input data counter
'       w%(4) input byte array
'
'       Double precison floating point variables
'
'       dph# - delta phase word value
'       fout# - dds output frequency
'       clk# - dds clock frequency set to 100.00000000000 MHz
'       binv# - binary value of powers of 2 computed on the fly
'
'       Dimension arrays
'
        DIM w%(4)
'
'       set up the exit funtion as F1 key
'
        ON KEY(1) GOSUB done
        KEY(1) ON
'
        clk# = 100000000#  'set up dds clock frequency
'
start:  CLS
'
'       query for input decimal value of bytes sent to dds board
'
        FOR a% = 3 TO zero STEP -1
        PRINT
tryagn: PRINT "Enter decimal value (0-255) for byte "; a%; "here ";
        INPUT w%(a%)
        IF w%(a%) < 0 THEN GOTO oops
        IF w%(a%) > 255 THEN GOTO oops
        GOTO ok
oops:   PRINT
        PRINT "Number must be between 0 and 255"
        PRINT
        GOTO tryagn

ok:     NEXT a%
'
'       start computation loop here
        CLS
        PRINT
        PRINT "Byte"; TAB(8); "Bit"; TAB(12); " N "; TAB(25); "2^N";
        PRINT TAB(33); "Bit Set"; TAB(45); "Add to Total ="; TAB(65); "Sum"
        PRINT
        dph# = 0        'reset total to zero
'
        FOR a% = 3 TO 0 STEP -1
'
'       set remaindier to value of w%(a%)  for each loop
        r# = w%(a%)
'
        FOR b% = 7 TO 0 STEP -1
        p2# = (a% * 8) + b%
        bval# = 2 ^ p2#      'Test value of decimal bytes and convert to power of 2
'
        Bit% = 0
        pwr2# = 0
        IF r# >= (2 ^ b%) THEN pwr2# = bval#
        IF r# >= (2 ^ b%) THEN r# = r# - (2 ^ b%)
        IF pwr2# > 0 THEN Bit% = 1
        dph# = dph# + pwr2#
'
        PRINT a%; TAB(8); b%; TAB(12); p2#; TAB(20); bval#;
        PRINT TAB(35); Bit%; TAB(45); pwr2#; TAB(60); dph#
'
        NEXT b%
        NEXT a%
       
'        PRINT "Type return to display the results ";
'        INPUT s$
'
'       Now we have the delta phase word (dph#)as a decimal number. From
'       the dds frequency is computed.
'
        fout# = (dph# * clk#) / 2 ^ 32

        PRINT
        PRINT "Resurected Delta Phase (Tuning Word) Value is "; TAB(60);
        PRINT USING "#############,.#"; dph#
        PRINT
        PRINT "Calculated DDS Output Frequency is"; TAB(60);
        PRINT USING "#########,.####"; fout#
        PRINT
        PRINT "Type enter to run again, or F1 & Enter to exit";
        INPUT s$
        GOTO start
'
done:   STOP

        END

