CLS
PRINT
PRINT "       Program DDS.BAS is used to program the AD9850 FMTDDS"
PRINT "       Synthesizer to any frequency (10Hz - 40MHz) under computer control."
PRINT
PRINT "       Last Revised 19 Jan 2012 - John C. Roos; K6IQL"
PRINT
PRINT "       The program input is in terms of the Synthesizer Output Frequency"
PRINT "       expressed in Hz and an Offset Frequency(Hz). The Offset Frequency is"
PRINT "       used to increment or decrement the requested frequency using "
PRINT "       the function keys as explained below."
PRINT
PRINT "       Output from the program is a series of 5 bytes from the COM1 port of"
PRINT "       a PC at 9600 bits per second. The data structure may be gleaned from"
PRINT "       the AD9850 specification. It consists of 40 bits sent as 5 bytes."
PRINT "       The first byte is a phase control and test control byte. In this"
PRINT "       program the first byte will always be all 0s as no phase control is"
PRINT "       implemented. The remaining 4 bytes (words as AD calls them in the spec)"
PRINT "       comprise the 32 bit frequency control word consisting of 8 bits each."
PRINT
PRINT "       Type Enter to continue with instructions ";
	INPUT Y$
	CLS
	PRINT

PRINT "       When each byte is transmitted to the synthesizer from this program,"
PRINT "       the program awaits a response byte from the synthesizer which echoes"
PRINT "       back the same byte as sent. This provides flow control and a check on"
PRINT "       the accuracy of the data transmission path.  To display the actual"
PRINT "       frequency output which is different due to round off error the"
PRINT "       program runs the frequency control calculation in reverse and "
PRINT "       calculates the expected frequency output from the DDS. Due to"
PRINT "       roundoff error this will be slightly different from the requested"
PRINT "       frequency. In the internal calculation of the delta phase integer"
PRINT "       (i.e. the Tuning Word Tint)"
PRINT "       0.5 is added to the floating point delta phase value before"
PRINT "       conversion to integer. This makes the round off errors symmetrical"
PRINT "       about the requested frequency and halves the absolute value"
PRINT "       of the peak frequency error."
PRINT "       Both the requested and actual output frequencies as well as the"
PRINT "       frequency error in milli-Hertz are displayed."
PRINT
PRINT "       The program will write the current DDS frequency and system time"
PRINT "       to C:\freqdata\ddsfreq.txt by pushing F4. If this file does not exist"
PRINT "       the program will create both the file and the directory. If the"
PRINT "       file exists - then the latest data is simply appended to it. Thus"
PRINT "       it is not required to create the directory or the file, or to delete"
PRINT "       an old version of the file to capture the data. Also it will print the"
PRINT "       current DDS frequency and System time to LPT1 by pressing F5"
PRINT
PRINT "                          J. C. Roos, K6IQL, 19 Jan 2012"
'
PRINT
	PRINT "Type Enter to Start Progam";
	INPUT E$
	CLEAR           'ensure open ports closed
	

'
'               PROGRAM STARTS HERE...

'       Note - frequency determining math must be double precision
'
	count = 0   'initialze disk write safety counter see file
'                    write routine at "file:" label.
'
	DIM DELPH#(40), binv#(40), bit%(40)     'SET UP ARRAYS
'
'       CREATE ALL POWERS OF 2^0 TO 2^31 AND LOAD INTO BINV#
	FOR N% = 0 TO 31
	binv#(N%) = 2 ^ N%
'       PRINT BINV#(N%)
	NEXT N%
'
'       Assign DDS clock frequency to 100 MHz
	osc# = 100000000#
'       PRINT osc#
'
'       EVENT TRAPPING SETUP SECTION
'---------------------------
	KEY(1) ON  'stop program
	KEY(2) ON  'go sub 3000 and query for new inputs
	KEY(9) ON  'step up offset/10
	KEY(10) ON 'step up by offset
	KEY(8) ON  'step down by offset/10
	KEY(7) ON  'step down by offset
	KEY(4) ON  'Write present Frequency to File C;\freqdata\ddsfreq.txt
	KEY(5) ON  'Print present frequency to LPT1:
'
	ON KEY(1) GOSUB 1000    'stop
	ON KEY(2) GOSUB 3000    'stop loop and ask for new frequency
	ON KEY(9) GOSUB 200     'increase by offset/10
	ON KEY(10) GOSUB 210    'increase by offset
	ON KEY(8) GOSUB 220     'decrease by offset/10
	ON KEY(7) GOSUB 230     'decrease by offset
	ON KEY(4) GOSUB file    'File I/O subroutine
	ON KEY(5) GOSUB prn     'LPT1 printer subroutine

'
	GOSUB 3000 'display instructions

iput:   PRINT "Enter Starting DDS Frequency in Hz ";
	INPUT fout#
	PRINT
	PRINT "Enter an offset frequency step in Hz ";
	INPUT oset#
LP:     PRINT
	PRINT "New Output Frequency Requested is"; TAB(50);
	PRINT USING "#########,.####"; fout#
'
'       Open the serial port COM1
'
999     OPEN "com1:9600,n,8,1,bin,cd0,cs0,ds0,rs" FOR RANDOM AS 1
'
	KEY(7) OFF        'disable event trapping while serial I/O
	KEY(8) OFF        'is taking place. Prevent fast key inputs from
	KEY(9) OFF        'crashing program
	KEY(10) OFF
       
       
       
       
	GOSUB 400       'Branch to dds calc and serial load routine. Return
'                        here after sending 1 set of 5 bytes to DDS board.
'
	CLOSE 1         'Close serial port to clear buffer
'
goon:   KEY(7) ON       're-enable keys 7-10
	KEY(8) ON
	KEY(9) ON
	KEY(10) ON

	FOR a = 1 TO 1000
	delay = SIN(a) / COS(a)     'Loop here and wait for key interrupt
	NEXT a
	GOTO goon
	'
200     fout# = fout# + (oset# / 10) 'these routines compute the frequency
	RETURN LP                    'frequency increments for Keys F7,F8,F9,F10
210     fout# = fout# + oset#
	RETURN LP
220     fout# = fout# - (oset# / 10)
	RETURN LP
230     fout# = fout# - oset#
	RETURN LP'
'
400     REM - DDS NCO Coefficient Calculations
'
'
	clk# = osc#
'
	fdds# = fout#
'
	fract# = fdds# / clk#   'intermediate value  - mult by 2^N
	dpha# = (fract# * 2 ^ 32) + .5#

'       The above is the delta phase input to the NCO in float pt. Note
'       addition of 0.5 to make roundoff error symmetrical about the
'       nominal frequency. This reduces the absolute value of the peak error.
'
'        PRINT
'        PRINT "NCO Coefficient {decimal} = "; dpha#
'        INPUT s$
'
'       Next we convert the floating point NCO coefficient into a series
'       of binary bits to be passed to the loader circuit. Each of the
'       elements of the array bit% will contain either a 1 or a 0 depending
'       upon whether the corresponding power of 2 is true or false in the
'       binary equivalent of the coefficient value.
'
'
'       Translate to binary format by successive division by powers of 2,
'       starting with 2^31 and going to 2^0.
'
	rmd# = dpha#                    'remainder after each loop
'
	FOR i% = 31 TO 0 STEP -1
'
	bit%(i%) = 0            'bit not set to start ...
'
	IF rmd# >= binv#(i%) THEN bit%(i%) = 1  'that binary bit value is set
'
	IF bit%(i%) = 1 THEN rmd# = rmd# - binv#(i%) '& work on whats left
'
'       PRINT i%, bit%(i%), binv#(i%)   ' debug
'
	NEXT i%         'until all bit values tested and loaded into bit%()
'
'       Now we have to load the bit%() array with all zeros in locations
'       39 down to 32 to set the phase word to all zeros prior to sending
'       to the DDS board.
'
	FOR i% = 39 TO 32 STEP -1
	bit%(i%) = 0
	NEXT i%


'       Conversion Accuracy Test - comment out most of it but keep
'       routine to show roundoff error
'
	sum# = 0
	FOR j = 0 TO 31 STEP 1
	sum# = sum# + binv#(j) * bit%(j)
	NEXT j
'       PRINT "integer phase word is "; sum#
'       PRINT "requested phase word is "; dpha#
'       PRINT (dpha# - sum#)
	factual# = (sum# * clk#) / 2 ^ 32
	PRINT "Calculated Actual DDS Output is "; TAB(50);
	PRINT USING "#########,.####"; factual#
	PRINT
'       PRINT "Requested DDS Frequency Output was"; TAB(50);
'       PRINT USING "#########,.####"; fout#
	diff = (factual# - fout#) * 1000!
'       PRINT
	PRINT "Frequency Error in milli-Hertz is "; TAB(50);
	PRINT USING "###.##"; diff
	PRINT
'
	PRINT "----> Be Sure to Record Frequency if Needed   <-----"
	PRINT "----> Before Using F1 (Halt) or F2 (New Freq) <-----"
	PRINT "----> F4 writes it to disk, F5 prints to LPT1 <-----"
'
'        INPUT z$  ' pause to read above if enabled
'
'
	REM - SERIAL TRANSFER ROUTINE
'
'       Set up interrupt for detction of return byte
'
'
	COM(1) ON
'
'       This software does the following to get each byte across using the
'       COM1 serial port:
'
'
'       Start main address loop incrementing here
'
	FOR adc% = 4 TO 0 STEP -1          'address bytes
'       PRINT adc%
	boff% = (adc% * 8)                 'offset to find byte in BIT%()
'
'       First each transmit byte is read from BIT%() and sent to loader
'
	d0% = bit%(boff% + 0) * 1          'bit 0 decimal value
	d1% = bit%(boff% + 1) * 2          'bit 1 decimal value
	d2% = bit%(boff% + 2) * 4          'bit 2 decimal value               d1% = bit%(adc% + boff% + 0) * 1'bit 0 decimal value
	d3% = bit%(boff% + 3) * 8          'bit 3 decimal value
'
	d4% = bit%(boff% + 4) * 16         'bit 4 decimal value
	d5% = bit%(boff% + 5) * 32         'bit 5 decimal value
	d6% = bit%(boff% + 6) * 64         'bit 6 decimal value               d1% = bit%(adc% + boff% + 0) * 1'bit 0 decimal value
	d7% = bit%(boff% + 7) * 128        'bit 7 decimal value
'
	send% = d0% + d1% + d2% + d3% + d4% + d5% + d6% + d7%
'
'       add to make up transfer byte decimal value to send
'
	OUT (1016), send%
'
'       Now loop until byte is returned
'
more:   FOR l% = 1 TO 1000
	ON COM(1) GOSUB 2000
	NEXT l%
'       PRINT "looping l%;l%"
	GOTO more
'
ONWRD:  IF adc% = 4 THEN PRINT
	IF adc% = 4 THEN PRINT "Byte", "Sent", "Echoed"
	PRINT adc%, send%, ebyte%  'print sent and recvd bytes to compare
'
'       INPUT z$
'
	NEXT adc%     'end of byte transfer loop
	RETURN        'query next frequency
'
1000    CLOSE 1       'close output to com1
	STOP
2000    REM - Returned byte input subroutine. Branch to here upon reciept
'       of returned byte from synthesizer board.
'
	ebyte% = INP(1016)
	RETURN ONWRD
'
'
3000    REM  Instructions and new inputs - go here on startup or on F2 key
'
	CLS
	PRINT ; TAB(30); "Function Key Definitions"
	PRINT
	PRINT , "Key"; TAB(30); "Action"
	PRINT
	PRINT , "F1"; TAB(20); "Halts Program or F1 + Enter Halts Program"
	PRINT , "F2"; TAB(20); "Brings up this Screen & Requests New Inputs"
	PRINT , "F4"; TAB(20); "Writes DDS frequency to C:\freqdata\ddsfreq.txt"
	PRINT , "F5"; TAB(20); "Prints DDS frequency to LPT1"
	PRINT , "F7"; TAB(20); "Steps Frequency Down by Offset Increment"
	PRINT , "F8"; TAB(20); "Steps Frequency Down by Offset/10"
	PRINT , "F9"; TAB(20); "Steps Frequency Up by Offset/10"
	PRINT , "F10"; TAB(20); "Steps Frequency up by Offset Increment"
	PRINT
	PRINT , "If 5 Bytes Not Echoed From DDS upon each new frequency"
	PRINT , "request - DDS is not responding due to a error"
	PRINT , "If Port Already Open Error Occurs - Restart Program to Close"
	PRINT , "any open ports automatically"
	PRINT , "Be sure computer clock is set correctly before a FMT !!"
	PRINT
	RETURN iput
'
'       -----------------------------------------------------------------
'       Printer and File i/o routines
'
file:   REM File Output to C:\freqdata\ddsfreq.txt
'       Create Directory and Path if it does not exist
'       Trap error if directory already exists
'
	ON ERROR GOTO erhnd 'directory exists
'
	MKDIR "C:\freqdata"
'
	OPEN "C:\freqdata\ddsfreq.txt" FOR APPEND AS #3
	T$ = TIME$
	PRINT #3,
	PRINT #3, "TIME:  "; T$
	PRINT #3, "Req Frequency"; TAB(20); "DDS Frequency"; TAB(40); "Error mHz"
	PRINT #3, USING "#########,.####"; fout#; TAB(20); factual#; TAB(40);
	PRINT #3, USING "####.####"; diff
	CLOSE 3
'
'       This is safety code that limits the maximum number of disk writes
'       to 1000 per program session. It prevents a runaway loop from
'       filling the hard disk with repetitive requency data.
	count = count + 1
	IF count >= 1000 THEN PRINT "disk overwrite error - program stopped"
	IF count >= 1000 THEN STOP
'
'       ERROR handler
'
erhnd:  IF ERR = 75 THEN RESUME NEXT  'directory exists so continue

	RETURN
'
'
prn:    REM  Printer output of Freq data to LPT1:
	OPEN "LPT1" FOR OUTPUT AS #2
	T$ = TIME$
	PRINT #2,
	PRINT #2, "TIME:  "; T$
	PRINT #2, "Req Frequency"; TAB(20); "DDS Frequency"; TAB(40); "Error mHz"
	PRINT #2, USING "#########,.####"; fout#; TAB(20); factual#; TAB(40);
	PRINT #2, USING "####.####"; diff
	CLOSE 2
	RETURN
	END







