//---------------------------------------------------------------------------
#ifndef mainH
#define mainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include "JvHidControllerClass.hpp"
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
//---------------------------------------------------------------------------
typedef struct {
  unsigned char bId;
  unsigned char bData[64];
} TReport;
//----------------------------------------------------------------------------
class TDevInThread : public TThread
{
private:
        TJvHidDevice *Dev;
        void __fastcall HandleReport(void);
protected:
	void __fastcall Execute(void);
public:
        TReport Report;
        unsigned long dwReportLen;
        __fastcall TDevInThread(TJvHidDevice *MyDev);
};
//---------------------------------------------------------------------------
class TMainForm : public TForm
{
__published:	// IDE-managed Components
        TJvHidDeviceController *HidCtl;
        TRichEdit *LogRichEdit;
        TListBox *DevListBox;
        TBevel *Bevel1;
        TBevel *Bevel2;
        TBevel *Bevel3;
        TBevel *Bevel4;
        TLabel *Label1;
        TLabel *Label2;
        TLabel *Label3;
        TLabel *Label4;
        TLabel *Label5;
        TLabel *Label6;
        TLabel *Label7;
        TLabel *Label8;
        TLabel *Label9;
        TLabel *Label10;
        TLabel *Label11;
        TLabel *Label12;
        TLabel *Label13;
        TLabel *Label14;
        TLabel *Label15;
        TLabel *Label16;
        TLabel *Label17;
        TLabel *Label18;
        TEdit *OutRepSizeEdit;
        TEdit *OutRepCountEdit;
        TEdit *OutRepSpeedEdit;
        TEdit *InRepSizeEdit;
        TEdit *InRepCountEdit;
        TEdit *InRepSpeedEdit;
        TEdit *OutRepIntervalEdit;
        TButton *StartButton;
        TButton *StopButton;
        TTimer *MeasureTimer;
        TTimer *OutRepTimer;
        TButton *ClearButton;
        void __fastcall HidCtlDeviceChange(TObject *Sender);
        bool __fastcall HidCtlEnumerate(TJvHidDevice *HidDev, const int Idx);
        void __fastcall DevListBoxClick(TObject *Sender);
        void __fastcall StartButtonClick(TObject *Sender);
        void __fastcall StopButtonClick(TObject *Sender);
        void __fastcall ClearButtonClick(TObject *Sender);
        void __fastcall MeasureTimerTimer(TObject *Sender);
        void __fastcall OutRepTimerTimer(TObject *Sender);
        void __fastcall FormDestroy(TObject *Sender);
        void __fastcall OutRepIntervalEditChange(TObject *Sender);
private:	// User declarations
        TList *DevList;
        TDevInThread *DevInThread;
        TReport OutReport;
        unsigned long dwOutReportLen, dwOutReportNum;
        unsigned char bRunning;
        unsigned short wInRepSize, wOutRepSize;
        unsigned long dwInRepCount, dwOutRepCount;
        unsigned long dwInRepTotal, dwOutRepTotal;
        unsigned long dwInRepTime, dwOutRepTime;
public:		// User declarations
        __fastcall TMainForm(TComponent* Owner);
        void __fastcall ShowInputReport(void);
        void __fastcall ShowOutputReport(void);
};
//---------------------------------------------------------------------------
extern PACKAGE TMainForm *MainForm;
//---------------------------------------------------------------------------
#endif
