// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'JvHidControllerClass.pas' rev: 6.00

#ifndef JvHidControllerClassHPP
#define JvHidControllerClassHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <ModuleLoader.hpp>	// Pascal unit
#include <Hid.hpp>	// Pascal unit
#include <SetupApi.hpp>	// Pascal unit
#include <DBT.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Jvhidcontrollerclass
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TJvHidDevice;
typedef bool __fastcall (__closure *TJvHidEnumerateEvent)(TJvHidDevice* HidDev, const int Idx);

typedef void __fastcall (__closure *TJvHidUnplugEvent)(TJvHidDevice* HidDev);

typedef void __fastcall (__closure *TJvHidDataEvent)(TJvHidDevice* HidDev, Byte ReportID, const void * Data, Word Size);

typedef void __fastcall (__closure *TJvHidDataErrorEvent)(TJvHidDevice* HidDev, unsigned Error);

typedef bool __stdcall (*TJvHidCheckCallback)(TJvHidDevice* HidDev);

#pragma option push -b-
enum TJvHidOpenExMode { omhRead, omhWrite };
#pragma option pop

typedef DynamicArray<Word >  TJvPhysicalDescriptor;

class DELPHICLASS TJvHidPnPInfo;
class PASCALIMPLEMENTATION TJvHidPnPInfo : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	unsigned FDeviceID;
	AnsiString FDevicePath;
	unsigned FCapabilities;
	AnsiString FClassDescr;
	AnsiString FClassGUID;
	Classes::TStringList* FCompatibleIDs;
	unsigned FConfigFlags;
	AnsiString FDeviceDescr;
	AnsiString FDriver;
	AnsiString FFriendlyName;
	Classes::TStringList* FHardwareID;
	Classes::TStringList* FLowerFilters;
	AnsiString FMfg;
	Classes::TStringList* FUpperFilters;
	AnsiString FAddress;
	unsigned FBusNumber;
	AnsiString FBusType;
	AnsiString FCharacteristics;
	AnsiString FDevType;
	AnsiString FEnumeratorName;
	unsigned FExclusive;
	AnsiString FLegacyBusType;
	AnsiString FLocationInfo;
	AnsiString FPhysDevObjName;
	AnsiString FSecurity;
	AnsiString FService;
	unsigned FUINumber;
	AnsiString FUINumberFormat;
	AnsiString __fastcall GetRegistryPropertyString(void * PnPHandle, const SP_DEVINFO_DATA &DevData, unsigned Prop);
	Classes::TStringList* __fastcall GetRegistryPropertyStringList(void * PnPHandle, const SP_DEVINFO_DATA &DevData, unsigned Prop);
	unsigned __fastcall GetRegistryPropertyDWord(void * PnPHandle, const SP_DEVINFO_DATA &DevData, unsigned Prop);
	__property unsigned DeviceID = {read=FDeviceID, nodefault};
	__property AnsiString DevicePath = {read=FDevicePath};
	__property unsigned Capabilities = {read=FCapabilities, nodefault};
	__property AnsiString ClassDescr = {read=FClassDescr};
	__property AnsiString ClassGUID = {read=FClassGUID};
	__property Classes::TStringList* CompatibleIDs = {read=FCompatibleIDs};
	__property unsigned ConfigFlags = {read=FConfigFlags, nodefault};
	__property AnsiString DeviceDescr = {read=FDeviceDescr};
	__property AnsiString Driver = {read=FDriver};
	__property AnsiString FriendlyName = {read=FFriendlyName};
	__property Classes::TStringList* HardwareID = {read=FHardwareID};
	__property Classes::TStringList* LowerFilters = {read=FLowerFilters};
	__property AnsiString Mfg = {read=FMfg};
	__property Classes::TStringList* UpperFilters = {read=FUpperFilters};
	__property AnsiString Address = {read=FAddress};
	__property unsigned BusNumber = {read=FBusNumber, nodefault};
	__property AnsiString BusType = {read=FBusType};
	__property AnsiString Characteristics = {read=FCharacteristics};
	__property AnsiString DevType = {read=FDevType};
	__property AnsiString EnumeratorName = {read=FEnumeratorName};
	__property unsigned Exclusive = {read=FExclusive, nodefault};
	__property AnsiString LegacyBusType = {read=FLegacyBusType};
	__property AnsiString LocationInfo = {read=FLocationInfo};
	__property AnsiString PhysDevObjName = {read=FPhysDevObjName};
	__property AnsiString Security = {read=FSecurity};
	__property AnsiString Service = {read=FService};
	__property unsigned UINumber = {read=FUINumber, nodefault};
	__property AnsiString UINumberFormat = {read=FUINumberFormat};
	__fastcall TJvHidPnPInfo(void * APnPHandle, const SP_DEVINFO_DATA &ADevData, char * ADevicePath);
	__fastcall virtual ~TJvHidPnPInfo(void);
};


typedef DynamicArray<Byte >  JvHidControllerClass__3;

class DELPHICLASS TJvHidDeviceReadThread;
class PASCALIMPLEMENTATION TJvHidDeviceReadThread : public Classes::TThread 
{
	typedef Classes::TThread inherited;
	
private:
	unsigned FErr;
	void __fastcall DoData(void);
	void __fastcall DoDataError(void);
	__fastcall TJvHidDeviceReadThread(const TJvHidDevice* Dev);
	
public:
	TJvHidDevice* Device;
	unsigned NumBytesRead;
	DynamicArray<Byte >  Report;
	virtual void __fastcall Execute(void);
	__fastcall TJvHidDeviceReadThread(bool CreateSuspended);
public:
	#pragma option push -w-inl
	/* TThread.Destroy */ inline __fastcall virtual ~TJvHidDeviceReadThread(void) { }
	#pragma option pop
	
};


typedef DynamicArray<HIDP_LINK_COLLECTION_NODE >  JvHidControllerClass__5;

class DELPHICLASS TJvHidDeviceController;
class PASCALIMPLEMENTATION TJvHidDeviceController : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	#pragma pack(push, 1)
	GUID FHidGuid;
	#pragma pack(pop)
	
	Classes::TNotifyEvent FDeviceChangeEvent;
	TJvHidEnumerateEvent FEnumerateEvent;
	TJvHidDataEvent FDevDataEvent;
	TJvHidDataErrorEvent FDevDataErrorEvent;
	TJvHidUnplugEvent FDevUnplugEvent;
	bool FDeviceChangeFired;
	int FDevThreadSleepTime;
	AnsiString FVersion;
	AnsiString FDummy;
	Classes::TList* FList;
	int FNumCheckedInDevices;
	int FNumCheckedOutDevices;
	int FNumUnpluggedDevices;
	bool __fastcall CheckThisOut(TJvHidDevice* &HidDev, int Idx, bool Check);
	void __fastcall FillInList(Classes::TList* &List);
	bool __fastcall EventPipe(Messages::TMessage &Msg);
	
protected:
	void __fastcall DoDeviceChange(void);
	bool __fastcall DoEnumerate(TJvHidDevice* HidDev, int Idx);
	void __fastcall SetDeviceChangeEvent(const Classes::TNotifyEvent Notifier);
	void __fastcall SetEnumerate(const TJvHidEnumerateEvent Enumerator);
	void __fastcall SetDevThreadSleepTime(const int DevTime);
	void __fastcall SetDevData(const TJvHidDataEvent DataEvent);
	void __fastcall SetDevDataError(const TJvHidDataErrorEvent DataErrorEvent);
	void __fastcall SetDevUnplug(const TJvHidUnplugEvent Unplugger);
	
public:
	__property GUID HidGuid = {read=FHidGuid};
	__fastcall virtual TJvHidDeviceController(Classes::TComponent* AOwner);
	__fastcall virtual ~TJvHidDeviceController(void);
	void __fastcall CheckIn(TJvHidDevice* &HidDev);
	bool __fastcall CheckOut(TJvHidDevice* &HidDev);
	bool __fastcall CheckOutByClass(TJvHidDevice* &HidDev, const AnsiString ClassName);
	bool __fastcall CheckOutByID(TJvHidDevice* &HidDev, const int Vid, const int Pid);
	bool __fastcall CheckOutByIndex(TJvHidDevice* &HidDev, const int Idx);
	bool __fastcall CheckOutByProductName(TJvHidDevice* &HidDev, const WideString ProductName);
	bool __fastcall CheckOutByVendorName(TJvHidDevice* &HidDev, const WideString VendorName);
	bool __fastcall CheckOutByCallback(TJvHidDevice* &HidDev, TJvHidCheckCallback Check);
	int __fastcall CountByClass(const AnsiString ClassName);
	int __fastcall CountByID(const int Vid, const int Pid);
	int __fastcall CountByProductName(const WideString ProductName);
	int __fastcall CountByVendorName(const WideString VendorName);
	int __fastcall CountByCallback(TJvHidCheckCallback Check);
	int __fastcall Enumerate(void);
	/*         class method */ static AnsiString __fastcall HidVersion(TMetaClass* vmt);
	__property int NumCheckedInDevices = {read=FNumCheckedInDevices, nodefault};
	__property int NumCheckedOutDevices = {read=FNumCheckedOutDevices, nodefault};
	__property int NumUnpluggedDevices = {read=FNumUnpluggedDevices, nodefault};
	
__published:
	__property int DevThreadSleepTime = {read=FDevThreadSleepTime, write=SetDevThreadSleepTime, default=100};
	__property AnsiString Version = {read=FVersion, write=FDummy, stored=false};
	__property TJvHidEnumerateEvent OnEnumerate = {read=FEnumerateEvent, write=SetEnumerate};
	__property Classes::TNotifyEvent OnDeviceChange = {read=FDeviceChangeEvent, write=SetDeviceChangeEvent};
	__property TJvHidDataEvent OnDeviceData = {read=FDevDataEvent, write=SetDevData};
	__property TJvHidDataErrorEvent OnDeviceDataError = {read=FDevDataErrorEvent, write=SetDevDataError};
	__property TJvHidUnplugEvent OnDeviceUnplug = {read=FDevUnplugEvent, write=SetDevUnplug};
	void __fastcall DeviceChange(void);
};


class PASCALIMPLEMENTATION TJvHidDevice : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TJvHidDeviceController* FMyController;
	bool FIsPluggedIn;
	bool FIsCheckedOut;
	bool FIsEnumerated;
	unsigned FHidFileHandle;
	unsigned FHidOverlappedRead;
	unsigned FHidOverlappedWrite;
	_OVERLAPPED FOvlRead;
	_OVERLAPPED FOvlWrite;
	HIDD_ATTRIBUTES FAttributes;
	TJvHidPnPInfo* FPnPInfo;
	WideString FVendorName;
	WideString FProductName;
	DynamicArray<Word >  FPhysicalDescriptor;
	void *FPreparsedData;
	WideString FSerialNumber;
	Classes::TStringList* FLanguageStrings;
	int FNumInputBuffers;
	int FNumOverlappedBuffers;
	int FThreadSleepTime;
	DynamicArray<HIDP_LINK_COLLECTION_NODE >  FLinkCollection;
	unsigned FMaxDataListLength;
	unsigned FMaxUsageListLength;
	unsigned FMaxButtonListLength;
	unsigned FReportTypeParam;
	Word FUsagePageParam;
	Word FLinkCollectionParam;
	Word FUsageParam;
	TJvHidDataEvent FData;
	TJvHidDataErrorEvent FDataError;
	TJvHidUnplugEvent FUnplug;
	bool FHasReadWriteAccess;
	TJvHidDeviceReadThread* FDataThread;
	int FTag;
	bool __fastcall IsAccessible(void);
	void __fastcall GetMax(void);
	AnsiString __fastcall GetDeviceStringAnsi(Byte Idx);
	WideString __fastcall GetDeviceStringUnicode(Byte Idx);
	HIDP_LINK_COLLECTION_NODE __fastcall GetLinkCollectionNode(Word Idx);
	HIDD_CONFIGURATION __fastcall GetConfiguration();
	void * __fastcall GetPreparsedData(void);
	HIDP_CAPS __fastcall GetCaps();
	WideString __fastcall GetVendorName();
	WideString __fastcall GetProductName();
	WideString __fastcall GetSerialNumber();
	TJvPhysicalDescriptor __fastcall GetPhysicalDescriptor();
	Classes::TStringList* __fastcall GetLanguageStrings(void);
	unsigned __fastcall GetOverlappedReadResult(void);
	unsigned __fastcall GetOverlappedWriteResult(void);
	void __fastcall SetConfiguration(const HIDD_CONFIGURATION &Config);
	void __fastcall SetDataEvent(const TJvHidDataEvent DataEvent);
	void __fastcall SetNumInputBuffers(const int Num);
	void __fastcall SetNumOverlappedBuffers(const int Num);
	void __fastcall SetReportTypeParam(const unsigned ReportType);
	void __fastcall SetThreadSleepTime(const int SleepTime);
	void __fastcall SetUsagePageParam(const Word UsagePage);
	void __fastcall StartThread(void);
	void __fastcall StopThread(void);
	__fastcall TJvHidDevice(const TJvHidPnPInfo* APnPInfo, const TJvHidDeviceController* Controller);
	
protected:
	void __fastcall DoUnplug(void);
	
public:
	__fastcall TJvHidDevice(void);
	__fastcall virtual ~TJvHidDevice(void);
	__property HIDD_ATTRIBUTES Attributes = {read=FAttributes};
	__property HIDP_CAPS Caps = {read=GetCaps};
	__property bool HasReadWriteAccess = {read=FHasReadWriteAccess, nodefault};
	__property unsigned HidFileHandle = {read=FHidFileHandle, nodefault};
	__property unsigned HidOverlappedRead = {read=FHidOverlappedRead, nodefault};
	__property unsigned HidOverlappedWrite = {read=FHidOverlappedWrite, nodefault};
	__property unsigned HidOverlappedReadResult = {read=GetOverlappedReadResult, nodefault};
	__property unsigned HidOverlappedWriteResult = {read=GetOverlappedWriteResult, nodefault};
	__property bool IsCheckedOut = {read=FIsCheckedOut, nodefault};
	__property bool IsPluggedIn = {read=FIsPluggedIn, nodefault};
	__property Classes::TStringList* LanguageStrings = {read=GetLanguageStrings};
	__property unsigned MaxButtonListLength = {read=FMaxButtonListLength, nodefault};
	__property unsigned MaxDataListLength = {read=FMaxDataListLength, nodefault};
	__property unsigned MaxUsageListLength = {read=FMaxUsageListLength, nodefault};
	__property TJvPhysicalDescriptor PhysicalDescriptor = {read=GetPhysicalDescriptor};
	__property TJvHidPnPInfo* PnPInfo = {read=FPnPInfo};
	__property void * PreparsedData = {read=GetPreparsedData};
	__property WideString ProductName = {read=GetProductName};
	__property WideString SerialNumber = {read=GetSerialNumber};
	__property WideString VendorName = {read=GetVendorName};
	__property HIDD_CONFIGURATION Configuration = {read=GetConfiguration, write=SetConfiguration};
	__property Word LinkCollectionParam = {read=FLinkCollectionParam, write=FLinkCollectionParam, nodefault};
	__property int NumInputBuffers = {read=FNumInputBuffers, write=SetNumInputBuffers, nodefault};
	__property int NumOverlappedBuffers = {read=FNumOverlappedBuffers, write=SetNumOverlappedBuffers, nodefault};
	__property unsigned ReportTypeParam = {read=FReportTypeParam, write=SetReportTypeParam, nodefault};
	__property int Tag = {read=FTag, write=FTag, nodefault};
	__property int ThreadSleepTime = {read=FThreadSleepTime, write=SetThreadSleepTime, nodefault};
	__property Word UsagePageParam = {read=FUsagePageParam, write=SetUsagePageParam, nodefault};
	__property Word UsageParam = {read=FUsageParam, write=FUsageParam, nodefault};
	__property AnsiString DeviceStrings[Byte Idx] = {read=GetDeviceStringAnsi};
	__property WideString DeviceStringsUnicode[Byte Idx] = {read=GetDeviceStringUnicode};
	__property HIDP_LINK_COLLECTION_NODE LinkCollectionNodes[Word Idx] = {read=GetLinkCollectionNode};
	__property TJvHidDataEvent OnData = {read=FData, write=SetDataEvent};
	__property TJvHidDataErrorEvent OnDataError = {read=FDataError, write=FDataError};
	__property TJvHidUnplugEvent OnUnplug = {read=FUnplug, write=FUnplug};
	bool __fastcall CancelIO(const TJvHidOpenExMode Mode);
	void __fastcall CloseFile(void);
	void __fastcall CloseFileEx(const TJvHidOpenExMode Mode);
	bool __fastcall DeviceIoControl(unsigned IoControlCode, void * InBuffer, unsigned InSize, void * OutBuffer, unsigned OutSize, unsigned &BytesReturned);
	bool __fastcall FlushQueue(void);
	int __fastcall GetButtonCaps(Hid::PHIDPButtonCaps ButtonCaps, Word &Count);
	int __fastcall GetButtons(Hid::PUsage UsageList, unsigned &UsageLength, void *Report, unsigned ReportLength);
	int __fastcall GetButtonsEx(Hid::PUsageAndPage UsageList, unsigned &UsageLength, void *Report, unsigned ReportLength);
	int __fastcall GetData(Hid::PHIDPData DataList, unsigned &DataLength, void *Report, unsigned ReportLength);
	bool __fastcall GetFeature(void *Report, const int Size);
	int __fastcall GetScaledUsageValue(int &UsageValue, void *Report, unsigned ReportLength);
	int __fastcall GetSpecificButtonCaps(Hid::PHIDPButtonCaps ButtonCaps, Word &Count);
	int __fastcall GetSpecificValueCaps(Hid::PHIDPValueCaps ValueCaps, Word &Count);
	int __fastcall GetUsages(Hid::PUsage UsageList, unsigned &UsageLength, void *Report, unsigned ReportLength);
	int __fastcall GetUsagesEx(Hid::PUsageAndPage UsageList, unsigned &UsageLength, void *Report, unsigned ReportLength);
	int __fastcall GetUsageValue(unsigned &UsageValue, void *Report, unsigned ReportLength);
	int __fastcall GetUsageValueArray(char * UsageValue, Word UsageValueByteLength, void *Report, unsigned ReportLength);
	int __fastcall GetValueCaps(Hid::PHIDPValueCaps ValueCaps, Word &Count);
	bool __fastcall OpenFile(void);
	bool __fastcall OpenFileEx(TJvHidOpenExMode Mode);
	int __fastcall SetButtons(Hid::PUsage UsageList, unsigned &UsageLength, void *Report, unsigned ReportLength);
	int __fastcall SetData(Hid::PHIDPData DataList, unsigned &DataLength, void *Report, unsigned ReportLength);
	bool __fastcall SetFeature(void *Report, const int Size);
	int __fastcall SetScaledUsageValue(int UsageValue, void *Report, unsigned ReportLength);
	int __fastcall SetUsages(Hid::PUsage UsageList, unsigned &UsageLength, void *Report, unsigned ReportLength);
	int __fastcall SetUsageValue(unsigned UsageValue, void *Report, unsigned ReportLength);
	int __fastcall SetUsageValueArray(char * UsageValue, Word UsageValueByteLength, void *Report, unsigned ReportLength);
	int __fastcall UnsetButtons(Hid::PUsage UsageList, unsigned &UsageLength, void *Report, unsigned ReportLength);
	int __fastcall UnsetUsages(Hid::PUsage UsageList, unsigned &UsageLength, void *Report, unsigned ReportLength);
	bool __fastcall ReadFile(void *Report, unsigned ToRead, unsigned &BytesRead);
	bool __fastcall ReadFileEx(void *Report, unsigned ToRead, void * CallBack);
	bool __fastcall WriteFile(void *Report, unsigned ToWrite, unsigned &BytesWritten);
	bool __fastcall WriteFileEx(void *Report, unsigned ToWrite, void * CallBack);
};


//-- var, const, procedure ---------------------------------------------------
#define cHidControllerClassVersion "1.0.18"
#define cHidKeyboardClass "Keyboard"
#define cHidMouseClass "Mouse"
#define cHidNoClass "HIDClass"
extern PACKAGE int __fastcall HidCheck(const int RetVal)/* overload */;
extern PACKAGE BOOL __fastcall HidCheck(const BOOL RetVal)/* overload */;
extern PACKAGE int __fastcall HidError(const int RetVal);
extern PACKAGE AnsiString __fastcall HidErrorString(const int RetVal);
extern PACKAGE void __fastcall Register(void);

}	/* namespace Jvhidcontrollerclass */
using namespace Jvhidcontrollerclass;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// JvHidControllerClass
