;                            Software License Agreement
;
; The software supplied herewith by Microchip Technology Incorporated (the "Company")
; for its PICmicro(r) Microcontroller is intended and supplied to you, the Company's
; customer, for use solely and exclusively on Microchip PICmicro Microcontroller
; products.
;
; The software is owned by the Company and/or its supplier, and is protected under
; applicable copyright laws. All rights are reserved. Any use in violation of the
; foregoing restrictions may subject the user to criminal sanctions under applicable
; laws, as well as to civil liability for the breach of the terms and conditions of
; this license.
;
; THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, WHETHER EXPRESS,
; IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
; MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE
; COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
; CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
;
; ###############################################################################
;	filename:	DESCRIPT.ASM
;
; 
;
; ###############################################################################
;
;	Author:			Dan Butler and Reston Condit
;	Company:		Microchip Technology Inc
;
;	Revision:		1.25
;	Date:			14 March 2002
;	Assembled using:	MPASM 3.20
;   $Header: $
;################################################################################
;
;	include files:
;		P16C745.inc	Rev 1.00
;		usb_defs.inc	Rev 1.10
;
;################################################################################
#include <p16C745.inc>
#include "usb_defs.inc"

USBBANK	code
	global	Config_desc_index
	global	Report_desc_index
	global	Descriptions
	global	string_index
	global	DeviceDescriptor
	global	ReportDescriptor
	global	ReportDescriptorLen
	global	String0
	global	String0_end
	global	StringDescriptions
	global	HID_Descriptor

	extern	EP0_start
	extern	temp		; temp var used in get config index
	extern	temp2 		; another temp, in bank2 

; ******************************************************************
; Given a configuration descriptor index, returns the beginning address
; of the descriptor within the descriptions table
; ******************************************************************
Config_desc_index
	movwf	temp
	movlw	HIGH CDI_start
	movwf	PCLATH
	movlw	low CDI_start
	addwf	temp,w
	btfsc	STATUS,C
	incf	PCLATH,f
	movwf	PCL
CDI_start			; this table calculates the offsets for each 
	retlw	low  Config1	; configuration descriptor from the beginning
	retlw	high Config1	; of the table
	; more configurations can be added here
	; retlw   low Config2
	; retlw   high Config2
	; etc....

; ******************************************************************
; Given a report descriptor index, returns the beginning address
; of the descriptor within the descriptions table
; ******************************************************************
Report_desc_index
	movwf	temp
	movlw	HIGH RDI_start
	movwf	PCLATH
	movlw	low RDI_start
	addwf	temp,w
	btfsc	STATUS,C
	incf	PCLATH,f
	movwf	PCL
RDI_start		; this table calculates the offsets for each report
	retlw	low  ReportDescriptorLen  ; descriptor from the beginning
	retlw	high ReportDescriptorLen  ; of the table, effectively
	; more reports can be added here
	; retlw   low  ReportDescriptorLen2
	; retlw   high ReportDescriptorLen2
	; etc....

; ******************************************************************
; This table is polled by the host immediately after USB Reset has been released.
; This table defines the maximum packet size EP0 can take.
; See section 9.6.1 of the Rev 1.0 USB specification.
; These fields are application DEPENDENT. Modify these to meet
; your specifications.
; the offset is passed in P0 and P1 (P0 is low order byte).
; ******************************************************************
Descriptions
	banksel	EP0_start
	movf	EP0_start+1,w
	movwf	PCLATH
	movf	EP0_start,w
	movwf	PCL

DeviceDescriptor
StartDevDescr
	retlw	0x12	; bLength	    Length of this descriptor
	retlw	1		; bDescType 	This is a DEVICE descriptor
	retlw	0x10	; bcdUSB	    USB revision 1.10 (low byte)
	retlw	1		; high byte
	retlw	0		; bDeviceClass	zero means each interface operates independently
	retlw	0		; bDeviceSubClass
	retlw	0		; bDeviceProtocol
	retlw	0x08	; bMaxPacketSize0 - inited in UsbInit()
	DT	0xD8,0x04	; idVendor	0x0925 ****Change this to uniquely ID your PIC. Note low order byte 1st			
	DT	0x34,0x12	; idProduct 0x1234 ****Change this to uniquely ID your PIC. Note low order byte 1st
	DT	0x79,0x00	; bcdDevice 0x0079 ****Change this to uniquely ID your PIC (device version#) low byte 1st
	retlw	0x01	; iManufacturer
	retlw	0x02	; iProduct
	; somehow, changing iSerialNumber will cause windows to display
	; "New Hardware found" dialog. The device will function normally,
	; however, USBCheck will NOT start. From CATC we can see that
	; the string is correctly transmitted.
	retlw	0x0		; iSerialNumber - 3
	retlw	NUM_CONFIGURATIONS ; bNumConfigurations

; ******************************************************************
; This table is retrieved by the host after the address has been set.
; This table defines the configurations available for the device.
; See section 9.6.2 of the Rev 1.0 USB specification (page 184).
; These fields are application DEPENDENT. 
; Modify these to meet your specifications.
; ******************************************************************
Config1
	retlw	9		; bLength	Length of this descriptor
	retlw	2		; bDescType	2=CONFIGURATION

	retlw	EndConfig1 - Config1
	retlw	0
	retlw	1		; bNumInterfaces	Number of interfaces

	retlw	0x01		; bConfigValue	Configuration Value
	retlw	0   		; iConfig	String Index for this config = #01
	retlw	0x80		; bmAttributes	attributes - bus powered ****Change this to 0 if your device is self powered
	retlw	0x0D		; MaxPower	26 mA from the bus.          ****Change this to match the current draw by your circuit. 
						; Do not exceet 100mA otherwise Window might not accept your device. The value is the max current/2.
Interface1
	retlw	9		; length of descriptor
	retlw	INTERFACE
	retlw	0		; number of interface, 0 based array
	retlw	0		; alternate setting
	retlw	1		; number of endpoints used in this interface
	retlw	3		; interface class - assigned by the USB
	retlw	0		; boot device - not a boot device
	retlw	0		; interface protocol 
	retlw 	0		; index to string descriptor that describes this interface
HID_Descriptor
        retlw	09h		; descriptor size (9 bytes)
        retlw	21h		; descriptor type (HID)
        retlw	00h
 	    retlw	01h		; HID class release number (1.00)
        retlw	00h		; Localized country code (none)
        retlw	01h		; # of HID class descriptor to follow (1)
        retlw	22h		; Report descriptor type (HID)
        retlw	(end_ReportDescriptor - ReportDescriptor)
        retlw	00h
Endpoint1
	retlw	7		; length of descriptor
	retlw	ENDPOINT
	retlw	0x81		; EP1, In
	retlw	3		; Interrupt
	retlw	8		; max packet size (8 bytes) low order byte
	retlw	0		; max packet size (4 bytes) high order byte
	retlw	0x0a		; polling interval (10ms)
EndConfig1

ReportDescriptorLen
	retlw	low  (end_ReportDescriptor-ReportDescriptor)

ReportDescriptor
		DT 0x06,0xA0,0xFF  ; usage page (Vendor Defined)
		DT 0x09,0x01       ; usage (Vendor Defined)
		DT 0xA1,0x01	   ; collection (application)
		DT 0x09,0x02       ; usage (Vendor Defined)
		DT 0xA1,0x00    	; collection (linked)
		DT 0x06,0xA1,0xFF	; usage page (buttons)
		DT 0x09,0x03	   	; usage vendor defined
   		DT 0x09,0x04	   	; usage vendor defined
		DT 0x15,0x80		; logical minimum (-128)
		DT 0x25,0x7F		; logical maximum (127)
		DT 0x35,0x00		; Physical Minimum (0)
		DT 0x45,0xFF		; Physical Maximum (255)
        DT 0x75,0x08		; report size (8) (bits)
		DT 0x95,0x08       ; report count (8) (fields) .. ****Change 0x08 to the # of bytes you need
		DT 0x81,0x02	    ; input (Data, Variable, Absolute)

       	DT	0x09,0x05		; usage (Vendor Defined)

       	DT	0x09,0x06		; useage (Vendor Defined)
		DT	0x15,0x80		; logical minimum (-128)
     	DT	0x25,0x7F		; logical maximum (127)
        DT	0x35,0x00		; Physical Minimum (0)
        DT	0x45,0xFF		; Physical Maximum (255)

        DT	0x75,0x08		; report size (8) (bits)
		
        DT	0x95,0x08		; report Count (8) (fields).. ****Change 0x08 to the # of bytes you need
        DT	0x91,0x02		; Output (Data, Variable, Absolute)

        DT	0xC0,0xC0		; end collection, end collection


end_ReportDescriptor
	
StringDescriptions
	banksel	EP0_start
	movf	EP0_start+1,w
	movwf	PCLATH
	movf	EP0_start,w
	movwf	PCL

; ******************************************************************
; Given a configuration descriptor index, returns the beginning address
; of the descriptor within the descriptions table
; ******************************************************************
string_index	; langid in W reg, string offset in EP0_start
	movwf	temp
	bcf 	STATUS,C
	rlf 	temp, f
	pagesel	langid_index
	call	langid_index
	movwf	temp2
	incf	temp, f
	pagesel	langid_index
	call	langid_index
	movwf	temp

	movf	temp, w
	movwf	PCLATH
	movf	temp2,w
	addwf	EP0_start+1,w
	btfsc	STATUS,C
	incf	PCLATH, f
	movwf	PCL

langid_index
	movlw	high langids
	movwf	PCLATH
	movlw	low langids
	addwf	temp, w
	btfsc	STATUS,C
	incf	PCLATH,f
	movwf	PCL

langids
	retlw	low lang_1
	retlw	high lang_1
	retlw	low lang_2	; string indexes of different languages
	retlw	high lang_2

lang_1	; english
	retlw	low  String0	; LangIDs
	retlw	high String0
	retlw	low  String1_l1
	retlw	high String1_l1
	retlw	low  String2_l1
	retlw	high String2_l1
	retlw	low  String3_l1
	retlw	high String3_l1
	retlw	low  String4_l1
	retlw	high String4_l1
	retlw	low  String5_l1
	retlw	high String5_l1

lang_2
	retlw	low  String0	; also point to LangID
	retlw	high String0
	retlw	low  String1_l2
	retlw	high String1_l2
	retlw	low  String2_l2
	retlw	high String2_l2
	retlw	low  String3_l2
	retlw	high String3_l2
	retlw	low  String4_l2
	retlw	high String4_l2
	retlw	low  String5_l2
	retlw	high String5_l2

String0
	retlw   low (String1_l1 - String0)    ; length of string 
	DT  0x03        ; descriptor type 3?
	DT  0x09,0x04   ; language ID (as defined by MS 0x0409)
	DT  0x04,0x08    ; some other language ID for testing

String0_end
String1_l1
	retlw	String2_l1-String1_l1    ; length of string
	DT	0x03    ; string descriptor type 3
	DT	'M',0x00,'i',0x00,'c',0x00,'r',0x00,'o',0x00,'c',0x00,'h',0x00,'i',0x00,'p',0x00
String2_l1 ;****Change this string to match your product name
	retlw	String3_l1-String2_l1 ;
	DT	0x03
	DT	'P',0x00,'I',0x00,'C',0x00,'1',0x00,'6',0x00,'C',0x00,'7',0x00,'4',0x00,'5',0x00,' ',0x00
	DT	'S',0x00,'A',0x00,'M',0x00,'P',0x00,'L',0x00,'E',0x00
	global	String3_l1
String3_l1 ;****Change this string to match your product version
	retlw	String4_l1-String3_l1
	DT	0x03
	DT	'V',0x00,'1',0x00,'.',0x00,'0',0x00,'0',0x00
String4_l1
	retlw	String5_l1-String4_l1
	DT	0x03
	DT	'C',0x00,'f',0x00,'g',0x00,'1',0x00
String5_l1
	retlw	String6_l1-String5_l1
	DT	0x03
	DT	'E',0x00,'P',0x00,'1',0x00,'0',0x00,'I',0x00,'n',0x00
String6_l1

String1_l2          ; lang 2, chinese. String can be totally different than english
	retlw	String2_l2-String1_l2    ; length of string
	DT	0x03    ; string descriptor type 3
	DT	'M',0x00,'i',0x00,'c',0x00,'r',0x00,'o',0x00,'c',0x00,'h',0x00,'i',0x00,'p',0x00
String2_l2 ;****Change this string to match your product name
    retlw   String3_l2-String2_l2
	DT	0x03
	DT	'P',0x00,'I',0x00,'C',0x00,'1',0x00,'6',0x00,'C',0x00,'7',0x00,'4',0x00,'5',0x00,' ',0x00
	DT	'S',0x00,'A',0x00,'M',0x00,'P',0x00,'L',0x00,'E',0x00

String3_l2;****Change this string to match your product version
	retlw	String4_l2-String3_l2
	DT	0x03
	DT	'V',0x00,'1',0x00,'.',0x00,'0',0x00,'0',0x00

String4_l2
	retlw	String5_l2-String4_l2
	DT	0x03
	DT	'C',0x00,'f',0x00,'g',0x00,'1',0x00
String5_l2
	retlw	String6_l2-String5_l2
	DT	0x03
	DT	'E',0x00,'P',0x00,'1',0x00,'0',0x00,'I',0x00,'n',0x00
String6_l2

	end
