;
; Program to interface ATR-2000 HF Transceiver to PC
;
; Copyright 1999-2000 John B. Stephensen
;
; This software in source, object or binary form is licensed only for personal non-profit
; educational use in the Amateur Radio Service and the license is not transferrable. The
; software is provided as-is for experimental purposes and the author does not warranty
; its freedom from defects or its suitability for any specific application. 
;
;  Written for use with Microchip MPASM v02.15
;
;	8-10-99	written
;	8-11-99	reverse UARTOUT polarity, zero ADC before conversion
;	8-12-99	fix SETFIL
;	8-13-99 fix TX/RX bit selection add NB code
;	3-4-00	add padding char. to beginning of transmitted string
;	3-14-00	add long. parity to S-Meter response and use SOH for commands
;	3-16-00	add VOX
;	3-17-00	disable PTT line when VOX threshold at maximum
;	3-21-00	fake receipt pad char. when PTT line changes
;	3-22-00	PTT now active high - change test instructions at ** if active low
;	3-25-00	NB (IF preamp) always on - to change this replace code marked with ***
;
;Requites 7.3728 MHz crystal on oscillator pins.
;Accepts data from asynch. port and loads into peripheral chips.
;
	LIST	P=16F84
	RADIX 	DEC
	__CONFIG 0x3FF2
;
; PIC registers
;
OPTREG	EQU	0x81	;OPTION
;
FSR	EQU	4	;indirect address pointer
INDF	EQU	0	;access to use indirect address
TMR0	EQU	1	;timer register
STATUS	EQU	3	;status register
CARRY	EQU	0	;carry bit
ZERO	EQU	2	;zero bit
RP0	EQU	5	;select register page - low bit
;
INTCON	EQU	0x0B	;interrupt control register
RBIF	EQU	0	;RB chnage interrupt flag
INTF	EQU	1	;set by change on RB0/INT pin
T0IF	EQU	2	;timer flag (clear in ISR)
RBIE	EQU	3	;RB change interrupt enable
INTE	EQU	4	;RB0/INT interrupt enable
T0IE	EQU	5	;timer interrupt enable
EEIE	EQU	6	;EE Write interrupt enable
GIE	EQU	7	;set to enable interrupts
;
RA	EQU	5	;PORT A - chip select
TRISA	EQU	0x85	;TRIS A
ENAADC	EQU	1	;ADC0831N ADC enable - active low
ENAREG	EQU	3	;SN74HC594N shift reg. enable - low to high trans.
ENADAC	EQU	2	;MC144111P quad. DAC enable - active low
;
RB	EQU	6	;PORT B - RS-232 and local serial I/O
TRISB	EQU	0x86	;TRIS B
PTT	EQU	6	;PTT input (active high)
TXD	EQU	5	;serial data out
RXD	EQU	4	;serial data in
RXDM	EQU	0x10	;mask for serial data
CLK	EQU	3	;peripheral clock
DTOUT	EQU	2	;data to MC144111 and SN74HC594
DTIN	EQU	1	;data from ADC0831
DTINM	EQU	0x02	;mask for ADC0831 data input
;
; PIC RAM
;
CTR	EQU	0x0E	;general loop counter
ACTR	EQU	0x0F	;ADC/DAC byte counter
FCTR	EQU	0x10	;command frame byte counter
BITS	EQU	0x11	;UART bit accumulator
BCTR	EQU	0x12	;UART bit counter
LONGPAR	EQU	0x13	;frame longitudinal parity accum.
;
;the following 6 locations contain the received command
CTL	EQU	0x14	;control byte
;numeric values stores LS bit first in following registers
DT1	EQU	0x15	;1st data byte
DT2	EQU	0x16	;2nd data byte
DT3	EQU	0x17	;3rd data byte
DT4	EQU	0x18	;4th data byte
DT5	EQU	0x19	;5th data byte
DT6	EQU	0x1A
DT7	EQU	0x1B
DT8	EQU	0x1C
DT9	EQU	0x1D
DT10	EQU	0x1E
;
CTR1	EQU	0x1F	;2nd loop counter
;
;Copies of peripheral chip contents
;
DIGOUT	EQU	0x20	;SN74HC594 register 
RX	EQU	0	;set to enable receiver
TX	EQU	1	;set to enable transmitter
ANT	EQU	2	;set to switch antenna relay to xmtr.
NBON	EQU	3	;set to enable noise blanker
F250	EQU	0x10	;IF filter selection bits
F500	EQU	0x20
F1800	EQU	0x40
F2400	EQU	0x80
DAC	EQU	0x21	;MC144111 DAC - 6 LSB used 
DAC4	EQU	0x21
CLIPPER	EQU	0x21	;0V= +30dB  4V= -10dB
DAC3	EQU	0x22
AGC	EQU	0x22	;0V= max. gain  4V= min. gain
DAC2	EQU	0x23
BLANKER	EQU	0x23	;noise blanker threshold
DAC1	EQU	0x24
VOX	EQU	0x24	;VOX threshold
ADC	EQU	0x25	;ADC0831 ADC
;gain controls
IFGAIN	EQU	0x26
CLIPLEV	EQU	0x27
NBLEV	EQU	0x28
VOXLEV	EQU	0x29
;
W_TEMP	EQU	0x2A	;to save CPU state during ISR
S_TEMP	EQU	0x2B	;(unused)
;
;ASCII control characters
NUL	EQU	0
SOH	EQU	1
STX	EQU	2
ETX	EQU	3
ACK	EQU	6
DLE	EQU	0x10
NAK	EQU	0x15
SYN	EQU	0x16
DEL	EQU	0x7F
;commands recognized by this program
CSMTR	EQU	'S'
CFIL	EQU	'B'
CRCV	EQU	'N'
CXMT	EQU	'X'
CGAIN	EQU	'G'
CCLIP	EQU	'C'
CNB	EQU	'Z'
CVOX	EQU	'V'
;
	ORG	0x000
;
;Initialize MCU
;
RESET	MOVLW	0x00	;pullups on
	OPTION
	MOVLW	0x00	;RA2-4 outputs, rest unused
	TRIS	RA
	MOVLW	0x1F	;set chip select pins high (inactive)
	MOVWF	RA
;
	MOVLW	0x52	;RB0,2,3,5,7 outputs, RB1,4,6 input
	TRIS	RB
	MOVLW	0x00	;set UART out pin low (inactive), rest low
	MOVWF	RB
;
	CLRF	DIGOUT	;clear copy of digital output register
	CLRF	ADC	;ADC input
	CLRF	DAC1	;and analog outputs
	CLRF	DAC2
	CLRF	DAC3
	CLRF	DAC4
;
;Initialize peripherals
;
	MOVLW	60	;set minimum gain for xmtr.
	MOVWF	CLIPLEV
	MOVWF	CLIPPER
	MOVWF	VOXLEV	;and maxium VOX threshold
	MOVWF	VOX
	MOVLW	0	
	MOVWF	NBLEV	;noise blanker off
	MOVWF	BLANKER
	MOVWF	IFGAIN	;max. rcv. gain
	MOVWF	AGC
	BSF	DIGOUT,RX	;receiver on
	BSF	DIGOUT,NBON	;IF preamp on ***
	CALL	WAIT250	;wait untill all voltages settled
	CALL	SNDREG	;enable receiver
	CALL	SNDDAC	;and set gain
;
;Main program loop
;
START	CALL	RCVF	;wait for a command
	MOVF	CTL,W	;check for S-meter read
	XORLW	CSMTR
	BTFSC	STATUS,ZERO
	CALL	RDSMTR
	MOVF	CTL,W	;check for filter select
	XORLW	CFIL
	BTFSC	STATUS,ZERO
	CALL	SETFIL
	MOVF	CTL,W	;check for receive cmd.
	XORLW	CRCV
	BTFSC	STATUS,ZERO
	CALL	RECEIVE
	MOVF	CTL,W	;check for transmit cmd.
	XORLW	CXMT
	BTFSC	STATUS,ZERO
	CALL	TRANSMIT
	MOVF	CTL,W	;check for IF gain cmd.
	XORLW	CGAIN
	BTFSC	STATUS,ZERO
	CALL	NEWGAIN
	MOVF	CTL,W	;check for clipping level cmd.
	XORLW	CCLIP
	BTFSC	STATUS,ZERO
	CALL	NEWCLIP
	MOVF	CTL,W	;check for noise blanker level cmd.
	XORLW	CNB
	BTFSC	STATUS,ZERO
	CALL	NEWNB
	MOVF	CTL,W	;check for VOX level cmd.
	XORLW	CVOX
	BTFSC	STATUS,ZERO
	CALL	NEWVOX
	GOTO	START
;
;subroutine to receive a frame of data from PC
;
; frame is SOH, command, 
; data bytes, ETX and LRC
;
RCVF	MOVLW	CTL	;point to beginning of buffer
	MOVWF	FSR
	MOVLW	10	;max. 10 bytes
	MOVWF	FCTR
	CLRF	LONGPAR
	CALL	RCVB	;first byte must be SOH
	XORLW	SOH
	BTFSS	STATUS,ZERO
	GOTO	RCVF	;try again if not SOH
RCVLOOP	DECF	FCTR,F	;abort if too many characters
	BTFSC	STATUS,ZERO
	GOTO	RCVF
	CALL	RCVB	;collect character
	MOVWF	INDF	;and store in next byte of buffer 
	INCF	FSR,F
	XORWF	LONGPAR,F ;add to LRC
	XORLW	ETX	;check for end
	BTFSS	STATUS,ZERO
	GOTO	RCVLOOP	;this loop takes 12 instr. cycles (1/8 bit)
	CALL	RCVB	;get and test LRC
	XORWF	LONGPAR,W
	BTFSS	STATUS,ZERO
	GOTO	RCVF	;abort if incorrect
	RETURN
;
;subroutine to receive one byte from RS-232 port
;
; set for 19,200 b/s: 1 bit = 96 instruction cycles
; with 7.3728 MHz crystal
;
;Also checks PTT line if VOX enabled (VOX > 59 to disable)
;
RCVB	CLRF	BITS	;zero bit accumulator
	MOVLW	8	;set up for 8 bits
	MOVWF	BCTR
	MOVF	VOX,W	;check VOX threshold
	SUBLW	59	;W=59-W
	BTFSS	STATUS,CARRY ;carry set if zero or positive result
	GOTO	LOOP
	ADDLW	0	;reset carry bit
	BTFSC	DIGOUT,RX ;check mode
	GOTO	RLOOP ;and use appropriate code loop
;check PTT and RXD during transmit
TLOOP	BTFSS	RB,RXD	;check for start bit
	GOTO	RCV0
	BTFSC	RB,PTT	;check for PTT going inactive **
	GOTO	TLOOP
;here if line went high
	CALL	RECEIVE ;go to receive mode
	MOVLW	255
	MOVWF	BITS	;invalidate bit accumulator
	RETURN
;check PTT and RXD during receive
RLOOP	BTFSS	RB,RXD	;check for start bit
	GOTO	RCV0
	BTFSS	RB,PTT	;check for PTT going acitve **
	GOTO	RLOOP
;here if line went low
	CALL	TRANSMIT ;go to transmit mode
	MOVLW	255
	MOVWF	BITS	;invalidate bit accumulator
	RETURN
;check RXD only when VOX off
LOOP	BTFSC	RB,RXD	;test for start bit 
	GOTO	LOOP	;loop takes 3 cycles
;
	NOP
	NOP
RCV0	MOVLW	14	;wait 1/2 bit times
	MOVWF	CTR	;46 more cycles
RCV1	DECFSZ	CTR,F	;each loop is 3 cycles
	GOTO	RCV1	
;
	BTFSC	RB,RXD	;if still there then data follows
	GOTO	RCVB	;else start over	
;
	NOP		;add 6 cycles on entry 
	NOP		;to make 1 bit time
	NOP		;or 93 cycles
	NOP
	NOP
	NOP
;
RCV2	NOP		;wait 87 cycles
	MOVLW	28	
	MOVWF	CTR
RCV3	DECFSZ	CTR,F	;each loop is 3 cycles
	GOTO	RCV3	
;
	MOVLW	RXDM	;mask for bit 4 - this is a cycle
	ANDWF	RB,W	;get bit 4 of port b
	IORWF	BITS,F	;add to data byte
	RRF	BITS,F	;make space for another bit
	DECFSZ	BCTR,F	;get another bit if more coming
	GOTO	RCV2	;this took 9 cycles
;
	RLF	BITS,F	;move over 4 bits so aligned
	RLF	BITS,F	
	RLF	BITS,F	
	RLF	BITS,F	
	MOVF	BITS,W	;put in W to return
RCV4	BTFSS	RB,RXD	;wait for start of framing bit
	GOTO	RCV4	
	RETURN		;and then return
;
;subroutine to send one byte via RS-232 port
;
; set for 19,200 b/s: 1 bit = 96 instruction cycles
; with 7.3728 MHz crystal
;
SNDB	MOVWF	BITS	;save byte to send
	XORWF	LONGPAR,F ;add to parity byte
	MOVLW	8	;set up for 8 bits
	MOVWF	BCTR
	BSF	RB,TXD	;send start bit
	NOP		;add 5 cycles on entry 
	NOP		;to make 1 bit time
	NOP		;or 95-97 cycles before next bit
	NOP
	NOP
;
SNDB2	NOP		;wait 1 bit time
	NOP		;or 88 more cycles
	MOVLW	28	
	MOVWF	CTR
SNDB3	DECFSZ	CTR,F	;each loop is 3 cycles
	GOTO	SNDB3	
;
	BTFSS	BITS,0	;test for 0
	BSF	RB,TXD	;and send it
	BTFSC	BITS,0	;test for 1
	BCF	RB,TXD	;and send it
	RRF	BITS,F	;get another bit
	DECFSZ	BCTR,F	;check if all sent
	GOTO	SNDB2	;this took 8 cycles
;
	NOP		;wait 91 more cycles
	NOP
	MOVLW	29	
	MOVWF	CTR
SNDB4	DECFSZ	CTR,F	;each loop is 3 cycles
	GOTO	SNDB4	
	BCF	RB,TXD	;send stop bit
;	
	MOVLW	28	;wait 87 more cycles
	MOVWF	CTR
	NOP
SNDB5	DECFSZ	CTR,F	;each loop is 3 cycles
	GOTO	SNDB5	
	RETURN		;and then return
;
;Routines to implement commands
;
;Go to receive mode
;
RECEIVE	BTFSC	DIGOUT,RX	;skip if already in the mode
	RETURN
	MOVLW	60	;turn off clipper
	CALL	SETCLIP
	MOVLW	10	;wait 10 ms
	CALL	WAIT
	BCF	DIGOUT,TX	;disable TX IF
	BCF	DIGOUT,ANT	;antenna relay to receive
	CALL	SNDREG
	MOVFW	NBLEV	;enable noise blanker
	CALL	SETNB	;switch relays as side-effect
	MOVLW	200	;wait 200 ms
	CALL	WAIT
	BSF	DIGOUT,RX	;enable RX IF
	BSF	DIGOUT,NBON	;and IF preamp ***
	CALL	SNDREG
	MOVLW	10	;wait 10 ms
	CALL	WAIT
	MOVFW	IFGAIN	;un-mute receiver
	CALL	SETGAIN
	RETURN
;
;Go to transmit mode
;
TRANSMIT BTFSC	DIGOUT,TX	;skip if already in the mode
	RETURN
	MOVLW	60	;mute receiver
	CALL	SETGAIN
	MOVLW	10	;wait 10 ms
	CALL	WAIT
	BCF	DIGOUT,RX	;disable RX IF
	BCF	DIGOUT,NBON	;and IF preamp ***
	BSF	DIGOUT,ANT	;antenna relay to transmit
	CALL	SNDREG
	MOVLW	0	;disable noise blanker
	CALL	SETNB	;switch relays as side-effect
	MOVLW	200	;wait 200 ms
	CALL	WAIT
	BSF	DIGOUT,TX	;enable TX IF
	CALL	SNDREG
	MOVLW	10	;wait 10 ms
	CALL	WAIT
	MOVFW	CLIPLEV	;enable clipper
	CALL	SETCLIP
	RETURN 
;
;Read AGC line voltage - 0.5 dB/bit
;
RDSMTR	CALL	RDADC	;get AGC voltage
	MOVLW	255	;send DEL as padding
	CALL	SNDB
	MOVLW	STX	;send start of text
	CALL	SNDB
	CLRF	LONGPAR	;clear parity accumulator
	MOVLW	's'	;identify response
	CALL	SNDB
	SWAPF	ADC,W	;get MS nibble
	ANDLW	0x0F
	IORLW	0x30
	CALL	SNDB	;and send as 0-9+
	MOVFW	ADC	;get LS nibble
	ANDLW	0x0F
	IORLW	0x30
	CALL	SNDB	;send to user
	MOVFW	DIGOUT
	ANDLW	0x0F
	IORLW	0x30
	CALL	SNDB	;send status bits
	MOVLW	ETX
	CALL	SNDB	;send end of text
	MOVF	LONGPAR,W
	CALL	SNDB	;send parity
	RETURN
;
;Set IF gain
;
NEWGAIN	MOVFW	DT1	;get new gain
	ANDLW	0x3F
	MOVWF	IFGAIN	;save for future use
	BTFSS	DIGOUT,RX	;done if not in rcv mode
	RETURN
SETGAIN	MOVWF	AGC	;output new value
	CALL	SNDDAC
	RETURN
;
;Set noise blanker gain (0 = disable)
;
NEWNB	MOVFW	DT1	;get new level
	ANDLW	0x3F
	MOVWF	NBLEV	;save for future use
	BTFSS	DIGOUT,RX	;done if not in rcv mode
	RETURN
SETNB	MOVWF	BLANKER
;	ANDLW	0x3F	;update zero flag ***
;	BTFSC	STATUS,ZERO
;	BCF	DIGOUT,NBON	;turn off if 0
;	BTFSS	STATUS,ZERO
;	BSF	DIGOUT,NBON	;turn on if 1-63
	CALL	SNDDAC	;set level
;	CALL	SNDREG	;enable/disable
	RETURN
;
;Set RF clipper gain - now used for RF compressor gain
;
NEWCLIP	MOVFW	DT1	;get new level
	ANDLW	0x3F
	MOVWF	CLIPLEV	;save for future use
	BTFSS	DIGOUT,TX	;done if not in xmt mode
	RETURN
SETCLIP	MOVWF	CLIPPER	;output new value
	CALL	SNDDAC
	RETURN
;
;Set VOX threshold
;
NEWVOX	MOVFW	DT1	;get new level
	ANDLW	0x3F
	MOVWF	VOXLEV	;save for future use
SETVOX	MOVWF	VOX	;output new value
	CALL	SNDDAC
	RETURN
;
;Select Filter 
;
SETFIL	MOVLW	0x0F	;clear filter selection bits
	ANDWF	DIGOUT,F
	SWAPF	DT1,W	;put incoming selection bits in MS nibble
	ANDLW	0xF0
	IORWF	DIGOUT,F	;put in register copy
	CALL	SNDREG	;set register
	RETURN
;
;Routines to control peripheral chips
;
;subroutine to read ADC0831 8-bit A/D converter
; clock must be high at least 1 uS but not more than 60uS
;  this is 2 instruction cycles minimum with 7.3728 MHz xtal
; clock may be low indefinitely
; 1 clock required to start conversion
; 8 clocks to shift out data
; 1 clock at end for no apparent reaon other than in data sheet
;
RDADC	BCF	RA,ENAADC	;select ADC
	MOVLW	0	;start with all bits zero
	MOVWF	ADC
	BSF	RB,CLK	;start conversion
	NOP
	NOP
	BCF	RB,CLK	;1st bit discarded
	MOVLW	8	;read 8 bits
	MOVWF	ACTR
RDADC0	BSF	RB,CLK	;clock in 1 bit
	NOP
	NOP
	BCF	RB,CLK
	NOP		;wait for conversion of this bit
	NOP
	RLF	ADC,F	;make space for another bit
	MOVLW	DTINM	;mask for bit 1
	ANDWF	RB,W	;get bit 1 of port B
	IORWF	ADC,F	;add to data byte
	DECFSZ	ACTR,F	;get another bit if more coming
	GOTO	RDADC0
	RRF	ADC,F	;shift LSB to bit 0
	BSF	RB,CLK	;discard last bits
	NOP
	NOP
	BCF	RB,CLK
	NOP
	NOP
	BSF	RA,ENAADC	;unselect ADC
	MOVFW	ADC	;put result in working reg.
	RETURN	
;
;subroutine to send data to MC144111 quadruple DAC
; sends 6 bits for each DAC, 
;
SNDDAC	BCF	RA,ENADAC	;enable DAC serial input
	MOVLW	DAC	;point to beginning of buffer
	MOVWF	FSR
	MOVLW	4	;4 DACs to set - send serially
	MOVWF	CTR
SNDDAC0	MOVLW	6	;send 6 bits per DAC, MSB first
	MOVWF	ACTR
	RLF	INDF,F	;skip 2 MSB
	RLF	INDF,F
SNDDAC2	RLF	INDF,F	;get bit to send into carry flag
	CALL	SNDBIT
	DECFSZ	ACTR,F	;loop until 6 bits sent
	GOTO	SNDDAC2
	RLF	INDF,F	;put bits in original position
	INCF	FSR,F
	DECFSZ	CTR,F	;loop until 4 sent
	GOTO	SNDDAC0
	BSF	RA,ENADAC	;latch DAC input
	RETURN
;
;subroutine to send 8 bits (MSB first) to SN74HC594 register
;
SNDREG	BCF	RA,ENAREG	;prepare to load register
	MOVLW	8	;send 8 bits
	MOVWF	ACTR
SNDREG0	RLF	DIGOUT,F	;get bit from copy of register contents
	CALL	SNDBIT	;and send it
	DECFSZ	ACTR,F	;then loop until all sent
	GOTO	SNDREG0
	RLF	DIGOUT,F	;put bits in original position
	BSF	RA,ENAREG	;move into holding register
	RETURN
;
; Subroutines to send carry bit, 0 and 1 
; to register and to DAC
;
SONE	BSF	RB,DTOUT	;set data pin
	NOP
	BSF	RB,CLK		;generate clock pulse
	BCF	RB,CLK
	RETURN
;
SNDBIT	BTFSC	STATUS,CARRY	;check for one or zero
	GOTO	SONE
SZERO	BCF	RB,DTOUT	;reset data pin
	NOP
	BSF	RB,CLK		;generate clock pulse
	BCF	RB,CLK
	RETURN
;
; delay routine - 284.5 ms
;
WAIT250	CLRW
WAIT	MOVWF	CTR1
	CLRF	CTR
WAIT0	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECFSZ	CTR,F
	GOTO	WAIT0
	DECFSZ	CTR1,F
	GOTO	WAIT0
	RETURN
;
; Copyright 1999-2000 John B. Stephensen
;
	END
