{
 radioinfo contains definition of RadioDRV.EXE commands

 Copyright 1999-2000 John B. Stephensen

 This software in source, object or binary form is licensed only for personal non-profit
 educational use in the Amateur Radio Service and the license is not transferrable. The
 software is provided as-is for experimental purposes and the author does not warranty
 its freedom from defects or its suitability for any specific application.

  Written for use with Borland Pascal for Windows version 7.0

 1-8-94    add cmd_step_size
 3-1-94    added polarization into to tune_record
 3-11-95   added RTTY to xcvr_mode
 11-26-95  added c1,x1,x2,x3,k,k1 bands
 12-3-95   deleted x2,x3
 6-9-96    add x2,x3
 9-6-97    add six (6m)
 1-17-97   add 222, 2304
 6-11-99   added HF band designations
 7-9-99    added shift (if shift) to tune record
 8-11-99   added filter bandwidth to tune record
}

unit radioinfo;

interface

{note that xcvr_mode is used by all units to specify rx and tx modes}
type
  polarization_type = (rhcp,lhcp,horizontal,vertical);
  xcvr_mode = (cw,lsb,usb,lsbc,usbc,dsb,am,pm,fm,pac,rtty);
  freq_record = record
    s: integer;
    r,t: real;
    m: xcvr_mode;
    i: boolean;
  end;
  band = (h,six,v,one,u,u1,l,l1,thirteen,s,s1,c,c1,x,x1,x2,x3,k,k1,m160,m80,m40,m30,m20,m17,m15,m12,m10,m6);
  xcvr_freq = record
    d: double; {range rate}
    r,t: real; {doppler corrected frequencies}
  end; {record}

type
  tune_record = record
    mode: xcvr_mode; {receiver mode}
    rx: real; {receiver frequency - Hz}
    min_rx,max_rx,rx_ofs: real; {minimum/maximum receiver freq and freq offset}
    tx: real; {transmitter frequency - Hz}
    min_tx,max_tx,tx_ofs: real; {minimum/maximum transmitter freq and freq offset}
    invert: boolean; {true if signal inverted in transponder}
    rxb,txb: band;    {current receiver and transmitter band}
    polarization: polarization_type;
    shift: integer;
    filter:integer;
   end;

const
  int_radiodrv: Word = $64;
  cmd_range_rate: Word = $0300;
  cmd_set_freq: Word = $4200;
  cmd_get_freq: Word = $4300;
  cmd_get_knob: Word = $4400;
  cmd_get_cor_freq: Word = $4500;
  cmd_step_size: Word = $4600;

implementation
{no code in this unit}
end.
{Copyright 1999-2000 John B. Stephensen}
