{
 Transceiver control routines

 Copyright 1999-2000 John B. Stephensen

 This software in source, object or binary form is licensed only for personal non-profit
 educational use in the Amateur Radio Service and the license is not transferrable. The
 software is provided as-is for experimental purposes and the author does not warranty
 its freedom from defects or its suitability for any specific application.

  Written for use with Borland Pascal for Windows version 7.0

This program takes the desired transmit and receive frequencies and modes from newxcvr.pas,
and sets the transmitter, received and IF switch.

History:
       6-11-99  created from radiodrv()
       7-9-99   added IF shift
       8-11-99  IF shift now integer value and xmt control separate
       8-12-99  added T/R control, gain control
       8-13-99  calibrate gain controls
       8-25-99  add noise blanker control
       8-27-99  reduce TX IF gain by 6 dB
       9-8-99   new ALC circuit, setting 0-40dB gain reduction
       9-19-99  fix ALC level
       3-3-00   add azimuth()
       3-12-00  add serial knob
       3-14-00  azimuth now real
       3-17-99  add status to getagc() and add setvox()
}

unit newradiodrv;

interface

uses radioinfo, ddsctl, wcom;

procedure change_filter(filter: integer);
function getagc(var agc: integer; var rx: boolean): boolean;
procedure reqagc;
procedure sendfreq(tune: tune_record; xmt: boolean);
procedure reqknobstate;
function getknobstate(var state: integer): boolean;
procedure setifgain(a: real);
procedure setclippinglevel(a: real);
procedure setblankinglevel(a: real);
procedure setvox(a: real);
procedure send_azimuth(a:real);
procedure gotoxmt;
procedure gotorcv;

implementation

{mode control procedures}
procedure gotoxmt;
begin
  transmit;
end;

procedure gotorcv;
begin
  receive;
end;

{
DAC control procedures
Convert real dB value to integer value to load into DAC
DAC range is 6-60 for 0-4 volts (max. to min. gain)
IF gain is 0-80 dB
Clipping Level is -14/+20 dB (upper 6 dB unused)
}
procedure setifgain(a: real);
var b: integer;
begin
  b := round(60.0 - 0.675*a);
  if (b <= 63) and (b >= 0)
  then ifgain(b)
  else writeln('IF gain level outside range:',b:5);
end;

procedure setclippinglevel(a: real);
var b: integer;
begin
  b := round(59.0 - 1.3*a);
  if (b <= 63) and (b >= 0)
  then clippinglevel(b)
  else writeln('ALC level outside range:',b:5);
end;

procedure setblankinglevel(a: real);
var b: integer;
begin
  b := round(a);
  if (b <= 63) and (b >= 0)
  then clippinglevel(b)
  else writeln('Blanking Level outside range:',b:5);
end;

procedure setvox(a: real);
var b: integer;
begin
  b := round(0.63*a);
  if (b <= 63) and (b >= 0)
  then voxlevel(b)
  else writeln('VOX Level outside range:',b:5);
end;

{select filter}
procedure change_filter(filter: integer);
begin
  selectfilter(filter);
end;

{rotate antenna}
procedure send_azimuth(a:real);
begin
  set_az(round(a));
end; {azimuth}

{request AGC voltage}
procedure reqagc;
begin
  readagc0;
end;

{read AGC voltage}
function getagc(var agc: integer; var rx: boolean): boolean;
begin
  getagc := readagc1(agc,rx);
end;

{request knob counts since last call}
procedure reqknobstate;
begin
  readknob0;
end;

{get knob counts since last call}
function getknobstate(var state: integer): boolean;
begin
  getknobstate := readknob1(state);
end;

{procedure to adjust transceiver frequencies to match tune record}
procedure sendfreq(tune: tune_record; xmt: boolean);
var
  rxf,txf: real;      {corrected TX/RX freq.}
  rxs,txs: integer;
  rxm,txm:xcvr_mode;
begin
  {send info for rx or tx LO}
  if not xmt then
  begin
    rxf := tune.rx;
    rxs := tune.shift;
    rxm := tune.mode;
    if tune.rx_ofs < 144000000 then
      rxfreq(round(rxf+tune.rx_ofs),rxm,rxs)
    else
      rxfreq(round(rxf-tune.rx_ofs),rxm,rxs);
  end else begin
    txf := tune.tx;
    txs := tune.shift;
    txm := tune.mode;
    if tune.invert
    then
      case tune.mode of
      lsb: txm := usb;
      usb: txm := lsb;
      end; {case}
    if tune.tx_ofs < 144000000 then
      txfreq(round(txf+tune.tx_ofs),txm,txs)
    else
      txfreq(round(txf-tune.tx_ofs),txm,txs);
  end;
    {select appropriate transverters with RF switch}
{    if (rxf/txf < 1.1) and (rxf/txf > 0.9)
{    then select(tune.rxb,tune.txb,tune.polarization,xmte,not xmte) {HDX}
{    else select(tune.rxb,tune.txb,tune.polarization,xmte,true); {FDX}
end;
{Copyright 1999-2000 John B. Stephensen}
end.
