/*  HISTR.C  */
#include<math.h>

void est(int n,float xr[],float xi[],float smpfrq,
         float *ppeak,float *ppitch,float *pshift)
/*  Estimator of pitch and one (out of many possible) freq shift  */
/*  See "Cochannel" page B-21                                     */
/*  n;            Buffer size (power of 2)                        */
/*  xr[],xi[];    Real, imag buffers from ccor                    */
/*  smpfrq;       Sampling frequency                              */
/*  peak;         Peak power at speaker pitch                     */
/*  pitch;        Estimated speaker pitch                         */
/*  shift;        One possible frequency shift                    */
{
   float pi=3.14159265358979;
   float lolim,hilim; /* low, high limits for speaker_pitch search range */
   int lidx,hidx; /* low, high index limits for tau search range */
   float temp;
   int idx, idpk; /* index and index_to_peak                     */
   float bsq,usq; /* below_square and upper_square               */
   float x; /* fractional spacing of interpolated peak, -1<=x<=1 */
   float tau; /* sampling_frequency/speaker_pitch                */
   float cf1,cf2; /* coefficients for parabolic interpolation    */
   float partr,parti; /* real, imag, parts of ccor peak          */
   float angl; /* Shift_angle in radians versus speaker pitch    */
   
   lolim=50; /* Assumes speaker pitch >= 50 Hz */
   hilim=250; /* Assumes speaker pitch <= 250 Hz */
   lidx=smpfrq/hilim; /* hi pitch is low time delta  */
   if(lidx<4)lidx=4;
   hidx=smpfrq/lolim;
   if(hidx>n/2-2)hidx=n/2-2;
   *ppeak=0.;
   idpk=4;  /*  2-18-98  */
   for(idx=lidx;idx<=hidx;idx++)
   {
      temp=xr[idx]*xr[idx]+xi[idx]*xi[idx];
      if(*ppeak<temp)
      {
         *ppeak=temp;
         idpk=idx;
      }
   }
   /* Find quadratic-interpolation peak */
   bsq=xr[idpk-1]*xr[idpk-1]+xi[idpk-1]*xi[idpk-1];
   usq=xr[idpk+1]*xr[idpk+1]+xi[idpk+1]*xi[idpk+1];
   x=1.;
   if(*ppeak>usq)
      x=0.;
   if(bsq>=*ppeak)
      x=-1.;
   if(x==0.)
      x=0.5*(usq-bsq)/(2.* *ppeak-bsq-usq);
   tau=idpk+x;
   *ppitch=smpfrq/tau;
   /* Interpolate real and imag parts */
   cf1=0.5*(xr[idpk+1]-xr[idpk-1]);
   cf2=0.5*(xr[idpk-1]+xr[idpk+1])-xr[idpk];
   partr=xr[idpk]+x*(cf1+x*cf2);
   cf1=0.5*(xi[idpk+1]-xi[idpk-1]);
   cf2=0.5*(xi[idpk-1]+xi[idpk+1])-xi[idpk];
   parti=xi[idpk]+x*(cf1+x*cf2);
   *ppeak=partr*partr+parti*parti;
   /* calculate 4-quadrant arctangent (-pi/2 to 3pi/2) */
   if(partr>0.)
      angl=atan(parti/partr);
   if(partr==0.)
   {
      if(parti>=0.)
         angl=0.5*pi;
      else
         angl=-0.5*pi;
   }
   if(partr<0.)
      angl=pi-atan(-parti/partr);
   *pshift=*ppitch*angl/(2.*pi);
}
