*
* 9600-baud (G3RUH) BER test routines, with SINAD measurement
*
* Copyright (c) 1994, American Radio Relay League, Inc.
* All Rights Reserved
*
* J. Bloom, KE3Z
* 17 November, 1994
*
;-----------------------------------------------------------;
AIC_1	.set    00A14h  ;RA =TA = 5  0000101000010100 = 00A14h
AIC_2	.set    00025h  ;TA'=0 RA'= 9  0000000000100101 = 00025h
;AIC_2	.set    00205h  ;TA'=1 RA'= 1  000000100000000101 = 00205h
AIC_3	.set    0346ah  ;RB =TB =1Ah 0011010001101010 = 0346ah
AIC_CMD	.set    00083h  ;   COMMAND  0000000010000011 = 00083h
TEMP	.set	060h
BITLEN	.set	066h
	.ds	0600h
;
; Interrupt vector jump address location
jvect	.set	0fae0h
jvect+2	.set	0fae2h
; DSK_COMM routines
DRECV	.set	0fa16h
DXMIT	.set	0fa1ah
tmp1	.word	0
shift	.word	0
shift1	.word	0
sstate	.word	0
y1	.word	0
bstate	.word	0
MYBITL	.word	0fbh
func	.word	0
resp	.word	0
smpdly	.word	0
sdly	.word	17	; Sample delay
flags	.word	0
*
* Flag bit definitions
*
*	15	1 = Calib signal, 0 = bit stream
*	14	Respond with next sample value
*	13	Start-up delay active
*	12	Action flag--next sample is center of data bit
*	11	BER test running
*	10	4/8-byte response
*	9	8-byte response
*	8	Generate Test signal
clkcmd	.word	0
xsamp	.word	0
rsamp	.word	0
sudly	.word	0
tmp0	.word	0
invert	.word	0
one	.word	1
rvect	.word	0fae0h
outbit	.word	0
outbit+1	.word	0
errcnt	.word	0
errcnt+1	.word	0
tcount	.word	0
tcount+1	.word	0
g-1	.word	0
g-2	.word	0
;gc2	.q14	0.320956
gc2	.q14	0.597127
prnofs	.Q15	-0.164	; DC offset, PRN case
clkjit	.word	0

; Calibration function
STUP	.set	0	; Startup state
CWAIT	.set	1	; Settling time wait state
SMPSCN	.set	2	; Scan for sample delay
DLYSCN	.set	3	; Scan for clock advance/retard
; Calibraton constants
CALW	.set	1920	; # samples to wait for settling
;----------------------------------------------------------------
;    SECONDARY VECTOR TABLE LOACTED IN B0 PROGRAM RAM
;----------------------------------------------------------------
        .include  "mmregs.asm"  ;     > USERCODE SHOULD NOT OVERWRITE DSKD  <
        .ps     0fa00h          ;     > VECTORS.  ON LOAD, INT2 IS RESTORED <
        B       start           ;RS   > BY DSKD, BUT TRAP IS NOT            <
        B       start           ;INT0
        B       start           ;INT1
        B       start           ;INT2  > DSKD LOAD IGNORES INT2 VECTOR
        B       start           ;TINT
        B       RINT		;RINT  Branch to receive interrupt routine
        eint                    ;XINT  XINT is only for timing, so just return
        ret                     ;
	.ps	0fae0h
riber	b	berri		; BER interrupt
risin	b	sinadi		; SINAD interupt
      ; Begin TRAP/DSKD Kernal  ;DSKD load does not restore this code!
;----------------------------------------------------------------
;    APPLICATION CODE IS LOCATED ABOVE DSKD KERNAL
;----------------------------------------------------------------
	.ps	0FB00h
	.entry
start:	ldpk	0		; All direct addressing is to MMRs and B2
	fort	0		; Serial port : 16 bit
	rtxm			;             : ext. FSX
	sfsm			;             ; burst mode
	lack	080h		; AIC reset by pulsing /BR (Global Data)
	sach	DXR		; send 0 to DXR (AIC)
	sacl	GREG		; 256 * 100 nS /BR pulse
	lrlk    AR0,0FFFFh
	rptk	255		; read junk from address 0xFFFF
	lac	*,0,AR0
	conf	2
	sovm			; catch accumulator overflows

* Uncomment the following three lines to pick up the
* serial port speed from DSK_COMM
;	lac	BITLEN
;	ldpk	12
;	sacl	MYBITL
	ldpk	0
;--------------------------------
AIC_RS  lack    024h            ; Turn on XINT
        sacl    IMR             ;
        idle                    ;
        lalk    AIC_1           ; Load each AIC configuration word
        call    AIC_2nd         ; and load it into the AIC
        lalk    AIC_2           ;
        call    AIC_2nd         ;
        lalk    AIC_3           ;
        call    AIC_2nd         ;
        lalk    AIC_CMD         ;
        call    AIC_2nd         ;
;----------------------------------------------------------------
	rsxm

	ldpk	12
	zac
	sacl	IMR
	b	runit

; Receive and respond to new command

docmd:	ldpk	12
	call	RECV		; Get function command from host
	sacl	func		; Save function ID
	subk	043h		; C = calib
	bnz	docmd0
	lac	flags
	ork	1
	sacl	flags
	b	runit
docmd0	lac	func
	subk	049h		; I = Idle
	bnz	docmd1
	lalk	0ff6eh		; Reset calib and reporting flags
	b	icmd
docmd1	lac	func
	subk	034h		; 4,5 = BER test
	bz	ord4
	subk	1
	bnz	docmd2
	lalk	0186ah,4	; = 100000
	b	setord
ord4	lalk	10000
setord	sach	tcount
	sacl	tcount+1
	lalk	20000		; Set startup delay
	sacl	sudly
	zac
	sacl	errcnt
	sacl	errcnt+1
	lac	flags
	ork	010h		; Set BER reporting flag
	sacl	flags
	lalk	0ff7eh
icmd	and	flags
	sacl	flags
	b	runit
docmd2	lac	func		; + = increment sdly
	subk	02bh
	bnz	docmd3
	lac	sdly
	addk	1
	sacl	sdly
	b	runit
docmd3	lac	func		; - = decrement sdly
	subk	02dh
	bnz	docmd4
	lac	sdly
	subk	1
	bz	runit		; Don't go below 1
	sacl	sdly
	b	runit
docmd4:	lac	func		; V = report value
	subk	056h
	bnz	docmd5
	lac	flags
	ork	2
	sacl	flags
	lalk	20000
	sacl	sudly
	b	runit
docmd5:	lac	func		; A = advance rx clock
	subk	041h
	bnz	docmd6
	lack	2
	sacl	clkcmd
	b	runit
docmd6:	lac	func		; R = retard rx clock
	subk	052h
	bnz	docmd7
	lack	1
	sacl	clkcmd
	b	runit
docmd7:	lac	func
	subk	030h		; 0 = normal data, 1 = invert data
	bz	setinv
	subk	1
	bnz	docmd8
	lack	1
setinv	sacl	invert
	b	runit
docmd8	lac	func		; N = 1-kHz siNe wave
	subk	04eh
	bnz	docmd9
	zac
	b	docmd9a
docmd9	lac	func		; S = SINAD measurement
	subk	053h
	bnz	docmd10
	lalk	8192
docmd9a	sacl	tcount
	lalk	20000
	sacl	sudly
	zac
	sacl	resp
	sacl	y1
	sacl	sstate
	sacl	sumn
	sacl	sumn+1
	sacl	sumsn
	sacl	sumsn+1
; Init oscillator
	sacl	g-2
	lac	gc2
	sacl	g-1
	lalk	jvect+2
	sacl	rvect
	b	stint		; Start interrupts
docmd10	lac	func		; D = report debug value
	subk	044h
	bnz	docmd11
	lac	sdly		; Value to report
	call	XMIT16
	b	waity
docmd11	lac	func		; T = test signal
	subk	054h
	bnz	docmd12
	lac	flags
	andk	0ffeeh		; Clear calib and BER bits
	ork	080h		; Set test signal bit
	sacl	flags
	b	runit
docmd12	lac	func		; Q = quiet
	subk	051h
	bnz	docmd13
	zac
	ldpk	0
	sacl	DXR
	ldpk	12
	b	waity
docmd13:
; Init variables
runit:	zac
	sacl	resp		; No response yet
	sacl	bstate		; Start in bit state 0
	sacl	y1		; Init IIR filter storage
	lack	1		; Start in sample state 1
	sacl	sstate
	lalk	jvect		; BER interrupt processing
	sacl	rvect
; Enable RINTs to start processing
stint:
	ldpk	0
	lack    010h            ; AIC RINT
	sacl    IMR             ; where INT0 indicates EOC (End Of Conv)
; Idle loop. Just processes RINTs until BIO goes low (incoming
; command from host) or a response is generated by the interrupt
; processing routine.
AGN:	idle
	ldpk	12
	bioz	docomm		; Host wants a response
	lac	resp		; Need to send a response?
	bz	AGN		; No, loop
; Here to send delayed response and await another command
	ldpk	0
	zac
	sacl	IMR
	ldpk	12
	lac	resp
	call	XMIT16
	bit	flags,10	; 4/8-byte response?
	bbz	waity
	lac	errcnt+1
	call	XMIT16
	bit	flags,9		; 8-byte response?
	bbz	resres
	lac	sumsn
	call	XMIT16
	lac	sumsn+1
	call	XMIT16
resres:	lac	flags
	andk	0ff9fh		; Reset 4- and 8-byte-response flags
	sacl	flags
waity	bioz	docomm		; Get new command
	b	waity
; Here when host wants to talk to us. Respond with R(eady)
docomm:
	ldpk	0
	zac			;Turn off interrupts
	sacl	IMR
	ldpk	12
; A little delay to let the host's serial port recover
; from the last XF pulse sent during sampling
	lark	AR1,40
	larp	AR1
waitx	rptk	255		;wait 25.6 usec
	nop
	banz	waitx,*-
	lack	052h		; Send the response char
	call	XMIT
	b	docmd

;-----------------------------------------------------------------
*
* sinx/x correction coefficients
*
v1	.q14	-0.1049616
v1-1	.q14	1.1049616

RINT:
*
* I/O the sample values
*
	ldpk	12
	lac	xsamp
	ldpk	0
	sacl	DXR
	lac	DRR
	ldpk	12
	sacl	rsamp
*
* Count down the start-up delay, if any
*
	lac	flags		; Mark no delay happening
	andk	0fffbh
	sacl	flags
	lac	sudly
	bz	gori
	subk	1
	sacl	sudly
	bz	gori
	lac	flags		; Mark delay happening
	ork	4
	sacl	flags
gori:	lac	rvect
	bacc
*
* Here to continue RINT processing for BER test
*
berri:
*
* Count down the trigger delay
*
trig:
	lac	smpdly		; Waiting for trigger?
	bz	action		; No
	subk	1
	sacl	smpdly
	bnz	action
	rxf
	rptk	7
	nop
	sxf
	bit	flags,13	; In start-up delay?
	bbnz	genbit		; Yes
	lac	flags
	ork	8		; Next sample is "it"
	sacl	flags
	b	genbit
*
* Check if we need to act on this sample
*
action:	bit	flags,13	; Wait for start-up delay to finish
	bbnz	genbit
	bit	flags,12	; Time to act?
	bbz	genbit		; Not yet!
	lac	flags
	andk	0fff7h		; Reset action flag
	sacl	flags
	bit	flags,11	; BER sampling?
	bbz	nober
	lac	rsamp		; Save sign bit of input sample
	sfl
	sach	tmp1
	lac	sdly		; Get system sample delay count
	addk	1
	sfr			; Divide by 4 (samples/bit)
	sfr
	neg
	addk	31		; # shifts
	sacl	tmp0
	lar	AR1,tmp0
	larp	AR1
	zalh	outbit
	or	outbit+1
bsft	sfl
	banz	bsft,*-
	; Transmitted bit is in carry now
	zac
	bnc	ber1
	lack	1
ber1	xor	tmp1		; Compare transmitted and received bits
	andk	1
	xor	invert
	bnz	ber2
	zalh	errcnt
	or	errcnt+1
	addk	1
	sach	errcnt
	sacl	errcnt+1
ber2:	zalh	tcount		; Decrement test count
	or	tcount+1
	subk	1
	sach	tcount
	sacl	tcount+1
	bnz	genbit
	lac	errcnt		; End of BER test... report error count
	ork	08000h
	sacl	resp
	lac	flags
	andk	0ffefh		; Reset BER flag
	ork	020h		; Set 4-byte-response flag
	sacl	flags
	b	genbit
nober	bit	flags,14	; Report sample value to host?
	bbz	genbit		; No
	lac	rsamp
	sacl	resp
	lac	flags
	andk	0fffdh		; Reset report flag
	sacl	flags
genbit	lac	sstate		;Count down sample states...
	subk	1
	sacl	sstate
	bnz	bit0		;states 1,2,3: 0 sample
	lack	4
	sacl	sstate
; Get the next data bit and insert into filter
; (1 = +1, 0 = -1)
	bit	flags,15	; Calib signal
	bbnz	docal
	bit	flags,8		; Test signal?
	bbnz	dotest
	lac	sdly		; Set trigger/action delay
	andk	3
	addk	1
	sacl	smpdly
	call	SCGEN		;Get next random data bit
	sacl	tmp0
	zalh	outbit		; Get shift reg of tx'd bits
	or	outbit+1
	sfl			; Shift new bit into reg
	or	tmp0
	sach	outbit
	sacl	outbit+1
	lac	tmp0
	bz	bit0
bitp1	lalk	07fffh
	b	out0
bit0	zac
	b	out0
dotest	call	TESTGEN
	bz	bit0
	b	bitp1
docal	call	CALGEN
	bz	cbitm1
	lac	sdly
	sacl	smpdly
	lalk	07fffh
	b	out0
cbitm1	zac
;cout0	call	rcfilt
;	sach	tmp1,1
;	b	outcor
out0:
	call	rcfilt	;Run the raised-cosine filter
	sach	tmp1,1
	lac	tmp1
	add	prnofs
	sacl	tmp1,1
*
* sinx/x correction for F=38,400
*
outcor:	mac	v1-1,tmp1
	zac
	mac	v1,y1
	apac
	sach	y1,2
	lac	y1
finint:	andk	0fffch
	or	clkcmd
	sacl	xsamp
	zac
;	lac	clkjit
;	xork	1
;	sacl	clkjit
	sacl	clkcmd
	eint
	ret
******************************************************************
AIC_2nd adlk    6,15            ;set ACCU_hi = 3 for secondary XMIT
        idle                    ;Wait for a XINT
        sach    DXR             ;
        idle                    ;ACCU_hi requests 2nd XMIT
        sacl    DXR             ;
        idle                    ;ACCU_lo sets up registers
        sacl    DXR,2           ;close command with LSB = 00
        idle                    ;
        eint                    ;
        ret                     ;
;====================================================================
*
* Test signal generator. Returns 1 every other call.
*
TESTGEN:
	lac	bstate
	xork	1
	sacl	bstate
	andk	1
	ret
*
* Calibration generator. Returns a 1 of each 18th call,
* 0 or the other 8 calls.
*
CALGEN:
	lac	bstate
	bz	gen
	subk	1
	sacl	bstate
	zac
	ret
gen:
	lack	17
; lack 1
	sacl	bstate
	lack	1
	ret

* Scrambler: Generates a PRN bit stream
*
* D1 XOR D12 XOR D17
*
	.ds
sccnt	.word	0
	.ps
SCGEN:
;	lac	sccnt
;	xork	1
;	sacl	sccnt
;	andk	1
;	ret
	zalh	shift
	or	shift1
	sfl
	sach	shift
	sacl	shift1
	lac	shift1,4
	sach	tmp1
	lac	shift
	sfr
	xor	tmp1
	xork	1
	andk	1		; bit is in LSB
	or	shift1
	sacl	shift1
	andk	1	
	ret

; Raised-cosine filter

	.ds
rcxn	.word	0,0,0,0,0,0,0,0,0,0
	.word	0,0,0,0,0,0,0,0,0,0
	.word	0,0,0,0,0,0,0,0,0,0
	.word	0,0,0,0,0,0

; Filter coefficients

	.ps
	.include "rcfilt72.asm"
;	.include "pulse.dat"
	
; 36-TAP FIR FILTER CODE
; NOTE THAT THE DATA MUST BE IN INTERNAL MEMORY

rcfilt	larp	3
	lrlk	3,rcxn
	sacl	*
	adrk	35
	mac	rch0,*-
	zac
	rptk	34
	macd	rch1,*-
	apac
; RESULT IS IN HIGH ACCUM
	ret

; Serial I/O subroutines

	.ds
TEMPx	.word	0
WORD16	.word	0
	.ps
;============================================================
; RECV returns word in bottom 8 bits of ACCL
;============================================================
RECV16: call    RECV            ;recv LO
        sacl    WORD16          ;
        call    RECV            ;recv HI
        rptk    7               ;
        sfl                     ;build HI+LO
        or      WORD16          ;
	sacl    WORD16          ;
	ret                     ;
	;------------------------
;============================================================
; XMIT assumes word is in bottom 8 bits of ACCL
;============================================================
XMIT16: call    XMIT            ;xmit LO
	call    XMIT            ;xmit HI
	ret                     ;
RECV	ldpk	0
	call	DRECV
	ldpk	12
	ret
XMIT	ldpk	0
	call	DXMIT
	ldpk	12
	ret

; Interrupt processing for SINAD measurement

; Constants for sine-wave oscillator
gc1	.q14	1.8941882
m1	.q14	-1
*
* Constants for the notch filter
*
	.ds
ninsf	.q13	0.00195	; Input scale factor
; First second-order section
a11	.q13	-1.8964
a12	.q13	1
b11	.q13	1.8751
b12	.q13	-0.9795
; Second second-order section
a21	.q13	-1.8924
a22	.q13	1
b21	.q13	1.8909
b22	.q13	-0.9900
; Third second-order section
a31	.q13	-1.8944
a32	.q13	1
b31	.q13	1.8782
b32	.q13	-0.9894

d1	.word	0
d1m1	.word	0
d1m2	.word	0
d2	.word	0
d2m1	.word	0
d2m2	.word	0
d3	.word	0
d3m1	.word	0
d3m2	.word	0
sumsn	.word	0
sumsn+1	.word	0
sumn	.word	0
sumn+1	.word	0
	.ps

sinadi:	lac	sstate
	xork	1
	andk	1
	sacl	sstate
	bz	finint
*
* Generate the sine wave via oscillator
*
	ssxm
	mac	m1,g-2
	zac
	macd	gc1,g-1
	apac
	sach	g-1,2
	sach	tmp1,2
*
* Notch the input signal
*
	lt	rsamp
	mpy	ninsf
	pac
	lt	d1m1
	mpy	b11
	lta	d1m2
	mpy	b12
	apac
	sach	d1,3		;Store in Q15 format
	mpy	a12
	ltd	d1m1
	mpy	a11
	dmov	d1
	apac
;
	lt	d2m1
	mpy	b21
	lta	d2m2
	mpy	b22
	apac
	sach	d2,3		;Store in Q15 format
	mpy	a22
	ltd	d2m1
	mpy	a21
	dmov	d2
	apac
;
	lt	d3m1
	mpy	b31
	lta	d3m2
	mpy	b32
	apac
	sach	d3,3		;Store in Q15 format
	mpy	a32
	ltd	d3m1
	mpy	a31
	dmov	d3
	apac
	sfl
	sfl
	sfl
	sfl
	sfl
	sach	d1,7		; Filter output sample
	bit	flags,13	; In start-up delay?
	bbnz	outcor		; Yes, done
*
* Sum the squares of the sample values
*
	lt	rsamp		; Sum input signal (s+n)
	mpy	rsamp
	pac
	rptk	11
	sfr
	adds	sumsn+1
	addh	sumsn
	sach	sumsn
	sacl	sumsn+1
	lt	d1		; Sum filtered signal (n)
	mpy	d1
	pac
	rptk	11
	sfr
	adds	sumn+1
	addh	sumn
	sach	sumn
	sacl	sumn+1
*
* Check for end of test
*
	lac	tcount		; Decrement test count
	bz	outcor
	subk	1
	sacl	tcount
	bnz	outcor		; Keep going
	lac	sumn
	ork	08000h
	sacl	resp
	lac	sumn+1
 	sacl	errcnt+1
 	lac	flags		; Note 8-byte response
 	ork	060h
 	sacl	flags
	b	outcor
