/* Interrupt-driven serial input functions */

typedef struct
{
	int port;
	int base_addr;
	int intlev;
	unsigned int max_buffer;
	unsigned int buffer_in;
	unsigned int buffer_out;
	unsigned int buffer_length;
	unsigned int near_full;
	unsigned int near_empty;
	char bf_hndshk;
	char *buffer;
	char overrun_flag;
	char shake_type;
#define CM_RTS		1
#define CM_XOFF		2
	void interrupt (*oldfunc)();
	int portidx;
} COMM;

COMM *open_com(int cport, unsigned int baud, int parity, int stopbits,
	int numbits, int shaketype, unsigned int buflen);
void close_com(COMM *com);
void reset_buffer(COMM *com);
int com_in(COMM *com);
int send_com(COMM *com, char c, int handshake);
int comm_cd(COMM *com);
int comm_cts(COMM *com);
int comm_dsr(COMM *com);
void shut_down(COMM *com);
char *comm_errmsg(int errno);

extern int comm_errno;
#define CM_NOMEMORY		1
#define CM_TOOMANY		2
#define CM_INVALID		3
#define CM_OVERRUN		4
#define CM_TIMEOUT		5
#define CM_NERRCODE		5
