//	LSW30a.cpp for NJQRP DDS-30 - note four changes for DDS-60 at	*#*#*#*#*#*
//	written by Dr. Sam Green, W0PCE 
//	for the Fully Automated DDS Sweep Generator Measurement System 
/*
	This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
//	Logarithmic single sweep of DDS Frequency 
//	with ADC measurement of input 2 from log detector and Write to text file  
//
//  Enter frequency step size as an integer denominator (freq += freq/stepfractiondenominator) 
//	to control resolution  
//
//  Driver for MAXIM DAC110 serial A to D Converter with calibration procedure  
//  With +/-Vref set by LM385-1.2s to +/-1.234V volts, range is from -2.468V to +2.468V 
//	for a resolution of about 300 uV when running at 13 bit resolution plus sign   
//  timeout to prevent lock-up 
//  add dwell delay for low frequencies so log detector sees several cycles 

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>
#include <windows.h>

void delay (int ttime) ;
void delaym (long msecs) ;
void write40bits2d0 (int freqword, int phaseword) ;	// DDS
void cal (void) ;									// DDS
int writereaddatabits (int writeword);				// ADC 
void gotoxy (int x, int y) ;

clock_t start, now ,then, current, finish;

float RefClock = 100000000,	// 180000000 for 180MHz clock on DDS-30 *#*#*#*#*#*  
	  mult = 0x100000000/RefClock;  

const double 
	ADC14cal = 2.46670,
	ADC13cal = 2.46955, 
	ADC12cal = 2.46390 ; 

float floatreading;

int base	= 0x378,	// parallel port register addresses
	status	= base+1,
	control	= base+2,
	phaseword = 0x00,		   // phaseword = 0x01 for DDS-60		*#*#*#*#*#* 
	startword = 1000000*mult,  // default 1 MHz start
	endword   = 10000000*mult, // default 10 MHz end
	freqword = startword,
	writeword1	= 0x8100,	// input 1 and divide clock by 4 - replace five places to change input!!
	writeword2	= 0x8110,	// input 2 and divide clock by 4
	CONVbits	= 0x0600,	// default 13 bits and 50 measurements per second  
	CSactive	= 0xbf,	    // active low so set D6 = 0 
	CSinactive	= 0xff,	    // all ones
	ClockLow	= 0xdf,	    // set D5 = 0 
	DataBitLow	= 0xef,	    // set D4 = 0 
	DataBitHi	= 0xff;	    // all ones 

int value, tt=0, intreading, sign, overflow, cc, stepfractiondenominator = 20 ;

double  duration;

void main(int argc, char *argv[]) {
	system("CLS");

	if (argc < 2){	fprintf(stderr,"\nUsage: %s filename.txt [start] [end] [step-fraction-denominator]\n\n", argv[0]);
					puts("defaults are 1MHz, 10MHz, and 20, so each step is 5% higher in frequency.\n\nHit Control and C to cancel.\n\n"); exit(1);}
	FILE *fp; 
	if ((fp = fopen(argv[1],"w")) == NULL) {fprintf(stderr,"Can't open %s\n", argv[1]); exit(1);}
	freqword = startword;  

							// Single Sweep
	if (argc>2) {startword = mult*atoi(argv[2]); }; // enter start  
	if (argc>3) {endword   = mult*atoi(argv[3]); }; // enter end 
	if (endword < startword) {puts("Enter end frequency higher than start frequency!");_exit(2);}

									// change 3 to 6 for DDS-60		*#*#*#*#*#* 
	if (endword > 30000000*mult) exit(1); // comment out to remove limit 
	if (startword > endword) exit(1); 
	if (argc>4) stepfractiondenominator = atoi(argv[4]); 
	if (stepfractiondenominator > startword) {puts("step too small - decrease step-fraction-denominator\n");exit(3);}   

	gotoxy(1,3);printf("DDS-30");	//change 30 to 60 for DDS-60	*#*#*#*#*#*
	gotoxy(9,3);printf("\tStart Frequency		  = %10.1f Hz  ", (startword/mult));
	gotoxy(9,5);printf("\tEnd Frequency		  = %10.1f Hz  ", (endword/mult));
	gotoxy(9,7);printf("\tFrequency Change per Step = %f percent  ", 100/float(stepfractiondenominator));
	fprintf(fp," Frequency\t  dBm \n");
	fflush(fp);
	cal ();
									// begin frequency step loop 
	for(freqword = startword; freqword < endword; freqword += freqword/stepfractiondenominator) {
		write40bits2d0 (freqword, phaseword) ;									
		if(freqword < 0x28f5c3) delaym (5000*mult/freqword);
									// measure ADC and write to screen and file 		
		value = writereaddatabits (writeword2 | CONVbits);	// requests meas and returns previously requested meas
		value = writereaddatabits (writeword2 | CONVbits);	// so read twice to get current measurement!! 
		sign = value & 0x8000 ;
		overflow = value & 0x4000 ;
		intreading = 0xffffffff & value ; 
		if (sign == 0) intreading &= 0x000003fff; else intreading |= 0xffffc000; 
		floatreading = float (intreading * ADC13cal) / 0x3fff ; 
		gotoxy(9,10);printf("\tfrequency = %8.1f\t dBm =  %1.3f    \n\n", freqword/mult, 40*(floatreading-2.1)) ;  
		fprintf(fp," %8.1f\t%2.3f  ", freqword/mult, 40*(floatreading-2.1));
		if (sign != overflow <<1) fprintf(fp,"\tOverflow\n"); else fprintf(fp,"\n");
		fflush(fp);
}		}	

void cal (void) {											// 3 calibration procedure steps 
	int step1 = 0xc, step2 = 8, step3 = 4, value, tt; 
	
	value = writereaddatabits (writeword2 | CONVbits | step1);  
	while((tt=0x80&_inp(base+1)) != 0) ;	 
	value = writereaddatabits (writeword2 | CONVbits | step2);  
	while((tt=0x80&_inp(base+1)) != 0) ; 
	value = writereaddatabits (writeword2 | CONVbits | step3);  
	while((tt=0x80&_inp(base+1)) != 0) ;  
}

int writereaddatabits (int writeword) {  
int i, temp, writebyte, mask=0x10000, databit, dataword=0;
	_outp(base, CSactive & DataBitLow);			// pull CS low by writing a 0 to D6
	for(i=0; i<16; i++) {           
		writebyte = CSactive & ClockLow & DataBitLow; 
		_outp(base, writebyte);					// write clock low
		mask >>= 1 ; temp = writeword & mask ;	// setup data to write to Din - comes out MSB first
		if (temp==0) temp = DataBitHi; else temp = DataBitLow; 
		_outp(base, writebyte |= ~temp);
		_outp(base, writebyte|= ~ClockLow);		// write clock high 
		databit = 0x40 & _inp(base + 1) ;		// read data bit 6 from DOUT 
		if (databit != 0) {dataword |= mask;}	// build dataword one bit at a time from MSB to LSB 
		}	
	_outp(base, CSinactive & DataBitLow);		// pull CS hi 
	start = clock();
	while((tt=0x80 & _inp(base+1)) != 0) {if(clock() - start > 220) break;} // in milliseconds
	return dataword; 
}

void write40bits2d0 (int freqword, int phaseword) { // with clock to d1 & freq update strobe to d2
	int freqvar, i, writebit;
	freqvar = freqword ;
	for(i=1; i<33; i++) {           
		writebit = freqvar & 1; writebit |= 0xf0;	
		_outp(base, writebit);		// write bit
		_outp(base, writebit | 2);	// writeclock high
		_outp(base, writebit);	// writeclock low 
		freqvar >>= 1 ;
		}
	freqvar = phaseword ;  // all zeroes 
	for(i=1; i<9; i++) {           
		writebit = freqvar & 1;	writebit |= 0xf0; 
		_outp(base, writebit);		// write bit
		_outp(base, writebit | 2);	// writeclock high
		_outp(base, writebit);	// writeclock low 
		freqvar >>= 1 ;
		}
	_outp(base, 0xf4);	// frequency update stobe pulse high;  
	_outp(base, 0xf0);	// frequency update stobe pulse low;  
}

void gotoxy (int x, int y){
	HANDLE hdl;
	COORD coords;
	hdl = GetStdHandle(STD_OUTPUT_HANDLE);
	coords.X=x-1;
	coords.Y=y-1;
	SetConsoleCursorPosition(hdl,coords);
}

void delay (int ttime){ // short delay in fractions of a microsecond
	int i;
	for (i=0; i<ttime; i++) ;
}
	
void delaym (long msecs) {  // long delay in milliseconds
	clock_t now = clock();  // get current time
	clock_t then = now + CLOCKS_PER_SEC * (long)msecs/1000 ;
	while (now<then) now=clock() ;
}

