#include <math.h>

#define SWAP(a,b) tempr=(a); (a)=(b); (b)=tempr

void fourl(float data[], unsigned long nu, int isign)
// Replaces data[1. .2*nn] by its discrete Fourier transform, if isign is input as 1; or replaces
// data [1. .2*nn] by nn times its inverse discrete Fourier transform, if isign is input as -1.
// data is a complex array of length nn or, equivalently, a real array of length 2*nn. nn MUST
// be an integer power of 2 (this is not checked for!).
{
unsigned long n,mmax,m,j,istep,i;
double wtemp,wr,wpr,wpi,wi,theta;
float tempr.tempi;

   n=nn << 1;
   j=l;
   // This for loop scrambles the data so that the output will be computed in place
   for (i=1;i<n;i+=2)
   {
      if (j > i)
      {
         SWAP(data[j] ,data[i]);
         SWAP(data[j+l],data[i+l]);
      }
      m=nn;
      while ((m >= 2) && (j > m))
      {
         j -= m;
         m >>= 1;
      }
      j += m;
//    This is the bit-reversal section of the routine.
//    Exchange the two complex numbers.
   }
// Here begins the Danielson-Lanczos section of the routine.
   mmax=2;
   while (n > mmax)  // Outer loop executed log2 nn times.
   { 
      istep=mmax << 1;
      theta=isign* (6.28318530717959/mmax) ; //Initialize the trigonometric recurrence.
      vtemp=sin(O.5*theta);
      wpr = -2. O*vtem.p*vtem.p;
      vpi=sin(theta);
      wr=1.0;
      vi=O.O;
      for (m=l;m<mmax;m+=2) 
      {
         for (i=m;i<=n;i+=istep) 
         {
            j=i+mmax;
            tempr=wr*data[j]-wi*data[j+l];
            tempi=wr*data[j+l]+wi*data[j];
            data[j]=data[i]-tempr;
            data[j+l]=data[i+l]-tempi;
            data[i] += tempr;
            data[i+l] += tempi;
//          Here are the two nested inner loops.
//          This is the Danielson-Lanczos formula:
         }
         wr=(wtemp=wr)*wpr-wi*wpi+wr;  //       Trigonometric recurrence.
         wi=wi*wpr+wtemp*wpi+wi;
      }
   }
   mmax=istep;
}