using namespace std;  // must be declared first to get the header files to work correctly

#include <stdio.h>
#include <initguid.h>
#include <Dsound.h>
#include <vector>
#include <string>
#include <iostream>

#pragma hdrstop

#include "sdr.h"


AudioDevices input_audio_devices, output_audio_devices;




LPDIRECTSOUND p_output_object;

int main (void)
{
HRESULT status;
unsigned char    buffer[10000];
DWORD            bytes_read;
DWORD              i;
int            phase_accumulator = 0;
short          phase_values[10000];
int            table_index;

    status = user_input();
    if (status != 0)
    {
    	  return status;
    }
 
    status = setup_output_buffer();
    status = setup_input_buffer();

    // start the capture
    p_input_buffer->Start(DSCBSTART_LOOPING);
    // start the play back

    p_direct_sound_buffer->Play(0, 0, DSBPLAY_LOOPING);


    while (1)
    {
      status = read_input_data(buffer, &bytes_read);
      //cout << "bytes read " << bytes_read << endl;
      if (bytes_read > 0)
      {
         for (i=0; i < (bytes_read/2); i++)
         {
            table_index = phase_accumulator >> PHASE_DIVISOR;
//            cout << table_index << endl;
            phase_values[i++] =  phase_table[table_index];
            phase_values[i] =  phase_table[table_index];
            phase_accumulator += phase_increment;
            if(phase_accumulator > MAX_ACCUMULATOR)
            {
//               cout << "  " << table_index << endl;
            }
            phase_accumulator &= ACCUMULATOR_MASK;
         }
         memcpy(buffer, phase_values, bytes_read);
         status = write_output_data((unsigned char *)buffer, bytes_read);
      }
    }

    return 0;
}
