/*******************************************************************************
* File Name: PrISM.h
* Version 1.20
*
* Description:
*  This file provides constants and parameter values for the PrISM
*  Component.
*
* Note:
*
********************************************************************************
* Copyright 2008-2009, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PrISM_PrISM_H)    /* CY_PrISM_PrISM_H */
#define CY_PrISM_PrISM_H

#include "cytypes.h"
#include "cyfitter.h"


/***************************************
* Conditional Compilation Parameters
***************************************/

#define PrISM_RESOLUTION             10u
#define PrISM_PULSE_TYPE_HARDCODED   0u


/***************************************
*       Function Prototypes
***************************************/

void  PrISM_Start(void);
void  PrISM_Stop(void);
void  PrISM_SetPulse0Mode(uint8 pulse0Type);
void  PrISM_SetPulse1Mode(uint8 pulse1Type);
uint16 PrISM_ReadSeed(void);
void   PrISM_WriteSeed(uint16 seed);
uint16 PrISM_ReadPolynomial(void);
void   PrISM_WritePolynomial(uint16 polynomial);
uint16 PrISM_ReadPusle0(void);
void   PrISM_WritePulse0(uint16 pulseDesity0);
uint16 PrISM_ReadPusle1(void);
void   PrISM_WritePulse1(uint16 pulseDesity1);


/***************************************
*          API Constants
***************************************/

/* Constants for SetPulse0Mode(), SetPulse1Mode(), pulse type */
#define PrISM_LESSTHAN_OR_EQUAL      0x00u
#define PrISM_GREATERTHAN_OR_EQUAL   0x01u


/***************************************
*    Initial Parameter Constants
***************************************/

#define PrISM_POLYNOM                0x360u
#define PrISM_SEED                   0x3FFu
#define PrISM_DENSITY0               0x1u
#define PrISM_DENSITY1               0x1u


/***************************************
*              Registers
***************************************/

#if (PrISM_RESOLUTION  <= 8) /* 8bit - PrISM */
    #define PrISM_DENSITY0_REG       (* (reg8 *) PrISM_sC8_PrISMdp_u0__D0_REG)
    #define PrISM_DENSITY0_PTR       ((reg8 *) PrISM_sC8_PrISMdp_u0__D0_REG)
    #define PrISM_DENSITY1_REG       (* (reg8 *) PrISM_sC8_PrISMdp_u0__D1_REG)
    #define PrISM_DENSITY1_PTR       ((reg8 *) PrISM_sC8_PrISMdp_u0__D1_REG)
    #define PrISM_POLYNOM_REG        (* (reg8 *) PrISM_sC8_PrISMdp_u0__A1_REG)
    #define PrISM_POLYNOM_PTR        ((reg8 *) PrISM_sC8_PrISMdp_u0__A1_REG)
    #define PrISM_SEED_REG           (* (reg8 *) PrISM_sC8_PrISMdp_u0__A0_REG)
    #define PrISM_SEED_PTR           ((reg8 *) PrISM_sC8_PrISMdp_u0__A0_REG)
    #define PrISM_SEED_COPY_REG      (* (reg8 *) PrISM_sC8_PrISMdp_u0__F0_REG)
    #define PrISM_SEED_COPY_PTR      ((reg8 *) PrISM_sC8_PrISMdp_u0__F0_REG)
    #define PrISM_AUX_CONTROL_REG    (* (reg8 *) PrISM_sC8_PrISMdp_u0__DP_AUX_CTL_REG)
    #define PrISM_AUX_CONTROL_PTR    ((reg8 *) PrISM_sC8_PrISMdp_u0__DP_AUX_CTL_REG)
#elif (PrISM_RESOLUTION <= 16) /* 16bit - PrISM */
    #define PrISM_DENSITY0_REG       (* (reg16 *) PrISM_sC16_PrISMdp_u0__D0_REG)
    #define PrISM_DENSITY0_PTR       ((reg16 *) PrISM_sC16_PrISMdp_u0__D0_REG)
    #define PrISM_DENSITY1_REG       (* (reg16 *) PrISM_sC16_PrISMdp_u0__D1_REG)
    #define PrISM_DENSITY1_PTR       ((reg16 *) PrISM_sC16_PrISMdp_u0__D1_REG)
    #define PrISM_POLYNOM_REG        (* (reg16 *) PrISM_sC16_PrISMdp_u0__A1_REG)
    #define PrISM_POLYNOM_PTR        ((reg16 *) PrISM_sC16_PrISMdp_u0__A1_REG)
    #define PrISM_SEED_REG           (* (reg16 *) PrISM_sC16_PrISMdp_u0__A0_REG)
    #define PrISM_SEED_PTR           ((reg16 *) PrISM_sC16_PrISMdp_u0__A0_REG)
    #define PrISM_SEED_COPY_REG      (* (reg16 *) PrISM_sC16_PrISMdp_u0__F0_REG)
    #define PrISM_SEED_COPY_PTR      ((reg16 *) PrISM_sC16_PrISMdp_u0__F0_REG)
    #define PrISM_AUX_CONTROL_REG    (* (reg16 *) PrISM_sC16_PrISMdp_u0__DP_AUX_CTL_REG)
    #define PrISM_AUX_CONTROL_PTR    ((reg16 *) PrISM_sC16_PrISMdp_u0__DP_AUX_CTL_REG)
#elif (PrISM_RESOLUTION <= 24) /* 24bit - PrISM */
    #define PrISM_DENSITY0_REG       (* (reg32 *) PrISM_sC24_PrISMdp_u0__D0_REG)
    #define PrISM_DENSITY0_PTR       ((reg32 *) PrISM_sC24_PrISMdp_u0__D0_REG)
    #define PrISM_DENSITY1_REG       (* (reg32 *) PrISM_sC24_PrISMdp_u0__D1_REG)
    #define PrISM_DENSITY1_PTR       ((reg32 *) PrISM_sC24_PrISMdp_u0__D1_REG)
    #define PrISM_POLYNOM_REG        (* (reg32 *) PrISM_sC24_PrISMdp_u0__A1_REG)
    #define PrISM_POLYNOM_PTR        ((reg32 *) PrISM_sC24_PrISMdp_u0__A1_REG)
    #define PrISM_SEED_REG           (* (reg32 *) PrISM_sC24_PrISMdp_u0__A0_REG)
    #define PrISM_SEED_PTR           ((reg32 *) PrISM_sC24_PrISMdp_u0__A0_REG)
    #define PrISM_SEED_COPY_REG      (* (reg32 *) PrISM_sC24_PrISMdp_u0__F0_REG)
    #define PrISM_SEED_COPY_PTR      ((reg32 *) PrISM_sC24_PrISMdp_u0__F0_REG)
    #define PrISM_AUX_CONTROL_REG    (* (reg32 *) PrISM_sC24_PrISMdp_u0__DP_AUX_CTL_REG)
    #define PrISM_AUX_CONTROL_PTR    ((reg32 *) PrISM_sC24_PrISMdp_u0__DP_AUX_CTL_REG)
    #define PrISM_AUX_CONTROL2_REG   (* (reg32 *) PrISM_sC24_PrISMdp_u2__DP_AUX_CTL_REG)
    #define PrISM_AUX_CONTROL2_PTR   ((reg32 *) PrISM_sC24_PrISMdp_u2__DP_AUX_CTL_REG)
#else /* 32bit - PrISM */
    #define PrISM_DENSITY0_REG       (* (reg32 *) PrISM_sC32_PrISMdp_u0__D0_REG)
    #define PrISM_DENSITY0_PTR       ((reg32 *) PrISM_sC32_PrISMdp_u0__D0_REG)
    #define PrISM_DENSITY1_REG       (* (reg32 *) PrISM_sC32_PrISMdp_u0__D1_REG)
    #define PrISM_DENSITY1_PTR       ((reg32 *) PrISM_sC32_PrISMdp_u0__D1_REG)
    #define PrISM_POLYNOM_REG        (* (reg32 *) PrISM_sC32_PrISMdp_u0__A1_REG)
    #define PrISM_POLYNOM_PTR        ((reg32 *) PrISM_sC32_PrISMdp_u0__A1_REG)
    #define PrISM_SEED_REG           (* (reg32 *) PrISM_sC32_PrISMdp_u0__A0_REG)
    #define PrISM_SEED_PTR           ((reg32 *) PrISM_sC32_PrISMdp_u0__A0_REG)
    #define PrISM_SEED_COPY_REG      (* (reg32 *) PrISM_sC32_PrISMdp_u0__F0_REG)
    #define PrISM_SEED_COPY_PTR      ((reg32 *) PrISM_sC32_PrISMdp_u0__F0_REG)
    #define PrISM_AUX_CONTROL_REG    (* (reg32 *) PrISM_sC32_PrISMdp_u0__DP_AUX_CTL_REG)
    #define PrISM_AUX_CONTROL_PTR    ((reg32 *) PrISM_sC32_PrISMdp_u0__DP_AUX_CTL_REG)
    #define PrISM_AUX_CONTROL2_REG   (* (reg32 *) PrISM_sC32_PrISMdp_u2__DP_AUX_CTL_REG)
    #define PrISM_AUX_CONTROL2_PTR   ((reg32 *) PrISM_sC32_PrISMdp_u2__DP_AUX_CTL_REG)
#endif /* End PrISM_RESOLUTION */

#define PrISM_CONTROL                (* (reg8 *) PrISM_ctrl_CtrlReg__CONTROL_REG )
#define PrISM_CONTROL_PTR            ( (reg8 *) PrISM_ctrl_CtrlReg__CONTROL_REG )


/***************************************
*       Register Constants
***************************************/

#define PrISM_CTRL_ENABLE                                0x01u
#define PrISM_CTRL_COMPARE_TYPE0_GREATER_THAN_OR_EQUAL   0x02u
#define PrISM_CTRL_COMPARE_TYPE1_GREATER_THAN_OR_EQUAL   0x04u

#define PrISM_FIFO0_CLR                                  0x01u

#endif  /* End CY_PrISM_PrISM_H */


/* [] END OF FILE */
