/*******************************************************************************
* File Name: PWM_DACI.h  
* Version 1.10
*
* Description:
*  Contains the prototypes and constants for the functions available to the 
*  PWM user module.
*
* Note:
*
********************************************************************************
* Copyright 2008-2009, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/



#include "cytypes.h"
#include "cyfitter.h"

#if !defined(CY_PWM_PWM_DACI_H)
#define CY_PWM_PWM_DACI_H

#define PWM_DACI_Resolution 16
#define PWM_DACI_UsingFixedFunction 0
#define PWM_DACI_DeadBandMode 0
#define PWM_DACI_KillModeMinTime 0
#define PWM_DACI_KillMode 0
#define PWM_DACI_PWMMode 0
#define PWM_DACI_PWMModeIsCenterAligned 0
#define PWM_DACI_DeadBandUsed 0
#define PWM_DACI_DeadBand2_4 0
#if !defined(PWM_DACI_PWMUDB_sSTSReg_stsreg__REMOVED)
    #define PWM_DACI_UseStatus 1
#else
    #define PWM_DACI_UseStatus 0
#endif
#if !defined(PWM_DACI_PWMUDB_sCTRLReg_ctrlreg__REMOVED)
    #define PWM_DACI_UseControl 1
#else
    #define PWM_DACI_UseControl 0
#endif
#define PWM_DACI_UseOneCompareMode 1
#define PWM_DACI_MinimumKillTime 1
#define PWM_DACI_EnableMode 0

#define PWM_DACI_CompareMode1SW 0
#define PWM_DACI_CompareMode2SW 0

/* Use Kill Mode Enumerated Types */
#define PWM_DACI__B_PWM__DISABLED 0
#define PWM_DACI__B_PWM__ASYNCHRONOUS 1
#define PWM_DACI__B_PWM__SINGLECYCLE 2
#define PWM_DACI__B_PWM__LATCHED 3
#define PWM_DACI__B_PWM__MINTIME 4


/* Use Dead Band Mode Enumerated Types */
#define PWM_DACI__B_PWM__DBMDISABLED 0
#define PWM_DACI__B_PWM__DBM_2_4_CLOCKS 1
#define PWM_DACI__B_PWM__DBM_256_CLOCKS 2


/* Used PWM Mode Enumerated Types */
#define PWM_DACI__B_PWM__ONE_OUTPUT 0
#define PWM_DACI__B_PWM__TWO_OUTPUTS 1
#define PWM_DACI__B_PWM__DUAL_EDGE 2
#define PWM_DACI__B_PWM__CENTER_ALIGN 3
#define PWM_DACI__B_PWM__DITHER 5
#define PWM_DACI__B_PWM__HARDWARESELECT 4


/* Used PWM Compare Mode Enumerated Types */
#define PWM_DACI__B_PWM__LESS_THAN 1
#define PWM_DACI__B_PWM__LESS_THAN_OR_EQUAL 2
#define PWM_DACI__B_PWM__GREATER_THAN 3
#define PWM_DACI__B_PWM__GREATER_THAN_OR_EQUAL_TO 4
#define PWM_DACI__B_PWM__EQUAL 0
#define PWM_DACI__B_PWM__FIRMWARE 5


/***************************************
 *   Function Prototypes
 **************************************/
void    PWM_DACI_Start(void);
void    PWM_DACI_Stop(void);
void    PWM_DACI_SetInterruptMode(uint8 interruptMode);
uint8   PWM_DACI_GetInterruptSource(void);
#if (PWM_DACI_UseStatus || PWM_DACI_UsingFixedFunction)
	uint8   PWM_DACI_ReadStatusRegister(void);
#endif
#if (PWM_DACI_UseControl)
	uint8   PWM_DACI_ReadControlRegister(void);
	void    PWM_DACI_WriteControlRegister(uint8 control);
#endif
#if PWM_DACI_UseOneCompareMode
	#if PWM_DACI_CompareMode1SW
	void    PWM_DACI_SetCompareMode(uint8 comparemode);
	#endif
#else
	#if PWM_DACI_CompareMode1SW
	void    PWM_DACI_SetCompareMode1(uint8 comparemode);
	#endif
	#if PWM_DACI_CompareMode2SW
	void    PWM_DACI_SetCompareMode2(uint8 comparemode);
	#endif
#endif

#if (!PWM_DACI_UsingFixedFunction)
uint16   PWM_DACI_ReadCounter(void);
uint16  PWM_DACI_ReadCapture(void);
#if (PWM_DACI_UseStatus)
void PWM_DACI_ClearFIFO(void);
#endif
#endif

void    PWM_DACI_WriteCounter(uint16 counter);
void    PWM_DACI_WritePeriod(uint16 period);
uint16   PWM_DACI_ReadPeriod(void);
#if PWM_DACI_UseOneCompareMode
    void    PWM_DACI_WriteCompare(uint16 compare);
    uint16   PWM_DACI_ReadCompare(void);
#else
    void    PWM_DACI_WriteCompare1(uint16 compare);
    uint16   PWM_DACI_ReadCompare1(void);
    void    PWM_DACI_WriteCompare2(uint16 compare);
    uint16   PWM_DACI_ReadCompare2(void);
#endif


#if (PWM_DACI_DeadBandUsed)
	void    PWM_DACI_WriteDeadTime(uint8 deadtime);
	uint8   PWM_DACI_ReadDeadTime(void);
#endif

#if ( PWM_DACI_KillModeMinTime)
	void PWM_DACI_WriteKillTime(uint8 killtime);
	uint8 PWM_DACI_ReadKillTime(void);
#endif

/***************************************
 *    Initialization Values
 **************************************/
#define PWM_DACI_INIT_PERIOD_VALUE        1024
#define PWM_DACI_INIT_COMPARE_VALUE1      127
#define PWM_DACI_INIT_COMPARE_VALUE2      63
#define PWM_DACI_INIT_INTERRUPTS_MODE     ((0 << PWM_DACI_STATUS_TC_INT_EN_MASK_SHIFT) | (0 << PWM_DACI_STATUS_CMP2_INT_EN_MASK_SHIFT) | (0 << PWM_DACI_STATUS_CMP1_INT_EN_MASK_SHIFT ) | (0 << PWM_DACI_STATUS_KILL_INT_EN_MASK_SHIFT ))
#define PWM_DACI_DEFAULT_COMPARE2_MODE    (1 << PWM_DACI_CTRL_CMPMODE2_SHIFT)
#define PWM_DACI_DEFAULT_COMPARE1_MODE    (1 << PWM_DACI_CTRL_CMPMODE1_SHIFT)
#define PWM_DACI_INIT_DEAD_TIME           1

/********************************
 ******     Registers       *****
 ******************************** */

#if (PWM_DACI_UsingFixedFunction)
   #define PWM_DACI_PERIOD_LSB      (*(reg16 *) PWM_DACI_PWMHW__PER0)
   #define PWM_DACI_PERIOD_LSB_PTR   ((reg16 *) PWM_DACI_PWMHW__PER0)
   #define PWM_DACI_COMPARE1_LSB    (*(reg16 *) PWM_DACI_PWMHW__CNT_CMP0)
   #define PWM_DACI_COMPARE1_LSB_PTR ((reg16 *) PWM_DACI_PWMHW__CNT_CMP0)
   #define PWM_DACI_COMPARE2_LSB     0x00u
   #define PWM_DACI_COMPARE2_LSB_PTR 0x00u
   #define PWM_DACI_COUNTER_LSB     (*(reg16 *) PWM_DACI_PWMHW__CNT_CMP0)
   #define PWM_DACI_COUNTER_LSB_PTR  ((reg16 *) PWM_DACI_PWMHW__CNT_CMP0)
   #define PWM_DACI_CAPTURE_LSB     (*(reg16 *) PWM_DACI_PWMHW__CAP0)
   #define PWM_DACI_CAPTURE_LSB_PTR  ((reg16 *) PWM_DACI_PWMHW__CAP0)
   
#else
   #if(PWM_DACI_PWMModeIsCenterAligned)
       #define PWM_DACI_PERIOD_LSB      (*(reg16 *) PWM_DACI_PWMUDB_sP16_pwmdp_u0__D1_REG)
       #define PWM_DACI_PERIOD_LSB_PTR   ((reg16 *) PWM_DACI_PWMUDB_sP16_pwmdp_u0__D1_REG)
   #else
       #define PWM_DACI_PERIOD_LSB      (*(reg16 *) PWM_DACI_PWMUDB_sP16_pwmdp_u0__F0_REG)
       #define PWM_DACI_PERIOD_LSB_PTR   ((reg16 *) PWM_DACI_PWMUDB_sP16_pwmdp_u0__F0_REG)
   #endif
   #define PWM_DACI_COMPARE1_LSB    (*(reg16 *) PWM_DACI_PWMUDB_sP16_pwmdp_u0__D0_REG)
   #define PWM_DACI_COMPARE1_LSB_PTR ((reg16 *) PWM_DACI_PWMUDB_sP16_pwmdp_u0__D0_REG)
   #define PWM_DACI_COMPARE2_LSB    (*(reg16 *) PWM_DACI_PWMUDB_sP16_pwmdp_u0__D1_REG)
   #define PWM_DACI_COMPARE2_LSB_PTR ((reg16 *) PWM_DACI_PWMUDB_sP16_pwmdp_u0__D1_REG)
   #define PWM_DACI_COUNTERCAP_LSB   *(reg16 *) PWM_DACI_PWMUDB_sP16_pwmdp_u0__A1_REG)
   #define PWM_DACI_COUNTERCAP_LSB_PTR ((reg16 *) PWM_DACI_PWMUDB_sP16_pwmdp_u0__A1_REG)
   #define PWM_DACI_COUNTER_LSB     (*(reg16 *) PWM_DACI_PWMUDB_sP16_pwmdp_u0__A0_REG)
   #define PWM_DACI_COUNTER_LSB_PTR  ((reg16 *) PWM_DACI_PWMUDB_sP16_pwmdp_u0__A0_REG)
   #define PWM_DACI_CAPTURE_LSB     (*(reg16 *) PWM_DACI_PWMUDB_sP16_pwmdp_u0__F1_REG)
   #define PWM_DACI_CAPTURE_LSB_PTR  ((reg16 *) PWM_DACI_PWMUDB_sP16_pwmdp_u0__F1_REG)
   #define PWM_DACI_AUX_CONTROLDP0      (*(reg8 *) PWM_DACI_PWMUDB_sP16_pwmdp_u0__DP_AUX_CTL_REG)
   #define PWM_DACI_AUX_CONTROLDP0_PTR  ((reg8 *) PWM_DACI_PWMUDB_sP16_pwmdp_u0__DP_AUX_CTL_REG)
   #if (PWM_DACI_Resolution == 16)
       #define PWM_DACI_AUX_CONTROLDP1    (*(reg8 *) PWM_DACI_PWMUDB_sP16_pwmdp_u1__DP_AUX_CTL_REG)
       #define PWM_DACI_AUX_CONTROLDP1_PTR  ((reg8 *) PWM_DACI_PWMUDB_sP16_pwmdp_u1__DP_AUX_CTL_REG)
   #endif
#endif
   
#if(PWM_DACI_KillModeMinTime )
    #define PWM_DACI_KILLMODEMINTIME      (*(reg8 *) PWM_DACI_PWMUDB_sKM_killmodecounterdp_u0__D0_REG)
    #define PWM_DACI_KILLMODEMINTIME_PTR   ((reg8 *) PWM_DACI_PWMUDB_sKM_killmodecounterdp_u0__D0_REG)
    /* Fixed Function Block has no Kill Mode parameters because it is Asynchronous only */
#endif

#if(PWM_DACI_DeadBandMode == PWM_DACI__B_PWM__DBM_256_CLOCKS)
    #define PWM_DACI_DEADBAND_COUNT        (*(reg8 *) PWM_DACI_PWMUDB_sDB255_deadbandcounterdp_u0__D0_REG)
    #define PWM_DACI_DEADBAND_COUNT_PTR     ((reg8 *) PWM_DACI_PWMUDB_sDB255_deadbandcounterdp_u0__D0_REG)
#elif(PWM_DACI_DeadBandMode == PWM_DACI__B_PWM__DBM_2_4_CLOCKS)
    /* In Fixed Function Block these bits are in the control blocks control register */
    #if (PWM_DACI_UsingFixedFunction)
        #define PWM_DACI_DEADBAND_COUNT        (*(reg8 *) PWM_DACI_PWMHW__CFG0) 
        #define PWM_DACI_DEADBAND_COUNT_PTR     ((reg8 *) PWM_DACI_PWMHW__CFG0)
        #define PWM_DACI_DEADBAND_COUNT_MASK    (0x03u << PWM_DACI_DEADBAND_COUNT_SHIFT) 
        #define PWM_DACI_DEADBAND_COUNT_SHIFT   0x06u /* As defined by the Register Map as DEADBAND_PERIOD[1:0] in CFG0 */ 
    #else
        /* Lower two bits of the added control register define the count 1-3 */
        #define PWM_DACI_DEADBAND_COUNT        (*(reg8 *) PWM_DACI_PWMUDB_sDB3_dbctrlreg__CONTROL_REG)
        #define PWM_DACI_DEADBAND_COUNT_PTR     ((reg8 *) PWM_DACI_PWMUDB_sDB3_dbctrlreg__CONTROL_REG)
        #define PWM_DACI_DEADBAND_COUNT_MASK    (0x03u << PWM_DACI_DEADBAND_COUNT_SHIFT) 
        #define PWM_DACI_DEADBAND_COUNT_SHIFT   0x00u /* As defined by the verilog implementation of the Control Register */
    #endif
#endif



#if (PWM_DACI_UsingFixedFunction)
    #define PWM_DACI_STATUS                (*(reg8 *) PWM_DACI_PWMHW__SR0)
    #define PWM_DACI_STATUS_MASK           (*(reg8 *) PWM_DACI_PWMHW__SR0)
    #define PWM_DACI_CONTROL               (*(reg8 *) PWM_DACI_PWMHW__CFG0)
    #define PWM_DACI_CONTROL2              (*(reg8 *) PWM_DACI_PWMHW__CFG1)
    #define PWM_DACI_GLOBAL_ENABLE         (*(reg8 *) PWM_DACI_PWMHW__PM_ACT_CFG)

    /***********************************
    *     Constants
    ***********************************/
    /* Fixed Function Block Chosen */
    #define PWM_DACI_BLOCK_EN_MASK          PWM_DACI_PWMHW__PM_ACT_MSK
    /* Control Register definitions */
    #define PWM_DACI_CTRL_ENABLE_SHIFT      0x00u
    #define PWM_DACI_CTRL_RESET_SHIFT       0x00u   /* Not available in Fixed Function Block */
    #define PWM_DACI_CTRL_CMPMODE2_SHIFT    0x00u   /* Not available in Fixed Function Block */
    #define PWM_DACI_CTRL_CMPMODE1_SHIFT    0x01u   /* As defined by Register map as MODE_CFG bits in CFG1*/
    #define PWM_DACI_CTRL_DEAD_TIME_SHIFT   0x06u   /* As defined by Register map */
    /* Fixed Function Block Only CFG register bit definitions */
    #define PWM_DACI_CFG0_MODE              0x03u   /* Enable the block to run and set to compare mode */
    #define PWM_DACI_CFG0_DB                0x20u   /* As defined by Register map as DB bit in CFG0 */

    /* Control Register Bit Masks */
    #define PWM_DACI_CTRL_ENABLE            (0x01u << PWM_DACI_CTRL_ENABLE_SHIFT)
    #define PWM_DACI_CTRL_RESET             (0x01u << PWM_DACI_CTRL_RESET_SHIFT)
    #define PWM_DACI_CTRL_CMPMODE2_MASK     (0x07u << PWM_DACI_CTRL_CMPMODE2_SHIFT)
    #define PWM_DACI_CTRL_CMPMODE1_MASK     (0x07u << PWM_DACI_CTRL_CMPMODE1_SHIFT)
    
    /* Control2 Register Bit Masks */
    #define PWM_DACI_CTRL2_IRQ_SEL_SHIFT    0x00u       /* As defined in Register Map, Part of the TMRX_CFG1 register */
    #define PWM_DACI_CTRL2_IRQ_SEL          (0x01u << PWM_DACI_CTRL2_IRQ_SEL_SHIFT)  
    
    /* Status Register Bit Locations */
    #define PWM_DACI_STATUS_KILL_SHIFT          0x00u   /* Not available in Fixed Function Block */
    #define PWM_DACI_STATUS_FIFONEMPTY_SHIFT    0x00u   /* Not available in Fixed Function Block */
    #define PWM_DACI_STATUS_FIFOFULL_SHIFT      0x00u   /* Not available in Fixed Function Block */
    #define PWM_DACI_STATUS_TC_SHIFT            0x07u   /* As defined by Register map as TC in SR0 */
    #define PWM_DACI_STATUS_CMP2_SHIFT          0x00u   /* Not available in Fixed Function Block */
    #define PWM_DACI_STATUS_CMP1_SHIFT          0x06u   /* As defined by the Register map as CAP_CMP in SR0 */
    /* Status Register Interrupt Enable Bit Locations */
    #define PWM_DACI_STATUS_KILL_INT_EN_MASK_SHIFT          (0x00u)    /* Not available in Fixed Function Block */
    #define PWM_DACI_STATUS_FIFONEMPTY_INT_EN_MASK_SHIFT    (0x00u)   /* Not available in Fixed Function Block */
    #define PWM_DACI_STATUS_FIFOFULL_INT_EN_MASK_SHIFT      (0x00u)   /* Not available in Fixed Function Block */
    #define PWM_DACI_STATUS_TC_INT_EN_MASK_SHIFT            (PWM_DACI_STATUS_TC_SHIFT - 4)
    #define PWM_DACI_STATUS_CMP2_INT_EN_MASK_SHIFT          (0x00u)   /* Not available in Fixed Function Block */
    #define PWM_DACI_STATUS_CMP1_INT_EN_MASK_SHIFT          (PWM_DACI_STATUS_CMP1_SHIFT - 4)
    /* Status Register Bit Masks */
    #define PWM_DACI_STATUS_KILL            (0x00u) /* Not available in Fixed Function Block */
    #define PWM_DACI_STATUS_FIFONEMPTY      (0x00u) /* Not available in Fixed Function Block */
    #define PWM_DACI_STATUS_FIFOFULL        (0x00u) /* Not available in Fixed Function Block */
    #define PWM_DACI_STATUS_TC              (0x01u << PWM_DACI_STATUS_TC_SHIFT)
    #define PWM_DACI_STATUS_CMP2            (0x00u) /* Not available in Fixed Function Block */
    #define PWM_DACI_STATUS_CMP1            (0x01u << PWM_DACI_STATUS_CMP1_SHIFT)
    /* Status Register Interrupt Bit Masks*/
    #define PWM_DACI_STATUS_KILL_INT_EN_MASK            (0x00u) /* Not available in Fixed Function Block */
    #define PWM_DACI_STATUS_FIFONEMPTY_INT_EN_MASK      (0x00u) /* Not available in Fixed Function Block */
    #define PWM_DACI_STATUS_FIFOFULL_INT_EN_MASK        (0x00u) /* Not available in Fixed Function Block */
    #define PWM_DACI_STATUS_TC_INT_EN_MASK              (PWM_DACI_STATUS_TC >> 4)
    #define PWM_DACI_STATUS_CMP2_INT_EN_MASK            (0x00u) /* Not available in Fixed Function Block */
    #define PWM_DACI_STATUS_CMP1_INT_EN_MASK            (PWM_DACI_STATUS_CMP1 >> 4)

    /* Datapath Auxillary Control Register definitions */
    //#define PWM_DACI_AUX_CTRL_FIFO0_CLR         0x01u   /* As defined by Register map */
    //#define PWM_DACI_AUX_CTRL_FIFO1_CLR       0x02u   /* As defined by Register map */
    //#define PWM_DACI_AUX_CTRL_FIFO0_LVL       0x04u   /* As defined by Register map */
    //#define PWM_DACI_AUX_CTRL_FIFO1_LVL       0x08u   /* As defined by Register map */
    //#define PWM_DACI_STATUS_ACTL_INT_EN_MASK    0x10u   /* As defined for the ACTL Register */
#else
    #define PWM_DACI_STATUS                (*(reg8 *) PWM_DACI_PWMUDB_sSTSReg_stsreg__STATUS_REG )
    #define PWM_DACI_STATUS_MASK           (*(reg8 *) PWM_DACI_PWMUDB_sSTSReg_stsreg__MASK_REG)
    #define PWM_DACI_STATUS_AUX_CTRL       (*(reg8 *) PWM_DACI_PWMUDB_sSTSReg_stsreg__STATUS_AUX_CTL_REG)
    #define PWM_DACI_CONTROL               (*(reg8 *) PWM_DACI_PWMUDB_sCTRLReg_ctrlreg__CONTROL_REG)
    /***********************************
    *     Constants
    ***********************************/
    /* Control Register definitions */
    #define PWM_DACI_CTRL_ENABLE_SHIFT      0x07u
    #define PWM_DACI_CTRL_RESET_SHIFT       0x06u
    #define PWM_DACI_CTRL_CMPMODE2_SHIFT    0x03u
    #define PWM_DACI_CTRL_CMPMODE1_SHIFT    0x00u
	#define PWM_DACI_CTRL_DEAD_TIME_SHIFT   0x00u   /* No Shift Needed for UDB block */
    /* Control Register Bit Masks */
    #define PWM_DACI_CTRL_ENABLE            (0x01u << PWM_DACI_CTRL_ENABLE_SHIFT)
    #define PWM_DACI_CTRL_RESET             (0x01u << PWM_DACI_CTRL_RESET_SHIFT)
    #define PWM_DACI_CTRL_CMPMODE2_MASK     (0x07u << PWM_DACI_CTRL_CMPMODE2_SHIFT)
    #define PWM_DACI_CTRL_CMPMODE1_MASK     (0x07u << PWM_DACI_CTRL_CMPMODE1_SHIFT) 
    
    /* Status Register Bit Locations */
    #define PWM_DACI_STATUS_KILL_SHIFT          0x05u
    #define PWM_DACI_STATUS_FIFONEMPTY_SHIFT    0x04u
    #define PWM_DACI_STATUS_FIFOFULL_SHIFT      0x03u  
    #define PWM_DACI_STATUS_TC_SHIFT            0x02u
    #define PWM_DACI_STATUS_CMP2_SHIFT          0x01u
    #define PWM_DACI_STATUS_CMP1_SHIFT          0x00u
    /* Status Register Interrupt Enable Bit Locations - UDB Status Interrupt Mask match Status Bit Locations*/
    #define PWM_DACI_STATUS_KILL_INT_EN_MASK_SHIFT          PWM_DACI_STATUS_KILL_SHIFT          
    #define PWM_DACI_STATUS_FIFONEMPTY_INT_EN_MASK_SHIFT    PWM_DACI_STATUS_FIFONEMPTY_SHIFT    
    #define PWM_DACI_STATUS_FIFOFULL_INT_EN_MASK_SHIFT      PWM_DACI_STATUS_FIFOFULL_SHIFT        
    #define PWM_DACI_STATUS_TC_INT_EN_MASK_SHIFT            PWM_DACI_STATUS_TC_SHIFT            
    #define PWM_DACI_STATUS_CMP2_INT_EN_MASK_SHIFT          PWM_DACI_STATUS_CMP2_SHIFT          
    #define PWM_DACI_STATUS_CMP1_INT_EN_MASK_SHIFT          PWM_DACI_STATUS_CMP1_SHIFT   
    /* Status Register Bit Masks */
    #define PWM_DACI_STATUS_KILL            (0x00u << PWM_DACI_STATUS_KILL_SHIFT )
    #define PWM_DACI_STATUS_FIFOFULL        (0x01u << PWM_DACI_STATUS_FIFOFULL_SHIFT)
    #define PWM_DACI_STATUS_FIFONEMPTY      (0x01u << PWM_DACI_STATUS_FIFONEMPTY_SHIFT)
    #define PWM_DACI_STATUS_TC              (0x01u << PWM_DACI_STATUS_TC_SHIFT)
    #define PWM_DACI_STATUS_CMP2            (0x01u << PWM_DACI_STATUS_CMP2_SHIFT) 
    #define PWM_DACI_STATUS_CMP1            (0x01u << PWM_DACI_STATUS_CMP1_SHIFT)
    /* Status Register Interrupt Bit Masks  - UDB Status Interrupt Mask match Status Bit Locations */
    #define PWM_DACI_STATUS_KILL_INT_EN_MASK            PWM_DACI_STATUS_KILL
    #define PWM_DACI_STATUS_FIFOFULL_INT_EN_MASK        PWM_DACI_STATUS_FIFOFULL
    #define PWM_DACI_STATUS_FIFONEMPTY_INT_EN_MASK      PWM_DACI_STATUS_FIFONEMPTY
    #define PWM_DACI_STATUS_TC_INT_EN_MASK              PWM_DACI_STATUS_TC
    #define PWM_DACI_STATUS_CMP2_INT_EN_MASK            PWM_DACI_STATUS_CMP2
    #define PWM_DACI_STATUS_CMP1_INT_EN_MASK            PWM_DACI_STATUS_CMP1
                                                          
    /* Datapath Auxillary Control Register definitions */
    #define PWM_DACI_AUX_CTRL_FIFO0_CLR     0x01u
    #define PWM_DACI_AUX_CTRL_FIFO1_CLR     0x02u
    #define PWM_DACI_AUX_CTRL_FIFO0_LVL     0x04u
    #define PWM_DACI_AUX_CTRL_FIFO1_LVL     0x08u
    #define PWM_DACI_STATUS_ACTL_INT_EN_MASK  0x10u /* As defined for the ACTL Register */
#endif /* PWM_DACI_UsingFixedFunction */

#endif  /* CY_PWM_PWM_DACI_H */
