/*******************************************************************************
* File Name: CG_SCL.c  
* Version 1.50
*
* Description:
*  This file contains API to enable firmware control of a Pins component.
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#include "cytypes.h"
#include "CG_SCL.h"


/*******************************************************************************
* Function Name: CG_SCL_Write
********************************************************************************
* Summary:
*  Assign a new value to the digital port's data output register.  
*
* Parameters:  
*  prtValue:  The value to be assigned to the Digital Port. 
*
* Return: 
*  void 
*  
*******************************************************************************/
void CG_SCL_Write(uint8 value) 
{
    uint8 staticBits = CG_SCL_DR & ~CG_SCL_MASK;
    CG_SCL_DR = staticBits | ((value << CG_SCL_SHIFT) & CG_SCL_MASK);
}


/*******************************************************************************
* Function Name: CG_SCL_SetDriveMode
********************************************************************************
* Summary:
*  Change the drive mode on the pins of the port.
* 
* Parameters:  
*  mode:  Change the pins to this drive mode.
*
* Return: 
*  void
*
*******************************************************************************/
void CG_SCL_SetDriveMode(uint8 mode) 
{
	CyPins_SetPinDriveMode(CG_SCL_0, mode);
}


/*******************************************************************************
* Function Name: CG_SCL_Read
********************************************************************************
* Summary:
*  Read the current value on the pins of the Digital Port in right justified 
*  form.
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value of the Digital Port as a right justified number
*  
* Note:
*  Macro CG_SCL_ReadPS calls this function. 
*  
*******************************************************************************/
uint8 CG_SCL_Read(void) 
{
    return (CG_SCL_PS & CG_SCL_MASK) >> CG_SCL_SHIFT;
}


/*******************************************************************************
* Function Name: CG_SCL_ReadDataReg
********************************************************************************
* Summary:
*  Read the current value assigned to a Digital Port's data output register
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value assigned to the Digital Port's data output register
*  
*******************************************************************************/
uint8 CG_SCL_ReadDataReg(void) 
{
    return (CG_SCL_DR & CG_SCL_MASK) >> CG_SCL_SHIFT;
}


/* If Interrupts Are Enabled for this Pins component */ 
#if defined(CG_SCL_INTSTAT) 

    /*******************************************************************************
    * Function Name: CG_SCL_ClearInterrupt
    ********************************************************************************
    * Summary:
    *  Clears any active interrupts attached to port and returns the value of the 
    *  interrupt status register.
    *
    * Parameters:  
    *  void 
    *
    * Return: 
    *  Returns the value of the interrupt status register
    *  
    *******************************************************************************/
    uint8 CG_SCL_ClearInterrupt(void) 
    {
        return (CG_SCL_INTSTAT & CG_SCL_MASK) >> CG_SCL_SHIFT;
    }

#endif /* If Interrupts Are Enabled for this Pins component */ 


/* [] END OF FILE */ 
