 
//`#start header` -- edit after this line, do not edit this line
// ========================================
//
// Copyright SIMPLE CIRCUITS INC., 2010
// All Rights Reserved
// UNPUBLISHED, LICENSED SOFTWARE.
//
// CONFIDENTIAL AND PROPRIETARY INFORMATION
// WHICH IS THE PROPERTY OF Simple Circuits Inc.
//
// ========================================
`include "cypress.v"
//`#end` -- edit above this line, do not edit this line
// Generated on 11/14/2010 at 21:24
// Component: FracN
module FracN (
	CarryOut,
	Clk
);
	output  CarryOut;
	input   Clk;

//`#start body` -- edit after this line, do not edit this line


//----------------------------------------------------------------------------
//
//	SIMPLE SDR RECEIVER PSoC3 FIRMWARE for Hardware Rev -
//
//	Copyright 2011 Simple Circuits Inc.
//
//	04/26/2011	Original release.
//
//	Fractional N Sigma Delta Modulator
//	2nd Order
//
//----------------------------------------------------------------------------
	
	wire [7:0] pllN;
	wire [7:0] fHigh;
	wire [7:0] fLow;
	wire [13:0] frac = {fHigh [5:0], fLow [7:0]};
	wire resetAcc = fHigh [7];				// msb of fHigh resets accumulators
	reg [13:0] acc1;						// accumulators
	reg [13:0] acc2;
	wire [14:0] adder1 = acc1 + frac;		// adders
	wire [14:0] adder2 = acc2 + adder1 [13:0];
	reg minus1;
	reg signed [6:0] pOut;					// PLL P register output
	wire CarryOut = minus1;

	cy_psoc3_control #(.cy_init_value (8'h15), .cy_force_order(1))
	PLL_N (		/* output [7:0] */	.control(pllN));
	
	cy_psoc3_control #(.cy_init_value (8'h80), .cy_force_order(1))
	FracHi (	/* output [7:0] */	.control(fHigh));

	cy_psoc3_control #(.cy_init_value (8'h00), .cy_force_order(1))
	FracLo (	/* output [7:0] */	.control(fLow));

	cy_psoc3_status #(.cy_force_order(1), .cy_md_select(8'h00))	// transparent bits
	PLL_P_Reg (	// /* input */				.clock(Clk),		// if transparent, no clock is needed
				/* input [7:0] */		.status( {1'b0, pOut} ));
	
	always @(posedge Clk)
	begin
		acc1 <= {14{~resetAcc}} & adder1 [13:0];
		acc2 <= {14{~resetAcc}} & adder2 [13:0];
		minus1 <= adder2 [14];
		pOut <= pllN [6:0] + {6'b0, adder1 [14]} + {6'b0, adder2 [14]} + {7{minus1}};
	end


//`#end` -- edit above this line, do not edit this line
endmodule
//`#start footer` -- edit after this line, do not edit this line
//`#end` -- edit above this line, do not edit this line
