/*******************************************************************************
* File Name: VDAC.h  
* Version 1.60
*
*  Description:
*    This file contains the function prototypes and constants used in
*    the 8-bit Voltage DAC (vDAC8) User Module.
*
*   Note:
*     
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#if !defined(CY_VDAC8_VDAC_H) 
#define CY_VDAC8_VDAC_H

#include "cytypes.h"
#include "cyfitter.h"


/* PSoC3 ES2 or early */
#define VDAC_PSOC3_ES2  ((CYDEV_CHIP_MEMBER_USED == CYDEV_CHIP_MEMBER_3A)    && \
                                    (CYDEV_CHIP_REVISION_USED <= CYDEV_CHIP_REVISION_3A_ES2))                    
/* PSoC5 ES1 or early */
#define VDAC_PSOC5_ES1  ((CYDEV_CHIP_MEMBER_USED == CYDEV_CHIP_MEMBER_5A)    && \
                                    (CYDEV_CHIP_REVISION_USED <= CYDEV_CHIP_REVISION_5A_ES1))
/* PSoC3 ES3 or later */
#define VDAC_PSOC3_ES3  ((CYDEV_CHIP_MEMBER_USED == CYDEV_CHIP_MEMBER_3A)    && \
                                    (CYDEV_CHIP_REVISION_USED > CYDEV_CHIP_REVISION_3A_ES2))
/* PSoC5 ES2 or later */
#define VDAC_PSOC5_ES2  ((CYDEV_CHIP_MEMBER_USED == CYDEV_CHIP_MEMBER_5A)    && \
                                    (CYDEV_CHIP_REVISION_USED > CYDEV_CHIP_REVISION_5A_ES1))


/***************************************
*       Type defines
***************************************/

/* Sleep Mode API Support */
typedef struct VDAC_backupStruct
{
    uint8 enableState; 
	uint8 data_value;
}VDAC_backupStruct;


/***************************************
*        Function Prototypes 
***************************************/

void VDAC_Start(void);
void VDAC_Stop(void)            ;
void VDAC_SetSpeed(uint8 speed) ;
void VDAC_SetRange(uint8 range) ;
void VDAC_SetValue(uint8 value) ;
void VDAC_DacTrim(void)         ;
void VDAC_Init(void)            ;
void VDAC_Enable(void)          ;
void VDAC_SaveConfig(void);
void VDAC_RestoreConfig(void);
void VDAC_Sleep(void);
void VDAC_Wakeup(void)          ;
  
  
/***************************************
*            API Constants
***************************************/

/* SetRange constants */

#define VDAC_RANGE_1V       0x00u
#define VDAC_RANGE_4V       0x04u


/* Power setting for Start API  */
#define VDAC_LOWSPEED       0x00u
#define VDAC_HIGHSPEED      0x02u


/***************************************
*  Initialization Parameter Constants
***************************************/

#define VDAC_DEFAULT_RANGE    0     /* Default DAC range */
#define VDAC_DEFAULT_SPEED    0     /* Default DAC speed */
#define VDAC_DEFAULT_CNTL     0x00u             /* Default Control */
#define VDAC_DEFAULT_STRB     0    /* Default Strobe mode */
#define VDAC_DEFAULT_DATA     100  /* Initial DAC value */
#define VDAC_DEFAULT_DATA_SRC 0    /* Default Data Source */


/***************************************
*              Registers        
***************************************/

#define VDAC_CR0         (* (reg8 *) VDAC_viDAC8__CR0 )
#define VDAC_CR1         (* (reg8 *) VDAC_viDAC8__CR1 )
#define VDAC_Data        (* (reg8 *) VDAC_viDAC8__D )
#define VDAC_Data_PTR    (  (reg8 *) VDAC_viDAC8__D )
#define VDAC_Strobe      (* (reg8 *) VDAC_viDAC8__STROBE )
#define VDAC_SW0         (* (reg8 *) VDAC_viDAC8__SW0 )
#define VDAC_SW2         (* (reg8 *) VDAC_viDAC8__SW2 )
#define VDAC_SW3         (* (reg8 *) VDAC_viDAC8__SW3 )
#define VDAC_SW4         (* (reg8 *) VDAC_viDAC8__SW4 )
#define VDAC_TR          (* (reg8 *) VDAC_viDAC8__TR )
#define VDAC_PWRMGR      (* (reg8 *) VDAC_viDAC8__PM_ACT_CFG )  /* Power manager */
#define VDAC_STBY_PWRMGR (* (reg8 *) VDAC_viDAC8__PM_STBY_CFG )  /* Standby Power manager */


/***************************************
*         Register Constants       
***************************************/

/* CR0 vDac Control Register 0 definitions */

/* Bit Field  DAC_HS_MODE                  */
#define VDAC_HS_MASK        0x02u
#define VDAC_HS_LOWPOWER    0x00u
#define VDAC_HS_HIGHSPEED   0x02u

/* Bit Field  DAC_MODE                  */
#define VDAC_MODE_MASK      0x10u
#define VDAC_MODE_V         0x00u
#define VDAC_MODE_I         0x10u

/* Bit Field  DAC_RANGE                  */
#define VDAC_RANGE_MASK     0x0Cu
#define VDAC_RANGE_0        0x00u
#define VDAC_RANGE_1        0x04u

/* CR1 iDac Control Register 1 definitions */

/* Bit Field  DAC_MX_DATA                  */
#define VDAC_SRC_MASK       0x20u
#define VDAC_SRC_REG        0x00u
#define VDAC_SRC_UDB        0x20u

/* This bit enable reset from UDB array      */
#define VDAC_RESET_MASK     0x10u
#define VDAC_RESET_ENABLE   0x10u
#define VDAC_RESET_DISABLE  0x00u

/* This bit enables data from DAC bus      */
#define VDAC_DACBUS_MASK     0x20u
#define VDAC_DACBUS_ENABLE   0x20u
#define VDAC_DACBUS_DISABLE  0x00u

/* DAC STROBE Strobe Control Register definitions */

/* Bit Field  DAC_MX_STROBE                  */
#define VDAC_STRB_MASK     0x08u
#define VDAC_STRB_EN       0x08u
#define VDAC_STRB_DIS      0x00u

/* PM_ACT_CFG (Active Power Mode CFG Register)     */ 
#define VDAC_ACT_PWR_EN   VDAC_viDAC8__PM_ACT_MSK /* Power enable mask */ 
#define VDAC_STBY_PWR_EN  VDAC_viDAC8__PM_STBY_MSK  /* Standby Power enable mask */


/***********************************************************************************
*              Trim    
* Note - VDAC trim values are stored in the "Customer Table" area in 
* Row 1 of the Hidden Flash.  There are 8 bytes of trim data for each VDAC block.
* The values are:
*       I Gain offset, min range, Sourcing
*       I Gain offset, min range, Sinking
*       I Gain offset, med range, Sourcing
*       I Gain offset, med range, Sinking
*       I Gain offset, max range, Sourcing
*       I Gain offset, max range, Sinking
*       V Gain offset, 1V range
*       V Gain offset, 4V range
*
* The data set for the 4 VDACs are arranged using a left side/right side approach:
*   Left 0, Left 1, Right 0, Right 1.
* When mapped to the VDAC0 thru VDAC3 as:
*   VDAC 0, VDAC 2, VDAC 1, VDAC 3
************************************************************************************/
#define VDAC_TRIM_M7_1V_RNG_OFFSET  0x06u
#define VDAC_TRIM_M8_4V_RNG_OFFSET  0x07u

#define VDAC_DAC_TRIM_BASE     (VDAC_viDAC8__TRIM__M1)

#endif /* CY_VDAC8_VDAC_H  */


/* [] END OF FILE */


