/*******************************************************************************
* File Name: TP_DEBUG.h  
* Version 1.50
*
* Description:
*  This file containts Control Register function prototypes and register defines
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#if !defined(CY_PINS_TP_DEBUG_H) /* Pins TP_DEBUG_H */
#define CY_PINS_TP_DEBUG_H

#include "cytypes.h"
#include "cyfitter.h"
#include "cypins.h"
#include "TP_DEBUG_aliases.h"


/***************************************
*        Function Prototypes             
***************************************/    

void    TP_DEBUG_Write(uint8 value) ;
void    TP_DEBUG_SetDriveMode(uint8 mode) ;
uint8   TP_DEBUG_ReadDataReg(void) ;
uint8   TP_DEBUG_Read(void) ;
uint8   TP_DEBUG_ClearInterrupt(void) ;

/***************************************
*           API Constants        
***************************************/

/* Drive Modes */
#define TP_DEBUG_DM_ALG_HIZ         PIN_DM_ALG_HIZ
#define TP_DEBUG_DM_DIG_HIZ         PIN_DM_DIG_HIZ
#define TP_DEBUG_DM_RES_UP          PIN_DM_RES_UP
#define TP_DEBUG_DM_RES_DWN         PIN_DM_RES_DWN
#define TP_DEBUG_DM_OD_LO           PIN_DM_OD_LO
#define TP_DEBUG_DM_OD_HI           PIN_DM_OD_HI
#define TP_DEBUG_DM_STRONG          PIN_DM_STRONG
#define TP_DEBUG_DM_RES_UPDWN       PIN_DM_RES_UPDWN

/* Digital Port Constants */
#define TP_DEBUG_MASK               TP_DEBUG__MASK
#define TP_DEBUG_SHIFT              TP_DEBUG__SHIFT
#define TP_DEBUG_WIDTH              1u

/***************************************
*             Registers        
***************************************/

/* Main Port Registers */
/* Pin State */
#define TP_DEBUG_PS                     (* (reg8 *) TP_DEBUG__PS)
/* Data Register */
#define TP_DEBUG_DR                     (* (reg8 *) TP_DEBUG__DR)
/* Port Number */
#define TP_DEBUG_PRT_NUM                (* (reg8 *) TP_DEBUG__PRT) 
/* Connect to Analog Globals */                                                  
#define TP_DEBUG_AG                     (* (reg8 *) TP_DEBUG__AG)                       
/* Analog MUX bux enable */
#define TP_DEBUG_AMUX                   (* (reg8 *) TP_DEBUG__AMUX) 
/* Bidirectional Enable */                                                        
#define TP_DEBUG_BIE                    (* (reg8 *) TP_DEBUG__BIE)
/* Bit-mask for Aliased Register Access */
#define TP_DEBUG_BIT_MASK               (* (reg8 *) TP_DEBUG__BIT_MASK)
/* Bypass Enable */
#define TP_DEBUG_BYP                    (* (reg8 *) TP_DEBUG__BYP)
/* Port wide control signals */                                                   
#define TP_DEBUG_CTL                    (* (reg8 *) TP_DEBUG__CTL)
/* Drive Modes */
#define TP_DEBUG_DM0                    (* (reg8 *) TP_DEBUG__DM0) 
#define TP_DEBUG_DM1                    (* (reg8 *) TP_DEBUG__DM1)
#define TP_DEBUG_DM2                    (* (reg8 *) TP_DEBUG__DM2) 
/* Input Buffer Disable Override */
#define TP_DEBUG_INP_DIS                (* (reg8 *) TP_DEBUG__INP_DIS)
/* LCD Common or Segment Drive */
#define TP_DEBUG_LCD_COM_SEG            (* (reg8 *) TP_DEBUG__LCD_COM_SEG)
/* Enable Segment LCD */
#define TP_DEBUG_LCD_EN                 (* (reg8 *) TP_DEBUG__LCD_EN)
/* Slew Rate Control */
#define TP_DEBUG_SLW                    (* (reg8 *) TP_DEBUG__SLW)

/* DSI Port Registers */
/* Global DSI Select Register */
#define TP_DEBUG_PRTDSI__CAPS_SEL       (* (reg8 *) TP_DEBUG__PRTDSI__CAPS_SEL) 
/* Double Sync Enable */
#define TP_DEBUG_PRTDSI__DBL_SYNC_IN    (* (reg8 *) TP_DEBUG__PRTDSI__DBL_SYNC_IN) 
/* Output Enable Select Drive Strength */
#define TP_DEBUG_PRTDSI__OE_SEL0        (* (reg8 *) TP_DEBUG__PRTDSI__OE_SEL0) 
#define TP_DEBUG_PRTDSI__OE_SEL1        (* (reg8 *) TP_DEBUG__PRTDSI__OE_SEL1) 
/* Port Pin Output Select Registers */
#define TP_DEBUG_PRTDSI__OUT_SEL0       (* (reg8 *) TP_DEBUG__PRTDSI__OUT_SEL0) 
#define TP_DEBUG_PRTDSI__OUT_SEL1       (* (reg8 *) TP_DEBUG__PRTDSI__OUT_SEL1) 
/* Sync Output Enable Registers */
#define TP_DEBUG_PRTDSI__SYNC_OUT       (* (reg8 *) TP_DEBUG__PRTDSI__SYNC_OUT) 


#if defined(TP_DEBUG__INTSTAT)  /* Interrupt Registers */

    #define TP_DEBUG_INTSTAT                (* (reg8 *) TP_DEBUG__INTSTAT)
    #define TP_DEBUG_SNAP                   (* (reg8 *) TP_DEBUG__SNAP)

#endif /* Interrupt Registers */

#endif /* End Pins TP_DEBUG_H */


/* [] END OF FILE */
