/*******************************************************************************
* File Name: TP2_OUT.h  
* Version 1.50
*
* Description:
*  This file containts Control Register function prototypes and register defines
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#if !defined(CY_PINS_TP2_OUT_H) /* Pins TP2_OUT_H */
#define CY_PINS_TP2_OUT_H

#include "cytypes.h"
#include "cyfitter.h"
#include "cypins.h"
#include "TP2_OUT_aliases.h"


/***************************************
*        Function Prototypes             
***************************************/    

void    TP2_OUT_Write(uint8 value) ;
void    TP2_OUT_SetDriveMode(uint8 mode) ;
uint8   TP2_OUT_ReadDataReg(void) ;
uint8   TP2_OUT_Read(void) ;
uint8   TP2_OUT_ClearInterrupt(void) ;

/***************************************
*           API Constants        
***************************************/

/* Drive Modes */
#define TP2_OUT_DM_ALG_HIZ         PIN_DM_ALG_HIZ
#define TP2_OUT_DM_DIG_HIZ         PIN_DM_DIG_HIZ
#define TP2_OUT_DM_RES_UP          PIN_DM_RES_UP
#define TP2_OUT_DM_RES_DWN         PIN_DM_RES_DWN
#define TP2_OUT_DM_OD_LO           PIN_DM_OD_LO
#define TP2_OUT_DM_OD_HI           PIN_DM_OD_HI
#define TP2_OUT_DM_STRONG          PIN_DM_STRONG
#define TP2_OUT_DM_RES_UPDWN       PIN_DM_RES_UPDWN

/* Digital Port Constants */
#define TP2_OUT_MASK               TP2_OUT__MASK
#define TP2_OUT_SHIFT              TP2_OUT__SHIFT
#define TP2_OUT_WIDTH              1u

/***************************************
*             Registers        
***************************************/

/* Main Port Registers */
/* Pin State */
#define TP2_OUT_PS                     (* (reg8 *) TP2_OUT__PS)
/* Data Register */
#define TP2_OUT_DR                     (* (reg8 *) TP2_OUT__DR)
/* Port Number */
#define TP2_OUT_PRT_NUM                (* (reg8 *) TP2_OUT__PRT) 
/* Connect to Analog Globals */                                                  
#define TP2_OUT_AG                     (* (reg8 *) TP2_OUT__AG)                       
/* Analog MUX bux enable */
#define TP2_OUT_AMUX                   (* (reg8 *) TP2_OUT__AMUX) 
/* Bidirectional Enable */                                                        
#define TP2_OUT_BIE                    (* (reg8 *) TP2_OUT__BIE)
/* Bit-mask for Aliased Register Access */
#define TP2_OUT_BIT_MASK               (* (reg8 *) TP2_OUT__BIT_MASK)
/* Bypass Enable */
#define TP2_OUT_BYP                    (* (reg8 *) TP2_OUT__BYP)
/* Port wide control signals */                                                   
#define TP2_OUT_CTL                    (* (reg8 *) TP2_OUT__CTL)
/* Drive Modes */
#define TP2_OUT_DM0                    (* (reg8 *) TP2_OUT__DM0) 
#define TP2_OUT_DM1                    (* (reg8 *) TP2_OUT__DM1)
#define TP2_OUT_DM2                    (* (reg8 *) TP2_OUT__DM2) 
/* Input Buffer Disable Override */
#define TP2_OUT_INP_DIS                (* (reg8 *) TP2_OUT__INP_DIS)
/* LCD Common or Segment Drive */
#define TP2_OUT_LCD_COM_SEG            (* (reg8 *) TP2_OUT__LCD_COM_SEG)
/* Enable Segment LCD */
#define TP2_OUT_LCD_EN                 (* (reg8 *) TP2_OUT__LCD_EN)
/* Slew Rate Control */
#define TP2_OUT_SLW                    (* (reg8 *) TP2_OUT__SLW)

/* DSI Port Registers */
/* Global DSI Select Register */
#define TP2_OUT_PRTDSI__CAPS_SEL       (* (reg8 *) TP2_OUT__PRTDSI__CAPS_SEL) 
/* Double Sync Enable */
#define TP2_OUT_PRTDSI__DBL_SYNC_IN    (* (reg8 *) TP2_OUT__PRTDSI__DBL_SYNC_IN) 
/* Output Enable Select Drive Strength */
#define TP2_OUT_PRTDSI__OE_SEL0        (* (reg8 *) TP2_OUT__PRTDSI__OE_SEL0) 
#define TP2_OUT_PRTDSI__OE_SEL1        (* (reg8 *) TP2_OUT__PRTDSI__OE_SEL1) 
/* Port Pin Output Select Registers */
#define TP2_OUT_PRTDSI__OUT_SEL0       (* (reg8 *) TP2_OUT__PRTDSI__OUT_SEL0) 
#define TP2_OUT_PRTDSI__OUT_SEL1       (* (reg8 *) TP2_OUT__PRTDSI__OUT_SEL1) 
/* Sync Output Enable Registers */
#define TP2_OUT_PRTDSI__SYNC_OUT       (* (reg8 *) TP2_OUT__PRTDSI__SYNC_OUT) 


#if defined(TP2_OUT__INTSTAT)  /* Interrupt Registers */

    #define TP2_OUT_INTSTAT                (* (reg8 *) TP2_OUT__INTSTAT)
    #define TP2_OUT_SNAP                   (* (reg8 *) TP2_OUT__SNAP)

#endif /* Interrupt Registers */

#endif /* End Pins TP2_OUT_H */


/* [] END OF FILE */
