/*******************************************************************************
* File Name: PRS.h
* Version 1.30
*
* Description:
*  This file provides constants and parameter values for the PRS Component.
*
* Note:
*  None
*
*********************************************************************************
* Copyright 2008-2009, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/


#if !defined(CY_PRS_PRS_H)
#define CY_PRS_PRS_H

#include "cytypes.h"
#include "cyfitter.h"


/***************************************
*   Conditional Compilation Parameters
****************************************/

#define PRS_PRS_SIZE        8u
#define PRS_RUN_MODE        0u

/***************************************
*        Function Prototypes
****************************************/

void PRS_Start(void);
void PRS_Stop(void);
#if (PRS_RUN_MODE)
    void PRS_Step(void);
#endif

#if (PRS_PRS_SIZE <= 32)    /* 8-32bit - PRS */
    uint8 PRS_Read(void);
    void PRS_WriteSeed(uint8 seed);
    uint8 PRS_ReadPolynomial(void);
    void PRS_WritePolynomial(uint8 polynomial);
#else    /* 64bits - PRS */
    uint8 PRS_ReadUpper(void);
    uint8 PRS_ReadLower(void);
    void PRS_WriteSeedUpper(uint32 seed);
    void PRS_WriteSeedLower(uint32 seed);
    uint32 PRS_ReadPolynomialUpper(void);
    uint32 PRS_ReadPolynomialLower(void);
    void PRS_WritePolynomialUpper(uint32 polynomial);
    void PRS_WritePolynomialLower(uint32 polynomial);
#endif


/***************************************
*    Initial Parameter Constants
***************************************/

#if (PRS_PRS_SIZE <= 32)
    #define PRS_DEFAULT_POLYNOM           0xB8u
    #define PRS_DEFAULT_SEED              0x80u
#else
    #define PRS_DEFAULT_POLYNOM_LOWER      0xB8u
    #define PRS_DEFAULT_POLYNOM_UPPER      0x0u
    #define PRS_DEFAULT_SEED_LOWER         0x80u
    #define PRS_DEFAULT_SEED_UPPER         0x0u
#endif /* PRS_PRS_SIZE */


/***************************************
*             Registers
***************************************/

#if (PRS_PRS_SIZE <= 8)    /* 8bits - PRS */
    #define PRS_POLYNOM_A__D0_REG          (*(reg8 *) PRS_PRSdp_a__D0_REG )
    #define PRS_POLYNOM_A__D0_REG_PTR      ((reg8 *) PRS_PRSdp_a__D0_REG )
    #define PRS_SEED_A__A0_REG             (*(reg8 *) PRS_PRSdp_a__A0_REG )
    #define PRS_SEED_A__A0_REG_PTR         ((reg8 *) PRS_PRSdp_a__A0_REG )
    
#elif (PRS_PRS_SIZE <= 16)    /* 16bits - PRS */
    #define PRS_POLYNOM_A__D1_REG          (*(reg8 *) PRS_PRSdp_a__D1_REG )
    #define PRS_POLYNOM_A__D1_REG_PTR      ((reg8 *) PRS_PRSdp_a__D1_REG )
    #define PRS_POLYNOM_A__D0_REG          (*(reg8 *) PRS_PRSdp_a__D0_REG )
    #define PRS_POLYNOM_A__D0_REG_PTR      ((reg8 *) PRS_PRSdp_a__D0_REG )
    
    #define PRS_SEED_A__A1_REG             (*(reg8 *) PRS_PRSdp_a__A1_REG )
    #define PRS_SEED_A__A1_REG_PTR         ((reg8 *) PRS_PRSdp_a__A1_REG )
    #define PRS_SEED_A__A0_REG             (*(reg8 *) PRS_PRSdp_a__A0_REG )
    #define PRS_SEED_A__A0_REG_PTR         ((reg8 *) PRS_PRSdp_a__A0_REG )
    
#elif (PRS_PRS_SIZE <= 24)    /* 24bits - PRS */
    #define PRS_POLYNOM_B__D1_REG          (*(reg8 *) PRS_b1_PRSdp_b__D1_REG )
    #define PRS_POLYNOM_B__D1_REG_PTR      ((reg8 *) PRS_b1_PRSdp_b__D1_REG )
    #define PRS_POLYNOM_B__D0_REG          (*(reg8 *) PRS_b1_PRSdp_b__D0_REG )
    #define PRS_POLYNOM_B__D0_REG_PTR      ((reg8 *) PRS_b1_PRSdp_b__D0_REG )
    #define PRS_POLYNOM_A__D0_REG          (*(reg8 *) PRS_PRSdp_a__D0_REG )
    #define PRS_POLYNOM_A__D0_REG_PTR      ((reg8 *) PRS_PRSdp_a__D0_REG )
    
    #define PRS_SEED_B__A1_REG             (*(reg8 *) PRS_b1_PRSdp_b__A1_REG )
    #define PRS_SEED_B__A1_REG_PTR         ((reg8 *) PRS_b1_PRSdp_b__A1_REG )
    #define PRS_SEED_B__A0_REG             (*(reg8 *) PRS_b1_PRSdp_b__A0_REG )
    #define PRS_SEED_B__A0_REG_PTR         ((reg8 *) PRS_b1_PRSdp_b__A0_REG )
    #define PRS_SEED_A__A0_REG             (*(reg8 *) PRS_PRSdp_a__A0_REG )
    #define PRS_SEED_A__A0_REG_PTR         ((reg8 *) PRS_PRSdp_a__A0_REG )
    
#elif (PRS_PRS_SIZE <= 32)    /* 32bits - PRS */
    #define PRS_POLYNOM_B__D1_REG          (*(reg8 *) PRS_b1_PRSdp_b__D1_REG )
    #define PRS_POLYNOM_B__D1_REG_PTR      ((reg8 *) PRS_b1_PRSdp_b__D1_REG )
    #define PRS_POLYNOM_A__D1_REG          (*(reg8 *) PRS_PRSdp_a__D1_REG )
    #define PRS_POLYNOM_A__D1_REG_PTR      ((reg8 *) PRS_PRSdp_a__D1_REG )
    #define PRS_POLYNOM_B__D0_REG          (*(reg8 *) PRS_b1_PRSdp_b__D0_REG )
    #define PRS_POLYNOM_B__D0_REG_PTR      ((reg8 *) PRS_b1_PRSdp_b__D0_REG )
    #define PRS_POLYNOM_A__D0_REG          (*(reg8 *) PRS_PRSdp_a__D0_REG )
    #define PRS_POLYNOM_A__D0_REG_PTR      ((reg8 *) PRS_PRSdp_a__D0_REG )
    
    #define PRS_SEED_B__A1_REG             (*(reg8 *) PRS_b1_PRSdp_b__A1_REG )
    #define PRS_SEED_B__A1_REG_PTR         ((reg8 *) PRS_b1_PRSdp_b__A1_REG )
    #define PRS_SEED_A__A1_REG             (*(reg8 *) PRS_PRSdp_a__A1_REG )
    #define PRS_SEED_A__A1_REG_PTR         ((reg8 *) PRS_PRSdp_a__A1_REG )
    #define PRS_SEED_B__A0_REG             (*(reg8 *) PRS_b1_PRSdp_b__A0_REG )
    #define PRS_SEED_B__A0_REG_PTR         ((reg8 *) PRS_b1_PRSdp_b__A0_REG )
    #define PRS_SEED_A__A0_REG             (*(reg8 *) PRS_PRSdp_a__A0_REG )
    #define PRS_SEED_A__A0_REG_PTR         ((reg8 *) PRS_PRSdp_a__A0_REG )
    
#elif (PRS_PRS_SIZE <= 40)    /* 40bits - PRS */
    #define PRS_POLYNOM_UPPER_C__D1_REG            (*(reg8 *) PRS_b2_PRSdp_c__D1_REG )
    #define PRS_POLYNOM_UPPER_C__D1_REG_PTR        ((reg8 *) PRS_b2_PRSdp_c__D1_REG )
    
    #define PRS_POLYNOM_LOWER_B__D1_REG            (*(reg8 *) PRS_b1_PRSdp_b__D1_REG )
    #define PRS_POLYNOM_LOWER_B__D1_REG_PTR        ((reg8 *) PRS_b1_PRSdp_b__D1_REG )
    #define PRS_POLYNOM_LOWER_C__D0_REG            (*(reg8 *) PRS_b2_PRSdp_c__D0_REG )
    #define PRS_POLYNOM_LOWER_C__D0_REG_PTR        ((reg8 *) PRS_b2_PRSdp_c__D0_REG )
    #define PRS_POLYNOM_LOWER_B__D0_REG            (*(reg8 *) PRS_b1_PRSdp_b__D0_REG )
    #define PRS_POLYNOM_LOWER_B__D0_REG_PTR        ((reg8 *) PRS_b1_PRSdp_b__D0_REG )
    #define PRS_POLYNOM_LOWER_A__D0_REG            (*(reg8 *) PRS_PRSdp_a__D0_REG )
    #define PRS_POLYNOM_LOWER_A__D0_REG_PTR        ((reg8 *) PRS_PRSdp_a__D0_REG )
    
    #define PRS_SEED_UPPER_C__A1_REG               (*(reg8 *) PRS_b2_PRSdp_c__A1_REG )
    #define PRS_SEED_UPPER_C__A1_REG_PTR           ((reg8 *) PRS_b2_PRSdp_c__A1_REG )
    
    #define PRS_SEED_LOWER_B__A1_REG               (*(reg8 *) PRS_b1_PRSdp_b__A1_REG )
    #define PRS_SEED_LOWER_B__A1_REG_PTR           ((reg8 *) PRS_b1_PRSdp_b__A1_REG )
    #define PRS_SEED_LOWER_C__A0_REG               (*(reg8 *) PRS_b2_PRSdp_c__A0_REG )
    #define PRS_SEED_LOWER_C__A0_REG_PTR           ((reg8 *) PRS_b2_PRSdp_c__A0_REG )
    #define PRS_SEED_LOWER_B__A0_REG               (*(reg8 *) PRS_b1_PRSdp_b__A0_REG )
    #define PRS_SEED_LOWER_B__A0_REG_PTR           ((reg8 *) PRS_b1_PRSdp_b__A0_REG )
    #define PRS_SEED_LOWER_A__A0_REG               (*(reg8 *) PRS_PRSdp_a__A0_REG )
    #define PRS_SEED_LOWER_A__A0_REG_PTR           ((reg8 *) PRS_PRSdp_a__A0_REG )
    
#elif (PRS_PRS_SIZE <= 48)    /* 48bits - PRS */
    #define PRS_POLYNOM_UPPER_C__D1_REG            (*(reg8 *) PRS_b2_PRSdp_c__D1_REG )
    #define PRS_POLYNOM_UPPER_C__D1_REG_PTR        ((reg8 *) PRS_b2_PRSdp_c__D1_REG )
    #define PRS_POLYNOM_UPPER_B__D1_REG            (*(reg8 *) PRS_b1_PRSdp_b__D1_REG )
    #define PRS_POLYNOM_UPPER_B__D1_REG_PTR        ((reg8 *) PRS_b1_PRSdp_b__D1_REG )
    
    #define PRS_POLYNOM_LOWER_A__D1_REG            (*(reg8 *) PRS_PRSdp_a__D1_REG )
    #define PRS_POLYNOM_LOWER_A__D1_REG_PTR        ((reg8 *) PRS_PRSdp_a__D1_REG )
    #define PRS_POLYNOM_LOWER_C__D0_REG            (*(reg8 *) PRS_b2_PRSdp_c__D0_REG )
    #define PRS_POLYNOM_LOWER_C__D0_REG_PTR        ((reg8 *) PRS_b2_PRSdp_c__D0_REG )
    #define PRS_POLYNOM_LOWER_B__D0_REG            (*(reg8 *) PRS_b1_PRSdp_b__D0_REG )
    #define PRS_POLYNOM_LOWER_B__D0_REG_PTR        ((reg8 *) PRS_b1_PRSdp_b__D0_REG )
    #define PRS_POLYNOM_LOWER_A__D0_REG            (*(reg8 *) PRS_PRSdp_a__D0_REG )
    #define PRS_POLYNOM_LOWER_A__D0_REG_PTR        ((reg8 *) PRS_PRSdp_a__D0_REG )
    
    #define PRS_SEED_UPPER_C__A1_REG               (*(reg8 *) PRS_b2_PRSdp_c__A1_REG )
    #define PRS_SEED_UPPER_C__A1_REG_PTR           ((reg8 *) PRS_b2_PRSdp_c__A1_REG )
    #define PRS_SEED_UPPER_B__A1_REG               (*(reg8 *) PRS_b1_PRSdp_b__A1_REG )
    #define PRS_SEED_UPPER_B__A1_REG_PTR           ((reg8 *) PRS_b1_PRSdp_b__A1_REG )
    
    #define PRS_SEED_LOWER_A__A1_REG               (*(reg8 *) PRS_PRSdp_a__A1_REG )
    #define PRS_SEED_LOWER_A__A1_REG_PTR           ((reg8 *) PRS_PRSdp_a__A1_REG )
    #define PRS_SEED_LOWER_C__A0_REG               (*(reg8 *) PRS_b2_PRSdp_c__A0_REG )
    #define PRS_SEED_LOWER_C__A0_REG_PTR           ((reg8 *) PRS_b2_PRSdp_c__A0_REG )
    #define PRS_SEED_LOWER_B__A0_REG               (*(reg8 *) PRS_b1_PRSdp_b__A0_REG )
    #define PRS_SEED_LOWER_B__A0_REG_PTR           ((reg8 *) PRS_b1_PRSdp_b__A0_REG )
    #define PRS_SEED_LOWER_A__A0_REG               (*(reg8 *) PRS_PRSdp_a__A0_REG )
    #define PRS_SEED_LOWER_A__A0_REG_PTR           ((reg8 *) PRS_PRSdp_a__A0_REG )
    
#elif (PRS_PRS_SIZE <= 56)    /* 56bits - PRS */
    #define PRS_POLYNOM_UPPER_D__D1_REG            (*(reg8 *) PRS_b3_PRSdp_d__D1_REG )
    #define PRS_POLYNOM_UPPER_D__D1_REG_PTR        ((reg8 *) PRS_b3_PRSdp_d__D1_REG )
    #define PRS_POLYNOM_UPPER_C__D1_REG            (*(reg8 *) PRS_b2_PRSdp_c__D1_REG )
    #define PRS_POLYNOM_UPPER_C__D1_REG_PTR        ((reg8 *) PRS_b2_PRSdp_c__D1_REG )
    #define PRS_POLYNOM_UPPER_B__D1_REG            (*(reg8 *) PRS_b1_PRSdp_b__D1_REG )
    #define PRS_POLYNOM_UPPER_B__D1_REG_PTR        ((reg8 *) PRS_b1_PRSdp_b__D1_REG )
    
    #define PRS_POLYNOM_LOWER_D__D0_REG            (*(reg8 *) PRS_b3_PRSdp_d__D0_REG )
    #define PRS_POLYNOM_LOWER_D__D0_REG_PTR        ((reg8 *) PRS_b3_PRSdp_d__D0_REG )
    #define PRS_POLYNOM_LOWER_C__D0_REG            (*(reg8 *) PRS_b2_PRSdp_c__D0_REG )
    #define PRS_POLYNOM_LOWER_C__D0_REG_PTR        ((reg8 *) PRS_b2_PRSdp_c__D0_REG )
    #define PRS_POLYNOM_LOWER_B__D0_REG            (*(reg8 *) PRS_b1_PRSdp_b__D0_REG )
    #define PRS_POLYNOM_LOWER_B__D0_REG_PTR        ((reg8 *) PRS_b1_PRSdp_b__D0_REG )
    #define PRS_POLYNOM_LOWER_A__D0_REG            (*(reg8 *) PRS_PRSdp_a__D0_REG )
    #define PRS_POLYNOM_LOWER_A__D0_REG_PTR        ((reg8 *) PRS_PRSdp_a__D0_REG )
    
    #define PRS_SEED_UPPER_D__A1_REG               (*(reg8 *) PRS_b3_PRSdp_d__A1_REG )
    #define PRS_SEED_UPPER_D__A1_REG_PTR           ((reg8 *) PRS_b3_PRSdp_d__A1_REG )
    #define PRS_SEED_UPPER_C__A1_REG               (*(reg8 *) PRS_b2_PRSdp_c__A1_REG )
    #define PRS_SEED_UPPER_C__A1_REG_PTR           ((reg8 *) PRS_b2_PRSdp_c__A1_REG )
    #define PRS_SEED_UPPER_B__A1_REG               (*(reg8 *) PRS_b1_PRSdp_b__A1_REG )
    #define PRS_SEED_UPPER_B__A1_REG_PTR           ((reg8 *) PRS_b1_PRSdp_b__A1_REG )
    
    #define PRS_SEED_LOWER_D__A0_REG               (*(reg8 *) PRS_b3_PRSdp_d__A0_REG )
    #define PRS_SEED_LOWER_D__A0_REG_PTR           ((reg8 *) PRS_b3_PRSdp_d__A0_REG )
    #define PRS_SEED_LOWER_C__A0_REG               (*(reg8 *) PRS_b2_PRSdp_c__A0_REG )
    #define PRS_SEED_LOWER_C__A0_REG_PTR           ((reg8 *) PRS_b2_PRSdp_c__A0_REG )
    #define PRS_SEED_LOWER_B__A0_REG               (*(reg8 *) PRS_b1_PRSdp_b__A0_REG )
    #define PRS_SEED_LOWER_B__A0_REG_PTR           ((reg8 *) PRS_b1_PRSdp_b__A0_REG )
    #define PRS_SEED_LOWER_A__A0_REG               (*(reg8 *) PRS_PRSdp_a__A0_REG )
    #define PRS_SEED_LOWER_A__A0_REG_PTR           ((reg8 *) PRS_PRSdp_a__A0_REG )
    
#else    /* 64bits - PRS */
    #define PRS_POLYNOM_UPPER_D__D1_REG            (*(reg8 *) PRS_b3_PRSdp_d__D1_REG )
    #define PRS_POLYNOM_UPPER_D__D1_REG_PTR        ((reg8 *) PRS_b3_PRSdp_d__D1_REG )
    #define PRS_POLYNOM_UPPER_C__D1_REG            (*(reg8 *) PRS_b2_PRSdp_c__D1_REG )
    #define PRS_POLYNOM_UPPER_C__D1_REG_PTR        ((reg8 *) PRS_b2_PRSdp_c__D1_REG )
    #define PRS_POLYNOM_UPPER_B__D1_REG            (*(reg8 *) PRS_b1_PRSdp_b__D1_REG )
    #define PRS_POLYNOM_UPPER_B__D1_REG_PTR        ((reg8 *) PRS_b1_PRSdp_b__D1_REG )
    #define PRS_POLYNOM_UPPER_A__D1_REG            (*(reg8 *) PRS_PRSdp_a__D1_REG )
    #define PRS_POLYNOM_UPPER_A__D1_REG_PTR        ((reg8 *) PRS_PRSdp_a__D1_REG )
    
    #define PRS_POLYNOM_LOWER_D__D0_REG            (*(reg8 *) PRS_b3_PRSdp_d__D0_REG )
    #define PRS_POLYNOM_LOWER_D__D0_REG_PTR        ((reg8 *) PRS_b3_PRSdp_d__D0_REG )
    #define PRS_POLYNOM_LOWER_C__D0_REG            (*(reg8 *) PRS_b2_PRSdp_c__D0_REG )
    #define PRS_POLYNOM_LOWER_C__D0_REG_PTR        ((reg8 *) PRS_b2_PRSdp_c__D0_REG )
    #define PRS_POLYNOM_LOWER_B__D0_REG            (*(reg8 *) PRS_b1_PRSdp_b__D0_REG )
    #define PRS_POLYNOM_LOWER_B__D0_REG_PTR        ((reg8 *) PRS_b1_PRSdp_b__D0_REG )
    #define PRS_POLYNOM_LOWER_A__D0_REG            (*(reg8 *) PRS_PRSdp_a__D0_REG )
    #define PRS_POLYNOM_LOWER_A__D0_REG_PTR        ((reg8 *) PRS_PRSdp_a__D0_REG )
    
    #define PRS_SEED_UPPER_D__A1_REG               (*(reg8 *) PRS_b3_PRSdp_d__A1_REG )
    #define PRS_SEED_UPPER_D__A1_REG_PTR           ((reg8 *) PRS_b3_PRSdp_d__A1_REG )
    #define PRS_SEED_UPPER_C__A1_REG               (*(reg8 *) PRS_b2_PRSdp_c__A1_REG )
    #define PRS_SEED_UPPER_C__A1_REG_PTR           ((reg8 *) PRS_b2_PRSdp_c__A1_REG )
    #define PRS_SEED_UPPER_B__A1_REG               (*(reg8 *) PRS_b1_PRSdp_b__A1_REG )
    #define PRS_SEED_UPPER_B__A1_REG_PTR           ((reg8 *) PRS_b1_PRSdp_b__A1_REG )
    #define PRS_SEED_UPPER_A__A1_REG               (*(reg8 *) PRS_PRSdp_a__A1_REG )
    #define PRS_SEED_UPPER_A__A1_REG_PTR           ((reg8 *) PRS_PRSdp_a__A1_REG )
    
    #define PRS_SEED_LOWER_D__A0_REG               (*(reg8 *) PRS_b3_PRSdp_d__A0_REG )
    #define PRS_SEED_LOWER_D__A0_REG_PTR           ((reg8 *) PRS_b3_PRSdp_d__A0_REG )
    #define PRS_SEED_LOWER_C__A0_REG               (*(reg8 *) PRS_b2_PRSdp_c__A0_REG )
    #define PRS_SEED_LOWER_C__A0_REG_PTR           ((reg8 *) PRS_b2_PRSdp_c__A0_REG )
    #define PRS_SEED_LOWER_B__A0_REG               (*(reg8 *) PRS_b1_PRSdp_b__A0_REG )
    #define PRS_SEED_LOWER_B__A0_REG_PTR           ((reg8 *) PRS_b1_PRSdp_b__A0_REG )
    #define PRS_SEED_LOWER_A__A0_REG               (*(reg8 *) PRS_PRSdp_a__A0_REG )
    #define PRS_SEED_LOWER_A__A0_REG_PTR           ((reg8 *) PRS_PRSdp_a__A0_REG )
#endif /*PRS_PRS_SIZE */

#define PRS_CONTROL                        (*(reg8 *) PRS_CtrlReg__CONTROL_REG)
#define PRS_CONTROL_PTR                    ((reg8 *) PRS_CtrlReg__CONTROL_REG)

/***************************************
*       Register Constants
***************************************/

#define PRS_CTRL_ENABLE                    0x01u
#define PRS_CTRL_RISING_EDGE               0x02u
#define PRS_CTRL_RESET_DFF                 0x04u

#endif  /* End CY_PRS_PRS_H */


/* [] END OF FILE */
