/*******************************************************************************
* File Name: CG_SDA.h  
* Version 1.50
*
* Description:
*  This file containts Control Register function prototypes and register defines
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#if !defined(CY_PINS_CG_SDA_H) /* Pins CG_SDA_H */
#define CY_PINS_CG_SDA_H

#include "cytypes.h"
#include "cyfitter.h"
#include "cypins.h"
#include "CG_SDA_aliases.h"


/***************************************
*        Function Prototypes             
***************************************/    

void    CG_SDA_Write(uint8 value) ;
void    CG_SDA_SetDriveMode(uint8 mode) ;
uint8   CG_SDA_ReadDataReg(void) ;
uint8   CG_SDA_Read(void) ;
uint8   CG_SDA_ClearInterrupt(void) ;

/***************************************
*           API Constants        
***************************************/

/* Drive Modes */
#define CG_SDA_DM_ALG_HIZ         PIN_DM_ALG_HIZ
#define CG_SDA_DM_DIG_HIZ         PIN_DM_DIG_HIZ
#define CG_SDA_DM_RES_UP          PIN_DM_RES_UP
#define CG_SDA_DM_RES_DWN         PIN_DM_RES_DWN
#define CG_SDA_DM_OD_LO           PIN_DM_OD_LO
#define CG_SDA_DM_OD_HI           PIN_DM_OD_HI
#define CG_SDA_DM_STRONG          PIN_DM_STRONG
#define CG_SDA_DM_RES_UPDWN       PIN_DM_RES_UPDWN

/* Digital Port Constants */
#define CG_SDA_MASK               CG_SDA__MASK
#define CG_SDA_SHIFT              CG_SDA__SHIFT
#define CG_SDA_WIDTH              1u

/***************************************
*             Registers        
***************************************/

/* Main Port Registers */
/* Pin State */
#define CG_SDA_PS                     (* (reg8 *) CG_SDA__PS)
/* Data Register */
#define CG_SDA_DR                     (* (reg8 *) CG_SDA__DR)
/* Port Number */
#define CG_SDA_PRT_NUM                (* (reg8 *) CG_SDA__PRT) 
/* Connect to Analog Globals */                                                  
#define CG_SDA_AG                     (* (reg8 *) CG_SDA__AG)                       
/* Analog MUX bux enable */
#define CG_SDA_AMUX                   (* (reg8 *) CG_SDA__AMUX) 
/* Bidirectional Enable */                                                        
#define CG_SDA_BIE                    (* (reg8 *) CG_SDA__BIE)
/* Bit-mask for Aliased Register Access */
#define CG_SDA_BIT_MASK               (* (reg8 *) CG_SDA__BIT_MASK)
/* Bypass Enable */
#define CG_SDA_BYP                    (* (reg8 *) CG_SDA__BYP)
/* Port wide control signals */                                                   
#define CG_SDA_CTL                    (* (reg8 *) CG_SDA__CTL)
/* Drive Modes */
#define CG_SDA_DM0                    (* (reg8 *) CG_SDA__DM0) 
#define CG_SDA_DM1                    (* (reg8 *) CG_SDA__DM1)
#define CG_SDA_DM2                    (* (reg8 *) CG_SDA__DM2) 
/* Input Buffer Disable Override */
#define CG_SDA_INP_DIS                (* (reg8 *) CG_SDA__INP_DIS)
/* LCD Common or Segment Drive */
#define CG_SDA_LCD_COM_SEG            (* (reg8 *) CG_SDA__LCD_COM_SEG)
/* Enable Segment LCD */
#define CG_SDA_LCD_EN                 (* (reg8 *) CG_SDA__LCD_EN)
/* Slew Rate Control */
#define CG_SDA_SLW                    (* (reg8 *) CG_SDA__SLW)

/* DSI Port Registers */
/* Global DSI Select Register */
#define CG_SDA_PRTDSI__CAPS_SEL       (* (reg8 *) CG_SDA__PRTDSI__CAPS_SEL) 
/* Double Sync Enable */
#define CG_SDA_PRTDSI__DBL_SYNC_IN    (* (reg8 *) CG_SDA__PRTDSI__DBL_SYNC_IN) 
/* Output Enable Select Drive Strength */
#define CG_SDA_PRTDSI__OE_SEL0        (* (reg8 *) CG_SDA__PRTDSI__OE_SEL0) 
#define CG_SDA_PRTDSI__OE_SEL1        (* (reg8 *) CG_SDA__PRTDSI__OE_SEL1) 
/* Port Pin Output Select Registers */
#define CG_SDA_PRTDSI__OUT_SEL0       (* (reg8 *) CG_SDA__PRTDSI__OUT_SEL0) 
#define CG_SDA_PRTDSI__OUT_SEL1       (* (reg8 *) CG_SDA__PRTDSI__OUT_SEL1) 
/* Sync Output Enable Registers */
#define CG_SDA_PRTDSI__SYNC_OUT       (* (reg8 *) CG_SDA__PRTDSI__SYNC_OUT) 


#if defined(CG_SDA__INTSTAT)  /* Interrupt Registers */

    #define CG_SDA_INTSTAT                (* (reg8 *) CG_SDA__INTSTAT)
    #define CG_SDA_SNAP                   (* (reg8 *) CG_SDA__SNAP)

#endif /* Interrupt Registers */

#endif /* End Pins CG_SDA_H */


/* [] END OF FILE */
