#! /usr/bin/octave -qf
fn = [100, 200, 300, 400, 500];
ff = linspace(100, 500, 101);
amplitude = [0.0, 1.0, 0.0, -1.0, 0.0];
sine_coef_5 = polyfit(fn, amplitude, 5);
sine_coef_7 = polyfit(fn, amplitude, 7);
sine_fit_5 = polyval(sine_coef_5, ff);
sine_fit_7 = polyval(sine_coef_7, ff);
plot(ff, sine_fit_5, ff, sine_fit_7, ff, sin((ff .- 100) .* 2 .* pi ./ 400));
title("LEAST SQUARES FIT TO SINE WAVE");
#xlabel("FREQUENCY IN MHz");
#ylabel("IMPEDANCE IN OHMS");
text(340, -0.50, "5th DEGREE FIT")
text(405, 0.77, "7th DEGREE FIT")
grid;
pause;

