using namespace std;  // must be declared first to get the header files to work correctly

#include <stdio.h>
#include <initguid.h>
#include <Dsound.h>
#include<vector>
#include<string>
#include<iostream>

#include "sdr.h"

#pragma hdrstop

int output_device, input_device;

int   output_frequency, phase_increment, counts_per_hz, deviation;


HRESULT CreateSoundBuffer(LPCDSBUFFERDESC lpDSBufferDesc,    // Pointer to the buffer's
                                                             // description
                    LPLPDIRECTSOUNDBUFFER lplpDirectSoundBuffer,    // A pointer to the
                                                                    // interface
                    IUnknown FAR * pUnkOter);    // NULL


HRESULT WINAPI DirectSoundEnumerate(
  LPDSENUMCALLBACK lpDSEnumCallback,  
  LPVOID lpContext                    
);
extern   AudioDevices input_audio_devices, output_audio_devices;

BOOL CALLBACK EnumCallBack (LPGUID guid, LPCSTR desc,
  LPCSTR mod, LPVOID list)
{
  AudioDevice *ad = new AudioDevice;
  if (guid == NULL)
    ad->guid = NULL;
  else{
    ad->guid = new GUID;
    memcpy (ad->guid, guid, sizeof (GUID));
  }
  ad->description = desc;
  ad->module = mod;
  (static_cast<AudioDevices*>(list))->push_back (ad);
  return true;
}
const char* app_title = "FM DDS Generator";

HRESULT user_input(void)
{
unsigned int i;

  SetConsoleTitle (app_title);
  input_device = 0;
  output_device = 0;

  if (FAILED (DirectSoundCaptureEnumerate (EnumCallBack, &input_audio_devices))){
    cout << "Couldn't enumerate the audio devices" << endl;
    return 1;
  }
  for (i = 0; i < input_audio_devices.size (); i++)
  {
    cout << i << ": " << input_audio_devices[i]->description << " " << input_audio_devices[i]->module << endl;
  }
  cout << endl << "Which drive shall we use?: ";
  cin >> i;
  if (i > input_audio_devices.size () - 1){
    cout << "Not a valid choice, using default" << endl;
    i = 0;
  }
  input_device = i;


  if (FAILED (DirectSoundEnumerate (EnumCallBack, &output_audio_devices))){
    cout << "Couldn't enumerate the audio devices" << endl;
    return 1;
  }
  for (i = 0; i < output_audio_devices.size (); i++)
  {
    cout << i << ": " << output_audio_devices[i]->description << " " << output_audio_devices[i]->module << endl;
  }
  cout << endl << "Which drive shall we use?: ";
  cin >> i;
  if (i > output_audio_devices.size () - 1){
    cout << "Not a valid choice, using default" << endl;
    i = 0;
  }
  input_device = i;

  cout << endl << "What output frequency shall we use?: ";
  cin >> output_frequency;

   counts_per_hz = (MAX_ACCUMULATOR * 2048) / DESIRED_SAMPLE_RATE;

    phase_increment =  (counts_per_hz * output_frequency) / 2048;
    if (counts_per_hz == 0)
    {
       cout << "Phase Accumulator setup error.  Fix sample rate or accumulator." << endl;
       return 10;
    }

    cout << endl << "What deviation value shall we use? (1 to 10): ";
    cin >> deviation;

  cout << "Output Frequency: " << output_frequency << endl 
       << "phase increment: " << phase_increment << endl;

  return 0;
}