using namespace std;  // must be declared first to get the header files to work correctly

#include <stdio.h>
#include <initguid.h>
#include <Dsound.h>
#include <vector>
#include <string>
#include <iostream>

#pragma hdrstop

#include "sdr.h"

LPDIRECTSOUNDCAPTURE p_direct_capture_object;
DSCCAPS dsccaps;
DSCBUFFERDESC  input_buffer_descriptor;
LPDIRECTSOUNDCAPTUREBUFFER  p_input_buffer;
WAVEFORMATEX                wfx =
    {WAVE_FORMAT_PCM, 2,        DESIRED_SAMPLE_RATE,DESIRED_SAMPLE_RATE*4,   4,           16,             0};
    // wFormatTag,   nChannels, nSamplesPerSec,     mAvgBytesPerSec,      nBlockAlign, wBitsPerSample, cbSize
 
DWORD   start_position = 0;

HRESULT read_input_data(unsigned char buffer[], DWORD *bytes_read)
{
HRESULT hr;
DWORD   read_position, capture_position;
char    *read_pointer_1, *read_pointer_2;
DWORD   read_1_count, read_2_count;

    // this is an error recovery step.  It will cause an audible glitch if it is > top_of_buffer.
    // the logic will occasionally hit this step if the last read pushed us to exactly the top of the buffer
    if (start_position >= top_of_buffer)
    {
       if (start_position != top_of_buffer)
       {
          cout << "above top of in buffer" << endl;
       }
       start_position = 0;
    }
    hr = p_input_buffer->GetCurrentPosition(&capture_position, &read_position);
    if (hr != 0)
    {
       return hr;
    }
    hr = p_input_buffer->Lock(start_position, 100, (LPVOID *)&read_pointer_1, &read_1_count,
                                                   (LPVOID *)&read_pointer_2, &read_2_count, 0);
    if (hr !=0)
    {
       cout << "lock failure" << endl;
    }
    if (read_1_count == 0)
    {
       *bytes_read = 0;
       hr = 0;
    }
    else
    {
       memcpy(buffer, read_pointer_1, read_1_count);
       *bytes_read = read_1_count;
       start_position += read_1_count;
       if (read_pointer_2 != NULL)
       {
          *bytes_read += read_2_count;
          memcpy(&buffer[read_1_count], read_pointer_2, read_2_count);
          start_position = read_2_count;
       }
    }
    hr = p_input_buffer->Unlock((LPVOID *)read_pointer_1, read_1_count, (LPVOID *)read_pointer_2, read_2_count); 
    if(start_position == wfx.nAvgBytesPerSec)
    {
       start_position = 0;
    }
    return hr;
}

HRESULT CreateCaptureBuffer(void)
{
HRESULT hr;

   input_buffer_descriptor.dwSize = sizeof(DSCBUFFERDESC);
   input_buffer_descriptor.dwFlags = 0;
   input_buffer_descriptor.dwBufferBytes = wfx.nAvgBytesPerSec;
   input_buffer_descriptor.dwReserved = 0;
   input_buffer_descriptor.lpwfxFormat = &wfx;
   input_buffer_descriptor.dwFXCount = 0;
   input_buffer_descriptor.lpDSCFXDesc = NULL;
  
   if (SUCCEEDED(hr = p_direct_capture_object->CreateCaptureBuffer(&input_buffer_descriptor, &p_input_buffer, NULL)))
   {
     hr = p_input_buffer->QueryInterface(IID_IDirectSoundCaptureBuffer8, (LPVOID *)&input_buffer_descriptor);
     p_input_buffer->Release();  
   }
   return hr;
}


HRESULT setup_input_buffer(void)
{
HRESULT	status;
DWORD   formats;

	status = 0;

   status = DirectSoundCaptureCreate8 (input_audio_devices[input_device]->guid, &p_direct_capture_object, NULL);
	if (FAILED(status))
   {
     cout << "Unable to create the DirectSoundCapture Object!!!" << endl;
     return 13;
   }

   dsccaps.dwSize = sizeof(DSCCAPS); 
   status = p_direct_capture_object->GetCaps(&dsccaps); 
   if (FAILED(status))
   {
      return(status);  // Add error-handling here.
   }
   formats = dsccaps.dwFormats;

   status = CreateCaptureBuffer();
   if (FAILED(status))
   {
      return(status);  // Add error-handling here.
   }

   return status;
}