﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Tmatrix
{
    /// <summary>
    /// Provides analysis and result storage for a set of tiles.
    /// Can be either at one frequency, or over a set of frequencies.
    /// Caller is responsibel for displaying the results
    /// </summary>
    class AnalysisSet
    {
        //public Complex Zin;     // single frequency analysis result
        //public Complex Zout;    // single frequency analysis result
        //public Complex Trans;    // complex transfer function
        //public Double Pload;    // power delivered to the load (last tile) based on Vpk of source.

        //private Complex Aaccum;      // In-process accumulation of the total ABCD matrix.
        //private Complex Baccum;      // Initialize to unity (no tranformation).
        //private Complex Caccum;      // Caller gets the answer through these parameters
        //private Complex Daccum;
        //private Complex AaccI;      // Inverted ABCD matrix elements.
        //private Complex BaccI;
        //private Complex CaccI;
        //private Complex DaccI;

        private Complex A;           // working values of ABCD
        private Complex B;          
        private Complex C;
        private Complex D;
        public Complex Z0;      // reference resistance as an impedance
        private static Complex Zero = new Complex(0);
        private static Complex One = new Complex(1);            // constants for conversions
        private static Complex Two = new Complex(2);

        //public List<Complex> NodeSet = new List<Complex>();     // hold the node voltages
                
        public AnalysisSet()   // default constructor
        {
            //Zin = new Complex();
            //Zout = new Complex();
            //Trans = new Complex();

            //Aaccum = new Complex(1);    // initialize accumulated matrix to unity
            //Baccum = new Complex();
            //Caccum = new Complex();
            //Daccum = new Complex(1);

            A = new Complex();
            B = new Complex();
            C = new Complex();
            D = new Complex();
            Z0 = new Complex();


            //AaccI = new Complex();    // inverted ABCD matrix
            //BaccI = new Complex();
            //CaccI = new Complex();
            //DaccI = new Complex();
            
        }

        ///// <summary>
        ///// Analyze the tiles and provide Zin, out, transfer fucntion.
        ///// </summary>
        ///// <param name="Frequency"></param>
        ///// <param name="tile"></param>
        ///// <returns>Parameter LineItem. If extract failed, then frequency is set to -1.</returns>
//        public ParamaterLineItem ExtractABCD(Double Frequency, Tile tile) // extract ABCD at Frequency from Tile
//        {
//            Double XL, XC, reactance, resistance;     // store interim calculations
//            Double conductance, susceptance;
//            Complex impedance = new Complex();
//            Complex admittance = new Complex();

//            // for now - ignore multiple frequencies, and just do a single-frequency analysis at startFreq

//            // Starting at the last tile, convert tile into its ABCD parameters
//            // Matrix multiply this by the next earlier tile ABCD parameters.
//            // When we get to the front, we have a single ABCD matrix representing the whole network.
//            // Compute Zin, Zout, and Trans for this concatenated matrix.

//            // Presume an initial tile with Identity ABCD matrix.
//            // (Aaccum=1, Baccum=0, Caccum=0, Daccum=1).
//            // Then can cascade each matrix multiply up through the first tile.

////           Complex V2 = new Complex(1);    // voltage at output of current tile - initialize to open circuit
////           Complex I2 = new Complex(0);    // current at output of current tile - initialize to open circuit
////           Complex V1 = new Complex();     // voltage at input to current tile
////           Complex I1 = new Complex();     // current at input to current tile

//           // don't record the last node set at output of last tile (Open-circuit)
//           // NodeSet.Add(V2);                //Initial node voltage 1+j0
//           // NodeSet.Add(I2);                //Initial node current 0+j0

//           try
//            {
//                Z0.real = tile.m_referenceR;     // get reference impedance for this tile from tile spec
//                Z0.imag = 0;

//                switch (tile.m_type)      // find type of tile and derive ABCD for that tile
//                {
//                    case NetworkType.ABCDparam:
//                        A = tile.m_elecParam11A;    // extract the 4 frequency-independent parameters
//                        B = tile.m_elecParam12B;
//                        C = tile.m_elecParam21C;
//                        D = tile.m_elecParam22D;
//                        break;

//                    case NetworkType.Zparam:
//                        Complex Zmag = new Complex();
//                        Zmag = tile.m_elecParam11A * tile.m_elecParam22D - tile.m_elecParam12B * tile.m_elecParam21C;
//                        A = tile.m_elecParam11A / tile.m_elecParam21C;
//                        B = Zmag / tile.m_elecParam21C;
//                        C = One / tile.m_elecParam21C;
//                        D = tile.m_elecParam22D / tile.m_elecParam21C;
//                        break;

//                    case NetworkType.Yparam:
//                        Complex Ymag = new Complex();
//                        Ymag = tile.m_elecParam11A * tile.m_elecParam22D - tile.m_elecParam12B * tile.m_elecParam21C;
//                        A = -tile.m_elecParam22D / tile.m_elecParam21C;
//                        B = -One / tile.m_elecParam21C;
//                        C = -Ymag / tile.m_elecParam21C;
//                        D = -tile.m_elecParam11A / tile.m_elecParam21C;
//                        break;

//                    case NetworkType.Sparam:
//                        A = ((One + tile.m_elecParam11A) * (One - tile.m_elecParam22D) +
//                            tile.m_elecParam12B * tile.m_elecParam21C) / (Two * tile.m_elecParam21C);
//                        B = Z0 * (((One + tile.m_elecParam11A) * (One + tile.m_elecParam22D) -
//                            tile.m_elecParam12B * tile.m_elecParam21C) / (Two * tile.m_elecParam21C));
//                        C = (((One - tile.m_elecParam11A) * (One - tile.m_elecParam22D) -
//                            tile.m_elecParam12B * tile.m_elecParam21C) / (Two * tile.m_elecParam21C)) / Z0;
//                        D = ((One - tile.m_elecParam11A) * (One + tile.m_elecParam22D) +
//                            tile.m_elecParam12B * tile.m_elecParam21C) / (Two * tile.m_elecParam21C);
//                        break;

//                    case NetworkType.SeriesTL:

//                    case NetworkType.SeriesZparRLC:
//                        A = One;
//                        C = Zero;
//                        D = One;

//                        // R ohms = param1, L uHy = param2, C pF= param3.

//                        // R is in ohms. 
//                        resistance = tile.m_elecParam1;
//                        if (resistance != 0)
//                            conductance = 1 / resistance;
//                        else
//                            conductance = Double.MaxValue; // R=0 is shorthand for no resistor.

//                        // L is in uHy. 
//                        if (tile.m_elecParam2 != 0)
//                            XL = 2 * Math.PI * Frequency * tile.elecParam2 / 1e6;
//                        else
//                            XL = Double.MaxValue; // L=0 is shorthand for no inductor.

//                        // C is in pF.
//                        if (tile.m_elecParam3 != 0)
//                            XC = 1 / (2 * Math.PI * Frequency * tile.m_elecParam3 / 1E12);
//                        else
//                            XC = Double.MaxValue;     //  C=0 is shorthand for no capacitor

//                        // Z = 1/(1/R, j 1/XC - 1/XL)

//                        susceptance = (1 / XC) - (1 / XL); // imaginary number has sign flip on inversion

//                        admittance.real = conductance;
//                        admittance.imag = susceptance;

//                        impedance = One / admittance;

//                        B = impedance;
//                        break;

//                    case NetworkType.SeriesZserRLC:
//                        A = One;
//                        C = Zero;
//                        D = One;

//                        resistance = tile.m_elecParam1; // R ohms
                        
//                        XL = 2 * Math.PI * Frequency * tile.elecParam2 / 1e6;   // L uHy

//                        // C is in pF.   
//                        if (tile.m_elecParam3 != 0)
//                            XC = 1 / (2 * Math.PI * Frequency * tile.m_elecParam3 / 1E12);
//                        else
//                            XC = 0; // C=0 is shorthand for no capacitor.

//                        reactance = XL - XC;
//                        B = new Complex(resistance, reactance);
//                        break;

//                    case NetworkType.ShuntYparRLC:
//                        A = One;
//                        B = Zero;
//                        D = One;

//                        // R ohms = param1, L uHy = param2, C pF= param3.

//                        // R is in ohms. 
//                        resistance = tile.m_elecParam1;
//                        if (resistance != 0)
//                            conductance = 1 / resistance;
//                        else
//                            conductance = Double.MaxValue; // R=0 is shorthand for no resistor.

//                        // L is in uHy. 
//                        if (tile.m_elecParam2 != 0)
//                            XL = 2 * Math.PI * Frequency * tile.elecParam2 / 1e6;
//                        else
//                            XL = Double.MaxValue; // L=0 is shorthand for no inductor.

//                        // C is in pF.
//                        if (tile.m_elecParam3 != 0)
//                            XC = 1 / (2 * Math.PI * Frequency * tile.m_elecParam3 / 1E12);
//                        else
//                            XC = Double.MaxValue;     //  C=0 is shorthand for no capacitor

//                        // Z = 1/(1/R, j 1/XC - 1/XL)

//                        susceptance = (1 / XC) - (1 / XL); // imaginary number has sign flip on inversion

//                        admittance.real = conductance;
//                        admittance.imag = susceptance;
//                        C = admittance;
//                        break;

//                    case NetworkType.ShuntYserRLC:
//                        A = One;
//                        B = Zero;
//                        D = One;

//                        resistance = tile.m_elecParam1; // R ohms

//                        XL = 2 * Math.PI * Frequency * tile.elecParam2 / 1e6;   // L uHy

//                        // C is in pF.   
//                        if (tile.m_elecParam3 != 0)
//                            XC = 1 / (2 * Math.PI * Frequency * tile.m_elecParam3 / 1E12);
//                        else
//                            XC = 0; // C=0 is shorthand for no capacitor.

//                        reactance = XL - XC;

//                        impedance.real = resistance;
//                        impedance.imag = reactance;

//                        admittance = One / impedance;
//                        C = admittance;

//                        break;

//                    case NetworkType.Empty:     // this provides just connection function (matrix = unity).
//                        A = One;
//                        B = Zero;
//                        C = Zero;
//                        D = One;
//                        break;

//                    default:
//                        throw new ArgumentException("Analyze: Invalid tile network type");
//                }

//                ParamaterLineItem p = new ParamaterLineItem();
//                p.frequency = Frequency;
//                p.P11A = A;
//                p.P12B = B;
//                p.P21C = C;
//                p.P22D = D;
//                return p;


//                    // 2x2 matrix multiplication of ABCD parameters concatenates the tile properties
//                    //Aaccum = Aaccum * A + Baccum * C;
//                   // Baccum = Aaccum * B + Baccum * D;
//                    //Caccum = Caccum * A + Daccum * C;
//                    //Daccum = Caccum * B + Daccum * D;

//                    // [V1,I1] = [ABCD] * [V2,I2]
// //                   V1 = A * V2 + B * I2;
// //                   I1 = C * V2 + D * I2;

//                    // Save it on the node list
// //                   NodeSet.Add(V1);
// //                   NodeSet.Add(I1);

//                    // update variables to the previous node in the list
// //                   V2 = V1;
// //                   I2 = I1;
                    

// //               }

//                // Try a different method - start at the last tile with V=1+j0 volts, and no current
//                // (an open-circuited load). then record the node {V,I} moving from the load towards
//                // the source.

//                // Compute Zin, Zout, and transfer function for the concatenated ABCD matrix
                
//                // Zin is Z looking into the composite tile with the output beyond the last tile
//                // open-circuited. That is, the last tile is the terminating impedance for the network.
//                // Then Zin = V1/I1 = A/C.

//                //Zin = Aaccum / Caccum;

//                // The network source impedance is the reference resistance of the first tile.
//                // That source Z is used to compute Zout, which is the impedance seen from the load
//                // looking towards the generator.   [ V2, I2 ] = [ ABCD inverse ] [ V1, I1 ].

//                //this.InvertABCD();
// //               Z0.real = tileSet[0].m_referenceR;      // use referenceR of the first tile

//                // BUGBUG: probably need to set a program variable for generator source impedance

//                //Z0.real = 50;                           // BUGBUG: temporarily
//                //Z0.imag = 0;                            // as the generator source resistance
//                //Zout = (AaccI * Z0 + BaccI) / (CaccI * Z0 + DaccI);

//                // The network transfer function is V2/V1.
//                // Assume that V1 = 1+j0 and I1 = V1/Z0. Then V2 is compared to V1.

//                //Trans = AaccI + BaccI / Z0;

//                // Power delivered to the load is V2 * I2* /2.  Based on Vpk of the source.
//                // If we specify Vrms of the source, then power is twice the value of Pload.

//                //Pload = (Trans * Complex.conjugate(Trans/Zout)).real / 2;

//            }
//            catch (ArgumentException a)
//            {
//                MessageBox.Show("Error calculating concatenated matrix transfer function: \n\r", a.Message,
//                    MessageBoxButtons.OK, MessageBoxIcon.Error);

//                ParamaterLineItem p = new ParamaterLineItem();
//                p.frequency = -1;               // signal an error to caller
//                p.P11A = One;        //return identity matrix to ease debugging
//                p.P12B = Zero;
//                p.P21C = Zero;
//                p.P22D = One;
//                return p;
//            }
//        }

        //public static ParamaterLineItem InvertABCD(ParamaterLineItem p)
        //{
        //    // Inverts the ABCD matrix.
        //    // sets frequency to -1 in returned item to signal error

        //    Complex invDeterminant = new Complex();
        //    ParamaterLineItem r = new ParamaterLineItem();

        //    try
        //    {
        //        invDeterminant = One / (p.P11A * p.P22D - p.P12B * p.P21C);
        //        r.P11A = p.P22D * invDeterminant;
        //        r.P12B = -p.P12B * invDeterminant;
        //        r.P21C = -p.P21C * invDeterminant;
        //        r.P22D = p.P11A * invDeterminant;
        //        r.frequency = 0;
        //        return r;
        //    }
        //    catch (ArgumentException ae)
        //    {
        //        MessageBox.Show("Can't invert ABCD matrix\n\r", ae.Message, MessageBoxButtons.OK,
        //            MessageBoxIcon.Error);
        //        r.frequency = -1;       // signal error to caller
        //        r.P11A = One;           // Identity matrix
        //        r.P12B = Zero;
        //        r.P21C = Zero;
        //        r.P22D = One;
        //        return r;
        //    }
        //}
     }
}
