# Write output to a SPICE-ready file

ftag = fopen("/home/mwright/Octave/spice_file.txt", "at", "native");

# Calculate and print out values for ZA

fprintf(ftag, "\nxx1 RA  Y1  Y2   %8.5g", real(ZA));
if imag(ZA) > 0
   LA = imag(ZA) / (2 * pi * f * 1e6);
   fprintf(ftag, "\nxx2 LA  Y2  Y3   %8.5g", LA);
elseif imag(ZA) < 0
   CA = 1 / (2 * pi * f * 1e6 * -imag(ZA));
   fprintf(ftag, "\nxx2 CA  Y2  Y3   %8.5g", CA);
else
   fprintf(ftag, "\nxx2 RAA  Y2  Y3   %8.5g", 0);
endif

# Calculate and print out values for ZB

fprintf(ftag, "\nxx3 RB  Y3  Y4   %8.5g", real(ZB));
if imag(ZB) > 0;
   LB = imag(ZB) / (2 * pi * f * 1e6);
   fprintf(ftag, "\nxx4 LB  Y4  Y5   %8.5g", LB);
elseif imag(ZB) < 0;
   CB = 1 / (2 * pi * f * 1e6 * -imag(ZB))
   fprintf(ftag, "\nxx4 CB  Y4  Y5   %8.5g", CB);
else
   fprintf(ftag, "\nxx4 RBB  Y4  Y5   %8.5g", 0);
endif

# Calculate and print out values for ZC

fprintf(ftag, "\nxx5 RC  Y3  Y6   %8.5g", real(ZC));
if imag(ZC) > 0
   LC = imag(ZC) / (2 * pi * f * 1e6);
   fprintf(ftag, "\nxx6 LC  Y6  0   %8.5g", LC);
elseif imag(ZC) < 0
   CC = 1 / (2 * pi * f * 1e6 * -imag(ZC));
   fprintf(ftag, "\nxx6 CC  Y6  0   %8.5g", CC);
else
   fprintf(ftag, "\nxx6 RCC  Y6  0   %8.5g", 0);
endif

# Close file

fclose(ftag);

# End program

